/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.Global;
import de.malban.util.HTMLHelper;
import de.malban.util.UtilityDate;
import de.malban.util.UtilityString;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;

public class ExcelHelper {
    private static int counter = 0;

    ExcelHelper() {
    }

    public static void toExcel(Vector<JTable> tables, String basename) {
        String cName = "";
        String filename = "";
        File f = null;
        do {
            filename = Global.mainPathPrefix + "tmp\\temp_excel_" + basename + "_" + counter + ".xls";
            filename = UtilityString.cleanFileString(filename);
            f = new File(filename);
            ++counter;
        } while (f.isFile());
        System.out.println("Temp Filename used: " + filename);
        try {
            PrintWriter pw = new PrintWriter(filename);
            pw.println("<P>List Generated: " + UtilityDate.dateToStringGermanClock(new Date()) + "</P>");
            boolean swapRowColumn = false;
            for (int t = 0; t < tables.size(); ++t) {
                JTable table = tables.elementAt(t);
                if (table.getColumnCount() > 250) {
                    swapRowColumn = true;
                }
                String html = HTMLHelper.toHTML(table, swapRowColumn);
                pw.println("<P></P>");
                pw.println(html);
            }
            pw.flush();
            pw.close();
            String log = "";
            String result = "";
            f = new File(filename);
            if (f == null) {
                return;
            }
            Desktop desktop = null;
            try {
                if (Desktop.isDesktopSupported()) {
                    desktop = Desktop.getDesktop();
                    desktop.open(f);
                }
            }
            catch (IOException e) {
                log = log + System.err.toString();
                e.printStackTrace(System.err);
            }
        }
        catch (Throwable e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
    }

    public static void toExcel(JTable table) {
        ExcelHelper.toExcel(table, false, "");
    }

    public static void toExcel(JTable table, String basename) {
        ExcelHelper.toExcel(table, false, basename);
    }

    public static void toExcel(JTable table, boolean swapRowColumn, String basename) {
        String cName = "";
        String filename = "";
        File f = null;
        do {
            filename = Global.mainPathPrefix + "tmp\\temp_excel_" + basename + "_" + counter + ".xls";
            filename = UtilityString.cleanFileString(filename);
            f = new File(filename);
            ++counter;
        } while (f.isFile());
        System.out.println("Temp Filename used: " + filename);
        try {
            if (table.getColumnCount() > 250) {
                swapRowColumn = true;
            }
            PrintWriter pw = new PrintWriter(filename);
            String html = HTMLHelper.toHTML(table, swapRowColumn);
            pw.println(html);
            pw.flush();
            pw.close();
            String log = "";
            String result = "";
            f = new File(filename);
            if (f == null) {
                return;
            }
            Desktop desktop = null;
            try {
                if (Desktop.isDesktopSupported()) {
                    desktop = Desktop.getDesktop();
                    desktop.open(f);
                }
            }
            catch (IOException e) {
                log = log + System.err.toString();
                e.printStackTrace(System.err);
            }
        }
        catch (Throwable e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
    }
}

