/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.util.UtilityString;
import de.malban.util.Z80ASMLine;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class TranscodeZ80To6809 {
    public static boolean doTranscode(String in, String out) {
        Vector<String> sLines = UtilityString.readTextFileToString(new File(in));
        ArrayList<String> outLines = new ArrayList<String>();
        for (int i = 0; i < sLines.size(); ++i) {
            String orgLine = sLines.elementAt(i);
            Z80ASMLine z80 = new Z80ASMLine(orgLine);
            outLines.add(TranscodeZ80To6809.transcodeLine(z80));
        }
        StringBuilder outString = new StringBuilder();
        for (String s : outLines) {
            outString.append(s).append("\n");
        }
        UtilityString.writeToTextFile(outString.toString(), new File(out));
        return true;
    }

    static String transcodeLine(Z80ASMLine z80) {
        String ret = "";
        if (z80.mnenomic.equals("nop")) {
            ret = "nop";
        }
        if (z80.mnenomic.equals("im")) {
            ret = "Interrup Mode Handler" + z80.operandAll;
        }
        if (z80.mnenomic.equals("halt")) {
            ret = "sync";
        }
        if (z80.mnenomic.equals("neg")) {
            ret = "nega";
        }
        if (z80.mnenomic.equals("ld")) {
            ret = TranscodeZ80To6809.handleLD(z80);
        }
        ret = ret + ";" + z80.org;
        return ret;
    }

    static String handleLD(Z80ASMLine z80) {
        return "";
    }
}

