/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;

public class Utility {
    static String add = "";
    static boolean isWin = Global.getOSName().toUpperCase().indexOf("WIN") != -1;

    public static String getCurrentStackTrace() {
        String s = "";
        for (int i = 0; i < Thread.currentThread().getStackTrace().length; ++i) {
            s = s + Thread.currentThread().getStackTrace()[i] + "\n";
        }
        return s;
    }

    public static String getStackTrace(Throwable e) {
        add = "";
        PrintStream p = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                char[] c = new char[]{(char)b};
                String s = new String(c);
                add = add + s;
            }
        });
        e.printStackTrace(p);
        p.flush();
        return add;
    }

    public static boolean isFilenameRelative(String relName) {
        if (relName == null) {
            return false;
        }
        return !(isWin ? relName.contains(":" + File.separator) : relName.startsWith(File.separator));
    }

    public static String makeGlobalAbsolute(String relName) {
        return Utility.makeVideAbsolute(relName);
    }

    public static String makeVideAbsolute(String relName) {
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        if (!Utility.isFilenameRelative(relName = UtilityFiles.convertSeperator(relName))) {
            return relName;
        }
        String videRelAbs = Global.mainPathPrefix + relName;
        File f = new File(videRelAbs);
        String here = f.getAbsolutePath();
        try {
            here = f.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return here;
    }

    public static String makeJavaAbsolute(String relName) {
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        if (!Utility.isFilenameRelative(relName = UtilityFiles.convertSeperator(relName))) {
            return relName;
        }
        File f = new File(relName);
        String here = f.getAbsolutePath();
        try {
            here = f.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return here;
    }

    public static String makeVideRelative(String fullpath) {
        if (Utility.isFilenameRelative(fullpath)) {
            return fullpath;
        }
        fullpath = UtilityFiles.convertSeperator(fullpath);
        File f = new File(Global.mainPathPrefix);
        String here = f.getAbsolutePath();
        String fullpathTest = fullpath;
        String hereTest = here;
        if (fullpath.endsWith(File.separator)) {
            fullpath = fullpath.substring(0, fullpath.length() - File.separator.length());
        }
        if (hereTest.endsWith(File.separator)) {
            hereTest = hereTest.substring(0, hereTest.length() - File.separator.length());
        }
        if (isWin) {
            fullpathTest = fullpath.toLowerCase();
            hereTest = here.toLowerCase();
        }
        if (fullpathTest.indexOf(hereTest.substring(0, hereTest.length() - 1)) != -1) {
            if ((fullpath = fullpath.substring(fullpathTest.indexOf(hereTest) + hereTest.length())).startsWith(File.separator)) {
                fullpath = fullpath.substring(1);
            }
        } else {
            int len = 1;
            while (hereTest.regionMatches(0, fullpathTest, 0, len)) {
                ++len;
            }
            if ((len -= 2) <= 1) {
                return fullpath;
            }
            while (!fullpath.substring(len).startsWith(File.separator) && len >= 1) {
                --len;
            }
            String rPath = fullpath.substring(len + 1);
            String rHere = here.substring(len + 1);
            int up = UtilityString.countStrings(rHere, File.separator);
            for (int i = 0; i <= up; ++i) {
                rPath = ".." + File.separator + rPath;
            }
            fullpath = rPath;
        }
        return fullpath;
    }

    public static String makeJavaRelative(String fullpath) {
        fullpath = UtilityFiles.convertSeperator(fullpath);
        File f = new File("./");
        String here = f.getAbsolutePath();
        try {
            here = f.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String fullpathTest = fullpath;
        String hereTest = here;
        if (fullpath.endsWith(File.separator)) {
            fullpath = fullpath.substring(0, fullpath.length() - File.separator.length());
        }
        if (hereTest.endsWith(File.separator)) {
            hereTest = hereTest.substring(0, hereTest.length() - File.separator.length());
        }
        if (isWin) {
            fullpathTest = fullpath.toLowerCase();
            hereTest = here.toLowerCase();
        }
        if (fullpathTest.indexOf(hereTest.substring(0, hereTest.length() - 1)) != -1) {
            if ((fullpath = fullpath.substring(fullpathTest.indexOf(hereTest) + hereTest.length())).startsWith(File.separator)) {
                fullpath = fullpath.substring(1);
            }
        } else {
            int len = 1;
            while (hereTest.regionMatches(0, fullpathTest, 0, len)) {
                ++len;
            }
            if ((len -= 2) <= 1) {
                return fullpath;
            }
            while (!fullpath.substring(len).startsWith(File.separator) && len >= 1) {
                --len;
            }
            String rPath = fullpath.substring(len + 1);
            String rHere = here.substring(len + 1);
            int up = UtilityString.countStrings(rHere, File.separator);
            for (int i = 0; i <= up; ++i) {
                rPath = ".." + File.separator + rPath;
            }
            fullpath = rPath;
        }
        return fullpath;
    }
}

