/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.util.UtilityString;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class UtilityDate {
    public static final int WORK_START_HOUR = 9;
    public static final int WORK_END_HOUR = 17;
    public static final int YEAR_MAX = 20;
    private static GregorianCalendar mCalendar;
    private static GregorianCalendar mCalendar_t;
    private static boolean[][][] mHolydays;

    public static Date earlyDay(Date d) {
        mCalendar_t.setTime(d);
        mCalendar_t.set(11, 0);
        mCalendar_t.set(12, 0);
        mCalendar_t.set(13, 0);
        return mCalendar_t.getTime();
    }

    public static Date lateDay(Date d) {
        mCalendar_t.setTime(d);
        mCalendar_t.set(11, 23);
        mCalendar_t.set(12, 59);
        mCalendar_t.set(13, 59);
        return mCalendar_t.getTime();
    }

    public static int getDayValue(Date d) {
        mCalendar_t.setTime(d);
        int year = mCalendar_t.get(1);
        int day = mCalendar_t.get(6);
        int value = year * 1000 + day;
        return value;
    }

    public static boolean isSameDay(Date d1, Date d2) {
        return UtilityDate.getDayValue(d1) == UtilityDate.getDayValue(d2);
    }

    public static boolean isWorkday(GregorianCalendar calendar) {
        int type = calendar.get(7);
        if (type == 1 || type == 7) {
            return false;
        }
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        if (year < 2000 || year > 2020) {
            return true;
        }
        return !mHolydays[year - 2000][month][day - 1];
    }

    static Date fixWorkHours(Date date) {
        if (date == null) {
            return null;
        }
        mCalendar_t.setTime(date);
        if (mCalendar_t.get(11) > 17) {
            mCalendar_t.set(11, 17);
            mCalendar_t.set(12, 0);
            mCalendar_t.set(13, 0);
        }
        if (mCalendar_t.get(11) < 9) {
            mCalendar_t.set(11, 9);
            mCalendar_t.set(12, 0);
            mCalendar_t.set(13, 0);
        }
        return mCalendar_t.getTime();
    }

    public static int getWorkHours(Date date1, Date date2) {
        int workDays = -1;
        int hours = 0;
        int minus = 1;
        date1 = UtilityDate.fixWorkHours(date1);
        if ((date2 = UtilityDate.fixWorkHours(date2)) == null) {
            return -1;
        }
        if (date2 == null) {
            return -1;
        }
        if (date2.before(date1)) {
            minus = -1;
            Date t = date2;
            date2 = date1;
            date1 = t;
        }
        mCalendar.setTime(date1);
        hours = 17 - mCalendar.get(11);
        if (hours < 0) {
            hours = 0;
        }
        while (UtilityDate.getDayValue(mCalendar.getTime()) != UtilityDate.getDayValue(date2)) {
            if (UtilityDate.isWorkday(mCalendar)) {
                ++workDays;
            }
            UtilityDate.increaseDay(mCalendar);
        }
        mCalendar.setTime(date2);
        if (UtilityDate.getDayValue(date1) == UtilityDate.getDayValue(date2)) {
            hours -= 17 - mCalendar.get(11);
        } else {
            if (mCalendar.get(11) > 9) {
                hours += mCalendar.get(11) - 9;
            }
            if (workDays > 0) {
                hours += workDays * 8;
            }
        }
        return hours * minus;
    }

    public static int getAbsolutHours(Date date1, Date date2) {
        int workDays = -1;
        int hours = 0;
        int minus = 1;
        if (date2 == null) {
            return -1;
        }
        if (date2 == null) {
            return -1;
        }
        if (date2.before(date1)) {
            minus = -1;
            Date t = date2;
            date2 = date1;
            date1 = t;
        }
        mCalendar.setTime(date1);
        hours = mCalendar.get(11);
        while (UtilityDate.getDayValue(mCalendar.getTime()) != UtilityDate.getDayValue(date2)) {
            ++workDays;
            UtilityDate.increaseDay(mCalendar);
        }
        mCalendar.setTime(date2);
        if (UtilityDate.getDayValue(date1) == UtilityDate.getDayValue(date2)) {
            hours -= mCalendar.get(11);
            hours *= -1;
        } else {
            hours += mCalendar.get(11);
            if (workDays > 0) {
                hours += workDays * 24;
            }
        }
        return hours * minus;
    }

    public static Date incDay(Date d) {
        mCalendar_t.setTime(d);
        UtilityDate.increaseDay(mCalendar_t);
        return mCalendar_t.getTime();
    }

    public static void increaseDay(Calendar c) {
        int t = c.get(5);
        c.roll(5, true);
        if (c.get(5) < t) {
            t = c.get(2);
            c.roll(2, true);
            if (c.get(2) < t) {
                c.roll(1, true);
            }
        }
    }

    public static String getMonthName(int month) {
        switch (month) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return "unkown Month";
    }

    public static int getYear(Date date) {
        mCalendar_t.setTime(date);
        return mCalendar_t.get(1);
    }

    public static int getMonth(Date date) {
        mCalendar_t.setTime(date);
        return mCalendar_t.get(2);
    }

    public static int getDayOfWeek(Date date) {
        mCalendar_t.setTime(date);
        return mCalendar_t.get(7);
    }

    public static Date earlyMonth(Date date) {
        mCalendar_t.setTime(date);
        mCalendar_t.set(5, 1);
        mCalendar_t.set(11, 0);
        mCalendar_t.set(12, 0);
        mCalendar_t.set(13, 0);
        return mCalendar_t.getTime();
    }

    public static Date incMonth(Date date) {
        mCalendar_t.setTime(date);
        int m = mCalendar_t.get(2);
        if (++m >= 12) {
            m = 0;
            int y = mCalendar_t.get(1);
            mCalendar_t.set(1, y + 1);
        }
        mCalendar_t.set(2, m);
        return mCalendar_t.getTime();
    }

    public static Date decMonth(Date date) {
        mCalendar_t.setTime(date);
        int m = mCalendar_t.get(2);
        if (--m < 0) {
            m = 11;
            int y = mCalendar_t.get(1);
            mCalendar_t.set(1, y - 1);
        }
        mCalendar_t.set(2, m);
        return mCalendar_t.getTime();
    }

    public static Date getDateFromString(String date) {
        Date d = new Date();
        if (date == null) {
            return UtilityDate.lateDay(d);
        }
        if (date.length() == 0) {
            return UtilityDate.lateDay(d);
        }
        try {
            mCalendar_t.set(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(5, 7)) - 1, Integer.parseInt(date.substring(8, 10)));
            d = mCalendar_t.getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return UtilityDate.lateDay(d);
    }

    public static Date getDateFromStringEarly(String date) {
        Date d = new Date();
        if (date == null) {
            return UtilityDate.earlyDay(d);
        }
        if (date.length() == 0) {
            return UtilityDate.earlyDay(d);
        }
        try {
            mCalendar_t.set(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(5, 7)) - 1, Integer.parseInt(date.substring(8, 10)));
            d = mCalendar_t.getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return UtilityDate.earlyDay(d);
    }

    public static Date getDateFromStringGerman(String date) {
        Date d = new Date();
        if (date == null) {
            return UtilityDate.earlyDay(d);
        }
        if (date.length() == 0) {
            return UtilityDate.earlyDay(d);
        }
        String t = UtilityString.replace(date, " ", "");
        String[] teile = t.split("\\.");
        if (teile.length <= 1) {
            teile = t.split("-");
        }
        if (teile.length <= 1) {
            teile = t.split(",");
        }
        if (teile.length <= 1) {
            teile = t.split(" ");
        }
        try {
            mCalendar_t.set(Integer.parseInt(teile[2]), Integer.parseInt(teile[1]) - 1, Integer.parseInt(teile[0]));
            d = mCalendar_t.getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return UtilityDate.earlyDay(d);
    }

    public static Date getDate(String oracleDate) {
        if (oracleDate == null) {
            return null;
        }
        try {
            if (oracleDate.length() > 12) {
                mCalendar_t.set(Integer.parseInt(oracleDate.substring(0, 4)), Integer.parseInt(oracleDate.substring(5, 7)) - 1, Integer.parseInt(oracleDate.substring(8, 10)), Integer.parseInt(oracleDate.substring(11, 13)), Integer.parseInt(oracleDate.substring(14, 16)), Integer.parseInt(oracleDate.substring(17, 19)));
                return mCalendar_t.getTime();
            }
            mCalendar_t.set(Integer.parseInt(oracleDate.substring(0, 4)), Integer.parseInt(oracleDate.substring(5, 7)) - 1, Integer.parseInt(oracleDate.substring(8, 10)));
            return UtilityDate.earlyDay(mCalendar_t.getTime());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Date getDateOnly(String oracleDate) {
        if (oracleDate == null) {
            return null;
        }
        try {
            mCalendar_t.set(Integer.parseInt(oracleDate.substring(0, 4)), Integer.parseInt(oracleDate.substring(5, 7)) - 1, Integer.parseInt(oracleDate.substring(8, 10)));
            return UtilityDate.earlyDay(mCalendar_t.getTime());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(UtilityDate.earlyDay(date));
        String dates = "" + ca.get(1) + "-";
        dates = ca.get(2) + 1 < 10 ? dates + "0" + (ca.get(2) + 1) + "-" : dates + "" + (ca.get(2) + 1) + "-";
        dates = ca.get(5) < 10 ? dates + "0" + ca.get(5) + "" : dates + "" + ca.get(5) + "";
        return dates;
    }

    public static String dateToStringGerman(Date date) {
        if (date == null) {
            return "";
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        String dates = "";
        dates = ca.get(5) < 10 ? dates + "0" + ca.get(5) + "." : dates + "" + ca.get(5) + ".";
        dates = ca.get(2) + 1 < 10 ? dates + "0" + (ca.get(2) + 1) + "." : dates + "" + (ca.get(2) + 1) + ".";
        dates = dates + "" + ca.get(1) + "";
        return dates;
    }

    public static String dateToStringGermanClock(Date date) {
        if (date == null) {
            return "";
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        String dates = "";
        dates = ca.get(5) < 10 ? dates + "0" + ca.get(5) + "." : dates + "" + ca.get(5) + ".";
        dates = ca.get(2) + 1 < 10 ? dates + "0" + (ca.get(2) + 1) + "." : dates + "" + (ca.get(2) + 1) + ".";
        dates = dates + "" + ca.get(1) + "";
        dates = dates + " ";
        int h = ca.get(11);
        dates = h < 10 ? dates + "0" + h : dates + h;
        dates = dates + ":";
        int m = ca.get(12);
        dates = m < 10 ? dates + "0" + m : dates + m;
        dates = dates + ":";
        int s = ca.get(13);
        dates = s < 10 ? dates + "0" + s : dates + s;
        return dates;
    }

    public static int getKW(Date date) {
        int kw = -1;
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.setFirstDayOfWeek(2);
        kw = ca.get(3);
        return kw;
    }

    static {
        mHolydays = new boolean[20][12][31];
        mCalendar = new GregorianCalendar();
        mCalendar_t = new GregorianCalendar();
        for (int y = 0; y < 20; ++y) {
            for (int m = 0; m < 12; ++m) {
                for (int d = 0; d < 31; ++d) {
                    UtilityDate.mHolydays[y][m][d] = false;
                }
            }
            UtilityDate.mHolydays[y][0][0] = true;
            UtilityDate.mHolydays[y][4][0] = true;
            UtilityDate.mHolydays[y][9][2] = true;
            UtilityDate.mHolydays[y][11][23] = true;
            UtilityDate.mHolydays[y][11][24] = true;
            UtilityDate.mHolydays[y][11][25] = true;
            UtilityDate.mHolydays[y][11][26] = true;
            UtilityDate.mHolydays[y][11][27] = true;
            UtilityDate.mHolydays[y][11][28] = true;
            UtilityDate.mHolydays[y][11][29] = true;
            UtilityDate.mHolydays[y][11][30] = true;
        }
        UtilityDate.mHolydays[3][0][5] = true;
        UtilityDate.mHolydays[3][2][2] = true;
        UtilityDate.mHolydays[3][3][17] = true;
        UtilityDate.mHolydays[3][4][1] = true;
        UtilityDate.mHolydays[3][4][28] = true;
        UtilityDate.mHolydays[3][5][8] = true;
        UtilityDate.mHolydays[3][5][18] = true;
    }
}

