/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.Logable;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityString;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UtilityFiles {
    public static String error = "";
    public static String warning = "";
    private static final int BUFFER_SIZE = 4096;
    public static volatile String lastMessage = "";
    public static volatile String lastError = "";
    static boolean isMac = Global.getOSName().toUpperCase().contains("MAC");
    static boolean isWin = Global.getOSName().toUpperCase().contains("WIN");
    static boolean isLinux = Global.getOSName().toUpperCase().contains("LIN");

    private static void init() {
        error = "";
        warning = "";
    }

    public static ArrayList<String> getXMLFileList(String filePath) {
        return UtilityFiles.getFilesWith(filePath, ".xml");
    }

    public static ArrayList<String> getFilesWith(String filePath, String contain) {
        File[] fList;
        ArrayList<String> files = new ArrayList<String>();
        File directory = new File(filePath);
        if (!directory.isDirectory()) {
            if (directory.getParent() != null) {
                directory = new File(directory.getParent());
            }
            if (!directory.isDirectory()) {
                return files;
            }
        }
        filePath = directory.toString();
        for (File file : fList = directory.listFiles()) {
            if (file.isDirectory() || !file.getName().toLowerCase().contains(contain.toLowerCase())) continue;
            files.add(file.getName());
        }
        return files;
    }

    public static boolean deleteFile(String p) {
        boolean ret = true;
        UtilityFiles.init();
        Path base = Paths.get("./", new String[0]);
        Path path = base.resolve(Paths.get(p, new String[0]));
        try {
            Files.delete(path);
        }
        catch (Exception x) {
            error = x.getMessage() + "\n" + Utility.getStackTrace(x);
            ret = false;
        }
        return ret;
    }

    public static boolean deleteDirectoryRecursive(String p) {
        boolean ret = true;
        UtilityFiles.init();
        DeleteDirectoryVisitor visitor = new DeleteDirectoryVisitor();
        Path base = Paths.get(Global.mainPathPrefix, new String[0]);
        Path path = base.resolve(Paths.get(p, new String[0]));
        try {
            Files.walkFileTree(path, visitor);
        }
        catch (Exception x) {
            error = x.getMessage() + "\n" + Utility.getStackTrace(x);
            ret = false;
        }
        return ret;
    }

    public static boolean cleanDirectory(String p) {
        Path path;
        boolean ret = true;
        UtilityFiles.init();
        DeleteDirectoryVisitor visitor = new DeleteDirectoryVisitor();
        Path base = Paths.get(Global.mainPathPrefix, new String[0]);
        visitor.notme = path = base.resolve(Paths.get(p, new String[0]));
        try {
            Files.walkFileTree(path, visitor);
        }
        catch (Exception x) {
            error = x.getMessage() + "\n" + Utility.getStackTrace(x);
            ret = false;
        }
        return ret;
    }

    public static boolean copyDirectoryAllFiles(String from, String to) {
        boolean ret = true;
        UtilityFiles.init();
        CopyDirVisitor visitor = new CopyDirVisitor();
        Path base = Paths.get(Global.mainPathPrefix, new String[0]);
        visitor.fromPath = base.resolve(Paths.get(from, new String[0]));
        visitor.toPath = base.resolve(Paths.get(to, new String[0]));
        try {
            Files.walkFileTree(visitor.fromPath, visitor);
        }
        catch (Exception x) {
            error = x.getMessage() + "\n" + Utility.getStackTrace(x);
            ret = false;
        }
        return ret;
    }

    public static boolean copyOneFile(String from, String to) {
        boolean ret = true;
        UtilityFiles.init();
        CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
        if (from.startsWith("." + File.separator)) {
            from = from.substring(("." + File.separator).length());
        }
        if (to.startsWith("." + File.separator)) {
            to = to.substring(("." + File.separator).length());
        }
        Path base = Paths.get(Global.mainPathPrefix, new String[0]);
        Path fromPath = base.resolve(Paths.get(from, new String[0]));
        Path toPath = base.resolve(Paths.get(to, new String[0]));
        try {
            Files.copy(fromPath, toPath, options);
        }
        catch (Exception x) {
            error = x.getMessage() + "\n" + Utility.getStackTrace(x);
            ret = false;
        }
        return ret;
    }

    public static boolean createTextFile(String file, String text) {
        boolean ret = true;
        UtilityFiles.init();
        try {
            OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(file));
            BufferedWriter writer = new BufferedWriter(w);
            writer.write(text);
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception x) {
            error = x.getMessage() + "\n" + Utility.getStackTrace(x);
            ret = false;
            return ret;
        }
    }

    public static boolean move(String pathAndNameFrom, String pathAndNameTo) {
        boolean ret = true;
        UtilityFiles.init();
        Path base = Paths.get(Global.mainPathPrefix, new String[0]);
        Path fromPath = base.resolve(Paths.get(pathAndNameFrom, new String[0]));
        Path toPath = base.resolve(Paths.get(pathAndNameTo, new String[0]));
        try {
            Files.move(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception x) {
            error = x.getMessage() + "\n" + Utility.getStackTrace(x);
            ret = false;
        }
        return ret;
    }

    public static boolean rename(String pathAndName, String newNameOnly) {
        boolean ret = true;
        UtilityFiles.init();
        Path base = Paths.get(Global.mainPathPrefix, new String[0]);
        Path fromPath = base.resolve(Paths.get(pathAndName, new String[0]));
        Path toPath = fromPath.resolveSibling(newNameOnly);
        return UtilityFiles.move(fromPath.toString(), toPath.toString());
    }

    public static long getFileSize(String f) {
        File file = new File(f);
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean truncateFile(String filename, int upTo) {
        File file = new File(filename);
        long len = file.length();
        if (len <= (long)upTo) {
            return false;
        }
        try {
            Path path = Paths.get(filename, new String[0]);
            byte[] data2 = Files.readAllBytes(path);
            try (FileOutputStream output = new FileOutputStream(filename + ".trun", true);){
                output.write(data2, 0, upTo);
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static boolean writeBinFile(String filename, byte[] data2, boolean append) {
        return UtilityFiles.writeBinFile(filename, data2, data2.length, append);
    }

    public static boolean writeBinFile(String filename, byte[] data2) {
        return UtilityFiles.writeBinFile(filename, data2, data2.length, true);
    }

    public static boolean writeBinFile(String filename, byte[] data2, int length) {
        return UtilityFiles.writeBinFile(filename, data2, length, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBinFile(String filename, byte[] data2, int length, boolean append) {
        try {
            if (!append) {
                new File(filename).delete();
            }
            try (FileOutputStream output = new FileOutputStream(filename, true);){
                output.write(data2, 0, length);
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static boolean writeBinFile(String filename, int[] data2) {
        byte[] dataB = new byte[data2.length];
        for (int d = 0; d < data2.length; ++d) {
            dataB[d] = (byte)(data2[d] & 0xFF);
        }
        return UtilityFiles.writeBinFile(filename, dataB);
    }

    public static boolean writeBinFile(String filename, int[] data2, boolean append) {
        if (!append) {
            new File(filename).delete();
        }
        byte[] dataB = new byte[data2.length];
        for (int d = 0; d < data2.length; ++d) {
            dataB[d] = (byte)(data2[d] & 0xFF);
        }
        return UtilityFiles.writeBinFile(filename, dataB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean padFile(String filename, byte fillerByte, int upTo) {
        File file = new File(filename);
        long len = file.length();
        if (len > (long)upTo) {
            return false;
        }
        if (len == (long)upTo) {
            UtilityFiles.copyOneFile(filename, filename + ".fil");
            return true;
        }
        UtilityFiles.copyOneFile(filename, filename + ".fil");
        byte[] filler = new byte[(int)((long)upTo - len)];
        int i = 0;
        while ((long)i < (long)upTo - len) {
            filler[i] = fillerByte;
            ++i;
        }
        try (FileOutputStream output = new FileOutputStream(filename + ".fil", true);){
            output.write(filler);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean concatFiles(String filename1, String filename2, String toFile) {
        UtilityFiles.copyOneFile(filename1, toFile);
        try {
            Path path = Paths.get(filename2, new String[0]);
            byte[] data2 = Files.readAllBytes(path);
            try (FileOutputStream output = new FileOutputStream(toFile, true);){
                output.write(data2);
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean concatFiles(String filename1, String filename2) {
        UtilityFiles.copyOneFile(filename1, filename1 + ".con");
        try {
            Path path = Paths.get(filename2, new String[0]);
            byte[] data2 = Files.readAllBytes(path);
            try (FileOutputStream output = new FileOutputStream(filename1 + ".con", true);){
                output.write(data2);
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static void unzip(String zipFilePath, String destDirectory) throws IOException {
        String[] charsets = new String[]{"Cp437", "ISO-8859-1", "UTF-8"};
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream((InputStream)new FileInputStream(zipFilePath), Charset.forName(charsets[0]));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            try {
                String filePath = destDirectory + File.separator + entry.getName();
                filePath = UtilityFiles.convertSeperator(filePath);
                if (!entry.isDirectory()) {
                    UtilityFiles.extractFile(zipIn, filePath);
                } else {
                    File dir = new File(filePath);
                    dir.mkdir();
                }
            }
            catch (FileNotFoundException e) {
                String filePath = destDirectory + File.separator + entry.getName();
                filePath = UtilityFiles.convertSeperator(filePath);
                String splitter = File.separator;
                if (splitter.equals("\\")) {
                    splitter = "\\\\";
                }
                String[] dirs = filePath.split(splitter);
                String path = "";
                for (int i = 0; i < dirs.length - 1; ++i) {
                    path = path + dirs[i];
                    File dir = new File(path);
                    dir.mkdir();
                    path = path + File.separator;
                }
                UtilityFiles.extractFile(zipIn, filePath);
            }
            catch (Throwable e) {
                Configuration.getConfiguration().getDebugEntity().addLog(e, LogPanel.WARN);
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public static String convertSeperator(String filename) {
        String ret = UtilityString.replace(filename, "/", File.separator);
        ret = UtilityString.replace(ret, "\\", File.separator);
        return ret;
    }

    public static boolean executeOSCommandNoLog(String[] cmd) {
        return UtilityFiles.executeOSCommand(cmd, null, null, false);
    }

    public static boolean executeOSCommand(String[] cmd) {
        return UtilityFiles.executeOSCommand(cmd, null, null, true);
    }

    public static boolean executeOSCommand(String[] cmd, String[] envs) {
        return UtilityFiles.executeOSCommand(cmd, envs, null, true);
    }

    public static boolean executeOSCommand(String[] cmd, String[] envs, File dir, boolean loggingEnabled) {
        StreamGobbler errorGobbler = null;
        StreamGobbler outputGobbler = null;
        try {
            Process p = Runtime.getRuntime().exec(cmd, envs, dir);
            errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR");
            outputGobbler = new StreamGobbler(p.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            p.waitFor();
            while (errorGobbler.stillWorking) {
                Thread.sleep(10L);
            }
            lastError = errorGobbler.allMessages.toString().trim();
            while (outputGobbler.stillWorking) {
                Thread.sleep(10L);
            }
            lastMessage = outputGobbler.allMessages.toString().trim();
            return true;
        }
        catch (Throwable e) {
            try {
                if (errorGobbler != null) {
                    while (errorGobbler.stillWorking) {
                        Thread.sleep(10L);
                    }
                    lastError = errorGobbler.allMessages.toString().trim();
                    lastError = lastError + "\n --- \n" + e.toString() + "\n" + e.getMessage();
                    while (outputGobbler.stillWorking) {
                        Thread.sleep(10L);
                    }
                    lastMessage = outputGobbler.allMessages.toString().trim();
                } else {
                    lastError = "Gobbler is null, exception: \n" + e.toString() + "\n" + e.getMessage();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (loggingEnabled) {
                Logable log = Configuration.getConfiguration().getDebugEntity();
                log.addLog(e, LogPanel.ERROR);
            }
            return false;
        }
    }

    public static boolean executeOSCommand_noWait(String[] cmd) {
        StreamGobbler errorGobbler = null;
        StreamGobbler outputGobbler = null;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR");
            outputGobbler = new StreamGobbler(p.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
        }
        catch (Throwable e) {
            Logable log = Configuration.getConfiguration().getDebugEntity();
            log.addLog(e, LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static boolean executeOSCommandInDir(String[] cmd, String dir) {
        StreamGobbler errorGobbler = null;
        StreamGobbler outputGobbler = null;
        try {
            Process p = Runtime.getRuntime().exec(cmd, new String[0], new File(UtilityFiles.convertSeperator(dir)));
            errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR");
            outputGobbler = new StreamGobbler(p.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            p.waitFor();
        }
        catch (Throwable e) {
            Logable log = Configuration.getConfiguration().getDebugEntity();
            log.addLog(e, LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static boolean executeOSCommandInDir_noWait(String[] cmd, String dir) {
        StreamGobbler errorGobbler = null;
        StreamGobbler outputGobbler = null;
        try {
            Process p = Runtime.getRuntime().exec(cmd, new String[0], new File(UtilityFiles.convertSeperator(dir)));
            errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR");
            outputGobbler = new StreamGobbler(p.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
        }
        catch (Throwable e) {
            Logable log = Configuration.getConfiguration().getDebugEntity();
            log.addLog(e, LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static boolean ejectVolume(String path) {
        try {
            if (isMac) {
                return UtilityFiles.ejectVolumeMac(path);
            }
            if (isWin) {
                return UtilityFiles.ejectVolumeWin(path);
            }
            if (isLinux) {
                return UtilityFiles.ejectVolumeLin(path);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean ejectVolumeMac(String path) {
        Logable log = Configuration.getConfiguration().getDebugEntity();
        String filepath = "diskutil";
        String[] cmd = new String[]{filepath, "eject", path};
        log.addLog("Trying to eject: " + path, LogPanel.INFO);
        return UtilityFiles.executeOSCommand(cmd);
    }

    private static boolean ejectVolumeLin(String path) {
        Logable log = Configuration.getConfiguration().getDebugEntity();
        log.addLog("Ejecting devices programmatically is not implemented in VIDE yet. Working example code appreciated...", LogPanel.WARN);
        return false;
    }

    private static boolean ejectVolumeWin(String path) {
        Logable log = Configuration.getConfiguration().getDebugEntity();
        try {
            path = path.substring(0, 2);
            String filepath = Global.mainPathPrefix + "externalTools" + File.separator + "removeDrive" + File.separator + "Win32" + File.separator + "RemoveDrive.exe";
            String[] cmd = new String[]{filepath, path};
            log.addLog("Trying to eject: " + path, LogPanel.INFO);
            return UtilityFiles.executeOSCommand(cmd);
        }
        catch (Throwable throwable) {
            log.addLog("Ejecting failed: " + path, LogPanel.WARN);
            return false;
        }
    }

    static class StreamGobbler
    extends Thread {
        InputStream is;
        String type;
        StringBuffer allMessages = new StringBuffer();
        boolean stillWorking = false;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
            this.setName("Exec StreamGobbler");
        }

        @Override
        public void run() {
            Logable log = Configuration.getConfiguration().getDebugEntity();
            this.stillWorking = true;
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.type.equals("ERROR")) {
                        if (line.trim().length() == 0) continue;
                        this.allMessages.append(line).append("\n");
                        log.addLog(line, LogPanel.WARN);
                        continue;
                    }
                    if (line.trim().length() == 0) continue;
                    this.allMessages.append(line).append("\n");
                    log.addLog(line, LogPanel.INFO);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.stillWorking = false;
        }
    }

    static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        public Path fromPath;
        public Path toPath;
        CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};

        CopyDirVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), this.options);
            return FileVisitResult.CONTINUE;
        }
    }

    static class DeleteDirectoryVisitor
    extends SimpleFileVisitor<Path> {
        public Path notme = null;

        DeleteDirectoryVisitor() {
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (this.notme != null) {
                if (!this.notme.equals(dir)) {
                    Files.delete(dir);
                }
            } else {
                Files.delete(dir);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }
    }
}

