/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.util.UtilityString;
import de.malban.util.XMLClassBuilderData;
import de.malban.util.XMLClassBuilderDataPool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class XMLClassBuilder
extends JFrame {
    private int yPos = 55;
    private XMLClassBuilderData mConfig = new XMLClassBuilderData();
    private XMLClassBuilderDataPool mConfigPool;
    private int mClassSetting = 0;
    Vector<Field> mFields = new Vector();
    private JButton JButtonGenerate;
    private JButton jButtonAdField;
    private JButton jButtonDelete;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JCheckBox jCheckBoxIsProtected;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelFieldName;
    private JLabel jLabelType;
    private JLabel jLabelXMLName;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelField;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldClass;
    private JTextField jTextFieldFieldName;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldName;
    private JTextField jTextFieldPackage;
    private JTextField jTextFieldXMLName;

    public XMLClassBuilder() {
        this.initComponents();
        this.mConfigPool = new XMLClassBuilderDataPool();
        this.resetConfigPool(false, "");
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mConfigPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "";
        this.jComboBoxKlasse.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxKlasse.addItem(item);
            if (select) {
                if (klasseToSet.length() == 0) {
                    if (i == 0) {
                        this.jComboBoxKlasse.setSelectedIndex(i);
                        this.jTextFieldKlasse.setText(item);
                        klasse = item;
                    }
                } else if (klasseToSet.equalsIgnoreCase(item)) {
                    this.jComboBoxKlasse.setSelectedIndex(i);
                    this.jTextFieldKlasse.setText(item);
                    klasse = item;
                }
            }
            ++i;
        }
        if (select && klasse.length() == 0 && this.jComboBoxKlasse.getItemCount() > 0) {
            this.jComboBoxKlasse.setSelectedIndex(0);
            this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
            klasse = this.jComboBoxKlasse.getSelectedItem().toString();
        }
        if (!select) {
            this.jComboBoxKlasse.setSelectedIndex(-1);
        }
        Collection<XMLClassBuilderData> colC = this.mConfigPool.getMapForKlasse(klasse).values();
        Iterator<XMLClassBuilderData> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            XMLClassBuilderData item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mConfig = this.mConfigPool.get(item.mName);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mConfig = new XMLClassBuilderData();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxKlasse.setSelectedItem(this.mConfig.mClass);
        this.jTextFieldKlasse.setText(this.mConfig.mClass);
        this.jComboBoxName.setSelectedItem(this.mConfig.mName);
        this.jTextFieldName.setText(this.mConfig.mName);
        this.jTextFieldPackage.setText(this.mConfig.mPackageName);
        this.jTextFieldClass.setText(this.mConfig.mClassName);
        this.jPanel2.removeAll();
        this.yPos = 0;
        for (int i = 0; i < this.mConfig.mFieldname.size(); ++i) {
            this.addPanelWithData(i);
        }
        this.pack();
        this.invalidate();
        this.repaint();
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mConfig.mClass = this.jTextFieldKlasse.getText();
        this.mConfig.mName = this.jTextFieldName.getText();
        this.mConfig.mFieldname.clear();
        this.mConfig.mXMLName.clear();
        this.mConfig.mType.clear();
        this.collectFields();
        for (int i = 0; i < this.mFields.size(); ++i) {
            Field f = this.mFields.elementAt(i);
            this.mConfig.mFieldname.addElement(f.name);
            this.mConfig.mXMLName.addElement(f.xmlName);
            this.mConfig.mType.addElement(f.type);
        }
        this.mConfig.mPackageName = this.jTextFieldPackage.getText();
        this.mConfig.mClassName = this.jTextFieldClass.getText();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldPackage = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldClass = new JTextField();
        this.jCheckBoxIsProtected = new JCheckBox();
        this.jButtonAdField = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.jPanelField = new JPanel();
        this.jComboBoxType = new JComboBox();
        this.jLabelType = new JLabel();
        this.jTextFieldXMLName = new JTextField();
        this.jLabelXMLName = new JLabel();
        this.jTextFieldFieldName = new JTextField();
        this.jLabelFieldName = new JLabel();
        this.JButtonGenerate = new JButton();
        this.jPanel3 = new JPanel();
        this.jTextFieldKlasse = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jComboBoxKlasse = new JComboBox();
        this.jComboBoxName = new JComboBox();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Package");
        this.jLabel2.setText("Class");
        this.jCheckBoxIsProtected.setSelected(true);
        this.jCheckBoxIsProtected.setText("use Protected");
        this.jCheckBoxIsProtected.setEnabled(false);
        this.jButtonAdField.setText("Add Field");
        this.jButtonAdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLClassBuilder.this.jButtonAdFieldActionPerformed(evt);
            }
        });
        this.jPanel2.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanelField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"String", "int", "float", "boolean", "Vector<String>", "Vector<int>", "Vector<float>", "Vector<boolean>", " "}));
        this.jComboBoxType.setName("Type");
        this.jLabelType.setText("Type");
        this.jTextFieldXMLName.setName("XMLName");
        this.jLabelXMLName.setText("XMLName");
        this.jTextFieldFieldName.setName("Name");
        this.jLabelFieldName.setText("Fieldname");
        GroupLayout jPanelFieldLayout = new GroupLayout(this.jPanelField);
        this.jPanelField.setLayout(jPanelFieldLayout);
        jPanelFieldLayout.setHorizontalGroup(jPanelFieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFieldLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelFieldName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFieldName, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelXMLName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldXMLName, -2, 147, -2).addGap(34, 34, 34).addComponent(this.jLabelType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxType, -2, 145, -2).addContainerGap(135, Short.MAX_VALUE)));
        jPanelFieldLayout.setVerticalGroup(jPanelFieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFieldLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFieldLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelFieldName).addComponent(this.jTextFieldFieldName, -2, -1, -2).addComponent(this.jLabelXMLName).addComponent(this.jTextFieldXMLName, -2, -1, -2).addComponent(this.jLabelType).addComponent(this.jComboBoxType, -2, -1, -2)).addContainerGap(16, Short.MAX_VALUE)));
        this.jPanel2.add((Component)this.jPanelField, new AbsoluteConstraints(0, 0, -1, 50));
        this.jScrollPane1.setViewportView(this.jPanel2);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 766, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 345, Short.MAX_VALUE));
        this.JButtonGenerate.setText("Generate");
        this.JButtonGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLClassBuilder.this.JButtonGenerateActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel4.setText("Name");
        this.jLabel3.setText("Class");
        this.jComboBoxKlasse.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLClassBuilder.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jComboBoxName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLClassBuilder.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jButtonNew.setText("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLClassBuilder.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLClassBuilder.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLClassBuilder.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLClassBuilder.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldKlasse, -2, 118, -2).addComponent(this.jTextFieldName)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxKlasse, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxName, 0, 98, Short.MAX_VALUE))).addComponent(this.jButtonDelete)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSaveAsNew).addComponent(this.jButtonNew).addComponent(this.jButtonSave)).addContainerGap(14, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldKlasse, -2, -1, -2).addComponent(this.jComboBoxKlasse, -2, -1, -2).addComponent(this.jButtonNew)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jComboBoxName, -2, -1, -2).addComponent(this.jButtonSave)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSaveAsNew).addComponent(this.jButtonDelete))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.JButtonGenerate)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jTextFieldPackage, -2, 142, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldClass, -2, 142, -2))).addGap(55, 55, 55).addComponent(this.jCheckBoxIsProtected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGap(4, 4, 4)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldPackage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldClass, -2, -1, -2).addComponent(this.jCheckBoxIsProtected)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAdField).addComponent(this.JButtonGenerate))).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    Field getField(Container c) {
        Field ret = null;
        String name = "";
        String xmlName = "";
        String type = "";
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component field = c.getComponent(i);
            if (field == null || field.getName() == null) continue;
            if (field.getName().equals("Name")) {
                name = ((JTextField)field).getText();
            }
            if (field.getName().equals("XMLName")) {
                xmlName = ((JTextField)field).getText();
            }
            if (!field.getName().equals("Type")) continue;
            type = (String)((JComboBox)field).getSelectedItem();
        }
        if (name.length() != 0 && xmlName.length() != 0 && type.length() != 0) {
            ret = new Field();
            ret.name = name;
            ret.xmlName = xmlName;
            ret.type = type;
        }
        return ret;
    }

    private void collectFields() {
        JPanel c = this.jPanel2;
        this.mFields.clear();
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Container fieldPanel = (Container)c.getComponent(i);
            Field f = this.getField(fieldPanel);
            if (f == null) continue;
            this.mFields.addElement(f);
            System.out.println("Field: " + f.name + " added!");
        }
    }

    private void JButtonGenerateActionPerformed(ActionEvent evt) {
        int i;
        PrintWriter pw;
        this.collectFields();
        Vector<String> bClass = this.generateClass();
        Vector<String> bHandler = this.generateHandler();
        Vector<String> bPool = this.generatePool();
        Vector<String> bgui = this.generateTemplateGUI();
        Vector<String> bform = this.generateTemplateGUIForm();
        String bPackage = this.jTextFieldPackage.getText();
        String bClassName = this.jTextFieldClass.getText();
        try {
            pw = new PrintWriter(bClassName + ".java");
            for (i = 0; i < bClass.size(); ++i) {
                pw.print(bClass.elementAt(i) + "\n");
            }
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        try {
            pw = new PrintWriter(bClassName + "XMLHandler.java");
            for (i = 0; i < bHandler.size(); ++i) {
                pw.print(bHandler.elementAt(i) + "\n");
            }
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        try {
            pw = new PrintWriter(bClassName + "Pool.java");
            for (i = 0; i < bPool.size(); ++i) {
                pw.print(bPool.elementAt(i) + "\n");
            }
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        try {
            pw = new PrintWriter(bClassName + "Panel.java");
            for (i = 0; i < bgui.size(); ++i) {
                pw.print(bgui.elementAt(i) + "\n");
            }
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        try {
            pw = new PrintWriter(bClassName + "Panel.form");
            for (i = 0; i < bform.size(); ++i) {
                pw.print(bform.elementAt(i) + "\n");
            }
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    private void addPanelWithData(int i) {
        JPanel PanelField = new JPanel();
        JComboBox<String> ComboBoxType = new JComboBox<String>();
        JLabel LabelType = new JLabel();
        JTextField TextFieldXMLName = new JTextField();
        JLabel LabelXMLName = new JLabel();
        JTextField TextFieldFieldName = new JTextField();
        JLabel LabelFieldName = new JLabel();
        PanelField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        ComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"String", "int", "float", "boolean", "Vector<String>", "Vector<int>", "Vector<float>", "Vector<boolean>", " "}));
        LabelType.setText("Type");
        LabelXMLName.setText("XMLName");
        LabelFieldName.setText("Fieldname");
        ComboBoxType.setName("Type");
        TextFieldXMLName.setName("XMLName");
        TextFieldFieldName.setName("Name");
        GroupLayout PanelFieldLayout = new GroupLayout(PanelField);
        PanelField.setLayout(PanelFieldLayout);
        PanelFieldLayout.setHorizontalGroup(PanelFieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PanelFieldLayout.createSequentialGroup().addContainerGap().addComponent(LabelFieldName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(TextFieldFieldName, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(LabelXMLName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(TextFieldXMLName, -2, 147, -2).addGap(34, 34, 34).addComponent(LabelType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(ComboBoxType, -2, 145, -2).addContainerGap(83, Short.MAX_VALUE)));
        PanelFieldLayout.setVerticalGroup(PanelFieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PanelFieldLayout.createSequentialGroup().addContainerGap().addGroup(PanelFieldLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(LabelFieldName).addComponent(TextFieldFieldName, -2, -1, -2).addComponent(LabelXMLName).addComponent(TextFieldXMLName, -2, -1, -2).addComponent(LabelType).addComponent(ComboBoxType, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        TextFieldFieldName.setText(this.mConfig.mFieldname.elementAt(i));
        TextFieldXMLName.setText(this.mConfig.mXMLName.elementAt(i));
        ComboBoxType.setSelectedItem(this.mConfig.mType.elementAt(i));
        this.jPanel2.add((Component)PanelField, new AbsoluteConstraints(0, this.yPos, -1, 50));
        this.yPos += 55;
        this.pack();
        this.invalidate();
    }

    private void jButtonAdFieldActionPerformed(ActionEvent evt) {
        JPanel PanelField = new JPanel();
        JComboBox<String> ComboBoxType = new JComboBox<String>();
        JLabel LabelType = new JLabel();
        JTextField TextFieldXMLName = new JTextField();
        JLabel LabelXMLName = new JLabel();
        JTextField TextFieldFieldName = new JTextField();
        JLabel LabelFieldName = new JLabel();
        PanelField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        ComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"String", "int", "float", "boolean", "Vector<String>", "Vector<int>", "Vector<float>", "Vector<boolean>", " "}));
        LabelType.setText("Type");
        LabelXMLName.setText("XMLName");
        LabelFieldName.setText("Fieldname");
        ComboBoxType.setName("Type");
        TextFieldXMLName.setName("XMLName");
        TextFieldFieldName.setName("Name");
        GroupLayout PanelFieldLayout = new GroupLayout(PanelField);
        PanelField.setLayout(PanelFieldLayout);
        PanelFieldLayout.setHorizontalGroup(PanelFieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PanelFieldLayout.createSequentialGroup().addContainerGap().addComponent(LabelFieldName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(TextFieldFieldName, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(LabelXMLName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(TextFieldXMLName, -2, 147, -2).addGap(34, 34, 34).addComponent(LabelType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(ComboBoxType, -2, 145, -2).addContainerGap(83, Short.MAX_VALUE)));
        PanelFieldLayout.setVerticalGroup(PanelFieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PanelFieldLayout.createSequentialGroup().addContainerGap().addGroup(PanelFieldLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(LabelFieldName).addComponent(TextFieldFieldName, -2, -1, -2).addComponent(LabelXMLName).addComponent(TextFieldXMLName, -2, -1, -2).addComponent(LabelType).addComponent(ComboBoxType, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.add((Component)PanelField, new AbsoluteConstraints(0, this.yPos, -1, 50));
        this.yPos += 55;
        this.pack();
        this.invalidate();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mConfigPool.put(this.mConfig);
        this.mConfigPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mConfig.mName);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mConfig = new XMLClassBuilderData();
        this.readAllToCurrent();
        this.mConfigPool.putAsNew(this.mConfig);
        this.mConfigPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mConfig.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mConfigPool.remove(this.mConfig);
        this.mConfigPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mConfig = this.mConfigPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mConfig = new XMLClassBuilderData();
        this.clearAll();
        this.resetConfigPool(false, "");
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mConfig = this.mConfigPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mConfig = this.mConfigPool.get(key);
        this.setAllFromCurrent();
    }

    private Vector<String> generateClass() {
        Field f;
        int i;
        Vector<String> r = new Vector<String>();
        String bPackage = this.jTextFieldPackage.getText();
        String bClass = this.jTextFieldClass.getText();
        r.addElement("package " + bPackage + ";\n");
        r.addElement("import de.malban.util.*;");
        r.addElement("import java.util.*;");
        r.addElement("import java.io.*;");
        r.addElement("import javax.swing.*;");
        r.addElement("import javax.xml.parsers.SAXParserFactory;");
        r.addElement("import javax.xml.parsers.SAXParser;\n");
        r.addElement("public class  " + bClass + "\n{");
        if (this.jCheckBoxIsProtected.isSelected()) {
            r.addElement("\tprotected String mClass=\"\";");
            r.addElement("\tpublic String mName=\"\";");
            for (i = 0; i < this.mFields.size(); ++i) {
                f = this.mFields.elementAt(i);
                if (f.type.equals("String")) {
                    r.addElement("\tprotected String m" + f.name + "=\"\";");
                }
                if (f.type.equals("int")) {
                    r.addElement("\tprotected int m" + f.name + "=0;");
                }
                if (f.type.equals("float")) {
                    r.addElement("\tprotected float m" + f.name + "=0f;");
                }
                if (f.type.equals("boolean")) {
                    r.addElement("\tprotected boolean m" + f.name + "=false;");
                }
                if (f.type.equals("Vector<String>")) {
                    r.addElement("\tprotected Vector<String> m" + f.name + "=new Vector<String>();");
                }
                if (f.type.equals("Vector<int>")) {
                    r.addElement("\tprotected Vector<Integer> m" + f.name + "=new Vector<Integer>();");
                }
                if (f.type.equals("Vector<float>")) {
                    r.addElement("\tprotected Vector<Float> m" + f.name + "=new Vector<Float>();");
                }
                if (!f.type.equals("Vector<boolean>")) continue;
                r.addElement("\tprotected Vector<Boolean> m" + f.name + "=new Vector<Boolean>();");
            }
            r.addElement("\tpublic String getName()");
            r.addElement("\t{");
            r.addElement("\t\treturn mName;");
            r.addElement("\t}");
            r.addElement("\tpublic void setName(String n)");
            r.addElement("\t{");
            r.addElement("\t\tmName=n;");
            r.addElement("\t}");
            r.addElement("\tpublic String getCClass()");
            r.addElement("\t{");
            r.addElement("\t\treturn mClass;");
            r.addElement("\t}");
            r.addElement("\tpublic void setCClass(String c)");
            r.addElement("\t{");
            r.addElement("\t\tmClass=c;");
            r.addElement("\t}");
            for (i = 0; i < this.mFields.size(); ++i) {
                f = this.mFields.elementAt(i);
                if (f.type.equals("String")) {
                    r.addElement("\tpublic String get" + f.name + "()");
                    r.addElement("\t{");
                    r.addElement("\t\treturn m" + f.name + ";");
                    r.addElement("\t}");
                    r.addElement("\tpublic void set" + f.name + "(String " + f.name + ")");
                    r.addElement("\t{");
                    r.addElement("\t\tm" + f.name + "=" + f.name + ";");
                    r.addElement("\t}");
                }
                if (f.type.equals("int")) {
                    r.addElement("\tpublic int get" + f.name + "()");
                    r.addElement("\t{");
                    r.addElement("\t\treturn m" + f.name + ";");
                    r.addElement("\t}");
                    r.addElement("\tpublic void set" + f.name + "(int " + f.name + ")");
                    r.addElement("\t{");
                    r.addElement("\t\tm" + f.name + "=" + f.name + ";");
                    r.addElement("\t}");
                }
                if (f.type.equals("float")) {
                    r.addElement("\tpublic float get" + f.name + "()");
                    r.addElement("\t{");
                    r.addElement("\t\treturn m" + f.name + ";");
                    r.addElement("\t}");
                    r.addElement("\tpublic void set" + f.name + "(float " + f.name + ")");
                    r.addElement("\t{");
                    r.addElement("\t\tm" + f.name + "=" + f.name + ";");
                    r.addElement("\t}");
                }
                if (f.type.equals("boolean")) {
                    r.addElement("\tpublic boolean get" + f.name + "()");
                    r.addElement("\t{");
                    r.addElement("\t\treturn m" + f.name + ";");
                    r.addElement("\t}");
                    r.addElement("\tpublic void set" + f.name + "(boolean " + f.name + ")");
                    r.addElement("\t{");
                    r.addElement("\t\tm" + f.name + "=" + f.name + ";");
                    r.addElement("\t}");
                }
                if (f.type.equals("Vector<String>")) {
                    r.addElement("\tpublic Vector<String> get" + f.name + "()");
                    r.addElement("\t{");
                    r.addElement("\t\treturn m" + f.name + ";");
                    r.addElement("\t}");
                    r.addElement("\tpublic void set" + f.name + "(Vector<String> " + f.name + ")");
                    r.addElement("\t{");
                    r.addElement("\t\tm" + f.name + "=" + f.name + ";");
                    r.addElement("\t}");
                }
                if (f.type.equals("Vector<int>")) {
                    r.addElement("\tpublic Vector<Integer> get" + f.name + "()");
                    r.addElement("\t{");
                    r.addElement("\t\treturn m" + f.name + ";");
                    r.addElement("\t}");
                    r.addElement("\tpublic void set" + f.name + "(Vector<Integer> " + f.name + ")");
                    r.addElement("\t{");
                    r.addElement("\t\tm" + f.name + "=" + f.name + ";");
                    r.addElement("\t}");
                }
                if (f.type.equals("Vector<float>")) {
                    r.addElement("\tpublic Vector<Float> get" + f.name + "()");
                    r.addElement("\t{");
                    r.addElement("\t\treturn m" + f.name + ";");
                    r.addElement("\t}");
                    r.addElement("\tpublic void set" + f.name + "(Vector<Float> " + f.name + ")");
                    r.addElement("\t{");
                    r.addElement("\t\tm" + f.name + "=" + f.name + ";");
                    r.addElement("\t}");
                }
                if (!f.type.equals("Vector<boolean>")) continue;
                r.addElement("\tpublic Vector<Boolean> get" + f.name + "()");
                r.addElement("\t{");
                r.addElement("\t\treturn m" + f.name + ";");
                r.addElement("\t}");
                r.addElement("\tpublic void set" + f.name + "(Vector<Boolean> " + f.name + ")");
                r.addElement("\t{");
                r.addElement("\t\tm" + f.name + "=" + f.name + ";");
                r.addElement("\t}");
            }
        }
        r.addElement("\tprivate String exportXML()");
        r.addElement("\t{");
        r.addElement("\t\tStringBuffer s = new StringBuffer();");
        r.addElement("\t\ts.append( \"\\t<" + bClass + ">\\n\");");
        r.addElement("\t\ts.append( \"\\t\\t<Class>\"+UtilityString.toXML(mClass)+\"</Class>\\n\");");
        r.addElement("\t\ts.append( \"\\t\\t<Name>\"+UtilityString.toXML(mName)+\"</Name>\\n\");");
        for (i = 0; i < this.mFields.size(); ++i) {
            f = this.mFields.elementAt(i);
            if (f.type.equals("String")) {
                r.addElement("\t\ts.append( \"\\t\\t<" + f.xmlName + ">\"+UtilityString.toXML(m" + f.name + ")+\"</" + f.xmlName + ">\\n\");");
            }
            if (f.type.equals("int")) {
                r.addElement("\t\ts.append( \"\\t\\t<" + f.xmlName + ">\"+m" + f.name + "+\"</" + f.xmlName + ">\\n\");");
            }
            if (f.type.equals("float")) {
                r.addElement("\t\ts.append( \"\\t\\t<" + f.xmlName + ">\"+m" + f.name + "+\"</" + f.xmlName + ">\\n\");");
            }
            if (f.type.equals("boolean")) {
                r.addElement("\t\ts.append( \"\\t\\t<" + f.xmlName + ">\"+m" + f.name + "+\"</" + f.xmlName + ">\\n\");");
            }
            if (f.type.equals("Vector<String>")) {
                r.addElement("\t\ts.append( \"\\t\\t<" + f.xmlName + "s>\\n\");");
                r.addElement("\t\tfor (int i=0;i<m" + f.name + ".size(); i++)");
                r.addElement("\t\t{");
                r.addElement("\t\t\ts.append( \"\\t\\t\\t<" + f.xmlName + ">\"+UtilityString.toXML(m" + f.name + ".elementAt(i))+\"</" + f.xmlName + ">\\n\");");
                r.addElement("\t\t}");
                r.addElement("\t\ts.append( \"\\t\\t</" + f.xmlName + "s>\\n\");");
            }
            if (f.type.equals("Vector<int>")) {
                r.addElement("\t\ts.append( \"\\t\\t<" + f.xmlName + "s>\\n\");");
                r.addElement("\t\tfor (int i=0;i<m" + f.name + ".size(); i++)");
                r.addElement("\t\t{");
                r.addElement("\t\t\ts.append( \"\\t\\t\\t<" + f.xmlName + ">\"+m" + f.name + ".elementAt(i)+\"</" + f.xmlName + ">\\n\");");
                r.addElement("\t\t}");
                r.addElement("\t\ts.append( \"\\t\\t</" + f.xmlName + "s>\\n\");");
            }
            if (f.type.equals("Vector<float>")) {
                r.addElement("\t\ts.append( \"\\t\\t<" + f.xmlName + "s>\\n\");");
                r.addElement("\t\tfor (int i=0;i<m" + f.name + ".size(); i++)");
                r.addElement("\t\t{");
                r.addElement("\t\t\ts.append( \"\\t\\t\\t<" + f.xmlName + ">\"+m" + f.name + ".elementAt(i)+\"</" + f.xmlName + ">\\n\");");
                r.addElement("\t\t}");
                r.addElement("\t\ts.append( \"\\t\\t</" + f.xmlName + "s>\\n\");");
            }
            if (!f.type.equals("Vector<boolean>")) continue;
            r.addElement("\t\ts.append( \"\\t\\t<" + f.xmlName + "s>\\n\");");
            r.addElement("\t\tfor (int i=0;i<m" + f.name + ".size(); i++)");
            r.addElement("\t\t{");
            r.addElement("\t\t\ts.append( \"\\t\\t\\t<" + f.xmlName + ">\"+m" + f.name + ".elementAt(i)+\"</" + f.xmlName + ">\\n\");");
            r.addElement("\t\t}");
            r.addElement("\t\ts.append( \"\\t\\t</" + f.xmlName + "s>\\n\");");
        }
        r.addElement("\t\ts.append( \"\\t</" + bClass + ">\\n\");");
        r.addElement("\t\treturn s.toString();");
        r.addElement("\t}");
        r.addElement("\t@Override public String toString()\n\t{\n\t\treturn mName;\n\t}");
        r.addElement("\tprivate static " + bClass + "XMLHandler XMLHANDLER = new " + bClass + "XMLHandler();");
        r.addElement("\tpublic static " + bClass + "XMLHandler getXMLParseHandler()\n\t{\n\t\treturn XMLHANDLER;\n\t}");
        r.addElement("\tpublic static boolean saveCollectionAsXML(String filename, Collection<" + bClass + "> col)");
        r.addElement("\t{");
        r.addElement("\treturn saveCollectionAsXML(de.malban.Global.mBaseDir,  filename, col);");
        r.addElement("\t}");
        r.addElement("\tpublic static boolean saveCollectionAsXML(String pathName, String filename, Collection<" + bClass + "> col)");
        r.addElement("\t{\n\t\ttry\n\t\t{");
        r.addElement("\t\t\tPrintWriter pw = new PrintWriter(pathName+filename, \"UTF-8\");");
        r.addElement("\t\t\tpw.print(\"<?xml version=\\\"1.0\\\"?>\\n\");");
        r.addElement("\t\t\tpw.print(\"<All" + bClass + ">\\n\");");
        r.addElement("\t\t\tIterator<" + bClass + "> iter = col.iterator();");
        r.addElement("\t\t\twhile (iter.hasNext())");
        r.addElement("\t\t\t{");
        r.addElement("\t\t\t\t" + bClass + " item = iter.next();");
        r.addElement("\t\t\t\tpw.print(item.exportXML());");
        r.addElement("\t\t\t}");
        r.addElement("\t\t\tpw.print(\"</All" + bClass + ">\\n\");");
        r.addElement("\t\t\tpw.close();");
        r.addElement("\t\t}");
        r.addElement("\t\tcatch (IOException e)");
        r.addElement("\t\t{");
        r.addElement("\t\t\tSystem.err.println(e.toString());");
        r.addElement("\t\t\treturn false;");
        r.addElement("\t\t}");
        r.addElement("\t\treturn true;");
        r.addElement("\t}");
        r.addElement("\tpublic static HashMap<String, " + bClass + "> getHashMapFromXML(String filename)");
        r.addElement("\t{");
        r.addElement("\t\tHashMap<String, " + bClass + "> filters = new HashMap<String, " + bClass + ">();");
        r.addElement("\t\ttry");
        r.addElement("\t\t{");
        r.addElement("\t\t\tSAXParserFactory factory = SAXParserFactory.newInstance();");
        r.addElement("\t\t\tSAXParser saxParser = factory.newSAXParser();");
        r.addElement("\t\t\t" + bClass + "XMLHandler h = " + bClass + ".getXMLParseHandler();");
        r.addElement("\t\t\tsaxParser.parse(de.malban.Global.mBaseDir+filename, h);");
        r.addElement("\t\t\tfilters = h.getLastHashMap();");
        r.addElement("\t\t}");
        r.addElement("\t\tcatch (Throwable e)");
        r.addElement("\t\t{");
        r.addElement("\t\t\te.printStackTrace();");
        r.addElement("\t\t\tJOptionPane.showMessageDialog(null, e.toString() ,\"" + bClass + " Load Error...\",  JOptionPane.INFORMATION_MESSAGE);");
        r.addElement("\t\t}");
        r.addElement("\t\treturn filters;");
        r.addElement("\t}");
        r.addElement("}");
        return r;
    }

    private Vector<String> generateHandler() {
        Field f;
        int i;
        Vector<String> r = new Vector<String>();
        String bPackage = this.jTextFieldPackage.getText();
        String bClass = this.jTextFieldClass.getText();
        r.addElement("package " + bPackage + ";\n");
        r.addElement("import org.xml.sax.helpers.DefaultHandler;");
        r.addElement("import org.xml.sax.*;");
        r.addElement("import java.util.*;");
        r.addElement("public class  " + bClass + "XMLHandler extends DefaultHandler\n{");
        r.addElement("\tprivate HashMap<String, " + bClass + "> m" + bClass + ";");
        r.addElement("\tprivate " + bClass + " mCurrentData = null;");
        r.addElement("\tprivate String mCurrentElement = null;");
        for (i = 0; i < this.mFields.size(); ++i) {
            f = this.mFields.elementAt(i);
            r.addElement("\tprivate String m" + f.name + " = \"\";");
            if (f.type.equals("Vector<String>")) {
                r.addElement("\tprivate Vector<String> m" + f.name + "s = null;");
            }
            if (f.type.equals("Vector<int>")) {
                r.addElement("\tprivate Vector<Integer> m" + f.name + "s = null;");
            }
            if (f.type.equals("Vector<float>")) {
                r.addElement("\tprivate Vector<Float> m" + f.name + "s = null;");
            }
            if (!f.type.equals("Vector<boolean>")) continue;
            r.addElement("\tprivate Vector<Boolean> m" + f.name + "s = null;");
        }
        r.addElement("\tpublic HashMap<String, " + bClass + "> getLastHashMap()");
        r.addElement("\t{");
        r.addElement("\t\treturn m" + bClass + ";");
        r.addElement("\t}");
        r.addElement("\t@Override public void startDocument() throws SAXException");
        r.addElement("\t{");
        r.addElement("\t\tmCurrentData = new " + bClass + "();");
        r.addElement("\t\tm" + bClass + " = new HashMap<String, " + bClass + ">();");
        r.addElement("\t}");
        r.addElement("\t@Override public void endDocument () throws SAXException");
        r.addElement("\t{");
        r.addElement("\t}");
        r.addElement("\t@Override public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException");
        r.addElement("\t{");
        r.addElement("\t\tmCurrentElement = qName;");
        r.addElement("\t\tif (qName.equalsIgnoreCase(\"" + bClass + "\"))");
        r.addElement("\t\t{");
        r.addElement("\t\t\tmCurrentData = new " + bClass + "();");
        for (i = 0; i < this.mFields.size(); ++i) {
            f = this.mFields.elementAt(i);
            r.addElement("\t\t\tm" + f.name + " = \"\";");
            if (f.type.equals("Vector<String>")) {
                r.addElement("\t\t\tm" + f.name + "s = new Vector<String>();");
            }
            if (f.type.equals("Vector<int>")) {
                r.addElement("\t\t\tm" + f.name + "s = new Vector<Integer>();");
            }
            if (f.type.equals("Vector<float>")) {
                r.addElement("\t\t\tm" + f.name + "s = new Vector<Float>();");
            }
            if (!f.type.equals("Vector<boolean>")) continue;
            r.addElement("\t\t\tm" + f.name + "s = new Vector<Boolean>();");
        }
        r.addElement("\t\t}");
        r.addElement("\t}");
        r.addElement("\t@Override public void characters(char[] ch, int start, int length)");
        r.addElement("\t{");
        r.addElement("\t\tString s = new String( ch, start, length );");
        r.addElement("\t\tif (mCurrentElement == null) return;");
        if (this.jCheckBoxIsProtected.isSelected()) {
            r.addElement("\t\tif (mCurrentElement.equalsIgnoreCase(\"Class\")) mCurrentData.mClass += s;");
            r.addElement("\t\tif (mCurrentElement.equalsIgnoreCase(\"Name\")) mCurrentData.mName += s;");
            for (i = 0; i < this.mFields.size(); ++i) {
                f = this.mFields.elementAt(i);
                r.addElement("\t\tif (mCurrentElement.equalsIgnoreCase(\"" + f.xmlName + "\")) m" + f.name + " += s;");
            }
        }
        r.addElement("\t}");
        r.addElement("\t@Override public void endElement(String uri, String localName, String qName) throws SAXException");
        r.addElement("\t{");
        for (i = 0; i < this.mFields.size(); ++i) {
            f = this.mFields.elementAt(i);
            if (f.type.equals("Vector<String>")) {
                r.addElement("\t\tif (\"" + f.xmlName + "\".equalsIgnoreCase(qName))");
                r.addElement("\t\t{");
                r.addElement("\t\t\tm" + f.name + "s.addElement(m" + f.name + ");");
                r.addElement("\t\t\tm" + f.name + "=\"\";");
                r.addElement("\t\t}");
            }
            if (f.type.equals("Vector<int>")) {
                r.addElement("\t\tif (\"" + f.xmlName + "\".equalsIgnoreCase(qName))");
                r.addElement("\t\t{");
                r.addElement("\t\t\ttry{");
                r.addElement("\t\t\tm" + f.name + "s.addElement(Integer.parseInt(m" + f.name + "));");
                r.addElement("\t\t\t}catch (Throwable e){}");
                r.addElement("\t\t\tm" + f.name + "=\"\";");
                r.addElement("\t\t}");
            }
            if (f.type.equals("Vector<float>")) {
                r.addElement("\t\tif (\"" + f.xmlName + "\".equalsIgnoreCase(qName))");
                r.addElement("\t\t{");
                r.addElement("\t\t\ttry{");
                r.addElement("\t\t\tm" + f.name + "s.addElement(Float.parseFloat(m" + f.name + "));");
                r.addElement("\t\t\t}catch (Throwable e){}");
                r.addElement("\t\t\tm" + f.name + "=\"\";");
                r.addElement("\t\t}");
            }
            if (!f.type.equals("Vector<boolean>")) continue;
            r.addElement("\t\tif (\"" + f.xmlName + "\".equalsIgnoreCase(qName))");
            r.addElement("\t\t{");
            r.addElement("\t\t\ttry{");
            r.addElement("\t\t\tm" + f.name + "s.addElement(Boolean.parseBoolean(m" + f.name + "));");
            r.addElement("\t\t\t}catch (Throwable e){}");
            r.addElement("\t\t\tm" + f.name + "=\"\";");
            r.addElement("\t\t}");
        }
        r.addElement("\t\tif (\"" + bClass + "\".equalsIgnoreCase(qName))");
        r.addElement("\t\t{");
        r.addElement("\t\t\tif (mCurrentData != null)");
        r.addElement("\t\t\t{");
        for (i = 0; i < this.mFields.size(); ++i) {
            f = this.mFields.elementAt(i);
            if (f.type.equals("String")) {
                r.addElement("\t\t\t\tmCurrentData.m" + f.name + " = m" + f.name + ";");
            }
            if (f.type.equals("int")) {
                r.addElement("\t\t\t\ttry{");
                r.addElement("\t\t\t\tmCurrentData.m" + f.name + " = Integer.parseInt(m" + f.name + ");");
                r.addElement("\t\t\t\t}catch (Throwable e){}");
            }
            if (f.type.equals("float")) {
                r.addElement("\t\t\t\ttry{");
                r.addElement("\t\t\t\tmCurrentData.m" + f.name + " = Float.parseFloat(m" + f.name + ");");
                r.addElement("\t\t\t\t}catch (Throwable e){}");
            }
            if (f.type.equals("boolean")) {
                r.addElement("\t\t\t\ttry{");
                r.addElement("\t\t\t\tmCurrentData.m" + f.name + " = Boolean.parseBoolean(m" + f.name + ");");
                r.addElement("\t\t\t\t}catch (Throwable e){}");
            }
            r.addElement("\t\t\t\tm" + f.name + " = \"\";");
            if (f.type.equals("Vector<String>")) {
                r.addElement("\t\t\t\tmCurrentData.m" + f.name + " = m" + f.name + "s;");
            }
            if (f.type.equals("Vector<int>")) {
                r.addElement("\t\t\t\tmCurrentData.m" + f.name + " = m" + f.name + "s;");
            }
            if (f.type.equals("Vector<float>")) {
                r.addElement("\t\t\t\tmCurrentData.m" + f.name + " = m" + f.name + "s;");
            }
            if (!f.type.equals("Vector<boolean>")) continue;
            r.addElement("\t\t\t\tmCurrentData.m" + f.name + " = m" + f.name + "s;");
        }
        r.addElement("\t\t\t\tm" + bClass + ".put(mCurrentData.mName, mCurrentData);");
        r.addElement("\t\t\t\tmCurrentData = null;");
        r.addElement("\t\t\t}");
        r.addElement("\t\t}");
        r.addElement("\t\tmCurrentElement = null;");
        r.addElement("\t}");
        r.addElement("}");
        return r;
    }

    private Vector<String> generatePool() {
        Vector<String> r = new Vector<String>();
        String bPackage = this.jTextFieldPackage.getText();
        String bClass = this.jTextFieldClass.getText();
        r.addElement("package " + bPackage + ";\n");
        r.addElement("import javax.swing.JOptionPane;");
        r.addElement("import java.util.*;");
        r.addElement("public class  " + bClass + "Pool\n{");
        r.addElement("\tpublic static final String DEFAULT_XML_NAME = new String(\"" + bClass + ".xml\");");
        r.addElement("\tprivate String mFileName = DEFAULT_XML_NAME;");
        r.addElement("\tprivate HashMap<String, " + bClass + "> m" + bClass + " = new HashMap<String, " + bClass + ">();");
        r.addElement("\tprivate HashMap<String, String> mKlassenMap = new HashMap<String, String>();");
        r.addElement("\tpublic " + bClass + "Pool(String name)");
        r.addElement("\t{");
        r.addElement("\t\tmFileName = name;");
        r.addElement("\t\tinit();");
        r.addElement("\t}");
        r.addElement("\tpublic " + bClass + "Pool()");
        r.addElement("\t{");
        r.addElement("\t\tinit();");
        r.addElement("\t}");
        r.addElement("\tpublic void setFilename(String n)");
        r.addElement("\t{");
        r.addElement("\t\tmFileName=n;");
        r.addElement("\t}");
        r.addElement("\tprivate boolean init()");
        r.addElement("\t{");
        r.addElement("\t\ttry");
        r.addElement("\t\t{");
        r.addElement("\t\t\treturn load();");
        r.addElement("\t\t}");
        r.addElement("\t\tcatch (Throwable e)");
        r.addElement("\t\t{");
        r.addElement("\t\t\tJOptionPane.showMessageDialog(null, e.toString() ,\"Load Error " + bClass + "...\",  JOptionPane.INFORMATION_MESSAGE);");
        r.addElement("\t\t\treturn false;");
        r.addElement("\t\t}");
        r.addElement("\t}");
        r.addElement("\tpublic boolean load()");
        r.addElement("\t{");
        r.addElement("\t\tjava.io.File f = new java.io.File(de.malban.Global.mBaseDir+mFileName);");
        r.addElement("\t\tif (!f.exists()) return false;");
        r.addElement("\t\tm" + bClass + " = " + bClass + ".getHashMapFromXML(mFileName);");
        r.addElement("\t\treturn true;");
        r.addElement("\t}");
        r.addElement("\tpublic void save()");
        r.addElement("\t{");
        r.addElement("\t\t" + bClass + ".saveCollectionAsXML(mFileName, m" + bClass + ".values());");
        r.addElement("\t\tbuildKlassenMap();");
        r.addElement("\t}");
        r.addElement("\tpublic void remove(" + bClass + " st)");
        r.addElement("\t{");
        r.addElement("\t\tm" + bClass + ".remove(st.mName);");
        r.addElement("\t}");
        r.addElement("\tpublic void put(" + bClass + " st)");
        r.addElement("\t{");
        r.addElement("\t\tm" + bClass + ".remove(st.mName);");
        r.addElement("\t\tm" + bClass + ".put(st.mName, st);");
        r.addElement("\t}");
        r.addElement("\tpublic void putAsNew(" + bClass + " st)");
        r.addElement("\t{");
        r.addElement("\t\tm" + bClass + ".put(st.mName, st);");
        r.addElement("\t}");
        r.addElement("\tpublic " + bClass + " get(String key)");
        r.addElement("\t{");
        r.addElement("\t\treturn m" + bClass + ".get(key);");
        r.addElement("\t}");
        r.addElement("\tpublic HashMap<String, " + bClass + "> getHashMap()");
        r.addElement("\t{");
        r.addElement("\t\treturn m" + bClass + ";");
        r.addElement("\t}");
        r.addElement("\tprivate void buildKlassenMap()");
        r.addElement("\t{");
        r.addElement("\t\tmKlassenMap = new HashMap<String, String>();");
        r.addElement("\t\tSet entries = m" + bClass + ".entrySet();");
        r.addElement("\t\tIterator it = entries.iterator();");
        r.addElement("\t\twhile (it.hasNext())");
        r.addElement("\t\t{");
        r.addElement("\t\t\tMap.Entry entry = (Map.Entry) it.next();");
        r.addElement("\t\t\t" + bClass + " value = (" + bClass + ") entry.getValue();");
        r.addElement("\t\t\tmKlassenMap.put(value.mClass, value.mClass);");
        r.addElement("\t\t}");
        r.addElement("\t}");
        r.addElement("\tpublic HashMap<String, String> getKlassenHashMap()");
        r.addElement("\t{");
        r.addElement("\t\tbuildKlassenMap();");
        r.addElement("\t\treturn mKlassenMap;");
        r.addElement("\t}");
        r.addElement("\tpublic HashMap<String, " + bClass + "> getMapForKlasse(String klasse)");
        r.addElement("\t{");
        r.addElement("\t\tHashMap<String, " + bClass + "> ret = new HashMap<String, " + bClass + ">();");
        r.addElement("\t\tSet entries = m" + bClass + ".entrySet();");
        r.addElement("\t\tIterator it = entries.iterator();");
        r.addElement("\t\twhile (it.hasNext())");
        r.addElement("\t\t{");
        r.addElement("\t\t\tMap.Entry entry = (Map.Entry) it.next();");
        r.addElement("\t\t\t" + bClass + " value = (" + bClass + ") entry.getValue();");
        r.addElement("\t\t\tif (value.mClass.equalsIgnoreCase(klasse))");
        r.addElement("\t\t\t{");
        r.addElement("\t\t\t\tret.put(value.mName, value);");
        r.addElement("\t\t\t}");
        r.addElement("\t\t}");
        r.addElement("\t\t return ret;");
        r.addElement("\t}");
        r.addElement("}");
        return r;
    }

    private Vector<String> generateTemplateGUI() {
        Vector<String> r = new Vector<String>();
        String bPackage = this.jTextFieldPackage.getText();
        String bClass = this.jTextFieldClass.getText();
        r.addElement("package " + bPackage + ";\n");
        r.addElement("");
        r.addElement("import java.util.*;");
        r.addElement("");
        r.addElement("public class TemplateGui extends javax.swing.JPanel {");
        r.addElement("    private XMLClassBuilderData mConfig = new XMLClassBuilderData();");
        r.addElement("    private XMLClassBuilderDataPool mConfigPool;");
        r.addElement("    private int mClassSetting=0;");
        r.addElement("");
        r.addElement("    /** Creates new form TemplateGui */");
        r.addElement("    public TemplateGui() {");
        r.addElement("        initComponents();");
        r.addElement("        mConfigPool = new XMLClassBuilderDataPool();");
        r.addElement("        resetConfigPool(false, \"\");");
        r.addElement("    }");
        r.addElement("");
        r.addElement("    private void resetConfigPool(boolean select, String klasseToSet) /* allneeded*/");
        r.addElement("    {");
        r.addElement("        mClassSetting++;");
        r.addElement("        Collection<String> collectionKlasse = mConfigPool.getKlassenHashMap().values();");
        r.addElement("        Iterator<String> iterKlasse = collectionKlasse.iterator();");
        r.addElement("        int i = 0;");
        r.addElement("        String klasse = \"\";");
        r.addElement("");
        r.addElement("        jComboBoxKlasse.removeAllItems();");
        r.addElement("        while (iterKlasse.hasNext())");
        r.addElement("        {");
        r.addElement("            String item = iterKlasse.next();");
        r.addElement("            jComboBoxKlasse.addItem(item);");
        r.addElement("            if (select)");
        r.addElement("            {");
        r.addElement("                if (klasseToSet.length()==0)");
        r.addElement("                {");
        r.addElement("                    if (i==0)");
        r.addElement("                    {");
        r.addElement("                        jComboBoxKlasse.setSelectedIndex(i);");
        r.addElement("                        jTextFieldKlasse.setText(item);");
        r.addElement("                        klasse = item;");
        r.addElement("                    }");
        r.addElement("                }");
        r.addElement("                else");
        r.addElement("                {");
        r.addElement("                    if (klasseToSet.equalsIgnoreCase(item))");
        r.addElement("                    {");
        r.addElement("                        jComboBoxKlasse.setSelectedIndex(i);");
        r.addElement("                        jTextFieldKlasse.setText(item);");
        r.addElement("                        klasse = item;");
        r.addElement("                    }");
        r.addElement("                }");
        r.addElement("            }");
        r.addElement("            i++;");
        r.addElement("        }");
        r.addElement("        if ((select) && (klasse.length()==0))");
        r.addElement("        {");
        r.addElement("            if (jComboBoxKlasse.getItemCount()>0)");
        r.addElement("            {");
        r.addElement("                jComboBoxKlasse.setSelectedIndex(0);");
        r.addElement("                jTextFieldKlasse.setText(jComboBoxKlasse.getSelectedItem().toString());");
        r.addElement("                klasse = jComboBoxKlasse.getSelectedItem().toString();");
        r.addElement("            }");
        r.addElement("        }");
        r.addElement("        if (!select)  jComboBoxKlasse.setSelectedIndex(-1);");
        r.addElement("");
        r.addElement("        Collection<XMLClassBuilderData> colC = mConfigPool.getMapForKlasse(klasse).values();");
        r.addElement("        Iterator<XMLClassBuilderData> iterC = colC.iterator();");
        r.addElement("");
        r.addElement("        jComboBoxName.removeAllItems();");
        r.addElement("        i = 0;");
        r.addElement("        while (iterC.hasNext())");
        r.addElement("        {");
        r.addElement("            XMLClassBuilderData item = iterC.next();");
        r.addElement("            jComboBoxName.addItem(item.mName);");
        r.addElement("            if ((i==0) && (select))");
        r.addElement("            {");
        r.addElement("                jComboBoxName.setSelectedIndex(0);");
        r.addElement("                mConfig = mConfigPool.get(item.mName);");
        r.addElement("                setAllFromCurrent();");
        r.addElement("            }");
        r.addElement("            i++;");
        r.addElement("        }");
        r.addElement("        if (!select)  jComboBoxName.setSelectedIndex(-1);");
        r.addElement("        mClassSetting--;");
        r.addElement("    }");
        r.addElement("");
        r.addElement("    private void clearAll() /* allneeded*/");
        r.addElement("    {");
        r.addElement("        mClassSetting++;");
        r.addElement("        mConfig = new XMLClassBuilderData();");
        r.addElement("        setAllFromCurrent();");
        r.addElement("        mClassSetting--;");
        r.addElement("    }");
        r.addElement("");
        r.addElement("    private void setAllFromCurrent() /* allneeded*/");
        r.addElement("    {");
        r.addElement("        mClassSetting++;");
        r.addElement("        jComboBoxKlasse.setSelectedItem(mConfig.mClass);");
        r.addElement("        jTextFieldKlasse.setText(mConfig.mClass);");
        r.addElement("        jComboBoxName.setSelectedItem(mConfig.mName);");
        r.addElement("        jTextFieldName.setText(mConfig.mName);");
        r.addElement("");
        r.addElement("        /* TO DO: Fill in needed Fields!");
        r.addElement("         *");
        r.addElement("         */");
        r.addElement("        mClassSetting--;");
        r.addElement("    }");
        r.addElement("");
        r.addElement("    private void readAllToCurrent() /* allneeded*/");
        r.addElement("    {");
        r.addElement("        mConfig.mClass = jTextFieldKlasse.getText();");
        r.addElement("        mConfig.mName = jTextFieldName.getText();");
        r.addElement("");
        r.addElement("        /* TO DO: Fill in needed Fields!");
        r.addElement("         *");
        r.addElement("         */");
        r.addElement("    }");
        r.addElement("    /** This method is called from within the constructor to");
        r.addElement("     * initialize the form.");
        r.addElement("     * WARNING: Do NOT modify this code. The content of this method is");
        r.addElement("     * always regenerated by the Form Editor.");
        r.addElement("     */");
        r.addElement("    @SuppressWarnings(\"unchecked\")");
        r.addElement("    // <editor-fold defaultstate=\"collapsed\" desc=\"Generated Code\">//GEN-BEGIN:initComponents");
        r.addElement("    private void initComponents() {");
        r.addElement("");
        r.addElement("        jPanel1 = new javax.swing.JPanel();");
        r.addElement("        jComboBoxKlasse = new javax.swing.JComboBox();");
        r.addElement("        jComboBoxName = new javax.swing.JComboBox();");
        r.addElement("        jLabel3 = new javax.swing.JLabel();");
        r.addElement("        jLabel4 = new javax.swing.JLabel();");
        r.addElement("        jTextFieldName = new javax.swing.JTextField();");
        r.addElement("        jTextFieldKlasse = new javax.swing.JTextField();");
        r.addElement("        jButtonNew = new javax.swing.JButton();");
        r.addElement("        jButtonSave = new javax.swing.JButton();");
        r.addElement("        jButtonSaveAsNew = new javax.swing.JButton();");
        r.addElement("        jButtonDelete = new javax.swing.JButton();");
        r.addElement("        jPanel2 = new javax.swing.JPanel();");
        r.addElement("");
        r.addElement("        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());");
        r.addElement("");
        r.addElement("        jComboBoxKlasse.addActionListener(new java.awt.event.ActionListener() {");
        r.addElement("            public void actionPerformed(java.awt.event.ActionEvent evt) {");
        r.addElement("                jComboBoxKlasseActionPerformed(evt);");
        r.addElement("            }");
        r.addElement("        });");
        r.addElement("");
        r.addElement("        jComboBoxName.addActionListener(new java.awt.event.ActionListener() {");
        r.addElement("            public void actionPerformed(java.awt.event.ActionEvent evt) {");
        r.addElement("                jComboBoxNameActionPerformed(evt);");
        r.addElement("            }");
        r.addElement("        });");
        r.addElement("");
        r.addElement("        jLabel3.setText(\"Name\");");
        r.addElement("");
        r.addElement("        jLabel4.setText(\"Class\");");
        r.addElement("");
        r.addElement("        jButtonNew.setText(\"New\");");
        r.addElement("        jButtonNew.addActionListener(new java.awt.event.ActionListener() {");
        r.addElement("            public void actionPerformed(java.awt.event.ActionEvent evt) {");
        r.addElement("                jButtonNewActionPerformed(evt);");
        r.addElement("            }");
        r.addElement("        });");
        r.addElement("");
        r.addElement("        jButtonSave.setText(\"Save\");");
        r.addElement("        jButtonSave.addActionListener(new java.awt.event.ActionListener() {");
        r.addElement("            public void actionPerformed(java.awt.event.ActionEvent evt) {");
        r.addElement("                jButtonSaveActionPerformed(evt);");
        r.addElement("            }");
        r.addElement("        });");
        r.addElement("");
        r.addElement("        jButtonSaveAsNew.setText(\"Save as new\");");
        r.addElement("        jButtonSaveAsNew.addActionListener(new java.awt.event.ActionListener() {");
        r.addElement("            public void actionPerformed(java.awt.event.ActionEvent evt) {");
        r.addElement("                jButtonSaveAsNewActionPerformed(evt);");
        r.addElement("            }");
        r.addElement("        });");
        r.addElement("");
        r.addElement("        jButtonDelete.setText(\"Delete\");");
        r.addElement("        jButtonDelete.addActionListener(new java.awt.event.ActionListener() {");
        r.addElement("            public void actionPerformed(java.awt.event.ActionEvent evt) {");
        r.addElement("                jButtonDeleteActionPerformed(evt);");
        r.addElement("            }");
        r.addElement("        });");
        r.addElement("");
        r.addElement("        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);");
        r.addElement("        jPanel1.setLayout(jPanel1Layout);");
        r.addElement("        jPanel1Layout.setHorizontalGroup(");
        r.addElement("            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("            .addGroup(jPanel1Layout.createSequentialGroup()");
        r.addElement("                .addContainerGap()");
        r.addElement("                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("                    .addComponent(jLabel4)");
        r.addElement("                    .addComponent(jLabel3))");
        r.addElement("                .addGap(16, 16, 16)");
        r.addElement("                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)");
        r.addElement("                    .addComponent(jTextFieldName, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 146, Short.MAX_VALUE)");
        r.addElement("                    .addComponent(jTextFieldKlasse, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 146, Short.MAX_VALUE))");
        r.addElement("                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)");
        r.addElement("                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("                    .addComponent(jComboBoxKlasse, 0, 146, Short.MAX_VALUE)");
        r.addElement("                    .addComponent(jComboBoxName, 0, 146, Short.MAX_VALUE))");
        r.addElement("                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)");
        r.addElement("                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("                    .addComponent(jButtonSave)");
        r.addElement("                    .addComponent(jButtonNew))");
        r.addElement("                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)");
        r.addElement("                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("                    .addComponent(jButtonSaveAsNew)");
        r.addElement("                    .addComponent(jButtonDelete))");
        r.addElement("                .addContainerGap())");
        r.addElement("        );");
        r.addElement("        jPanel1Layout.setVerticalGroup(");
        r.addElement("            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("            .addGroup(jPanel1Layout.createSequentialGroup()");
        r.addElement("                .addContainerGap()");
        r.addElement("                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("                    .addGroup(jPanel1Layout.createSequentialGroup()");
        r.addElement("                        .addComponent(jButtonDelete)");
        r.addElement("                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)");
        r.addElement("                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)");
        r.addElement("                            .addComponent(jButtonSave)");
        r.addElement("                            .addComponent(jButtonSaveAsNew)))");
        r.addElement("                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)");
        r.addElement("                        .addGroup(jPanel1Layout.createSequentialGroup()");
        r.addElement("                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)");
        r.addElement("                                .addComponent(jComboBoxKlasse, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)");
        r.addElement("                                .addComponent(jButtonNew))");
        r.addElement("                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)");
        r.addElement("                            .addComponent(jComboBoxName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))");
        r.addElement("                        .addGroup(jPanel1Layout.createSequentialGroup()");
        r.addElement("                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)");
        r.addElement("                                .addComponent(jLabel4)");
        r.addElement("                                .addComponent(jTextFieldKlasse, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))");
        r.addElement("                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)");
        r.addElement("                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)");
        r.addElement("                                .addComponent(jLabel3)");
        r.addElement("                                .addComponent(jTextFieldName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))))");
        r.addElement("                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))");
        r.addElement("        );");
        r.addElement("");
        r.addElement("        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);");
        r.addElement("        jPanel2.setLayout(jPanel2Layout);");
        r.addElement("        jPanel2Layout.setHorizontalGroup(");
        r.addElement("            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("            .addGap(0, 531, Short.MAX_VALUE)");
        r.addElement("        );");
        r.addElement("        jPanel2Layout.setVerticalGroup(");
        r.addElement("            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("            .addGap(0, 215, Short.MAX_VALUE)");
        r.addElement("        );");
        r.addElement("");
        r.addElement("        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);");
        r.addElement("        this.setLayout(layout);");
        r.addElement("        layout.setHorizontalGroup(");
        r.addElement("            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)");
        r.addElement("            .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)");
        r.addElement("        );");
        r.addElement("        layout.setVerticalGroup(");
        r.addElement("            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)");
        r.addElement("            .addGroup(layout.createSequentialGroup()");
        r.addElement("                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)");
        r.addElement("                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)");
        r.addElement("                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))");
        r.addElement("        );");
        r.addElement("    }// </editor-fold>//GEN-END:initComponents");
        r.addElement("");
        r.addElement("    private void jButtonNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewActionPerformed");
        r.addElement("        mClassSetting++;");
        r.addElement("        mConfig = new XMLClassBuilderData();");
        r.addElement("        clearAll();");
        r.addElement("        resetConfigPool(false, \"\");");
        r.addElement("        mClassSetting--;");
        r.addElement("}//GEN-LAST:event_jButtonNewActionPerformed");
        r.addElement("");
        r.addElement("    private void jButtonSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveActionPerformed");
        r.addElement("");
        r.addElement("        readAllToCurrent();");
        r.addElement("        mConfigPool.put(mConfig);");
        r.addElement("        mConfigPool.save();");
        r.addElement("        mClassSetting++;");
        r.addElement("        String klasse = jTextFieldKlasse.getText();");
        r.addElement("        resetConfigPool(true, klasse);");
        r.addElement("        jComboBoxName.setSelectedItem(mConfig.mName);");
        r.addElement("        mClassSetting--;");
        r.addElement("    }//GEN-LAST:event_jButtonSaveActionPerformed");
        r.addElement("");
        r.addElement("    private void jButtonSaveAsNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveAsNewActionPerformed");
        r.addElement("        mConfig = new XMLClassBuilderData();");
        r.addElement("        readAllToCurrent();");
        r.addElement("        mConfigPool.putAsNew(mConfig);");
        r.addElement("        mConfigPool.save();");
        r.addElement("        mClassSetting++;");
        r.addElement("        String klasse = jTextFieldKlasse.getText();");
        r.addElement("        resetConfigPool(true,klasse);");
        r.addElement("        jComboBoxName.setSelectedItem(mConfig.mName);");
        r.addElement("        mClassSetting--;");
        r.addElement("    }//GEN-LAST:event_jButtonSaveAsNewActionPerformed");
        r.addElement("");
        r.addElement("    private void jButtonDeleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteActionPerformed");
        r.addElement("        readAllToCurrent();");
        r.addElement("        mConfigPool.remove(mConfig);");
        r.addElement("        mConfigPool.save();");
        r.addElement("        mClassSetting++;");
        r.addElement("        String klasse = jTextFieldKlasse.getText();");
        r.addElement("        resetConfigPool(true,klasse);");
        r.addElement("");
        r.addElement("        if (jComboBoxName.getSelectedIndex() == -1)");
        r.addElement("        {");
        r.addElement("            clearAll();");
        r.addElement("        }");
        r.addElement("");
        r.addElement("        String key = jComboBoxName.getSelectedItem().toString();");
        r.addElement("        mConfig = mConfigPool.get(key);");
        r.addElement("        setAllFromCurrent();");
        r.addElement("");
        r.addElement("        mClassSetting--;");
        r.addElement("}//GEN-LAST:event_jButtonDeleteActionPerformed");
        r.addElement("");
        r.addElement("    private void jComboBoxKlasseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxKlasseActionPerformed");
        r.addElement("        if (mClassSetting >0 ) return;");
        r.addElement("        mClassSetting++;;");
        r.addElement("");
        r.addElement("        String selected = jComboBoxKlasse.getSelectedItem().toString();");
        r.addElement("        clearAll();");
        r.addElement("        resetConfigPool(true, selected);");
        r.addElement("        jTextFieldKlasse.setText(jComboBoxKlasse.getSelectedItem().toString());");
        r.addElement("        String key = jComboBoxName.getSelectedItem().toString();");
        r.addElement("        mConfig = mConfigPool.get(key);");
        r.addElement("        setAllFromCurrent();");
        r.addElement("        mClassSetting--;");
        r.addElement("    }//GEN-LAST:event_jComboBoxKlasseActionPerformed");
        r.addElement("");
        r.addElement("    private void jComboBoxNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxNameActionPerformed");
        r.addElement("        if (mClassSetting > 0 ) return;");
        r.addElement("        String key = jComboBoxName.getSelectedItem().toString();");
        r.addElement("        mConfig = mConfigPool.get(key);");
        r.addElement("        setAllFromCurrent();");
        r.addElement("    }//GEN-LAST:event_jComboBoxNameActionPerformed");
        r.addElement("");
        r.addElement("");
        r.addElement("    // Variables declaration - do not modify//GEN-BEGIN:variables");
        r.addElement("    private javax.swing.JButton jButtonDelete;");
        r.addElement("    private javax.swing.JButton jButtonNew;");
        r.addElement("    private javax.swing.JButton jButtonSave;");
        r.addElement("    private javax.swing.JButton jButtonSaveAsNew;");
        r.addElement("    private javax.swing.JComboBox jComboBoxKlasse;");
        r.addElement("    private javax.swing.JComboBox jComboBoxName;");
        r.addElement("    private javax.swing.JLabel jLabel3;");
        r.addElement("    private javax.swing.JLabel jLabel4;");
        r.addElement("    private javax.swing.JPanel jPanel1;");
        r.addElement("    private javax.swing.JPanel jPanel2;");
        r.addElement("    private javax.swing.JTextField jTextFieldKlasse;");
        r.addElement("    private javax.swing.JTextField jTextFieldName;");
        r.addElement("    // End of variables declaration//GEN-END:variables");
        r.addElement("");
        r.addElement("}");
        r = UtilityString.vectorReplace(r, "XMLClassBuilderDataPool", bClass + "Pool");
        r = UtilityString.vectorReplace(r, "mConfigPool", "m" + bClass + "Pool");
        r = UtilityString.vectorReplace(r, "XMLClassBuilderData", bClass);
        r = UtilityString.vectorReplace(r, "mConfig", "m" + bClass);
        r = UtilityString.vectorReplace(r, "TemplateGui", bClass + "Panel");
        return r;
    }

    private Vector<String> generateTemplateGUIForm() {
        Vector<String> r = new Vector<String>();
        r.addElement("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        r.addElement("");
        r.addElement("<Form version=\"1.3\" maxVersion=\"1.7\" type=\"org.netbeans.modules.form.forminfo.JPanelFormInfo\">");
        r.addElement("  <AuxValues>");
        r.addElement("    <AuxValue name=\"FormSettings_autoResourcing\" type=\"java.lang.Integer\" value=\"0\"/>");
        r.addElement("    <AuxValue name=\"FormSettings_autoSetComponentName\" type=\"java.lang.Boolean\" value=\"false\"/>");
        r.addElement("    <AuxValue name=\"FormSettings_generateFQN\" type=\"java.lang.Boolean\" value=\"true\"/>");
        r.addElement("    <AuxValue name=\"FormSettings_generateMnemonicsCode\" type=\"java.lang.Boolean\" value=\"false\"/>");
        r.addElement("    <AuxValue name=\"FormSettings_i18nAutoMode\" type=\"java.lang.Boolean\" value=\"false\"/>");
        r.addElement("    <AuxValue name=\"FormSettings_layoutCodeTarget\" type=\"java.lang.Integer\" value=\"1\"/>");
        r.addElement("    <AuxValue name=\"FormSettings_listenerGenerationStyle\" type=\"java.lang.Integer\" value=\"0\"/>");
        r.addElement("    <AuxValue name=\"FormSettings_variablesLocal\" type=\"java.lang.Boolean\" value=\"false\"/>");
        r.addElement("    <AuxValue name=\"FormSettings_variablesModifier\" type=\"java.lang.Integer\" value=\"2\"/>");
        r.addElement("  </AuxValues>");
        r.addElement("");
        r.addElement("  <Layout>");
        r.addElement("    <DimensionLayout dim=\"0\">");
        r.addElement("      <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("          <Component id=\"jPanel1\" alignment=\"0\" max=\"32767\" attributes=\"0\"/>");
        r.addElement("          <Component id=\"jPanel2\" alignment=\"0\" max=\"32767\" attributes=\"0\"/>");
        r.addElement("      </Group>");
        r.addElement("    </DimensionLayout>");
        r.addElement("    <DimensionLayout dim=\"1\">");
        r.addElement("      <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("          <Group type=\"102\" alignment=\"0\" attributes=\"0\">");
        r.addElement("              <Component id=\"jPanel1\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("              <EmptySpace max=\"-2\" attributes=\"0\"/>");
        r.addElement("              <Component id=\"jPanel2\" max=\"32767\" attributes=\"0\"/>");
        r.addElement("          </Group>");
        r.addElement("      </Group>");
        r.addElement("    </DimensionLayout>");
        r.addElement("  </Layout>");
        r.addElement("  <SubComponents>");
        r.addElement("    <Container class=\"javax.swing.JPanel\" name=\"jPanel1\">");
        r.addElement("      <Properties>");
        r.addElement("        <Property name=\"border\" type=\"javax.swing.border.Border\" editor=\"org.netbeans.modules.form.editors2.BorderEditor\">");
        r.addElement("          <Border info=\"org.netbeans.modules.form.compat2.border.EtchedBorderInfo\">");
        r.addElement("            <EtchetBorder/>");
        r.addElement("          </Border>");
        r.addElement("        </Property>");
        r.addElement("      </Properties>");
        r.addElement("");
        r.addElement("      <Layout>");
        r.addElement("        <DimensionLayout dim=\"0\">");
        r.addElement("          <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("              <Group type=\"102\" alignment=\"0\" attributes=\"0\">");
        r.addElement("                  <EmptySpace max=\"-2\" attributes=\"0\"/>");
        r.addElement("                  <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("                      <Component id=\"jLabel4\" alignment=\"0\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                      <Component id=\"jLabel3\" alignment=\"0\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                  </Group>");
        r.addElement("                  <EmptySpace min=\"-2\" pref=\"16\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                  <Group type=\"103\" groupAlignment=\"1\" attributes=\"0\">");
        r.addElement("                      <Component id=\"jTextFieldName\" alignment=\"0\" pref=\"146\" max=\"32767\" attributes=\"0\"/>");
        r.addElement("                      <Component id=\"jTextFieldKlasse\" alignment=\"0\" pref=\"146\" max=\"32767\" attributes=\"1\"/>");
        r.addElement("                  </Group>");
        r.addElement("                  <EmptySpace type=\"unrelated\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                  <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("                      <Component id=\"jComboBoxKlasse\" pref=\"146\" max=\"32767\" attributes=\"0\"/>");
        r.addElement("                      <Component id=\"jComboBoxName\" alignment=\"0\" pref=\"146\" max=\"32767\" attributes=\"1\"/>");
        r.addElement("                  </Group>");
        r.addElement("                  <EmptySpace max=\"-2\" attributes=\"0\"/>");
        r.addElement("                  <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("                      <Component id=\"jButtonSave\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                      <Component id=\"jButtonNew\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                  </Group>");
        r.addElement("                  <EmptySpace max=\"-2\" attributes=\"0\"/>");
        r.addElement("                  <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("                      <Component id=\"jButtonSaveAsNew\" alignment=\"0\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                      <Component id=\"jButtonDelete\" alignment=\"0\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                  </Group>");
        r.addElement("                  <EmptySpace min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("              </Group>");
        r.addElement("          </Group>");
        r.addElement("        </DimensionLayout>");
        r.addElement("        <DimensionLayout dim=\"1\">");
        r.addElement("          <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("              <Group type=\"102\" alignment=\"0\" attributes=\"0\">");
        r.addElement("                  <EmptySpace max=\"-2\" attributes=\"0\"/>");
        r.addElement("                  <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("                      <Group type=\"102\" alignment=\"0\" attributes=\"0\">");
        r.addElement("                          <Component id=\"jButtonDelete\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                          <EmptySpace max=\"-2\" attributes=\"0\"/>");
        r.addElement("                          <Group type=\"103\" groupAlignment=\"3\" attributes=\"0\">");
        r.addElement("                              <Component id=\"jButtonSave\" alignment=\"3\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                              <Component id=\"jButtonSaveAsNew\" alignment=\"3\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                          </Group>");
        r.addElement("                      </Group>");
        r.addElement("                      <Group type=\"103\" alignment=\"0\" groupAlignment=\"1\" attributes=\"0\">");
        r.addElement("                          <Group type=\"102\" alignment=\"1\" attributes=\"0\">");
        r.addElement("                              <Group type=\"103\" groupAlignment=\"3\" attributes=\"0\">");
        r.addElement("                                  <Component id=\"jComboBoxKlasse\" alignment=\"3\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                                  <Component id=\"jButtonNew\" alignment=\"3\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                              </Group>");
        r.addElement("                              <EmptySpace max=\"-2\" attributes=\"0\"/>");
        r.addElement("                              <Component id=\"jComboBoxName\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                          </Group>");
        r.addElement("                          <Group type=\"102\" alignment=\"1\" attributes=\"0\">");
        r.addElement("                              <Group type=\"103\" groupAlignment=\"3\" attributes=\"0\">");
        r.addElement("                                  <Component id=\"jLabel4\" alignment=\"3\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                                  <Component id=\"jTextFieldKlasse\" alignment=\"3\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                              </Group>");
        r.addElement("                              <EmptySpace max=\"-2\" attributes=\"0\"/>");
        r.addElement("                              <Group type=\"103\" groupAlignment=\"3\" attributes=\"0\">");
        r.addElement("                                  <Component id=\"jLabel3\" alignment=\"3\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                                  <Component id=\"jTextFieldName\" alignment=\"3\" min=\"-2\" max=\"-2\" attributes=\"0\"/>");
        r.addElement("                              </Group>");
        r.addElement("                          </Group>");
        r.addElement("                      </Group>");
        r.addElement("                  </Group>");
        r.addElement("                  <EmptySpace max=\"32767\" attributes=\"0\"/>");
        r.addElement("              </Group>");
        r.addElement("          </Group>");
        r.addElement("        </DimensionLayout>");
        r.addElement("      </Layout>");
        r.addElement("      <SubComponents>");
        r.addElement("        <Component class=\"javax.swing.JComboBox\" name=\"jComboBoxKlasse\">");
        r.addElement("          <Properties>");
        r.addElement("            <Property name=\"model\" type=\"javax.swing.ComboBoxModel\" editor=\"org.netbeans.modules.form.editors2.ComboBoxModelEditor\">");
        r.addElement("              <StringArray count=\"0\"/>");
        r.addElement("            </Property>");
        r.addElement("          </Properties>");
        r.addElement("          <Events>");
        r.addElement("            <EventHandler event=\"actionPerformed\" listener=\"java.awt.event.ActionListener\" parameters=\"java.awt.event.ActionEvent\" handler=\"jComboBoxKlasseActionPerformed\"/>");
        r.addElement("          </Events>");
        r.addElement("        </Component>");
        r.addElement("        <Component class=\"javax.swing.JComboBox\" name=\"jComboBoxName\">");
        r.addElement("          <Properties>");
        r.addElement("            <Property name=\"model\" type=\"javax.swing.ComboBoxModel\" editor=\"org.netbeans.modules.form.editors2.ComboBoxModelEditor\">");
        r.addElement("              <StringArray count=\"0\"/>");
        r.addElement("            </Property>");
        r.addElement("          </Properties>");
        r.addElement("          <Events>");
        r.addElement("            <EventHandler event=\"actionPerformed\" listener=\"java.awt.event.ActionListener\" parameters=\"java.awt.event.ActionEvent\" handler=\"jComboBoxNameActionPerformed\"/>");
        r.addElement("          </Events>");
        r.addElement("        </Component>");
        r.addElement("        <Component class=\"javax.swing.JLabel\" name=\"jLabel3\">");
        r.addElement("          <Properties>");
        r.addElement("            <Property name=\"text\" type=\"java.lang.String\" value=\"Name\"/>");
        r.addElement("          </Properties>");
        r.addElement("        </Component>");
        r.addElement("        <Component class=\"javax.swing.JLabel\" name=\"jLabel4\">");
        r.addElement("          <Properties>");
        r.addElement("            <Property name=\"text\" type=\"java.lang.String\" value=\"Class\"/>");
        r.addElement("          </Properties>");
        r.addElement("        </Component>");
        r.addElement("        <Component class=\"javax.swing.JTextField\" name=\"jTextFieldName\">");
        r.addElement("        </Component>");
        r.addElement("        <Component class=\"javax.swing.JTextField\" name=\"jTextFieldKlasse\">");
        r.addElement("        </Component>");
        r.addElement("        <Component class=\"javax.swing.JButton\" name=\"jButtonNew\">");
        r.addElement("          <Properties>");
        r.addElement("            <Property name=\"text\" type=\"java.lang.String\" value=\"New\"/>");
        r.addElement("          </Properties>");
        r.addElement("          <Events>");
        r.addElement("            <EventHandler event=\"actionPerformed\" listener=\"java.awt.event.ActionListener\" parameters=\"java.awt.event.ActionEvent\" handler=\"jButtonNewActionPerformed\"/>");
        r.addElement("          </Events>");
        r.addElement("        </Component>");
        r.addElement("        <Component class=\"javax.swing.JButton\" name=\"jButtonSave\">");
        r.addElement("          <Properties>");
        r.addElement("            <Property name=\"text\" type=\"java.lang.String\" value=\"Save\"/>");
        r.addElement("          </Properties>");
        r.addElement("          <Events>");
        r.addElement("            <EventHandler event=\"actionPerformed\" listener=\"java.awt.event.ActionListener\" parameters=\"java.awt.event.ActionEvent\" handler=\"jButtonSaveActionPerformed\"/>");
        r.addElement("          </Events>");
        r.addElement("        </Component>");
        r.addElement("        <Component class=\"javax.swing.JButton\" name=\"jButtonSaveAsNew\">");
        r.addElement("          <Properties>");
        r.addElement("            <Property name=\"text\" type=\"java.lang.String\" value=\"Save as new\"/>");
        r.addElement("          </Properties>");
        r.addElement("          <Events>");
        r.addElement("            <EventHandler event=\"actionPerformed\" listener=\"java.awt.event.ActionListener\" parameters=\"java.awt.event.ActionEvent\" handler=\"jButtonSaveAsNewActionPerformed\"/>");
        r.addElement("          </Events>");
        r.addElement("        </Component>");
        r.addElement("        <Component class=\"javax.swing.JButton\" name=\"jButtonDelete\">");
        r.addElement("          <Properties>");
        r.addElement("            <Property name=\"text\" type=\"java.lang.String\" value=\"Delete\"/>");
        r.addElement("          </Properties>");
        r.addElement("          <Events>");
        r.addElement("            <EventHandler event=\"actionPerformed\" listener=\"java.awt.event.ActionListener\" parameters=\"java.awt.event.ActionEvent\" handler=\"jButtonDeleteActionPerformed\"/>");
        r.addElement("          </Events>");
        r.addElement("        </Component>");
        r.addElement("      </SubComponents>");
        r.addElement("    </Container>");
        r.addElement("    <Container class=\"javax.swing.JPanel\" name=\"jPanel2\">");
        r.addElement("");
        r.addElement("      <Layout>");
        r.addElement("        <DimensionLayout dim=\"0\">");
        r.addElement("          <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("              <EmptySpace min=\"0\" pref=\"531\" max=\"32767\" attributes=\"0\"/>");
        r.addElement("          </Group>");
        r.addElement("        </DimensionLayout>");
        r.addElement("        <DimensionLayout dim=\"1\">");
        r.addElement("          <Group type=\"103\" groupAlignment=\"0\" attributes=\"0\">");
        r.addElement("              <EmptySpace min=\"0\" pref=\"215\" max=\"32767\" attributes=\"0\"/>");
        r.addElement("          </Group>");
        r.addElement("        </DimensionLayout>");
        r.addElement("      </Layout>");
        r.addElement("    </Container>");
        r.addElement("  </SubComponents>");
        r.addElement("</Form>");
        return r;
    }

    class Field {
        String name = "";
        String xmlName = "";
        String type;

        Field() {
        }
    }
}

