/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.util.XMLClassBuilderData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class XMLClassBuilderDataPool {
    public static final String DEFAULT_XML_NAME = new String("XMLClassBuilderData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, XMLClassBuilderData> mXMLClassBuilderData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public XMLClassBuilderDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public XMLClassBuilderDataPool() {
        this.init();
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error XMLClassBuilderData...", 1);
            return false;
        }
    }

    public boolean load() {
        this.mXMLClassBuilderData = XMLClassBuilderData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        XMLClassBuilderData.saveCollectionAsXML(this.mFileName, this.mXMLClassBuilderData.values());
    }

    public void remove(XMLClassBuilderData st) {
        this.mXMLClassBuilderData.remove(st.mName);
    }

    public void put(XMLClassBuilderData st) {
        this.mXMLClassBuilderData.remove(st.mName);
        this.mXMLClassBuilderData.put(st.mName, st);
    }

    public void putAsNew(XMLClassBuilderData st) {
        this.mXMLClassBuilderData.put(st.mName, st);
    }

    public XMLClassBuilderData get(String key) {
        return this.mXMLClassBuilderData.get(key);
    }

    public HashMap<String, XMLClassBuilderData> getHashMap() {
        return this.mXMLClassBuilderData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, XMLClassBuilderData>> entries = this.mXMLClassBuilderData.entrySet();
        for (Map.Entry<String, XMLClassBuilderData> entry : entries) {
            XMLClassBuilderData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, XMLClassBuilderData> getMapForKlasse(String klasse) {
        HashMap<String, XMLClassBuilderData> ret = new HashMap<String, XMLClassBuilderData>();
        Set<Map.Entry<String, XMLClassBuilderData>> entries = this.mXMLClassBuilderData.entrySet();
        for (Map.Entry<String, XMLClassBuilderData> entry : entries) {
            XMLClassBuilderData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

