/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityString;

public class XMLSupport {
    boolean quietNow = false;
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static final int OK = 0;
    public static final int ELEMENT_START_NOT_FOUND = 1;
    public static final int ELEMENT_END_NOT_FOUND = 2;
    public static final int ELEMENT_NOT_CAST_DOUBLE = 4;
    public static final int ELEMENT_NOT_CAST_INT = 8;
    public static final int ELEMENT_NOT_CAST_BOOLEAN = 16;
    public int errorCode = 0;

    public void beQuiet(boolean b) {
        this.quietNow = b;
    }

    public double getDoubleElement(String tag, StringBuilder xml) {
        this.errorCode = 0;
        double ret = 0.0;
        String found = this.getElement(tag, xml);
        try {
            ret = Double.parseDouble(found);
        }
        catch (Throwable e) {
            this.errorCode += 4;
            this.log.addLog("getDoubleElement(): cannot cast to double " + tag + " found", LogPanel.INFO);
        }
        return ret;
    }

    public int getIntElement(String tag, StringBuilder xml) {
        this.errorCode = 0;
        int ret = 0;
        String found = this.getElement(tag, xml);
        try {
            ret = Integer.parseInt(found);
        }
        catch (Throwable e) {
            this.errorCode += 8;
            this.log.addLog("getIntElement(): cannot cast to int " + tag + " found", LogPanel.INFO);
        }
        return ret;
    }

    public boolean getBooleanElement(String tag, StringBuilder xml) {
        this.errorCode = 0;
        boolean ret = false;
        String found = this.getElement(tag, xml);
        try {
            ret = Boolean.parseBoolean(found);
        }
        catch (Throwable e) {
            this.errorCode += 16;
            this.log.addLog("getBooleanElement(): cannot cast to boolean " + tag + " found", LogPanel.INFO);
        }
        return ret;
    }

    public String getStringElement(String tag, StringBuilder xml) {
        return this.getStringElement(tag, xml, true);
    }

    public String getStringElement(String tag, StringBuilder xml, boolean doWarn) {
        return this.getElement(tag, xml, doWarn);
    }

    public String getElement(String tag, StringBuilder xml) {
        return this.getElement(tag, xml, true);
    }

    public String getElement(String tag, StringBuilder xml, boolean doWarn) {
        StringBuilder element = this.getXMLElement(tag, xml, doWarn);
        if (element != null) {
            return UtilityString.fromXML(element.toString().trim());
        }
        return null;
    }

    public StringBuilder getXMLElement(String tag, StringBuilder xml) {
        return this.getXMLElement(tag, xml, true);
    }

    public StringBuilder getXMLElement(String tag, StringBuilder xml, boolean doWarn) {
        int startPos = xml.indexOf("<" + tag + ">");
        int startElementLength = ("<" + tag + ">").length();
        if (startPos < 0) {
            ++this.errorCode;
            if (doWarn && !this.quietNow) {
                this.log.addLog("getXMLElement(): StartTag not found: " + tag, LogPanel.INFO);
            }
            return null;
        }
        int endPos = xml.indexOf("</" + tag + ">");
        if (endPos < 0) {
            this.errorCode += 2;
            this.log.addLog("getXMLElement(): EndTag not found: " + tag, LogPanel.INFO);
            return null;
        }
        StringBuilder elementDataString = new StringBuilder(xml.substring(startPos + startElementLength, endPos));
        xml.delete(startPos, endPos + (startElementLength + 1));
        return elementDataString;
    }

    private static boolean ensureTagOk(String tag) {
        return true;
    }

    public static boolean addElement(StringBuilder s, String tag, double value) {
        boolean ok = XMLSupport.ensureTagOk(tag);
        if (!ok) {
            return false;
        }
        s.append("<").append(tag).append(">\n");
        s.append(value);
        s.append("</").append(tag).append(">\n");
        return true;
    }

    public static boolean addElement(StringBuilder s, String tag, int value) {
        boolean ok = XMLSupport.ensureTagOk(tag);
        if (!ok) {
            return false;
        }
        s.append("<").append(tag).append(">\n");
        s.append(value);
        s.append("</").append(tag).append(">\n");
        return true;
    }

    public static boolean addElement(StringBuilder s, String tag, boolean value) {
        boolean ok = XMLSupport.ensureTagOk(tag);
        if (!ok) {
            return false;
        }
        s.append("<").append(tag).append(">\n");
        s.append(value);
        s.append("</").append(tag).append(">\n");
        return true;
    }

    public static boolean addElement(StringBuilder s, String tag, String value) {
        boolean ok = XMLSupport.ensureTagOk(tag);
        if (!ok) {
            return false;
        }
        s.append("<").append(tag).append(">\n");
        s.append(UtilityString.toXML(value));
        s.append("</").append(tag).append(">\n");
        return true;
    }

    public static boolean hasTag(String tag, StringBuilder xml) {
        int startPos = xml.indexOf("<" + tag + ">");
        return startPos != -1;
    }

    public StringBuilder removeTag(String tag, StringBuilder xmlBuffer) {
        this.errorCode = 0;
        StringBuilder xmlElement = new StringBuilder();
        int startPos = xmlBuffer.indexOf("<" + tag + ">");
        int startElementLength = ("<" + tag + ">").length();
        if (startPos < 0) {
            return null;
        }
        int endPos = xmlBuffer.indexOf("</" + tag + ">");
        if (endPos < 0) {
            this.log.addLog("removeTag(): EndTag not found: " + tag, LogPanel.INFO);
            this.errorCode += 2;
            return null;
        }
        xmlElement.append(xmlBuffer.substring(startPos + startElementLength, endPos));
        xmlBuffer.delete(startPos, endPos + (startElementLength + 1));
        return xmlElement;
    }
}

