/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.util.UtilityString;
import de.malban.vide.assy.Comment;
import de.malban.vide.vedi.VediPanel;
import java.util.ArrayList;

public class Z80ASMLine {
    private static int UID = 0;
    public final int uid = UID++;
    public String org;
    public String clean = "";
    public String mnenomic = "";
    public String operandAllOrg = "";
    public String operandAll = "";
    public String operand1 = "";
    public String operand2 = "";
    public String lineNo = "";
    public String addressNo = "";
    public String hexRep = "";
    ArrayList<String> hexRepArray = new ArrayList();
    public String label = "";
    public String rest = "";
    public String comment = "";
    static String[] MNEMOMICS = new String[]{"ADC", "ADD", "AND", "BIT", "CALL", "CCF", "CP", "CPD", "CPDR", "CPI", "CPIR", "CPL", "DAA", "DEC", "DI", "DJNZ", "EI", "EX", "EXX", "HALT", "IM", "IN", "INC", "IND", "INDR", "INI", "INIR", "JP", "JR", "LD", "LDD", "LDDR", "LDI", "LDIR", "NEG", "NOP", "OR", "OTDR", "OTIR", "OUT", "OUTD", "OUTI", "POP", "PUSH", "RES", "RET", "RETI", "RETN", "RL", "RLA", "RLC", "RLCA", "RLD", "RR", "RRA", "RRC", "RRCA", "RRD", "RST", "SBC", "SCF", "SET", "SLA", "SRA", "SRL", "SUB", "XOR", "BYTE", "ABYTE", "DB", "DEFINE", "DC", "INCLUDE", "ORG", "END", "DD", "WORD", "DW", "DZ", "DWORD", "DUP", "NOP", "DS", "EQU", "=", "BLOCK", "ASSERT"};

    public Z80ASMLine(String s) {
        this.org = s;
        this.clean = Comment.removeEndOfLineComment(this.org);
        this.comment = UtilityString.replace(this.org, this.clean, "");
        String tmp = UtilityString.replaceWhiteSpaces(this.clean, " ");
        tmp = UtilityString.replace(tmp, "  ", " ");
        String[] split = tmp.split(" ");
        split = VediPanel.removeEmpty(split);
        if (split.length == 0) {
            return;
        }
        tmp = this.doLineNumber(tmp);
        tmp = this.doLineAddress(tmp);
        tmp = this.doLineHex(tmp);
        tmp = this.doLineLabel(tmp);
        tmp = this.doLineMnemonic(tmp);
        tmp = this.doLineOperands(tmp);
    }

    public String doLineNumber(String line) {
        this.lineNo = "";
        String[] split = line.split(" ");
        if ((split = VediPanel.removeEmpty(split)).length == 0) {
            return line;
        }
        String l1 = split[0];
        if (Z80ASMLine.isDec4(l1)) {
            if (split.length == 1) {
                return line;
            }
            String l2 = split[1].trim();
            if (Z80ASMLine.isHex4(l2 = UtilityString.replace(l2, ":", ""))) {
                this.lineNo = l1;
                line = UtilityString.replace(line, l1, "");
                return line.trim();
            }
            return line;
        }
        return line;
    }

    public String doLineAddress(String line) {
        String l1;
        this.addressNo = "";
        String[] split = line.split(" ");
        if ((split = VediPanel.removeEmpty(split)).length == 0) {
            return line;
        }
        String l2 = l1 = split[0];
        if (Z80ASMLine.isHex4(l2 = UtilityString.replace(l2, ":", ""))) {
            this.addressNo = l2;
            line = UtilityString.replace(line, l1, "");
            return line.trim();
        }
        return line;
    }

    public String doLineHex(String line) {
        this.hexRep = "";
        this.hexRepArray = new ArrayList();
        String workLine = line;
        while (true) {
            String[] split = workLine.split(" ");
            if ((split = VediPanel.removeEmpty(split)).length == 0) {
                return workLine;
            }
            String l1 = split[0];
            if (!Z80ASMLine.isHex2(l1)) break;
            if (this.hexRep.length() > 0) {
                this.hexRep = this.hexRep + " ";
            }
            this.hexRep = this.hexRep + l1;
            this.hexRepArray.add(l1);
            workLine = UtilityString.replace(workLine, l1, "").trim();
        }
        return workLine;
    }

    public String doLineLabel(String line) {
        this.label = "";
        String[] split = line.split(" ");
        if ((split = VediPanel.removeEmpty(split)).length == 0) {
            return line;
        }
        String l1 = split[0];
        if (!Z80ASMLine.isZ80Mnemonic(l1 = UtilityString.replace(l1, ":", "").trim())) {
            this.label = l1;
            line = UtilityString.replace(line, split[0], "").trim();
        }
        return line;
    }

    public String doLineMnemonic(String line) {
        this.mnenomic = "";
        String[] split = line.split(" ");
        if ((split = VediPanel.removeEmpty(split)).length == 0) {
            return line;
        }
        String l1 = split[0];
        if (Z80ASMLine.isZ80Mnemonic(l1)) {
            this.mnenomic = l1.toLowerCase();
            line = UtilityString.replace(line, l1, "").trim();
        }
        return line;
    }

    public String doLineOperands(String line) {
        this.operandAllOrg = "";
        this.operandAll = "";
        this.operand1 = "";
        this.operand2 = "";
        String[] split = line.split(" ");
        if ((split = VediPanel.removeEmpty(split)).length == 0) {
            return line;
        }
        String l1 = split[0];
        this.operandAllOrg = line.trim();
        this.operandAll = line.trim();
        String work = UtilityString.replace(this.operandAll, " ", "").trim();
        split = work.split(",");
        if ((split = VediPanel.removeEmpty(split)).length == 0) {
            return line;
        }
        this.operand1 = split[0];
        if (split.length == 1) {
            return line;
        }
        this.operand2 = split[1];
        if (split.length > 1) {
            for (int i = 2; i < split.length; ++i) {
                this.operand2 = "," + split[i];
            }
        }
        return "";
    }

    public static boolean isDec4(String n) {
        if (n == null) {
            return false;
        }
        if ((n = n.trim()).length() != 4) {
            return false;
        }
        return Z80ASMLine.isDecNumber(n);
    }

    public static boolean isHex4(String n) {
        if (n == null) {
            return false;
        }
        if ((n = n.trim()).length() != 4) {
            return false;
        }
        return Z80ASMLine.isHexNumber(n);
    }

    public static boolean isHex2(String n) {
        if (n == null) {
            return false;
        }
        if ((n = n.trim()).length() != 2) {
            return false;
        }
        return Z80ASMLine.isHexNumber(n);
    }

    public static boolean isDecNumber(String a) {
        for (int i = 0; i < a.length(); ++i) {
            char c = a.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isHexNumber(String a) {
        a = a.toLowerCase();
        for (int i = 0; i < a.length(); ++i) {
            char c = a.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            return false;
        }
        return true;
    }

    public static boolean isZ80Mnemonic(String m) {
        m = m.toUpperCase().trim();
        for (int i = 0; i < MNEMOMICS.length; ++i) {
            if (!MNEMOMICS[i].equals(m)) continue;
            return true;
        }
        return false;
    }
}

