/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.extractor;

import de.malban.Global;
import de.malban.VideMain;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.DownloaderPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityImage;
import de.malban.vide.VideConfig;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import javax.imageio.ImageIO;

public class Extractor {
    static boolean dataDirExisted;
    static boolean packDirExisted;
    static boolean chassisExisted;
    static boolean paraExisted;
    static boolean zipExisted;
    static String[] loadImages;

    public static boolean testChassisFromPara() {
        VideConfig config = VideConfig.getConfig();
        if (!Extractor.chassisMustLoad()) {
            return VideConfig.CHASSIS_AVAILABLE == 1;
        }
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        try {
            Extractor.startDataDir();
            if (!Extractor.ensureParaAvailable()) {
                Extractor.endDataDir();
                VideConfig.CHASSIS_AVAILABLE = -1;
                return VideConfig.CHASSIS_AVAILABLE == 1;
            }
            if (!Extractor.extractPara()) {
                Extractor.endDataDir();
                VideConfig.CHASSIS_AVAILABLE = -1;
                return VideConfig.CHASSIS_AVAILABLE == 1;
            }
            for (int i = 0; i < loadImages.length / 2; ++i) {
                String from = loadImages[i * 2];
                String to = UtilityFiles.convertSeperator(loadImages[i * 2 + 1]);
                InputStream is = Extractor.getParaImageInputStream(from);
                if (is == null) {
                    log.addLog(from + " could not be imported", LogPanel.WARN);
                    VideConfig.CHASSIS_AVAILABLE = -1;
                    continue;
                }
                BufferedImage image = ImageIO.read(is);
                ImageIO.write((RenderedImage)UtilityImage.toBufferedImage(image), "png", new File(to));
            }
        }
        catch (Throwable ex) {
            log.addLog(ex, LogPanel.WARN);
            VideConfig.CHASSIS_AVAILABLE = -1;
            Extractor.endDataDir();
            return VideConfig.CHASSIS_AVAILABLE == 1;
        }
        Extractor.endDataDir();
        VideConfig.CHASSIS_AVAILABLE = 1;
        return VideConfig.CHASSIS_AVAILABLE == 1;
    }

    private static void addSoftwareLibrary(File file) throws Exception {
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)ClassLoader.getSystemClassLoader(), file.toURI().toURL());
    }

    public static boolean extractPara() {
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        try {
            String name = Global.mainPathPrefix + "tmp" + File.separator + "ParaJVE_0.7.0_windows.zip";
            UtilityFiles.unzip(name, Global.mainPathPrefix + "tmp" + File.separator + "tmp1");
            String packPath = Global.mainPathPrefix + "tmp" + File.separator + "tmp1" + File.separator + "ParaJVE" + File.separator + "data" + File.separator + "packs" + File.separator + "chassis.jvepak";
            packPath = Global.mainPathPrefix + "tmp" + File.separator + "tmp1" + File.separator + "ParaJVE" + File.separator + "data" + File.separator + "roms" + File.separator + "homebrew" + File.separator + "SSlingTE.bin.jverom";
            String unpackPath = "data" + File.separator + "packs" + File.separator + "chassis.jvepak";
            unpackPath = Global.mainPathPrefix + "tmp" + File.separator + "SSlingTE.bin.jverom";
            UtilityFiles.copyOneFile(packPath, unpackPath);
            packPath = Global.mainPathPrefix + "tmp" + File.separator + "tmp1" + File.separator + "ParaJVE" + File.separator + "libs" + File.separator + "ParaJVE.jar";
            unpackPath = Global.mainPathPrefix + "lib" + File.separator + "ParaJVE.jar";
            UtilityFiles.copyOneFile(packPath, unpackPath);
            Extractor.addSoftwareLibrary(new File(unpackPath));
            UtilityFiles.deleteDirectoryRecursive(Global.mainPathPrefix + "tmp" + File.separator + "tmp1");
        }
        catch (Throwable ex) {
            log.addLog(ex, LogPanel.WARN);
            return false;
        }
        return true;
    }

    private static void startDataDir() {
        File f = new File(Global.mainPathPrefix + "data");
        dataDirExisted = f.exists();
        if (!dataDirExisted) {
            f.mkdir();
        }
        if (!(packDirExisted = (f = new File(Global.mainPathPrefix + "data" + File.separator + "packs")).exists())) {
            f.mkdir();
        }
        f = new File(Global.mainPathPrefix + "data" + File.separator + "packs" + File.separator + "chassis.jvepak");
        chassisExisted = f.exists();
        f = new File(Global.mainPathPrefix + "lib" + File.separator + "ParaJVE.jar");
        paraExisted = f.exists();
        f = new File(Global.mainPathPrefix + "tmp" + File.separator + "ParaJVE_0.7.0_windows.zip");
        zipExisted = f.exists();
    }

    private static void endDataDir() {
        File f;
        if (!zipExisted) {
            f = new File(Global.mainPathPrefix + "tmp" + File.separator + "ParaJVE_0.7.0_windows.zip");
            f.delete();
        }
        if (!paraExisted) {
            f = new File(Global.mainPathPrefix + "lib" + File.separator + "ParaJVE.jar");
            f.delete();
        }
        if (!chassisExisted) {
            f = new File(Global.mainPathPrefix + "data" + File.separator + "packs" + File.separator + "chassis.jvepak");
            f.delete();
        }
        if (!packDirExisted) {
            f = new File(Global.mainPathPrefix + "data" + File.separator + "packs");
            f.delete();
        }
        if (!dataDirExisted) {
            f = new File(Global.mainPathPrefix + "data");
            f.delete();
        }
    }

    private static InputStream getParaImageInputStream(String imageName) {
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        InputStream is = null;
        ClassLoader classLoader = VideMain.class.getClassLoader();
        try {
            Class<?> JoglContextClass = classLoader.loadClass("frc.emul.vectrex.ui.opengl.JoglContext");
            Object joglcontext = JoglContextClass.newInstance();
            Field kindField = JoglContextClass.getField("KIND_CHS");
            Object kind = kindField.get(joglcontext);
            Class<?> texLoaderClass = classLoader.loadClass("frc.emul.tools.data.TexLoader");
            Method method = texLoaderClass.getMethod("getResourceStream", String.class, Object.class);
            Object isObject = method.invoke(null, imageName, kind);
            is = (InputStream)isObject;
        }
        catch (Throwable ex) {
            log.addLog(ex, LogPanel.WARN);
            return null;
        }
        return is;
    }

    public static boolean ensureParaAvailable() {
        return DownloaderPanel.saveUrlInternal("http://vectrex.malban.de/ParaJVE_0.7.0_windows.zip", Global.mainPathPrefix + "tmp" + File.separator + "ParaJVE_0.7.0_windows.zip") != null;
    }

    private static boolean chassisMustLoad() {
        VideConfig config = VideConfig.getConfig();
        if (VideConfig.CHASSIS_AVAILABLE == 1) {
            return false;
        }
        if (VideConfig.CHASSIS_AVAILABLE == -1) {
            return false;
        }
        File chassis = new File(UtilityFiles.convertSeperator(Global.mainPathPrefix + "theme/images/chassis_screen.png"));
        if (chassis.exists()) {
            VideConfig.CHASSIS_AVAILABLE = 1;
            return false;
        }
        return true;
    }

    static {
        loadImages = new String[]{Global.mainPathPrefix + "data/packs/chassis_holders_top.png", Global.mainPathPrefix + "theme/images/chassis_holders_top.png", Global.mainPathPrefix + "data/packs/chassis_holders_bottom.png", Global.mainPathPrefix + "theme/images/chassis_holders_bottom.png", Global.mainPathPrefix + "data/packs/chassis_cartridge.png", Global.mainPathPrefix + "theme/images/chassis_cartridge.png", Global.mainPathPrefix + "data/packs/chassis_screen.png", Global.mainPathPrefix + "theme/images/chassis_screen.png", Global.mainPathPrefix + "data/packs/chassis_frame.png", Global.mainPathPrefix + "theme/images/chassis_frame.png", Global.mainPathPrefix + "data/packs/chassis_cable_port1.png", Global.mainPathPrefix + "theme/images/chassis_cable_port1.png", Global.mainPathPrefix + "data/packs/chassis_cable_port2.png", Global.mainPathPrefix + "theme/images/chassis_cable_port2.png", Global.mainPathPrefix + "data/packs/chassis_joystick_panel.png", Global.mainPathPrefix + "theme/images/chassis_joystick_panel.png"};
    }
}

