/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.Syntax;

import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.syntax.Syntax.DocPosition;
import de.malban.util.syntax.Syntax.DocPositionComparator;
import de.malban.util.syntax.Syntax.DocumentReader;
import de.malban.util.syntax.Syntax.HighlightedDocument;
import de.malban.util.syntax.Syntax.Lexer.Lexer;
import de.malban.util.syntax.Syntax.Lexer.Token;
import de.malban.util.syntax.Syntax.TokenStyles;
import de.malban.vide.VideConfig;
import de.malban.vide.vedi.VediPanel;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

class Colorer
extends Thread {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    static int uid_base = 0;
    int uid = uid_base++;
    int colorDelay = 0;
    private boolean mBreak = true;
    private WeakReference document;
    private TreeSet iniPositions = new TreeSet(DocPositionComparator.instance);
    private HashSet newPositions = new HashSet();
    private volatile LinkedList events = new LinkedList();
    private final Object eventsLock = new Object();
    private volatile int change = 0;
    private volatile int lastPosition = -1;
    boolean doNotTryToStart = false;
    boolean started = false;
    boolean broken = true;

    public Colorer(HighlightedDocument document) {
        this.setName("Colorer(" + document.knownFilename + "): " + this.uid + "!");
        this.document = new WeakReference<HighlightedDocument>(document);
        this.setPriority(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt() {
        this.doNotTryToStart = true;
        if (this.mBreak) {
            return;
        }
        Object object = this.eventsLock;
        synchronized (object) {
            this.mBreak = true;
            this.interrupt();
            this.eventsLock.notifyAll();
        }
        try {
            while (!this.broken) {
                Thread.sleep(10L);
            }
        }
        catch (Throwable e) {
            this.log.addLog("not importent:\n" + Utility.getStackTrace(e), LogPanel.INFO);
        }
    }

    public void colorAll() {
        if (!this.isStarted()) {
            return;
        }
        try {
            HighlightedDocument doc = (HighlightedDocument)this.document.get();
            if (doc == null) {
                return;
            }
            this.color(0, doc.getLength(), false);
        }
        catch (Throwable ex) {
            this.log.addLog("not importent:\n" + Utility.getStackTrace(ex), LogPanel.INFO);
        }
    }

    public void colorAllDirect() {
        HighlightedDocument doc = (HighlightedDocument)this.document.get();
        if (doc == null) {
            return;
        }
        boolean old = this.mBreak;
        if (!old) {
            this.log.addLog("Strange", LogPanel.INFO);
            System.out.println("Strange");
        }
        try {
            if (doc.asmFileInfo != null) {
                doc.asmFileInfo.processDocumentChanges(0, doc.getLength(), doc.getText(0, doc.getLength()));
            }
            if (doc.cFileInfo != null) {
                doc.cFileInfo.processDocumentChanges(0, doc.getLength(), doc.getText(0, doc.getLength()));
            }
        }
        catch (Throwable e) {
            this.log.addLog("not importent:\n" + Utility.getStackTrace(e), LogPanel.INFO);
        }
        this.mBreak = false;
        this.processEvent(0, doc.getLength(), false);
        this.events.clear();
        this.mBreak = old;
    }

    public void color(int position, int adjustment) {
        this.color(position, adjustment, true);
    }

    public void colordbg(int position, int adjustment) {
        this.color(position, adjustment, false);
    }

    public boolean isStarted() {
        return !this.mBreak && !this.broken;
    }

    @Override
    public void start() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Colorer colorer = Colorer.this;
                synchronized (colorer) {
                    if (!Colorer.this.started && !Colorer.this.doNotTryToStart) {
                        Colorer.this.started = true;
                        Colorer.this.mBreak = false;
                        Colorer.super.start();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void color(int position, int adjustment, boolean allowReset) {
        if (!this.isStarted()) {
            return;
        }
        if (position < this.lastPosition) {
            this.change = this.lastPosition < position - adjustment ? (this.change -= this.lastPosition - position) : (this.change += adjustment);
        }
        Object object = this.eventsLock;
        synchronized (object) {
            if (!this.events.isEmpty()) {
                RecolorEvent curLast = (RecolorEvent)this.events.getLast();
                if (adjustment < 0 && curLast.adjustment < 0) {
                    if (position == curLast.position) {
                        curLast.adjustment += adjustment;
                        return;
                    }
                } else if (adjustment >= 0 && curLast.adjustment >= 0) {
                    if (position == curLast.position + curLast.adjustment) {
                        curLast.adjustment += adjustment;
                        return;
                    }
                    if (curLast.position == position + adjustment) {
                        curLast.position = position;
                        curLast.adjustment += adjustment;
                        return;
                    }
                }
            }
            RecolorEvent ev = new RecolorEvent(position, adjustment, allowReset);
            this.events.add(ev);
            this.eventsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.broken = false;
        while (!this.mBreak) {
            try {
                RecolorEvent re = null;
                Object object = this.eventsLock;
                synchronized (object) {
                    while (this.events.isEmpty() && this.document.get() != null && !this.mBreak) {
                        this.eventsLock.wait(1000L);
                    }
                    if (this.mBreak) {
                        continue;
                    }
                    if (this.events.size() > 0) {
                        re = (RecolorEvent)this.events.removeFirst();
                    }
                    this.eventsLock.notifyAll();
                }
                if (re == null) continue;
                this.processEvent(re.position, re.adjustment, re.allowReset);
            }
            catch (InterruptedException re) {
            }
            catch (Throwable ee) {
                this.log.addLog(ee, LogPanel.WARN);
            }
        }
        this.broken = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(int position, int adjustment, boolean varCheck) {
        Iterator workingIt;
        SortedSet<DocPosition> workingSet;
        int tokenCount = 0;
        HighlightedDocument doc = (HighlightedDocument)this.document.get();
        if (doc == null) {
            return;
        }
        AttributeSet globalStyle = doc.getGlobalStyle();
        Lexer syntaxLexer = doc.getSyntaxLexer();
        DocumentReader documentReader = doc.getDocumentReader();
        Object docLock = doc.getDocumentLock();
        int start = Math.min(position, position + adjustment);
        int stop = Math.max(position, position + adjustment);
        if (globalStyle != null) {
            Object object = docLock;
            synchronized (object) {
                doc.setCharacterAttributes(start, stop - start, globalStyle, true);
            }
            return;
        }
        VediPanel.setInScan(true);
        DocPosition startRequest = new DocPosition(position);
        DocPosition endRequest = new DocPosition(position + Math.abs(adjustment));
        DocPosition dpStart = null;
        DocPosition dpEnd = null;
        try {
            workingSet = this.iniPositions.headSet(startRequest);
            dpStart = workingSet.last();
        }
        catch (NoSuchElementException x) {
            dpStart = new DocPosition(0);
        }
        if (varCheck) {
            ArrayList<String> changedVars;
            if (doc.asmFileInfo != null) {
                try {
                    changedVars = doc.asmFileInfo.processDocumentChanges(start, adjustment, doc.getText(0, doc.getLength()));
                    if (changedVars == null || changedVars.size() > 0) {
                        VediPanel.setInScan(false);
                        this.colorAll();
                        return;
                    }
                }
                catch (Throwable e) {
                    this.log.addLog("unkown:\n" + Utility.getStackTrace(e), LogPanel.INFO);
                }
            }
            if (doc.cFileInfo != null) {
                try {
                    changedVars = doc.cFileInfo.processDocumentChanges(start, adjustment, doc.getText(0, doc.getLength()));
                    if (changedVars == null || changedVars.size() > 0) {
                        VediPanel.setInScan(false);
                        this.colorAll();
                        return;
                    }
                }
                catch (Throwable e) {
                    this.log.addLog("unkown:\n" + Utility.getStackTrace(e), LogPanel.INFO);
                }
            }
        }
        if (adjustment < 0) {
            workingSet = this.iniPositions.subSet(startRequest, endRequest);
            workingIt = workingSet.iterator();
            while (workingIt.hasNext()) {
                workingIt.next();
                workingIt.remove();
            }
        }
        workingSet = this.iniPositions.tailSet(startRequest);
        workingIt = workingSet.iterator();
        while (workingIt.hasNext()) {
            ((DocPosition)workingIt.next()).adjustPosition(adjustment);
        }
        workingSet = this.iniPositions.tailSet(dpStart);
        workingIt = workingSet.iterator();
        DocPosition dp = null;
        if (workingIt.hasNext()) {
            dp = (DocPosition)workingIt.next();
        }
        VideConfig config = VideConfig.getConfig();
        int TAB_WIDTH = 8;
        if (config != null) {
            TAB_WIDTH = config.tab_width;
        }
        int TAB_COUNT = 100;
        TabStop[] tabs = new TabStop[TAB_COUNT];
        for (int i = 0; i < TAB_COUNT; ++i) {
            tabs[i] = new TabStop((i + 1) * TAB_WIDTH * TokenStyles.FONT_SIZE, 0, 0);
        }
        TabSet tabset = new TabSet(tabs);
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet paraSet = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.TabSet, tabset);
        doc.setParagraphAttributes(position, position + Math.abs(adjustment), paraSet, true);
        Token lastToken = null;
        try {
            Token t;
            boolean done = false;
            dpEnd = dpStart;
            Object object = docLock;
            synchronized (object) {
                syntaxLexer.reset(documentReader, 0, dpStart.getPosition(), 0);
                documentReader.seek(dpStart.getPosition());
                lastToken = t = syntaxLexer.getNextToken();
                ++tokenCount;
            }
            this.newPositions.add(dpStart);
            while (!done && t != null && !this.mBreak) {
                if (t.getCharEnd() <= doc.getLength()) {
                    AttributeSet saset;
                    int slen;
                    int sstart = t.getCharBegin() + this.change;
                    if (this.didAttributesChange(sstart, slen = t.getCharEnd() - t.getCharBegin(), saset = TokenStyles.getStyle(t.getDescription()), doc)) {
                        doc.setCharacterAttributes(sstart, slen, saset, true);
                    }
                    dpEnd = new DocPosition(t.getCharEnd());
                }
                this.lastPosition = t.getCharEnd() + this.change;
                if (this.lastPosition > stop) break;
                if (t.getState() == 0) {
                    while (dp != null && dp.getPosition() <= t.getCharEnd()) {
                        if (dp.getPosition() == t.getCharEnd() && dp.getPosition() >= endRequest.getPosition()) {
                            done = true;
                            dp = null;
                            continue;
                        }
                        if (workingIt.hasNext()) {
                            dp = (DocPosition)workingIt.next();
                            continue;
                        }
                        dp = null;
                    }
                    this.newPositions.add(dpEnd);
                }
                object = docLock;
                synchronized (object) {
                    try {
                        lastToken = t = syntaxLexer.getNextToken();
                        ++tokenCount;
                    }
                    catch (Throwable ex) {
                        this.log.addLog("Token:\n" + Utility.getStackTrace(ex), LogPanel.INFO);
                        this.log.addLog("lastToken:\n" + lastToken, LogPanel.INFO);
                        ex.printStackTrace();
                    }
                }
            }
            workingIt = this.iniPositions.subSet(dpStart, dpEnd).iterator();
            while (workingIt.hasNext()) {
                workingIt.next();
                workingIt.remove();
            }
            workingIt = this.iniPositions.tailSet(new DocPosition(doc.getLength())).iterator();
            while (workingIt.hasNext()) {
                workingIt.next();
                workingIt.remove();
            }
            this.iniPositions.addAll(this.newPositions);
            this.newPositions.clear();
        }
        catch (IOException x) {
            this.log.addLog("IO:\n" + Utility.getStackTrace(x), LogPanel.INFO);
        }
        catch (Throwable x) {
            this.log.addLog("all - weird:\n" + x, LogPanel.INFO);
            this.log.addLog("position: " + position, LogPanel.INFO);
            this.log.addLog("adjustment: " + adjustment, LogPanel.INFO);
            this.log.addLog("varCheck: " + varCheck, LogPanel.INFO);
            this.log.addLog("lastToken:\n" + lastToken, LogPanel.INFO);
        }
        Object object = docLock;
        synchronized (object) {
            this.lastPosition = -1;
            this.change = 0;
        }
        VediPanel.setInScan(false);
    }

    boolean didAttributesChange(int sstart, int slen, AttributeSet saset, HighlightedDocument doc) {
        try {
            for (int i = sstart; i < sstart + slen; ++i) {
                Element element = doc.getCharacterElement(i);
                AttributeSet attribute = element.getAttributes();
                if (attribute.isEqual(saset)) continue;
                return true;
            }
        }
        catch (Throwable e) {
            this.log.addLog("Attrib:\n" + Utility.getStackTrace(e), LogPanel.INFO);
        }
        return false;
    }

    private static class RecolorEvent {
        public int position;
        public int adjustment;
        public boolean allowReset = true;
        public boolean all = false;
        String whereFrom = "";

        public RecolorEvent(int position, int adjustment) {
            this.position = position;
            this.adjustment = adjustment;
        }

        public RecolorEvent(int position, int adjustment, boolean ar) {
            this.position = position;
            this.adjustment = adjustment;
            this.allowReset = ar;
        }
    }
}

