/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.Syntax.Lexer;

import de.malban.util.syntax.Syntax.Lexer.Token;

public class HTMLToken1
extends Token {
    public static final int TAG_START = 256;
    public static final int TAG_END = 257;
    public static final int EQUAL = 258;
    public static final int WORD = 512;
    public static final int REFERENCE = 768;
    public static final int TAG_NAME = 1024;
    public static final int END_TAG_NAME = 1025;
    public static final int NAME = 1280;
    public static final int VALUE = 1536;
    public static final int CHAR_REF = 1792;
    public static final int SCRIPT = 2048;
    public static final int COMMENT = 3328;
    public static final int WHITE_SPACE = 3584;
    public static final int ERROR_MALFORMED_TAG = 3840;
    private int ID;
    private String contents;
    private int lineNumber;
    private int charBegin;
    private int charEnd;
    private int state;

    public HTMLToken1(int ID, String contents, int lineNumber, int charBegin, int charEnd) {
        this(ID, contents, lineNumber, charBegin, charEnd, -1);
    }

    public HTMLToken1(int ID, String contents, int lineNumber, int charBegin, int charEnd, int state) {
        this.ID = ID;
        this.contents = new String(contents);
        this.lineNumber = lineNumber;
        this.charBegin = charBegin;
        this.charEnd = charEnd;
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public String getContents() {
        return new String(this.contents);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getCharBegin() {
        return this.charBegin;
    }

    @Override
    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isSeparator() {
        return this.ID >> 8 == 1;
    }

    public boolean isWord() {
        return this.ID >> 8 == 2;
    }

    public boolean isTagName() {
        return this.ID >> 8 == 4;
    }

    public boolean isName() {
        return this.ID >> 8 == 5;
    }

    public boolean isValue() {
        return this.ID >> 8 == 6;
    }

    public boolean isCharacterReference() {
        return this.ID >> 8 == 7;
    }

    public boolean isScript() {
        return this.ID >> 8 == 8;
    }

    @Override
    public boolean isComment() {
        return this.ID >> 8 == 13;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.ID >> 8 == 14;
    }

    @Override
    public boolean isError() {
        return this.ID >> 8 == 15;
    }

    @Override
    public String getDescription() {
        if (this.isSeparator()) {
            return "separator";
        }
        if (this.isWord()) {
            return "text";
        }
        if (this.ID == 1024) {
            return "tag";
        }
        if (this.ID == 1025) {
            return "endtag";
        }
        if (this.isName()) {
            return "name";
        }
        if (this.isCharacterReference()) {
            return "reference";
        }
        if (this.isValue()) {
            return "value";
        }
        if (this.isScript()) {
            return "preprocessor";
        }
        if (this.isComment()) {
            return "comment";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        if (this.isError()) {
            return "error";
        }
        return "unknown";
    }

    @Override
    public String errorString() {
        String s;
        if (this.isError()) {
            s = "Error on line " + this.lineNumber + ": ";
            switch (this.ID) {
                case 3840: {
                    s = s + "Malformed Tag: " + this.contents;
                }
            }
        } else {
            s = null;
        }
        return s;
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.ID) + ": " + this.getDescription() + " Line " + this.lineNumber + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

