/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.Syntax.Lexer;

import de.malban.util.syntax.Syntax.Lexer.Token;

public class M6809Token
extends Token {
    public static final int RESERVED_WORD = 256;
    public static final int RESERVED_REGISTER = 272;
    public static final int IDENTIFIER = 512;
    public static final int LINE_LABEL = 592;
    public static final int LITERAL_BOOLEAN = 768;
    public static final int LITERAL_INTEGER = 784;
    public static final int IMMEDIATE_NUMBER = 832;
    public static final int LITERAL_CHARACTER = 848;
    public static final int LITERAL_STRING = 864;
    public static final int LITERAL_NULL = 880;
    public static final int LITERAL_VARIABLE = 896;
    public static final int SEPARATOR_LPAREN = 1024;
    public static final int SEPARATOR_RPAREN = 1025;
    public static final int SEPARATOR_LBRACE = 1040;
    public static final int SEPARATOR_RBRACE = 1041;
    public static final int SEPARATOR_LBRACKET = 1056;
    public static final int SEPARATOR_RBRACKET = 1057;
    public static final int SEPARATOR_SEMICOLON = 1072;
    public static final int SEPARATOR_COMMA = 1088;
    public static final int SEPARATOR_PERIOD = 1104;
    public static final int RESERVED_OPERATOR = 1280;
    public static final int RESERVED_ASMWORD = 1536;
    public static final int COMMENT_LINE = 3328;
    public static final int COMMENT_END_OF_LINE = 3344;
    public static final int WHITE_SPACE = 3584;
    public static final int ERROR_IDENTIFIER = 3840;
    public static final int ERROR_UNCLOSED_STRING = 3856;
    public static final int ERROR_MALFORMED_STRING = 3857;
    public static final int ERROR_MALFORMED_UNCLOSED_STRING = 3858;
    public static final int ERROR_UNCLOSED_CHARACTER = 3872;
    public static final int ERROR_MALFORMED_CHARACTER = 3873;
    public static final int ERROR_MALFORMED_UNCLOSED_CHARACTER = 3874;
    public static final int ERROR_INTEGER_DECIMIAL_SIZE = 3888;
    public static final int ERROR_INTEGER_OCTAL_SIZE = 3889;
    public static final int ERROR_INTEGER_HEXIDECIMAL_SIZE = 3890;
    public static final int ERROR_LONG_DECIMIAL_SIZE = 3891;
    public static final int ERROR_LONG_OCTAL_SIZE = 3892;
    public static final int ERROR_LONG_HEXIDECIMAL_SIZE = 3893;
    public static final int ERROR_FLOAT_SIZE = 3894;
    public static final int ERROR_DOUBLE_SIZE = 3895;
    public static final int ERROR_FLOAT = 3896;
    public static final int ERROR_UNCLOSED_COMMENT = 3904;
    private int ID;
    private String contents;
    private int lineNumber;
    private int charBegin;
    private int charEnd;
    private int state;
    public boolean isMacroName = false;
    public boolean isMacroLabelName = false;
    public boolean isMacroParameterName = false;

    public M6809Token(int ID, String contents, int lineNumber, int charBegin, int charEnd) {
        this(ID, contents, lineNumber, charBegin, charEnd, -1);
    }

    public M6809Token(int ID, String contents, int lineNumber, int charBegin, int charEnd, int state) {
        this.ID = ID;
        this.contents = new String(contents);
        this.lineNumber = lineNumber;
        this.charBegin = charBegin;
        this.charEnd = charEnd;
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public String getContents() {
        return new String(this.contents);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getCharBegin() {
        return this.charBegin;
    }

    @Override
    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isReservedWord() {
        return this.ID >> 8 == 1;
    }

    public boolean isRegister() {
        return this.ID == 272;
    }

    public boolean isASMWord() {
        return this.ID >= 1536 && this.ID <= 1791;
    }

    public boolean isIdentifier() {
        return this.ID >> 8 == 2;
    }

    public boolean isName() {
        return (this.ID & 0x250) == 592;
    }

    public boolean isLiteral() {
        return this.ID >> 8 == 3;
    }

    public boolean isLiteralString() {
        return this.ID == 864;
    }

    public boolean isLiteralVariable() {
        return this.ID == 896;
    }

    public boolean isSeparator() {
        return this.ID >> 8 == 4;
    }

    public boolean isOperator() {
        return this.ID >> 8 == 5;
    }

    @Override
    public boolean isComment() {
        return this.ID >> 8 == 13;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.ID >> 8 == 14;
    }

    @Override
    public boolean isError() {
        return this.ID >> 8 == 15;
    }

    @Override
    public String getDescription() {
        if (this.isRegister()) {
            return "register";
        }
        if (this.isReservedWord()) {
            return "reservedWord";
        }
        if (this.isASMWord()) {
            return "preprocessor";
        }
        if (this.isIdentifier()) {
            return "identifier";
        }
        if (this.isLiteralVariable()) {
            return "literalVariable";
        }
        if (this.isLiteralString()) {
            return "literalstring";
        }
        if (this.isLiteral()) {
            return "literal";
        }
        if (this.isSeparator()) {
            return "separator";
        }
        if (this.isOperator()) {
            return "operator";
        }
        if (this.isComment()) {
            return "comment";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        if (this.isName()) {
            return "name";
        }
        if (this.isError()) {
            return "error";
        }
        return "unknown";
    }

    @Override
    public String errorString() {
        String s;
        if (this.isError()) {
            s = "Error on line " + this.lineNumber + ": ";
            switch (this.ID) {
                case 3840: {
                    s = s + "Unrecognized Identifier: " + this.contents;
                    break;
                }
                case 3856: {
                    s = s + "'\"' expected after " + this.contents;
                    break;
                }
                case 3857: 
                case 3858: {
                    s = s + "Illegal character in " + this.contents;
                    break;
                }
                case 3872: {
                    s = s + "\"'\" expected after " + this.contents;
                    break;
                }
                case 3873: 
                case 3874: {
                    s = s + "Illegal character in " + this.contents;
                    break;
                }
                case 3888: 
                case 3889: 
                case 3896: {
                    s = s + "Illegal character in " + this.contents;
                    break;
                }
                case 3890: 
                case 3891: 
                case 3892: 
                case 3893: 
                case 3894: 
                case 3895: {
                    s = s + "Literal out of bounds: " + this.contents;
                    break;
                }
                case 3904: {
                    s = s + "*/ expected after " + this.contents;
                }
            }
        } else {
            s = null;
        }
        return s;
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.ID) + ": " + this.getDescription() + " Line " + this.lineNumber + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

