/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.entities;

import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.syntax.entities.ASM6809FileMaster;
import de.malban.util.syntax.entities.EntityDefinition;
import de.malban.vide.vedi.EditorPanel;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextPane;

public class ASM6809File {
    ASM6809FileMaster master;
    public static final int ENTITY_UNCHANGED = 0;
    public static final int ENTITY_CHANGED = 1;
    public static final int ENTITY_DELETED = -1;
    String fullName;
    String path;
    String name;
    StringBuffer text;
    int lineCount = 0;
    ArrayList<EntityDefinition> entityArray = new ArrayList();
    HashMap<String, EntityDefinition> lineEntityMap = new HashMap();
    boolean doNotResetLabels = false;

    ASM6809File(ASM6809FileMaster m) {
        this.master = m;
    }

    public String toString() {
        return this.fullName;
    }

    boolean inMacro(EntityDefinition entity) {
        int scanFrom = this.entityArray.size() - 1;
        if (entity.lineNumber != -1) {
            scanFrom = entity.lineNumber - 1;
        }
        for (int i = scanFrom; i >= 0; --i) {
            EntityDefinition e = this.entityArray.get(i);
            if (e.isMacroEnd) {
                return false;
            }
            if (!e.isMacroStart) continue;
            return true;
        }
        return false;
    }

    boolean inStruct(EntityDefinition entity) {
        int scanFrom = this.entityArray.size() - 1;
        if (entity.lineNumber != -1) {
            scanFrom = entity.lineNumber - 1;
        }
        for (int i = scanFrom; i >= 0; --i) {
            EntityDefinition e = this.entityArray.get(i);
            if (e.isStructEnd) {
                return false;
            }
            if (!e.isStructStart) continue;
            return true;
        }
        return false;
    }

    protected boolean isPureFunctionCallLabel(EntityDefinition entity) {
        int checkingLineInText = entity.getLineNumber() - 1;
        String[] lines = this.text.toString().split("\n");
        for (int l = checkingLineInText - 1; l >= 0; --l) {
            String line = lines[l].toLowerCase();
            line = EntityDefinition.removeComment(line, ";");
            line = EntityDefinition.removeComment(line, "*");
            if ((line = UtilityString.replaceWhiteSpaces(line, " ")).trim().length() == 0) continue;
            if (line.contains(" db ")) {
                return true;
            }
            if (line.contains(" dw ")) {
                return true;
            }
            if (line.contains(" ds ")) {
                return true;
            }
            if (line.contains(" fcc ")) {
                return true;
            }
            if (line.contains(" fcb ")) {
                return true;
            }
            if (line.contains(" fdb ")) {
                return true;
            }
            if (line.contains(" rmb ")) {
                return true;
            }
            if (line.contains(" rts")) {
                return true;
            }
            if (line.contains(" rti")) {
                return true;
            }
            if (line.contains(" jmp ")) {
                return true;
            }
            if (line.contains(" bra ")) {
                return true;
            }
            if (line.contains(" lbra ")) {
                return true;
            }
            if (line.contains(" endm")) {
                return true;
            }
            if (line.contains(" end")) {
                return true;
            }
            if (line.contains(" org")) {
                return true;
            }
            if (line.contains(" code")) {
                return true;
            }
            if (line.contains(" include")) {
                return true;
            }
            if (line.contains(" equ ") || line.contains("=")) continue;
            return false;
        }
        return true;
    }

    protected boolean isDataLabel(EntityDefinition entity) {
        int checkingLineInText = entity.getLineNumber() - 1;
        String[] lines = this.text.toString().split("\n");
        for (int l = checkingLineInText; l < lines.length; ++l) {
            String line = lines[l].toLowerCase();
            line = EntityDefinition.removeComment(line, ";");
            line = EntityDefinition.removeComment(line, "*");
            if ((line = this.removeLeadingChars(line)).trim().length() == 0) continue;
            if (line.contains(" db ")) {
                return true;
            }
            if (line.contains(" dw ")) {
                return true;
            }
            if (line.contains(" ds ")) {
                return true;
            }
            if (line.contains(" fcc ")) {
                return true;
            }
            if (line.contains(" fcb ")) {
                return true;
            }
            if (line.contains(" fdb ")) {
                return true;
            }
            return line.contains(" rmb ");
        }
        return false;
    }

    String removeLeadingChars(String line) {
        if ((line = UtilityString.replaceWhiteSpaces(line, " ")).startsWith(" ")) {
            return line;
        }
        String[] splitter = line.split(" ");
        String result = "";
        for (int i = 1; i < splitter.length; ++i) {
            result = result + " " + splitter[i];
        }
        return result;
    }

    void addLineToArray(EntityDefinition e) {
        this.entityArray.add(e);
        e.lineNumber = this.entityArray.size() - 1;
    }

    void removeLineToArray(EntityDefinition e) {
        int line = e.lineNumber;
        if (line < 0) {
            line = this.entityArray.indexOf(e);
            return;
        }
        if (line != this.entityArray.indexOf(e)) {
            line = this.entityArray.indexOf(e);
        }
        this.entityArray.remove(e);
        for (int l = line; l < this.entityArray.size(); ++l) {
            this.entityArray.get((int)l).lineNumber = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetLabels() {
        if (this.doNotResetLabels) {
            return;
        }
        Set<Map.Entry<String, EntityDefinition>> entries = this.lineEntityMap.entrySet();
        for (Map.Entry<String, EntityDefinition> entry : entries) {
            EntityDefinition value = entry.getValue();
            String key = entry.getKey();
            HashMap<String, EntityDefinition> hashMap = this.master.knownGlobalVariables;
            synchronized (hashMap) {
                if (this.master.knownGlobalVariables.containsKey(value.name)) {
                    EntityDefinition entityGlobal = this.master.knownGlobalVariables.get(value.name);
                    if (value.file.fullName.equals(entityGlobal.file.fullName)) {
                        this.master.knownGlobalVariables.remove(value.name);
                        this.master.knownGlobalVariables.put(value.name, value);
                    }
                } else {
                    this.master.knownGlobalVariables.remove(value.name);
                    this.master.knownGlobalVariables.put(value.name, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        for (EntityDefinition e : this.entityArray) {
            if (e.type == EntityDefinition.TYP_MACRO) {
                this.master.knownGlobalMacros.remove(e.name);
                for (String n : e.parameter) {
                    this.master.knownGlobalMacros.remove(n);
                }
            }
            if (e.type != EntityDefinition.TYP_LABEL) continue;
            HashMap<String, EntityDefinition> hashMap = this.master.knownGlobalVariables;
            synchronized (hashMap) {
                if (this.master.knownGlobalVariables.containsKey(e.name)) {
                    EntityDefinition entityGlobal = this.master.knownGlobalVariables.get(e.name);
                    if (e.file.fullName.equals(entityGlobal.file.fullName)) {
                        this.master.knownGlobalVariables.remove(e.name);
                    }
                }
            }
        }
        this.lineEntityMap.clear();
        this.entityArray.clear();
        this.scanText(this.text.toString());
    }

    String getSingleName(String path, String name) {
        path = UtilityFiles.convertSeperator(path);
        if ((name = UtilityFiles.convertSeperator(name)).endsWith(File.separator)) {
            name = name.substring(0, name.length() - 1);
        }
        String result = path;
        String firstDir;
        while ((firstDir = this.getFirstDir(path)) != null) {
            path = this.removeLeadingDir(firstDir, path);
            if (!(name = this.removeLeadingDir(firstDir, name)).startsWith(File.separator)) continue;
            name = name.substring(1);
        }
        return result + name;
    }

    String getFirstDir(String path) {
        int p;
        if (path == null) {
            return null;
        }
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        if ((p = path.indexOf(File.separator)) == -1) {
            if (path.length() == 0) {
                return null;
            }
            return path;
        }
        return path.substring(0, p);
    }

    String removeLeadingDir(String fd, String path) {
        if (fd == null) {
            return path;
        }
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        if (path.startsWith(fd)) {
            return path.substring(fd.length());
        }
        return path;
    }

    private synchronized EntityDefinition updateEntity(String oldLine, String line) {
        return this.updateEntity(oldLine, line, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized EntityDefinition updateEntity(String oldLine, String line, boolean doInclude) {
        Object object;
        if (line == null) {
            return null;
        }
        boolean existed = false;
        int status = 0;
        EntityDefinition entity = this.lineEntityMap.get(oldLine);
        if (entity == null) {
            entity = EntityDefinition.scanLine(this, line);
            this.addLineToArray(entity);
            status = entity.getStatus();
        } else {
            existed = true;
            status = entity.updateEntity(line);
            if (entity.previousType == EntityDefinition.TYP_MACRO) {
                this.master.knownGlobalMacros.remove(entity.previousName);
                if (entity.previousParameter != null) {
                    for (String n : entity.previousParameter) {
                        this.master.knownGlobalMacros.remove(n);
                    }
                }
            }
            if (entity.previousType == EntityDefinition.TYP_LABEL) {
                object = this.master.knownGlobalVariables;
                synchronized (object) {
                    if (this.master.knownGlobalVariables.containsKey(entity.previousName)) {
                        EntityDefinition entityGlobal = this.master.knownGlobalVariables.get(entity.previousName);
                        if (entity.file.fullName.equals(entityGlobal.file.fullName)) {
                            this.master.knownGlobalVariables.remove(entity.previousName);
                        }
                    }
                }
            }
        }
        if (status == -1) {
            this.removeLineToArray(entity);
            this.lineEntityMap.remove(oldLine, entity);
        } else {
            this.lineEntityMap.remove(oldLine, entity);
            this.lineEntityMap.put(line, entity);
            if (entity.type == EntityDefinition.TYP_MACRO) {
                entity.subtype = EntityDefinition.SUBTYPE_MACRO_DEFINITION_LABEL;
                this.master.knownGlobalMacros.put(entity.name, entity);
                if (entity.parameter != null) {
                    for (String n : entity.parameter) {
                        if (n.trim().toLowerCase().equals("macro")) continue;
                        this.master.knownGlobalMacros.put(n, entity);
                    }
                }
            } else if (entity.type == EntityDefinition.TYP_LABEL) {
                object = this.master.knownGlobalVariables;
                synchronized (object) {
                    if (!this.master.knownGlobalVariables.containsKey(entity.name)) {
                        this.master.knownGlobalVariables.put(entity.name, entity);
                    }
                }
            }
        }
        if (status == 1 && entity.type == EntityDefinition.TYP_INCLUDE && doInclude) {
            String singleName;
            String newFilename = "";
            if (this.path != null) {
                newFilename = newFilename + this.path + File.separator;
            }
            newFilename = singleName = this.getSingleName(newFilename, entity.name);
            if (this.master.inReset) {
                String key = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(newFilename)).toLowerCase();
                this.master.allFileMap.remove(key);
            }
            if (!newFilename.equals(this.fullName)) {
                this.master.handleFile(newFilename, null, doInclude);
            }
        }
        if (status == -1 && !existed) {
            entity.setStatus(0);
        }
        if (entity.previousType == EntityDefinition.TYP_LABEL) {
            this.resetLabels();
        }
        return entity;
    }

    synchronized void scanText(String text) {
        this.scanText(text, true);
    }

    synchronized void scanText(String text, boolean doInclude) {
        String[] lines = text.split("\n");
        int c = 0;
        this.doNotResetLabels = true;
        for (String line : lines) {
            this.updateEntity(line + ";" + c, line + ";" + c, doInclude);
            ++c;
        }
        this.doNotResetLabels = false;
        this.resetLabels();
    }

    int getLineCount(String text) {
        if (text == null) {
            return 0;
        }
        return text.split("\n").length;
    }

    private static String loadText(String filename) {
        try {
            filename = UtilityFiles.convertSeperator(filename);
            String edited = EditorPanel.getTextForFile(filename);
            if (edited != null) {
                return edited;
            }
            JTextPane jTextPane1 = new JTextPane();
            FileReader fr = new FileReader(filename);
            jTextPane1.read(fr, null);
            fr.close();
            String text = jTextPane1.getDocument().getText(0, jTextPane1.getDocument().getLength());
            return text;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<String> processDocumentChanges(int start, int adjustment, String newCompleteText) {
        ++this.master.inUpdate;
        ArrayList<String> ret = new ArrayList<String>();
        if (this.lineCount != this.getLineCount(newCompleteText)) {
            this.text.delete(0, this.text.length());
            this.text.append(newCompleteText);
            this.lineCount = this.getLineCount(newCompleteText);
            this.reset();
            --this.master.inUpdate;
            return null;
        }
        if (Math.abs(adjustment) > 1) {
            for (EntityDefinition e : this.entityArray) {
                if (e.type == EntityDefinition.TYP_LABEL) {
                    HashMap<String, EntityDefinition> hashMap = this.master.knownGlobalVariables;
                    synchronized (hashMap) {
                        if (this.master.knownGlobalVariables.containsKey(e.name)) {
                            EntityDefinition entityGlobal = this.master.knownGlobalVariables.get(e.name);
                            if (e.file.fullName.equals(entityGlobal.file.fullName)) {
                                this.master.knownGlobalVariables.remove(e.name);
                                ret.add(e.name);
                            }
                        }
                    }
                }
                if (e.type != EntityDefinition.TYP_MACRO) continue;
                this.master.knownGlobalMacros.remove(e.name);
                ret.add(e.name);
            }
            this.text.delete(0, this.text.length());
            this.text.append(newCompleteText);
            this.lineCount = this.getLineCount(newCompleteText);
            this.scanText(newCompleteText);
        } else {
            String lineOld = this.getLineOfChange(start - adjustment, this.text.toString());
            String lineNew = this.getLineOfChange(start, newCompleteText.toString());
            boolean done = false;
            if (adjustment == 1) {
                String[] sp1 = new String[]{};
                if (lineOld != null) {
                    sp1 = lineOld.split(";");
                }
                String[] sp2 = new String[]{};
                if (lineNew != null) {
                    sp2 = lineNew.split(";");
                }
                if (sp1.length > 0 && sp2.length > 0 && !sp1[sp1.length - 1].equals(sp2[sp2.length - 1])) {
                    for (EntityDefinition e : this.entityArray) {
                        if (e.type == EntityDefinition.TYP_LABEL) {
                            HashMap<String, EntityDefinition> hashMap = this.master.knownGlobalVariables;
                            synchronized (hashMap) {
                                if (this.master.knownGlobalVariables.containsKey(e.name)) {
                                    EntityDefinition entityGlobal = this.master.knownGlobalVariables.get(e.name);
                                    if (e.file.fullName.equals(entityGlobal.file.fullName)) {
                                        this.master.knownGlobalVariables.remove(e.name);
                                        ret.add(e.name);
                                    }
                                }
                            }
                        }
                        if (e.type != EntityDefinition.TYP_MACRO) continue;
                        this.master.knownGlobalMacros.remove(e.name);
                        ret.add(e.name);
                    }
                    this.text.delete(0, this.text.length());
                    this.text.append(newCompleteText);
                    this.lineCount = this.getLineCount(newCompleteText);
                    this.scanText(newCompleteText);
                    done = true;
                }
            }
            if (!done) {
                EntityDefinition entity = this.updateEntity(lineOld, lineNew);
                if (entity != null && entity.getStatus() != 0) {
                    ret.add(entity.previousName);
                    ret.add(entity.name);
                }
                this.text.delete(0, this.text.length());
                this.text.append(newCompleteText);
                this.lineCount = this.getLineCount(newCompleteText);
            }
        }
        --this.master.inUpdate;
        return ret;
    }

    String getLineOfChangeNo(int lineNo, String t) {
        try {
            String[] lines = t.toString().split("\n");
            return lines[lineNo];
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    String getLineOfChange(int pos, String t) {
        int ret = -1;
        try {
            String[] lines = t.toString().split("\n");
            int c = -1;
            for (int count = 0; count <= pos + 1; count += lines[++c].length() + 1) {
            }
            if (c < lines.length) {
                ret = c;
            }
            if (ret == -1) {
                return null;
            }
            return lines[ret] + ";" + ret;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

