/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.entities;

import de.malban.Global;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.syntax.entities.C6809FileMaster;
import de.malban.util.syntax.entities.EntityDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class C6809File {
    String fullName;
    String path;
    String name;
    StringBuffer text;
    int lineCount = 0;
    ArrayList<EntityDefinition> entityArray = new ArrayList();
    HashMap<String, EntityDefinition> lineEntityMap = new HashMap();
    C6809FileMaster master;

    C6809File(C6809FileMaster m) {
        this.master = m;
    }

    public String toString() {
        return this.fullName;
    }

    String removeLeadingChars(String line) {
        if ((line = UtilityString.replaceWhiteSpaces(line, " ")).startsWith(" ")) {
            return line;
        }
        String[] splitter = line.split(" ");
        String result = "";
        for (int i = 1; i < splitter.length; ++i) {
            result = result + " " + splitter[i];
        }
        return result;
    }

    void addLineToArray(EntityDefinition e) {
        this.entityArray.add(e);
        e.lineNumber = this.entityArray.size() - 1;
    }

    void removeLineToArray(EntityDefinition e) {
        int line = e.lineNumber;
        if (line < 0) {
            line = this.entityArray.indexOf(e);
            return;
        }
        if (line != this.entityArray.indexOf(e)) {
            line = this.entityArray.indexOf(e);
        }
        this.entityArray.remove(e);
        for (int l = line; l < this.entityArray.size(); ++l) {
            this.entityArray.get((int)l).lineNumber = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetFunctions() {
        Set<Map.Entry<String, EntityDefinition>> entries = this.lineEntityMap.entrySet();
        for (Map.Entry<String, EntityDefinition> entry : entries) {
            EntityDefinition value = entry.getValue();
            String key = entry.getKey();
            HashMap<String, EntityDefinition> hashMap = this.master.knownGlobalFunctions;
            synchronized (hashMap) {
                if (this.master.knownGlobalFunctions.containsKey(value.name)) {
                    EntityDefinition entityGlobal = this.master.knownGlobalFunctions.get(value.name);
                    if (value.cfile.fullName.equals(entityGlobal.cfile.fullName)) {
                        this.master.knownGlobalFunctions.remove(value.name);
                        this.master.knownGlobalFunctions.put(value.name, value);
                    }
                } else {
                    this.master.knownGlobalFunctions.remove(value.name);
                    this.master.knownGlobalFunctions.put(value.name, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        for (EntityDefinition e : this.entityArray) {
            if (e.type != EntityDefinition.TYP_CFUNCTION) continue;
            HashMap<String, EntityDefinition> hashMap = this.master.knownGlobalFunctions;
            synchronized (hashMap) {
                if (this.master.knownGlobalFunctions.containsKey(e.name)) {
                    EntityDefinition entityGlobal = this.master.knownGlobalFunctions.get(e.name);
                    if (e.cfile.fullName.equals(entityGlobal.cfile.fullName)) {
                        this.master.knownGlobalFunctions.remove(e.name);
                    }
                }
            }
        }
        this.lineEntityMap.clear();
        this.entityArray.clear();
        this.scanText(this.text.toString());
    }

    private synchronized EntityDefinition updateEntity(String oldLine, String line) {
        return this.updateEntity(oldLine, line, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized EntityDefinition updateEntity(String oldLine, String line, boolean doInclude) {
        HashMap<String, EntityDefinition> hashMap;
        if (line == null) {
            return null;
        }
        boolean existed = false;
        int status = 0;
        EntityDefinition entity = this.lineEntityMap.get(oldLine);
        if (entity == null) {
            entity = EntityDefinition.scanLine(this, line);
            this.addLineToArray(entity);
            status = entity.getStatus();
        } else {
            existed = true;
            status = entity.updateEntity(line);
            if (entity.previousType == EntityDefinition.TYP_CFUNCTION) {
                hashMap = this.master.knownGlobalFunctions;
                synchronized (hashMap) {
                    if (this.master.knownGlobalFunctions.containsKey(entity.previousName)) {
                        EntityDefinition entityGlobal = this.master.knownGlobalFunctions.get(entity.previousName);
                        if (entity.cfile.fullName.equals(entityGlobal.cfile.fullName)) {
                            this.master.knownGlobalFunctions.remove(entity.previousName);
                        }
                    }
                }
            }
            if (entity.previousType == EntityDefinition.TYP_MACRO) {
                this.master.knownGlobalFunctions.remove(entity.previousName);
                if (entity.previousParameter != null) {
                    for (String n : entity.previousParameter) {
                        this.master.knownGlobalFunctions.remove(n);
                    }
                }
            }
            if (entity.previousType == EntityDefinition.TYP_LABEL) {
                this.master.knownGlobalFunctions.remove(entity.previousName);
                if (entity.previousParameter != null) {
                    for (String n : entity.previousParameter) {
                        this.master.knownGlobalFunctions.remove(n);
                    }
                }
            }
        }
        if (status == -1) {
            this.removeLineToArray(entity);
            this.lineEntityMap.remove(oldLine, entity);
        } else {
            this.lineEntityMap.remove(oldLine, entity);
            this.lineEntityMap.put(line, entity);
            if (entity.type == EntityDefinition.TYP_CFUNCTION) {
                hashMap = this.master.knownGlobalFunctions;
                synchronized (hashMap) {
                    if (!this.master.knownGlobalFunctions.containsKey(entity.previousName)) {
                        this.master.knownGlobalFunctions.put(entity.name, entity);
                    }
                }
            }
            if (entity.type == EntityDefinition.TYP_MACRO) {
                hashMap = this.master.knownGlobalFunctions;
                synchronized (hashMap) {
                    this.master.knownGlobalFunctions.put(entity.name, entity);
                }
            }
            if (entity.type == EntityDefinition.TYP_LABEL) {
                hashMap = this.master.knownGlobalFunctions;
                synchronized (hashMap) {
                    this.master.knownGlobalFunctions.put(entity.name, entity);
                }
            }
        }
        if (status == 1) {
            String key;
            String newFilename;
            if (entity.type == EntityDefinition.TYP_INCLUDE && doInclude) {
                newFilename = "";
                if (this.path != null) {
                    newFilename = newFilename + this.path + File.separator;
                }
                newFilename = newFilename + entity.name;
                if (this.master.inReset) {
                    key = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(newFilename)).toLowerCase();
                    this.master.allFileMap.remove(key);
                }
                if (!newFilename.equals(this.fullName)) {
                    this.master.handleFile(newFilename, null);
                }
            }
            if (entity.type == EntityDefinition.TYP_LIB_INCLUDE) {
                newFilename = "";
                newFilename = UtilityFiles.convertSeperator(Global.mainPathPrefix + "C/PeerC/vectrex/include/" + entity.name);
                if (this.master.inReset) {
                    key = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(newFilename)).toLowerCase();
                    this.master.allFileMap.remove(key);
                }
                if (!newFilename.equals(this.fullName)) {
                    this.master.handleFile(newFilename, null);
                }
            }
        }
        if (status == -1 && !existed) {
            entity.setStatus(0);
        }
        return entity;
    }

    synchronized void scanText(String text) {
        this.scanText(text, true);
    }

    synchronized void scanText(String text, boolean doInclude) {
        String[] lines = text.split("\n");
        int c = 0;
        for (String line : lines) {
            this.updateEntity(line + ";" + c, line + ";" + c, doInclude);
            ++c;
        }
    }

    int getLineCount(String text) {
        if (text == null) {
            return 0;
        }
        return text.split("\n").length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<String> processDocumentChanges(int start, int adjustment, String newCompleteText) {
        ++this.master.inUpdate;
        ArrayList<String> ret = new ArrayList<String>();
        if (this.lineCount != this.getLineCount(newCompleteText)) {
            this.text.delete(0, this.text.length());
            this.text.append(newCompleteText);
            this.lineCount = this.getLineCount(newCompleteText);
            this.reset();
            --this.master.inUpdate;
            return null;
        }
        if (Math.abs(adjustment) > 1) {
            for (EntityDefinition e : this.entityArray) {
                if (e.type == EntityDefinition.TYP_CFUNCTION) {
                    HashMap<String, EntityDefinition> hashMap = this.master.knownGlobalFunctions;
                    synchronized (hashMap) {
                        if (this.master.knownGlobalFunctions.containsKey(e.name)) {
                            EntityDefinition entityGlobal = this.master.knownGlobalFunctions.get(e.name);
                            if (e.cfile.fullName.equals(entityGlobal.cfile.fullName)) {
                                this.master.knownGlobalFunctions.remove(e.name);
                                ret.add(e.name);
                            }
                        }
                    }
                }
                if (e.type == EntityDefinition.TYP_MACRO) {
                    this.master.knownGlobalFunctions.remove(e.name);
                    ret.add(e.name);
                }
                if (e.type != EntityDefinition.TYP_LABEL) continue;
                this.master.knownGlobalFunctions.remove(e.name);
                ret.add(e.name);
            }
            this.text.delete(0, this.text.length());
            this.text.append(newCompleteText);
            this.lineCount = this.getLineCount(newCompleteText);
            this.scanText(newCompleteText);
        } else {
            String lineOld = this.getLineOfChange(start - adjustment, this.text.toString());
            String lineNew = this.getLineOfChange(start, newCompleteText.toString());
            boolean done = false;
            if (adjustment == 1) {
                String[] sp1 = lineOld.split(";");
                String[] sp2 = lineNew.split(";");
                if (sp1.length > 0 && sp2.length > 0 && !sp1[sp1.length - 1].equals(sp2[sp2.length - 1])) {
                    for (EntityDefinition e : this.entityArray) {
                        HashMap<String, EntityDefinition> hashMap;
                        if (e.type == EntityDefinition.TYP_CFUNCTION) {
                            hashMap = this.master.knownGlobalFunctions;
                            synchronized (hashMap) {
                                if (this.master.knownGlobalFunctions.containsKey(e.name)) {
                                    EntityDefinition entityGlobal = this.master.knownGlobalFunctions.get(e.name);
                                    if (e.cfile.fullName.equals(entityGlobal.cfile.fullName)) {
                                        this.master.knownGlobalFunctions.remove(e.name);
                                        ret.add(e.name);
                                    }
                                }
                            }
                        }
                        if (e.type == EntityDefinition.TYP_MACRO) {
                            hashMap = this.master.knownGlobalFunctions;
                            synchronized (hashMap) {
                                this.master.knownGlobalFunctions.remove(e.name);
                            }
                            ret.add(e.name);
                        }
                        if (e.type != EntityDefinition.TYP_LABEL) continue;
                        hashMap = this.master.knownGlobalFunctions;
                        synchronized (hashMap) {
                            this.master.knownGlobalFunctions.remove(e.name);
                        }
                        ret.add(e.name);
                    }
                    this.text.delete(0, this.text.length());
                    this.text.append(newCompleteText);
                    this.lineCount = this.getLineCount(newCompleteText);
                    this.scanText(newCompleteText);
                    done = true;
                }
            }
            if (!done) {
                EntityDefinition entity = this.updateEntity(lineOld, lineNew);
                if (entity != null && entity.getStatus() != 0) {
                    ret.add(entity.previousName);
                    ret.add(entity.name);
                }
                this.text.delete(0, this.text.length());
                this.text.append(newCompleteText);
                this.lineCount = this.getLineCount(newCompleteText);
            }
        }
        --this.master.inUpdate;
        return ret;
    }

    String getLineOfChangeNo(int lineNo, String t) {
        try {
            String[] lines = t.toString().split("\n");
            return lines[lineNo];
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    String getLineOfChange(int pos, String t) {
        int ret = -1;
        try {
            String[] lines = t.toString().split("\n");
            int c = -1;
            for (int count = 0; count <= pos + 1; count += lines[++c].length() + 1) {
            }
            if (c < lines.length) {
                ret = c;
            }
            if (ret == -1) {
                return null;
            }
            return lines[ret] + ";" + ret;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

