/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.entities;

import de.malban.Global;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.syntax.entities.C6809File;
import de.malban.util.syntax.entities.EntityDefinition;
import de.malban.vide.vedi.EditorPanel;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextPane;

public class C6809FileMaster {
    private static HashMap<Integer, C6809FileMaster> vediFileMap = new HashMap();
    HashMap<String, C6809File> allFileMap = new HashMap();
    public HashMap<String, EntityDefinition> knownGlobalFunctions = new HashMap();
    public HashMap<String, EntityDefinition> knownGlobalVariables = new HashMap();
    public HashMap<String, EntityDefinition> knownGlobalMacros = new HashMap();
    public boolean hasFramePointer = true;
    int inUpdate = 0;
    boolean inReset = false;

    public static C6809FileMaster getInfo(int id) {
        return vediFileMap.get(id);
    }

    public static C6809FileMaster getInstance(int i) {
        C6809FileMaster a = new C6809FileMaster();
        vediFileMap.put(i, a);
        return a;
    }

    public static void removeInstance(int i) {
        vediFileMap.remove(i);
    }

    private C6809FileMaster() {
    }

    public void replaceFileName(String oldFileName, String newFileName) {
        ++this.inUpdate;
        String oldkey = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(oldFileName)).toLowerCase();
        String newkey = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(newFileName)).toLowerCase();
        C6809File fileInfo = this.allFileMap.get(oldkey);
        if (fileInfo == null) {
            --this.inUpdate;
            return;
        }
        fileInfo.fullName = newFileName;
        Path path = Paths.get(newFileName, new String[0]);
        fileInfo.name = path.getFileName().toString();
        fileInfo.path = path.getParent() != null ? path.getParent().toString() : "";
        this.allFileMap.remove(oldkey);
        this.allFileMap.put(newkey, fileInfo);
        --this.inUpdate;
    }

    public void resetDefinitions(String filename, String text, boolean doIncludes) {
        if (this.inUpdate > 0) {
            return;
        }
        ++this.inUpdate;
        this.inReset = true;
        String key = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(filename)).toLowerCase();
        this.allFileMap.remove(key);
        this.handleFile(filename, text, doIncludes);
        this.inReset = false;
        --this.inUpdate;
    }

    public void resetDefinitions() {
        if (this.inUpdate > 0) {
            return;
        }
        ++this.inUpdate;
        this.knownGlobalVariables = new HashMap();
        this.knownGlobalMacros = new HashMap();
        this.knownGlobalFunctions = new HashMap();
        HashMap<String, C6809File> oldAllFileMap = this.allFileMap;
        this.allFileMap = null;
        this.allFileMap = new HashMap();
        Set<Map.Entry<String, C6809File>> entries = oldAllFileMap.entrySet();
        for (Map.Entry<String, C6809File> entry : entries) {
            C6809File value = entry.getValue();
            String key = entry.getKey();
            this.handleFile(value.fullName, null);
        }
        --this.inUpdate;
    }

    public void clearDefinitions() {
        this.knownGlobalVariables = new HashMap();
        this.knownGlobalMacros = new HashMap();
        this.knownGlobalFunctions = new HashMap();
        this.allFileMap = new HashMap();
    }

    public void resetToProject(File mainFile) {
        this.clearDefinitions();
        this.handleFile(mainFile.getAbsolutePath(), null);
    }

    String loadText(String filename) {
        try {
            filename = UtilityFiles.convertSeperator(filename);
            File f = Paths.get(filename, new String[0]).toFile();
            if (f == null) {
                return "";
            }
            if (!f.exists()) {
                return "";
            }
            String edited = EditorPanel.getTextForFile(filename);
            if (edited != null) {
                return edited;
            }
            JTextPane jTextPane1 = new JTextPane();
            FileReader fr = new FileReader(filename);
            jTextPane1.read(fr, null);
            fr.close();
            String text = jTextPane1.getDocument().getText(0, jTextPane1.getDocument().getLength());
            return text;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public C6809File handleFile(String _fullname, String _text) {
        return this.handleFile(_fullname, _text, true);
    }

    public C6809File handleFile(String _fullname, String _text, boolean doInclude) {
        String key;
        C6809File fileInfo;
        if (_fullname.contains(Global.mainPathPrefix)) {
            _fullname = UtilityString.replace(_fullname, Global.mainPathPrefix, "");
        }
        if ((fileInfo = this.allFileMap.get(key = Utility.makeVideAbsolute(Global.mainPathPrefix + UtilityFiles.convertSeperator(_fullname)).toLowerCase())) != null) {
            return fileInfo;
        }
        fileInfo = new C6809File(this);
        fileInfo.fullName = _fullname;
        Path path = Paths.get(_fullname, new String[0]);
        if (path.toString().length() == 0) {
            return fileInfo;
        }
        fileInfo.name = path.getFileName().toString();
        fileInfo.path = path.getParent() != null ? path.getParent().toString() : "";
        if (_text == null) {
            _text = this.loadText(_fullname);
        }
        fileInfo.text = new StringBuffer(_text);
        fileInfo.lineCount = fileInfo.getLineCount(_text);
        fileInfo.scanText(_text, doInclude);
        this.allFileMap.put(key, fileInfo);
        return fileInfo;
    }
}

