/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityString;
import de.malban.vide.ConfigJPanel;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.cartridge.CartridgeProperties;
import de.malban.vide.vecx.cartridge.CartridgePropertiesPool;
import de.malban.vide.vedi.VediPanel;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CLI {
    public static final ArrayList<CLICommand> activeCommands = new ArrayList();
    public static final HashMap<String, CLICommand> activeCommandsMap = new HashMap();
    private static final HashMap<String, CLICommand> knownCommandShort = new HashMap();
    private static final HashMap<String, CLICommand> knownCommandLong = new HashMap();
    public static final ArrayList<CLICommand> knownCommands = new ArrayList();
    private static final CLI cli = new CLI();

    public static CLI getCLI() {
        return cli;
    }

    private CLI() {
        CLI.addKnownCommand("-help            ", "-h", "       help");
        CLI.addKnownCommand("-configuration   ", "-co", "(=)   name of the configuration file to load (e.g. developer.vsv)");
        CLI.addKnownCommand("-jogl            ", "-jg", "(+/-) start with jogl graphics enabled");
        CLI.addKnownCommand("-oldJava         ", "-oj", "(+/-) start with java graphics enabled");
        CLI.addKnownCommand("-keepAspectRatio ", "-ar", "(+/-) keep aspect ratio when size of vecxi changes");
        CLI.addKnownCommand("-exitAfterGame   ", "-ex", "(+/-) shuts down vide after exiting vecxi");
        CLI.addKnownCommand("-fullpanel       ", "-fp", "(+/-) starts vecxi in fullpanel (only if vecxi runs)");
        CLI.addKnownCommand("-fullscreen      ", "-fs", "(+/-) starts vecxi in fullscreen (only if vecxi runs)");
        CLI.addKnownCommand("-enableOverlay   ", "-eo", "(+/-) whether to load an overlay, if available");
        CLI.addKnownCommand("-enableScreen    ", "-es", "(+/-) whether to enable the 'screen' drawing");
        CLI.addKnownCommand("-port0Device     ", "-p0", "(=)   name of the configured input device (names as they appear in vecxi combobox)");
        CLI.addKnownCommand("-port1Device     ", "-p1", "(=)   name of the configured input device (names as they appear in vecxi combobox)");
        CLI.addKnownCommand("-rotation        ", "-ro", "(=)   rotation (0, 90, 180, 270)");
        CLI.addKnownCommand("-binary          ", "-bi", "(=)   loads a binary file and starts vecxi");
        CLI.addKnownCommand("-gameCartridge   ", "-gc", "(=)   loads a cartridge definition and starts vecxi (name of the cart)");
        CLI.addKnownCommand("-resolution      ", "-rs", "(=)   resolution of fullscreen, format like '800x600'");
        CLI.addKnownCommand("-hotkeys         ", "-hk", "(+/-) enable/disable use of hotkeys (for debugging purposes only, default: enable)");
        CLI.addKnownCommand("-syntaxhighlite  ", "-sy", "(+/-) enable/disable use syntaxhighlite (for debugging purposes only, default: enable)");
        CLI.addKnownCommand("-undo            ", "-un", "(+/-) enable/disable use undo in editor (for debugging purposes only, default: enable)");
        CLI.addKnownCommand("-versionTest     ", "-vt", "(+/-) do test for java version (default: enable)");
    }

    private static void addKnownCommand(String l, String s, String h) {
        CLICommand c = new CLICommand(l, s, h);
        knownCommandShort.put(s.trim().toLowerCase(), c);
        knownCommandLong.put(l.trim().toLowerCase(), c);
        knownCommands.add(c);
    }

    public boolean parseArguments(String[] args) {
        boolean i = false;
        for (String a : args) {
            String c;
            String v;
            if (!(a = a.trim()).startsWith("-") || a.length() < 2) continue;
            if (a.toLowerCase().substring(1).equals("h")) {
                return CLI.doHelp();
            }
            if (a.endsWith("-") || a.endsWith("+")) {
                v = a.substring(a.length() - 1, a.length()).trim();
                c = a.substring(0, a.length() - 1).trim();
            } else {
                int p = a.indexOf("=");
                if (p == -1 || p == a.length() - 1) continue;
                v = a.substring(p + 1, a.length()).trim();
                c = a.substring(0, p).trim();
            }
            c = c.toLowerCase().trim();
            CLICommand com = knownCommandShort.get(c);
            if (com == null) {
                com = knownCommandLong.get(c);
            }
            if (com == null) continue;
            com.value = v;
            Configuration.getConfiguration().getDebugEntity().addLog("CLI: " + com.longCommand.trim() + " " + v, LogPanel.INFO);
            activeCommands.add(com);
            activeCommandsMap.put(com.shortCommand, com);
        }
        return false;
    }

    public void injectCLIConfig() {
        String ro;
        int roi;
        VideConfig config = VideConfig.getConfig();
        if (activeCommandsMap.get("-co") != null) {
            String configFile = activeCommandsMap.get("-co").getValue();
            config.load(configFile);
        }
        if (activeCommandsMap.get("-hk") != null) {
            VideConfig.hotKeysEnabled = activeCommandsMap.get("-hk").isEnabled();
        }
        if (activeCommandsMap.get("-sy") != null) {
            VideConfig.syntaxHighliteEnabled = activeCommandsMap.get("-sy").isEnabled();
        }
        if (activeCommandsMap.get("-un") != null) {
            VideConfig.editorUndoEnabled = activeCommandsMap.get("-un").isEnabled();
        }
        if (activeCommandsMap.get("-vt") != null) {
            Global.doTestJava = activeCommandsMap.get("-vt").isEnabled();
        }
        if (activeCommandsMap.get("-jg") != null) {
            config.tryJOGL = activeCommandsMap.get("-jg").isEnabled();
        }
        if (activeCommandsMap.get("-oj") != null) {
            boolean bl = config.tryJOGL = !activeCommandsMap.get("-oj").isEnabled();
        }
        if (activeCommandsMap.get("-ar") != null) {
            config.keepAspectRatio = activeCommandsMap.get("-ar").isEnabled();
        }
        if (activeCommandsMap.get("-ex") != null) {
            config.doExitAfterVecxi = activeCommandsMap.get("-ex").isEnabled();
        }
        if (activeCommandsMap.get("-fp") != null) {
            config.startInFullPanelMode = activeCommandsMap.get("-fp").isEnabled();
        }
        if (activeCommandsMap.get("-fs") != null) {
            config.startInFullScreenMode = activeCommandsMap.get("-fs").isEnabled();
        }
        if (activeCommandsMap.get("-eo") != null) {
            config.overlayEnabled = activeCommandsMap.get("-eo").isEnabled();
        }
        if (activeCommandsMap.get("-es") != null) {
            config.JOGLScreen = activeCommandsMap.get("-es").isEnabled();
        }
        if (activeCommandsMap.get("-p0") != null) {
            config.devicePort0 = activeCommandsMap.get("-p0").getValue();
        }
        if (activeCommandsMap.get("-p1") != null) {
            config.devicePort1 = activeCommandsMap.get("-p1").getValue();
        }
        if (activeCommandsMap.get("-ro") != null && ((roi = UtilityString.Int0(ro = activeCommandsMap.get("-ro").getValue().trim())) == 0 || roi == 90 || roi == 180 || roi == 270)) {
            config.rotate = roi;
        }
        if (activeCommandsMap.get("-bi") != null) {
            String fn = Utility.makeVideAbsolute(activeCommandsMap.get("-bi").getValue());
            if (new File(fn = Utility.makeVideAbsolute(fn)).exists()) {
                config.startFile = fn;
            }
        }
        if (activeCommandsMap.get("-gc") != null) {
            String cartName = activeCommandsMap.get("-gc").getValue();
            ArrayList<CartridgeProperties> allCartridges = new ArrayList<CartridgeProperties>();
            CartridgePropertiesPool mCartridgePropertiesPool = new CartridgePropertiesPool();
            Collection<CartridgeProperties> colC = mCartridgePropertiesPool.getMapForKlasse("Cartridge").values();
            for (CartridgeProperties cartridgeProperties : colC) {
                allCartridges.add(cartridgeProperties);
            }
            for (CartridgeProperties cartridgeProperties : allCartridges) {
                if (!cartName.equalsIgnoreCase(cartridgeProperties.getCartName())) continue;
                config.cartridgeToStart = cartridgeProperties;
                break;
            }
        }
        if (activeCommandsMap.get("-rs") != null) {
            String res = activeCommandsMap.get("-rs").getValue().toLowerCase();
            boolean resok = res.contains("x");
            String[] split = res.split("x");
            if ((split = VediPanel.removeEmpty(split)).length != 2) {
                resok = false;
            }
            int h = 0;
            int w = 0;
            if (resok) {
                w = UtilityString.Int0(split[0]);
                h = UtilityString.Int0(split[1]);
            }
            if (h == 0 || w == 0) {
                resok = false;
            }
            if (resok) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
                DisplayMode[] modes = graphicsDeviceArray[0].getDisplayModes();
                for (int i = 0; i < modes.length; ++i) {
                    DisplayMode displayMode = modes[i];
                    if (displayMode.getWidth() != w || displayMode.getHeight() != h) continue;
                    Configuration C = Configuration.getConfiguration();
                    String modeString = ConfigJPanel.buildStringForMode(displayMode);
                    C.setFullScrrenResString(modeString);
                    config.fullscreenResolution = modeString;
                    break;
                }
            }
        }
    }

    private static boolean doHelp() {
        Set<Map.Entry<String, CLICommand>> entries = knownCommandShort.entrySet();
        Iterator<Map.Entry<String, CLICommand>> it = entries.iterator();
        System.out.println("List of all command line options. No defaults are given, since");
        System.out.println("vedi upon start reads the configuration file \"default\" - ");
        System.out.println("which can be set up by the user.");
        System.out.println("The values of the configuration file are overwritten by values");
        System.out.println("given via the command line.");
        System.out.println("The commands are 'excuted' in the here listed order, commands");
        System.out.println("further down the list, can negate previous commands!");
        System.out.println("If a command fails - it does so quietly, no error message ");
        System.out.println("'false parameter' or the like will be displayed!\n");
        for (CLICommand com : knownCommands) {
            System.out.println(com);
        }
        return true;
    }

    public static class CLICommand {
        public final String longCommand;
        public final String shortCommand;
        public final String help;
        public String value = "";

        CLICommand(String l, String s, String h) {
            this.longCommand = l;
            this.shortCommand = s;
            this.help = h;
        }

        public boolean isEnabled() {
            return this.value.equals("+");
        }

        public String getValue() {
            return this.value;
        }

        public int getIntValue() {
            return UtilityString.Int0(this.value);
        }

        public String toString() {
            return this.longCommand + " " + this.shortCommand + " " + this.help;
        }
    }
}

