/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.PiTrex;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityString;
import de.malban.vide.PiTrex.PiTrexEvent;
import de.malban.vide.PiTrex.PiTrexListenerInterface;
import de.malban.vide.PiTrex.SerialPortWatcher;
import de.malban.vide.VideConfig;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class PiTrexSingleton
implements SerialPortWatcher.PortListener {
    private static PiTrexSingleton instance;
    VideConfig config = VideConfig.getConfig();
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private final List<PiTrexListenerInterface> listeners = new ArrayList<PiTrexListenerInterface>();
    SerialPort ubxPort = null;
    SerialPort[] ports;
    SerialPortWatcher swatcher = new SerialPortWatcher(this);
    String currentName = "";
    SerialPortDataListener listener = new SerialPortDataListener(){

        public int getListeningEvents() {
            return 1;
        }

        public synchronized void serialEvent(SerialPortEvent event) {
            SerialPort comPort = event.getSerialPort();
            int available = comPort.bytesAvailable();
            if (available < 0) {
                return;
            }
            byte[] newData = new byte[available];
            PiTrexSingleton.this.notifyListeners(new PiTrexEvent(event));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized PiTrexSingleton getPiTrex() {
        if (instance != null) return instance;
        Class<PiTrexSingleton> clazz = PiTrexSingleton.class;
        synchronized (PiTrexSingleton.class) {
            if (instance != null) return instance;
            instance = new PiTrexSingleton();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PiTrexSingleton() {
        this.init();
        if (this.config.piTrexSerialName.length() != 0) {
            this.startwatchSerialPorts();
        }
    }

    public boolean isReady() {
        return this.ubxPort != null;
    }

    void init() {
        this.fillSerial();
        this.connect(this.config.piTrexSerialName);
    }

    public SerialPort[] getSerialPorts() {
        return this.ports;
    }

    public SerialPort getActiveSerialPort() {
        return this.ubxPort;
    }

    void deinit() {
        if (this.ubxPort != null) {
            this.ubxPort.removeDataListener();
            this.ubxPort.closePort();
        }
        this.ubxPort = null;
        this.currentName = "";
    }

    public void fillSerial() {
        this.ports = SerialPort.getCommPorts();
        ArrayList<SerialPort> pp = new ArrayList<SerialPort>();
        for (SerialPort p : this.ports) {
            if (p.getDescriptivePortName().toLowerCase().contains("dial")) continue;
            pp.add(p);
        }
        this.ports = pp.toArray(new SerialPort[0]);
    }

    public void rescanConnect() {
        this.disconnect();
        this.init();
    }

    public boolean connect(String name) {
        int index = -1;
        int counter = 0;
        for (SerialPort p : this.ports) {
            if (p.getDescriptivePortName().equals(name)) {
                index = counter;
                break;
            }
            ++counter;
        }
        return this.connect(index);
    }

    private int getConnectedIndex() {
        if (this.ubxPort == null) {
            return -1;
        }
        if (this.currentName.length() == 0) {
            return -1;
        }
        int counter = 0;
        this.fillSerial();
        for (SerialPort p : this.ports) {
            if (p.getDescriptivePortName().equals(this.currentName)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    boolean alreadyConnected() {
        if (this.currentName.length() == 0) {
            return false;
        }
        if (this.ubxPort == null) {
            this.disconnect();
            return false;
        }
        this.fillSerial();
        for (SerialPort p : this.ports) {
            if (!p.getDescriptivePortName().equals(this.currentName)) continue;
            if (this.ubxPort.isOpen()) {
                return true;
            }
            this.disconnect();
            return false;
        }
        this.disconnect();
        return false;
    }

    boolean alreadyConnected(int index) {
        if (index == -1) {
            return false;
        }
        if (this.currentName.length() == 0) {
            return false;
        }
        if (this.ports.length <= index) {
            return false;
        }
        return this.ports[index].getDescriptivePortName().equals(this.currentName);
    }

    public boolean disconnect() {
        if (!this.isReady()) {
            return false;
        }
        if (this.ubxPort != null) {
            this.ubxPort.removeDataListener();
            this.ubxPort.closePort();
            this.ubxPort = null;
        }
        this.ubxPort = null;
        this.currentName = "";
        this.notifyListeners(new PiTrexEvent(1));
        this.log.addLog("PiTrex: Serial port disconnected.");
        return true;
    }

    public boolean connect(int index) {
        if (this.alreadyConnected(index)) {
            return true;
        }
        if (this.ubxPort != null) {
            this.ubxPort.removeDataListener();
            this.ubxPort.closePort();
            this.ubxPort = null;
        }
        if (index == -1) {
            return false;
        }
        if (this.ports.length <= index) {
            return false;
        }
        this.ubxPort = this.ports[index];
        boolean isReady = this.ubxPort.openPort();
        if (!isReady) {
            if (this.ubxPort != null) {
                this.log.addLog("PiTrex: Serial port '" + this.ubxPort.getDescriptivePortName() + "' available, but cannot be opened. Opened in another terminal?");
            }
            this.ubxPort = null;
            this.currentName = "";
            return !isReady;
        }
        this.currentName = this.ubxPort.getDescriptivePortName();
        int baud = 921600;
        this.ubxPort.setBaudRate(baud);
        this.ubxPort.setNumDataBits(8);
        this.ubxPort.setParity(0);
        this.ubxPort.setNumStopBits(1);
        this.ubxPort.setBaudRate(this.config.piTrexBaud);
        this.ubxPort.setNumDataBits(this.config.piDataBits);
        this.ubxPort.setParity(this.config.piParity);
        this.ubxPort.setNumStopBits(this.config.piStopBit);
        this.ubxPort.setComPortTimeouts(0, 1000, 0);
        this.ubxPort.setComPortTimeouts(0, 1000, 0);
        this.ubxPort.addDataListener(this.listener);
        this.toCard("\n");
        this.toCard("\n");
        this.notifyListeners(new PiTrexEvent(1));
        this.log.addLog("PiTrex: Serial port '" + this.ubxPort.getDescriptivePortName() + "' connected.");
        return isReady;
    }

    void toCard(byte[] buffer) {
        try {
            this.ubxPort.writeBytes(buffer, (long)buffer.length);
            this.ubxPort.getOutputStream().flush();
        }
        catch (Throwable e) {
            this.log.addLog(e);
        }
    }

    void toCard(String buffer) {
        String ret = "\n";
        buffer = UtilityString.replace(buffer, "\n", ret);
        this.toCard(buffer.getBytes());
    }

    void toCardSepSlow(byte[] buffer) {
        int M_L = 1;
        byte[] b = new byte[M_L];
        try {
            int len = M_L;
            int pos = 0;
            do {
                len = buffer.length - pos > M_L ? M_L : buffer.length - pos;
                for (int i = 0; i < len; ++i) {
                    b[i] = buffer[pos + i];
                }
                this.ubxPort.writeBytes(b, (long)len);
                this.ubxPort.getOutputStream().flush();
                Thread.sleep(1L);
            } while ((pos += len) < buffer.length);
        }
        catch (Throwable e) {
            this.log.addLog(e);
        }
    }

    void toCardSepFast(byte[] buffer) {
        int M_L = 10000000;
        byte[] b = new byte[M_L];
        try {
            int len = M_L;
            int pos = 0;
            do {
                len = buffer.length - pos > M_L ? M_L : buffer.length - pos;
                for (int i = 0; i < len; ++i) {
                    b[i] = buffer[pos + i];
                }
                this.ubxPort.writeBytes(b, (long)len);
                this.ubxPort.getOutputStream().flush();
                Thread.sleep(1L);
            } while ((pos += len) < buffer.length);
        }
        catch (Throwable e) {
            this.log.addLog(e);
        }
    }

    void toCardSep(String buffer) {
        String ret = "\n";
        buffer = UtilityString.replace(buffer, "\n", ret);
        this.toCardSepSlow(buffer.getBytes());
    }

    void startTransfer(final byte[] data2, final int size, String name) {
        Thread one = new Thread("Transfer: " + name){

            @Override
            public void run() {
                PiTrexSingleton.this.toCardSep("\n");
                PiTrexSingleton.this.toCardSep("vlb\n");
                PiTrexSingleton.this.writeSerialNumAscii(size);
                PiTrexSingleton.this.writeSerialBinary(data2, size);
                PiTrexSingleton.this.log.addLog("Transfer done");
                PiTrexSingleton.this.toCardSep("vpb\n");
            }
        };
        one.start();
    }

    void writeSerialNumAscii(int loadLen) {
        String n = "" + loadLen + '\n';
        this.toCardSep(n);
    }

    void writeSerialBinary(byte[] data2, int loadLen) {
        byte[] b = new byte[loadLen];
        for (int i = 0; i < loadLen; ++i) {
            b[i] = data2[i];
        }
        this.toCardSepFast(b);
    }

    public int romToPiTrex(byte[] data2, int size) {
        this.startTransfer(data2, size, "RomTransfer");
        return 0;
    }

    public boolean resetPi() {
        if (!this.isReady()) {
            return false;
        }
        try {
            this.toCardSep("\n");
            this.ubxPort.getOutputStream().flush();
            this.toCardSep("reset\n");
            this.ubxPort.getOutputStream().flush();
        }
        catch (Exception x) {
            this.log.addLog(x);
            return false;
        }
        return true;
    }

    public int fileToPiTrex(String p) {
        try {
            Path path = Paths.get(p, new String[0]);
            byte[] data2 = Files.readAllBytes(path);
            int loadLen = data2.length;
            this.log.addLog("File '" + p + "' loaded, size: " + loadLen);
            this.startTransfer(data2, loadLen, p);
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            return 1;
        }
        return 0;
    }

    public void addListener(PiTrexListenerInterface listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(PiTrexListenerInterface listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(PiTrexEvent event) {
        for (PiTrexListenerInterface listener : this.listeners) {
            listener.piTrexEvent(event);
        }
    }

    public void stopWatchSerialPorts() {
        this.swatcher.stopWatching();
    }

    public void startwatchSerialPorts() {
        this.startWatchSerialPorts(1000);
    }

    public void startWatchSerialPorts(int intervall) {
        this.swatcher.pollingInterval = intervall;
        this.swatcher.startWatching();
    }

    @Override
    public void onPortAdded(String portName) {
        if (this.alreadyConnected()) {
            return;
        }
        if (portName.equals(this.config.piTrexSerialName)) {
            this.init();
        }
    }

    @Override
    public void onPortRemoved(String portName) {
        if (this.ubxPort == null) {
            return;
        }
        if (this.currentName.length() == 0) {
            return;
        }
        if (this.currentName.equals(portName)) {
            this.disconnect();
        }
    }
}

