/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.PiTrex;

import com.fazecast.jSerialComm.SerialPort;
import java.util.HashSet;

public class SerialPortWatcher {
    private HashSet<String> knownPorts = new HashSet();
    protected int pollingInterval = 1000;
    private boolean threadActive = false;
    private PortListener listener;

    protected SerialPortWatcher(PortListener listener) {
        this.listener = listener;
    }

    protected void stopWatching() {
        this.threadActive = false;
    }

    protected void startWatching() {
        if (this.threadActive) {
            return;
        }
        new Thread(() -> {
            while (this.threadActive) {
                try {
                    SerialPort[] ports = SerialPort.getCommPorts();
                    HashSet<String> currentSet = new HashSet<String>();
                    for (SerialPort p : ports) {
                        if (p.getDescriptivePortName().toLowerCase().contains("dial")) continue;
                        currentSet.add(p.getDescriptivePortName());
                    }
                    for (String port : currentSet) {
                        if (this.knownPorts.contains(port)) continue;
                        this.listener.onPortAdded(port);
                    }
                    for (String port : this.knownPorts) {
                        if (currentSet.contains(port)) continue;
                        this.listener.onPortRemoved(port);
                    }
                    this.knownPorts = currentSet;
                    Thread.sleep(this.pollingInterval);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        this.threadActive = true;
    }

    protected static interface PortListener {
        public void onPortAdded(String var1);

        public void onPortRemoved(String var1);
    }
}

