/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.assy.AsmjDeath;
import de.malban.vide.assy.Conditional;
import de.malban.vide.assy.DynamicFile;
import de.malban.vide.assy.LineContext;
import de.malban.vide.assy.Macro;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.MemorySegment;
import de.malban.vide.assy.Option;
import de.malban.vide.assy.ProcessorDependencies;
import de.malban.vide.assy.SourceLine;
import de.malban.vide.assy.Struct;
import de.malban.vide.assy.Symbol;
import de.malban.vide.assy.SymbolTable;
import de.malban.vide.assy.arguments.ArgumentMemoryLocation;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.expressions.ExpressionNumber;
import de.malban.vide.assy.expressions.ExpressionSymbol;
import de.malban.vide.assy.instructions.Instruction;
import de.malban.vide.assy.instructions.RegArg;
import de.malban.vide.assy.instructions.SingleArg;
import de.malban.vide.assy.instructions.fcb;
import de.malban.vide.assy.instructions.fdb;
import de.malban.vide.assy.instructions.rmb;
import de.malban.vide.assy.instructions.struct;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.vedi.DebugComment;
import de.malban.vide.vedi.DebugCommentList;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Asmj {
    VideConfig config = VideConfig.getConfig();
    public static final int MAX_MACRO_DEPTH = 65536;
    public static ProcessorDependencies processor;
    public static String version;
    public static int bank;
    public static boolean multibank;
    public static boolean inBSS;
    public static String currentBaseDir;
    public static boolean is48k;
    public static final int SEGMENT_CODE = 0;
    public static final int SEGMENT_DATA = 1;
    public static final int SEGMENT_BSS = 2;
    public static boolean ALLOW_DIF_TRANSFER;
    public int currentSegment = 0;
    public int currentCodeOrg = 0;
    public int currentBSSOrg = 0;
    public int currentDataOrg = 0;
    private int globalAddress = 0;
    static ArrayList<ReplacementFileList> allReplacements;
    private static String replacementPrefix;
    static HashMap<String, HashMap> matchFiles;
    static HashMap<String, Integer> matchList;
    public static boolean doReplacements;
    public static ReplacementFileList rList;
    PrintStream ps_error;
    PrintStream ps_info;
    PrintStream ps_listing;
    PrintStream ps_symtab;
    PrintStream ps_allOut;
    OutputStream ps_error_add = null;
    OutputStream ps_info_add = null;
    OutputStream ps_listing_add = null;
    OutputStream ps_symtab_add = null;
    OutputStream ps_allOut_add = null;
    StringBuffer symtabString = new StringBuffer();
    StringBuffer errorString = new StringBuffer();
    StringBuffer infoString = new StringBuffer();
    StringBuffer listingString = new StringBuffer();
    StringBuffer allOutString = new StringBuffer();
    String mainFile = "";
    public static HashMap<String, DebugCommentList> allDebugComments;
    boolean watchesDone = false;
    public static boolean localOpt;
    ArrayList<Boolean> conditionals = new ArrayList();
    boolean condition = true;
    int macroCount = 0;
    static final int BYTES_PER_LINE = 6;
    static final int CHARS_PER_LINE = 26;
    static final String CODE_PADDING;
    int errorNum = -1;
    HashMap<Character, Character> cmapping = null;
    public static int LI_UNKOWN;
    public static int LI_BYTE;
    public static int LI_WORD;
    public static int LI_STRING;
    static HashMap<Integer, LineInfo> lineInfos;
    static boolean correctDataOption;
    static int maxData;

    public static void resetReplacements(String prefix) {
        allReplacements = new ArrayList();
        replacementPrefix = prefix;
        if (!replacementPrefix.endsWith(File.separator)) {
            replacementPrefix = replacementPrefix + File.separator;
        }
    }

    public static void binFileRename(String org2, String banked) {
        for (ReplacementFileList asmR : allReplacements) {
            if (!asmR.binFileName.equals(org2)) continue;
            asmR.binFileName = banked;
        }
    }

    public static void doReplacements() {
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        matchFiles = new HashMap();
        for (ReplacementFileList asmR : allReplacements) {
            try {
                log.addLog("Replacement start for file: " + asmR.binFileName, LogPanel.INFO);
                Path path = Paths.get(asmR.binFileName, new String[0]);
                byte[] data2 = Files.readAllBytes(path);
                for (Replacements r : asmR.replacementList) {
                    int org2;
                    if (r.address + r.len > data2.length) continue;
                    int value = Asmj.getReplacementValue(r.replacementVarName, r.replacementVarListName);
                    byte lo = (byte)(value & 0xFF);
                    byte hi = (byte)((value & 0xFF00) >> 8);
                    if (r.len == 1) {
                        org2 = data2[r.address] & 0xFF;
                        data2[r.address] = lo;
                        log.addLog("Replacement done (at $" + String.format("%04X", r.address) + "): '" + r.replacementVarName + "', from $" + String.format("%02X", org2) + " to $" + String.format("%02X", lo), LogPanel.INFO);
                        if (value != 0) continue;
                        log.addLog("Replacement value == 0 (at $" + String.format("%04X", r.address) + "): '" + r.replacementVarName + "', from $" + String.format("%02X", org2) + " to $" + String.format("%02X", lo), LogPanel.ERROR);
                        continue;
                    }
                    if (r.len != 2) continue;
                    org2 = (data2[r.address] & 0xFF) * 256 + (data2[r.address + 1] & 0xFF) & 0xFFFF;
                    data2[r.address] = hi;
                    data2[r.address + 1] = lo;
                    log.addLog("Replacement done (at $" + String.format("%04X", r.address) + "): '" + r.replacementVarName + "', from $" + String.format("%04X", org2) + " to $" + String.format("%04X", value & 0xFFFF), LogPanel.INFO);
                    if (value != 0) continue;
                    log.addLog("Replacement value == 0 (at $" + String.format("%04X", r.address) + "): '" + r.replacementVarName + "', from $" + String.format("%04X", org2) + " to $" + String.format("%02X", lo), LogPanel.ERROR);
                }
                UtilityFiles.writeBinFile(asmR.binFileName, data2, false);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public static int getReplacementValue(String varName, String listName) {
        HashMap<String, Integer> matchList = matchFiles.get(listName);
        if (matchList == null) {
            matchList = new HashMap<String, Integer>();
            Vector<String> matches = UtilityString.readTextFileToString(new File(replacementPrefix + listName));
            for (int i = 0; i < matches.size(); ++i) {
                String l = matches.elementAt(i);
                String[] split = l.split("=");
                if (split.length != 2) continue;
                matchList.put(split[0], DASM6809.toNumber(split[1]));
            }
        }
        if (matchList.get(varName) != null) {
            return (Integer)matchList.get(varName);
        }
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        log.addLog("Replacement match not found: " + varName, LogPanel.WARN);
        return 0;
    }

    private static void initReplacement() {
        doReplacements = false;
        rList = new ReplacementFileList();
    }

    private static void exitReplacement(SymbolTable symbols) {
        allReplacements.add(rList);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < symbols.symbols.size(); ++i) {
            Symbol s = (Symbol)symbols.symbols.elementAt(i);
            String name = s.getName();
            if (name.startsWith("*") || !s.defined()) continue;
            int value = s.getValue();
            if (Asmj.checkReplacer(name, value)) {
                // empty if block
            }
            b.append(name);
            b.append("=");
            b.append("0x" + String.format("%04X", value & 0xFFFF));
            b.append("\n");
        }
        String fName = replacementPrefix + Asmj.rList.replacementFileName;
        UtilityFiles.createTextFile(fName, b.toString());
    }

    static boolean checkReplacer(String name, int value) {
        String[] split = name.split("_");
        if (!split[0].equals("REPLACE")) {
            return false;
        }
        if (split.length != 6) {
            return false;
        }
        Replacements r = new Replacements();
        r.address = value;
        r.address += DASM6809.toNumber(split[1]);
        r.len = DASM6809.toNumber(split[2]);
        r.replacementVarName = split[3];
        r.replacementVarListName = split[4];
        Asmj.rList.replacementList.add(r);
        return true;
    }

    public int getGlobalAddress() {
        return this.globalAddress;
    }

    public void switchSegment(int newSegment) {
        if (this.currentSegment == 0) {
            this.currentCodeOrg = this.globalAddress;
        }
        if (this.currentSegment == 1) {
            this.currentDataOrg = this.globalAddress;
        }
        if (this.currentSegment == 2) {
            this.currentBSSOrg = this.globalAddress;
        }
        this.currentSegment = newSegment;
        if (this.currentSegment == 2) {
            this.globalAddress = this.currentBSSOrg;
            inBSS = true;
        }
        if (this.currentSegment == 1) {
            this.globalAddress = this.currentDataOrg;
            inBSS = false;
        }
        if (this.currentSegment == 0) {
            this.globalAddress = this.currentCodeOrg;
            inBSS = false;
        }
    }

    public String getAllOut() {
        String ao = this.allOutString.toString();
        this.allOutString.delete(0, this.allOutString.length());
        return ao;
    }

    public String getError() {
        String error2 = this.errorString.toString();
        this.errorString.delete(0, this.errorString.length());
        return error2;
    }

    public String getInfo() {
        String infoS = this.infoString.toString();
        this.infoString.delete(0, this.infoString.length());
        return infoS;
    }

    public String getListing() {
        String listingS = this.listingString.toString();
        this.listingString.delete(0, this.listingString.length());
        return listingS;
    }

    public String getSymtab() {
        String s = this.symtabString.toString();
        this.symtabString.delete(0, this.symtabString.length());
        return s;
    }

    private void initStreams() {
        this.ps_allOut = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                char[] c = new char[]{(char)b};
                Asmj.this.allOutString.append(c);
            }
        });
        this.ps_symtab = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                char[] c = new char[]{(char)b};
                String s = new String(c);
                Asmj.this.symtabString.append(s);
                try {
                    if (Asmj.this.ps_symtab_add != null) {
                        Asmj.this.ps_symtab_add.write(b);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.ps_error = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                char[] c = new char[]{(char)b};
                String s = new String(c);
                Asmj.this.errorString.append(s);
                try {
                    if (Asmj.this.ps_error_add != null) {
                        Asmj.this.ps_error_add.write(b);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.ps_listing = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                char[] c = new char[]{(char)b};
                String s = new String(c);
                Asmj.this.listingString.append(s);
                try {
                    if (Asmj.this.ps_listing_add != null) {
                        Asmj.this.ps_listing_add.write(b);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.ps_info = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                char[] c = new char[]{(char)b};
                String s = new String(c);
                Asmj.this.infoString.append(s);
                try {
                    if (Asmj.this.ps_info_add != null) {
                        Asmj.this.ps_info_add.write(b);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public Asmj(String filename, OutputStream errOut, OutputStream result) {
        version = "";
        Asmj.initReplacement();
        Asmj.clearLineInfo();
        this.mainFile = filename;
        this.ps_error_add = errOut;
        this.ps_allOut_add = result;
        bank = 0;
        this.initStreams();
        this.initProcessor();
        Option opt_p = new Option("p", true, null);
        opt_p.stream = this.ps_allOut;
        Option opt_e = new Option("e", true, null);
        opt_e.stream = this.ps_error;
        Option opt_l = new Option("l", true, null);
        opt_l.stream = this.ps_listing;
        Option opt_t = new Option("t", true, null);
        opt_t.stream = this.ps_symtab;
        Option opt_f = new Option("f", true, null);
        opt_f.unique = false;
        opt_f.valueNeeded = true;
        opt_f.negativeValueOK = true;
        Option opt_b = new Option("b", true, null);
        Option opt_s = new Option("s", false, null);
        Option opt_D = new Option("D", false, null);
        opt_D.unique = false;
        opt_D.valueNeeded = true;
        opt_D.negativeValueOK = true;
        SymbolTable symtab = new SymbolTable();
        Memory image = new Memory();
        Vector<String> inputFilenames = new Vector<String>();
        Vector definitions = new Vector();
        inputFilenames.addElement(filename);
        if (inputFilenames.size() == 0) {
            this.ps_error.println("No input file given - aborting!");
            return;
        }
        int size = inputFilenames.size();
        LineNumberReader[] inputs = new LineNumberReader[size];
        String[] filenames = new String[size];
        String lastInputFile = null;
        for (int i = 0; i < size; ++i) {
            String f;
            filenames[i] = f = (String)inputFilenames.elementAt(i);
            try {
                inputs[i] = DynamicFile.getLineNumberReader(f);
            }
            catch (IOException x) {
                this.die(x);
            }
            lastInputFile = f;
        }
        size = definitions.size();
        String[] symbols = new String[size];
        int[] values = new int[size];
        for (int i = 0; i < size; ++i) {
            String d = (String)definitions.elementAt(i);
            int p = d.indexOf("=");
            if (p == 0) {
                this.die("missing symbol name in '" + d + "'");
            }
            values[i] = 0;
            if (p < 0) {
                symbols[i] = d;
                continue;
            }
            symbols[i] = d.substring(0, p);
            try {
                String vs = d.substring(p + 1);
                values[i] = ExpressionNumber.eval(vs);
                continue;
            }
            catch (ParseException x) {
                this.die(x);
            }
        }
        String baseFilename = lastInputFile;
        Path p = Paths.get(baseFilename, new String[0]);
        currentBaseDir = p.getParent().toString();
        if (baseFilename.toLowerCase().endsWith(".asm")) {
            baseFilename = baseFilename.substring(0, baseFilename.length() - 4);
        } else {
            int li = baseFilename.lastIndexOf(".");
            if (li >= 0) {
                baseFilename = baseFilename.substring(0, li);
            }
        }
        Asmj.rList.binFileName = opt_b.default_value = baseFilename + ".bin";
        opt_s.default_value = baseFilename + ".s19";
        try {
            OutputStream binary_stream = null;
            PrintStream srecord_stream = opt_s.getPrintStream();
            PrintStream listing_stream = (PrintStream)opt_l.stream;
            PrintStream error_stream = (PrintStream)opt_e.stream;
            PrintStream symtab_stream = (PrintStream)opt_t.stream;
            PrintStream preprocess_stream = (PrintStream)opt_p.stream;
            this.assemble(inputs, filenames, binary_stream, srecord_stream, listing_stream, error_stream, symtab_stream, preprocess_stream, symbols, values);
            opt_b.closeStream();
            opt_s.closeStream();
            opt_l.closeStream();
            opt_e.closeStream();
            opt_t.closeStream();
            opt_p.closeStream();
        }
        catch (IOException x) {
            this.die(x);
        }
    }

    public Asmj(String filename, OutputStream errOut, OutputStream listOut, OutputStream symOut, OutputStream infoOut, String defines, HashMap<String, DebugCommentList> adc) {
        this(filename, errOut, listOut, symOut, infoOut, defines, adc, false);
    }

    public Asmj(String filename, OutputStream errOut, OutputStream listOut, OutputStream symOut, OutputStream infoOut, String defines, HashMap<String, DebugCommentList> adc, boolean is48k) {
        String[] defs;
        version = "";
        Asmj.is48k = is48k;
        Asmj.initReplacement();
        allDebugComments = adc;
        Asmj.clearLineInfo();
        this.mainFile = filename;
        this.ps_error_add = errOut;
        this.ps_info_add = infoOut;
        this.ps_listing_add = listOut;
        this.ps_symtab_add = symOut;
        bank = 0;
        this.initStreams();
        this.initProcessor();
        Option opt_e = new Option("e", true, null);
        opt_e.stream = this.ps_error;
        Option opt_l = new Option("l", true, null);
        opt_l.stream = this.ps_listing;
        Option opt_t = new Option("t", true, null);
        opt_t.stream = this.ps_symtab;
        Option opt_f = new Option("f", true, null);
        opt_f.unique = false;
        opt_f.valueNeeded = true;
        opt_f.negativeValueOK = true;
        Option opt_b = new Option("b", true, null);
        Option opt_s = new Option("s", false, null);
        Option opt_D = new Option("D", false, null);
        opt_D.unique = false;
        opt_D.valueNeeded = true;
        opt_D.negativeValueOK = true;
        SymbolTable symtab = new SymbolTable();
        Memory image = new Memory();
        Vector<String> inputFilenames = new Vector<String>();
        Vector<String> definitions = new Vector<String>();
        for (String d : defs = defines.split(";")) {
            definitions.addElement(d);
        }
        inputFilenames.addElement(filename);
        if (inputFilenames.size() == 0) {
            this.ps_error.println("No input file given - aborting!");
            return;
        }
        int size = inputFilenames.size();
        LineNumberReader[] inputs = new LineNumberReader[size];
        String[] filenames = new String[size];
        String lastInputFile = null;
        for (int i = 0; i < size; ++i) {
            String f;
            filenames[i] = f = (String)inputFilenames.elementAt(i);
            try {
                inputs[i] = DynamicFile.getLineNumberReader(f);
            }
            catch (IOException x) {
                this.die(x);
            }
            lastInputFile = f;
        }
        size = definitions.size();
        String[] symbols = new String[size];
        int[] values = new int[size];
        for (int i = 0; i < size; ++i) {
            String d = (String)definitions.elementAt(i);
            int p = d.indexOf("=");
            if (p == 0) {
                this.die("missing symbol name in '" + d + "'");
            }
            values[i] = 0;
            if (p < 0) {
                symbols[i] = d;
                continue;
            }
            symbols[i] = d.substring(0, p);
            try {
                String vs = d.substring(p + 1);
                values[i] = ExpressionNumber.eval(vs);
                continue;
            }
            catch (ParseException x) {
                this.die(x);
            }
        }
        String baseFilename = lastInputFile;
        Path p = Paths.get(baseFilename, new String[0]);
        currentBaseDir = p.getParent().toString();
        if (baseFilename.toLowerCase().endsWith(".asm")) {
            baseFilename = baseFilename.substring(0, baseFilename.length() - 4);
        } else {
            int li = baseFilename.lastIndexOf(".");
            if (li >= 0) {
                baseFilename = baseFilename.substring(0, li);
            }
        }
        Asmj.rList.binFileName = opt_b.default_value = baseFilename + ".bin";
        opt_s.default_value = baseFilename + ".s19";
        try {
            OutputStream binary_stream = opt_b.getOutputStream();
            PrintStream srecord_stream = opt_s.getPrintStream();
            PrintStream listing_stream = (PrintStream)opt_l.stream;
            PrintStream error_stream = (PrintStream)opt_e.stream;
            PrintStream symtab_stream = (PrintStream)opt_t.stream;
            this.assemble(inputs, filenames, binary_stream, srecord_stream, listing_stream, error_stream, symtab_stream, null, symbols, values);
            opt_b.closeStream();
            opt_s.closeStream();
            opt_l.closeStream();
            opt_e.closeStream();
            opt_t.closeStream();
        }
        catch (IOException x) {
            this.die(x);
        }
    }

    public Asmj(String[] argv) {
        Asmj.initReplacement();
        Asmj.clearLineInfo();
        bank = 0;
        this.initProcessor();
        Option opt_e = new Option("e", false, null);
        Option opt_l = new Option("l", true, null);
        Option opt_t = new Option("t", true, null);
        Option opt_f = new Option("f", true, null);
        opt_f.unique = false;
        opt_f.valueNeeded = true;
        opt_f.negativeValueOK = true;
        Option opt_b = new Option("b", true, null);
        Option opt_s = new Option("s", false, null);
        Option opt_D = new Option("D", false, null);
        opt_D.unique = false;
        opt_D.valueNeeded = true;
        opt_D.negativeValueOK = true;
        SymbolTable symtab = new SymbolTable();
        Memory image = new Memory();
        Vector<String> inputFilenames = new Vector<String>();
        Vector<String> definitions = new Vector<String>();
        for (int a = 0; a < argv.length; ++a) {
            char ch1 = argv[a].charAt(0);
            if (ch1 == '-' || ch1 == '+') {
                Option opt2 = null;
                try {
                    opt2 = Option.parseAny(argv[a]);
                }
                catch (Exception x) {
                    this.usage(x);
                }
                if (opt2 == null) {
                    this.usage("Unrecognized option " + argv[a]);
                }
                if (opt2.name.equals("f")) {
                    inputFilenames.addElement(opt2.value);
                }
                if (!opt2.name.equals("D")) continue;
                definitions.addElement(opt2.value);
                continue;
            }
            inputFilenames.addElement(argv[a]);
        }
        if (inputFilenames.size() == 0) {
            this.usage("No input filename specified.");
        }
        int size = inputFilenames.size();
        LineNumberReader[] inputs = new LineNumberReader[size];
        String[] filenames = new String[size];
        String lastInputFile = null;
        for (int i = 0; i < size; ++i) {
            String f;
            filenames[i] = f = (String)inputFilenames.elementAt(i);
            try {
                inputs[i] = DynamicFile.getLineNumberReader(f);
            }
            catch (IOException x) {
                this.die(x);
            }
            lastInputFile = f;
        }
        size = definitions.size();
        String[] symbols = new String[size];
        int[] values = new int[size];
        for (int i = 0; i < size; ++i) {
            String d = (String)definitions.elementAt(i);
            int p = d.indexOf("=");
            if (p == 0) {
                this.die("missing symbol name in '" + d + "'");
            }
            values[i] = 0;
            if (p < 0) {
                symbols[i] = d;
                continue;
            }
            symbols[i] = d.substring(0, p);
            try {
                String vs = d.substring(p + 1);
                values[i] = ExpressionNumber.eval(vs);
                continue;
            }
            catch (ParseException x) {
                this.die(x);
            }
        }
        String baseFilename = lastInputFile;
        if (baseFilename.toLowerCase().endsWith(".asm")) {
            baseFilename = baseFilename.substring(0, baseFilename.length() - 4);
        }
        Asmj.rList.binFileName = opt_b.default_value = baseFilename + ".bin";
        opt_s.default_value = baseFilename + ".s19";
        try {
            OutputStream binary_stream = opt_b.getOutputStream();
            PrintStream srecord_stream = opt_s.getPrintStream();
            PrintStream listing_stream = opt_l.getPrintStream();
            PrintStream error_stream = opt_e.getPrintStream();
            PrintStream symtab_stream = opt_t.getPrintStream();
            this.assemble(inputs, filenames, binary_stream, srecord_stream, listing_stream, error_stream, symtab_stream, null, symbols, values);
            opt_b.closeStream();
            opt_s.closeStream();
            opt_l.closeStream();
            opt_e.closeStream();
            opt_t.closeStream();
        }
        catch (IOException x) {
            this.die(x);
        }
    }

    private void initProcessor() {
        try {
            processor = new ProcessorDependencies();
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new AsmjDeath("Asmj bug - missing processor-dependencies");
        }
        processor.sanityCheck();
    }

    public void assemble(LineNumberReader[] inputs, String[] filenames, OutputStream binary, PrintStream srecords, PrintStream listing, PrintStream errors, PrintStream symbols, PrintStream preprocess, String[] externalSymbols, int[] externalValues) {
        LineContext ctx;
        int i;
        SymbolTable symtab = new SymbolTable();
        Memory image = new Memory();
        Macro.reset();
        for (i = 0; i < externalSymbols.length; ++i) {
            if (externalSymbols[i] == null) continue;
            symtab.define(externalSymbols[i], externalValues[i], -2, null, 1, null);
        }
        symtab.define("false", 0, -2, null, 1, null);
        symtab.define("true", 1, -2, null, 1, null);
        symtab.define("FALSE", 0, -2, null, 1, null);
        symtab.define("TRUE", 1, -2, null, 1, null);
        localOpt = this.config.opt;
        try {
            ctx = new LineContext(new SourceLine("", "", -1));
            for (i = 0; i < inputs.length; ++i) {
                this.pass0(ctx, inputs[i], filenames[i]);
            }
            this.pass1(ctx, symtab, 0);
            ctx.assertEndOfContext();
            this.pass2(ctx, symtab, image, preprocess);
        }
        catch (Exception x) {
            throw new AsmjDeath(x);
        }
        this.setErrorCount(ctx);
        if (preprocess == null) {
            if (this.errorNum == 0) {
                this.ps_info.println("0 errors detected.");
                String fn = filenames[0];
                int dot = fn.lastIndexOf(".");
                if (dot < 0) {
                    fn = fn + ".cnt";
                } else {
                    fn = fn.substring(0, dot);
                    fn = fn + ".cnt";
                }
                this.generateCNT(fn, symtab, ctx, image);
            }
            if (this.config.outputLST && listing != null) {
                this.emitListing(ctx, image, listing);
            }
            if (errors != null) {
                this.emitErrors(ctx, errors);
            }
            if (preprocess == null && binary != null) {
                this.writeBinary(image, binary);
            }
            if (srecords != null) {
                this.writeSRecords(image, symtab, srecords);
            }
            if (this.config.outputLST && symbols != null) {
                symtab.dump(symbols);
            }
        }
        Asmj.exitReplacement(symtab);
    }

    private void include(LineContext ctx, String filename) throws IOException {
        LineNumberReader in = DynamicFile.getLineNumberReader(filename);
        this.pass0(ctx, in, filename);
        in.close();
    }

    private void pass0(LineContext ctx, LineNumberReader in, String filename) {
        int lineNum;
        String line;
        SourceLine pline = null;
        if (!this.watchesDone) {
            this.watchesDone = true;
            if (allDebugComments != null) {
                Set<Map.Entry<String, DebugCommentList>> entries = allDebugComments.entrySet();
                for (Map.Entry<String, DebugCommentList> entry : entries) {
                    DebugCommentList value = entry.getValue();
                    for (DebugComment dbc : value.getList()) {
                        if (dbc.getType() != 2) continue;
                        pline = new SourceLine("; " + dbc.getGeneratedComment(), filename, 0);
                        this.pass0_line(ctx, pline);
                    }
                }
            }
        }
        do {
            try {
                line = in.readLine();
            }
            catch (IOException x) {
                break;
            }
        } while (line != null && this.pass0_line(ctx, pline = new SourceLine(line, filename, lineNum = in.getLineNumber())));
    }

    private void pass0(LineContext ctx, Vector src) {
        SourceLine pline;
        for (int i = 0; i < src.size() && this.pass0_line(ctx, pline = (SourceLine)src.elementAt(i)); ++i) {
        }
    }

    private boolean pass0_line(LineContext ctx, SourceLine pline) {
        Instruction instr = null;
        ctx.addLine(pline);
        if (pline.parsed()) {
            instr = Instruction.create(this, pline);
            pline.setInstruction(instr);
        }
        return instr == null || !instr.isEnd();
    }

    private void pass1(LineContext ctx, SymbolTable symtab, int address) {
        Conditional c;
        SourceLine pline = null;
        int skipMacroDepth = 65537;
        this.globalAddress = address;
        for (pline = ctx.first; pline != null; pline = pline.getNext()) {
            Macro macroRef;
            int d;
            pline.dp_value = LineContext.directRegister;
            pline.setOptimize(localOpt);
            Instruction instr = pline.getInstruction();
            c = ctx.getTopConditional();
            ctx.current = pline;
            if (skipMacroDepth <= 65536) {
                if (pline.getMacroDepth() >= skipMacroDepth) {
                    pline.setInstruction(null);
                    pline.eraseErrorMessages();
                    ctx.hideInMacro(pline);
                    continue;
                }
                d = skipMacroDepth;
                while (c.getMacroDepth() >= d) {
                    c = ctx.popContext();
                }
                skipMacroDepth = 65537;
            }
            if (ctx.processInstructions() && pline.getLabel() != null) {
                String lbl = ExpressionSymbol.parseName(pline.getLabel());
                if (!pline.getLabel().equals(lbl)) {
                    Asmj.error(pline, "bad label");
                } else if (instr == null || !instr.definesLabel()) {
                    if (ctx.currentStruct == null) {
                        symtab.define(pline.getLabel(), address, pline.getLineNumber(), null, 2, pline);
                    } else {
                        symtab.define(pline.getLabel(), ctx.currentStruct.currentPosition, pline.getLineNumber(), null, 3, pline);
                    }
                }
            }
            if (instr != null && instr.isEndMacro() && c.isMacro()) {
                if (!ctx.assertMacro()) continue;
                ctx.popContext();
                ctx.macroDef = null;
                continue;
            }
            if (c.isMacro()) {
                if (ctx.macroDef == null) continue;
                ctx.macroDef.addLine(pline);
                pline.eraseErrorMessages();
                continue;
            }
            if (ctx.processInstructions() && instr != null && instr.isBeginMacro()) {
                String mname;
                try {
                    mname = instr.macroName();
                }
                catch (ParseException x) {
                    Asmj.error(pline, x.getMessage());
                    mname = "*undefined";
                }
                ctx.macroDef = Macro.set(mname, pline.getLineNumber(), pline);
                c = ctx.beginMacro();
                continue;
            }
            if (ctx.processInstructions() && (macroRef = Macro.find(pline.op)) != null) {
                pline.setMacro(macroRef);
                ctx.hideInMacro(pline);
                pline.eraseErrorMessages();
                if (pline.getMacroDepth() >= 65536) {
                    Asmj.error(pline, "Macro recursion too deep");
                    continue;
                }
                this.pass0(ctx, macroRef.expandSource(pline));
                continue;
            }
            if (ctx.processInstructions() && instr != null && instr.isExitMacro()) {
                d = pline.getMacroDepth();
                if (d < 0) {
                    Asmj.error(pline, "not in a macro");
                }
                skipMacroDepth = d;
                ctx.hideInMacro(pline);
                continue;
            }
            if (ctx.processInstructions() || c.isIf() && c.getEnclosingState() && instr != null && instr.isElseIf()) {
                if (instr != null) {
                    if (ctx.currentStruct == null) {
                        instr.pass1(address, symtab);
                        instr = pline.getInstruction();
                    } else {
                        int value;
                        Symbol s;
                        instr.pass1(address, symtab);
                        if (instr instanceof fcb) {
                            fcb fcbInstr = (fcb)instr;
                            fcbInstr.setBSS(true);
                            s = fcbInstr.getSymbol();
                            if (s != null) {
                                s.removeUndefinedReference(instr);
                                value = ctx.currentStruct.currentPosition;
                                s.define(value, instr.getLineNumber(), pline);
                                s.line_Comment = instr.getSource().endOfLineComment;
                                instr.setEvalOk();
                            }
                            ctx.currentStruct.currentPosition += instr.getLength();
                        }
                        if (instr instanceof fdb) {
                            fdb fdbInstr = (fdb)instr;
                            fdbInstr.setBSS(true);
                            s = fdbInstr.getSymbol();
                            if (s != null) {
                                s.removeUndefinedReference(instr);
                                value = ctx.currentStruct.currentPosition;
                                s.define(value, instr.getLineNumber(), pline);
                                s.line_Comment = instr.getSource().endOfLineComment;
                                instr.setEvalOk();
                            }
                            ctx.currentStruct.currentPosition += instr.getLength();
                        }
                        if (instr instanceof rmb) {
                            rmb rmbInstr = (rmb)instr;
                            s = rmbInstr.getSymbol();
                            if (s != null) {
                                s.removeUndefinedReference(instr);
                                value = ctx.currentStruct.currentPosition;
                                s.define(value, instr.getLineNumber(), pline);
                                s.line_Comment = instr.getSource().endOfLineComment;
                                instr.setEvalOk();
                            }
                            ctx.currentStruct.currentPosition += instr.getLength();
                        }
                        if (instr.isStructEnd()) {
                            ctx.currentStruct.endStruct();
                            ctx.currentStruct = null;
                        }
                    }
                }
            } else {
                pline.eraseErrorMessages();
                pline.eraseWarningMessages();
                pline.eraseOptimizeMessages();
                pline.eraseComments();
            }
            if (instr == null) {
                ctx.hideInMacro(pline);
                continue;
            }
            if (instr.isStructStart() && ctx.processInstructions()) {
                ctx.setStruct(new Struct((struct)instr));
            }
            if (instr.isIf()) {
                c = ctx.beginIf(instr.getCondition());
                ctx.hideInMacro(pline);
                continue;
            }
            if (instr.isElseIf()) {
                if (!ctx.assertIf() || !ctx.assertPastElse(false)) continue;
                c.parseElseif(instr.getCondition());
                ctx.refreshState();
                ctx.hideInMacro(pline);
                continue;
            }
            if (instr.isElse()) {
                if (!ctx.assertIf()) continue;
                c.parseElse();
                ctx.refreshState();
                ctx.hideInMacro(pline);
                continue;
            }
            if (instr.isEndIf()) {
                if (!ctx.assertIf()) continue;
                c = ctx.popContext();
                ctx.hideInMacro(pline);
                continue;
            }
            if (instr.isInclude()) {
                try {
                    String f2 = instr.includeFilename();
                    if (!f2.startsWith(File.separator)) {
                        String f1 = "";
                        f1 = this.config.includeRelativeToParent ? pline.getFilename() : this.mainFile;
                        int p = f1.lastIndexOf(File.separator);
                        String path = p < 0 ? "" : f1.substring(0, p + 1);
                        f2 = path + f2;
                    }
                    this.include(ctx, f2);
                }
                catch (Exception x) {
                    Asmj.error(pline, x.getMessage());
                }
                continue;
            }
            if (ctx.processInstructions()) {
                if (ctx.currentStruct == null) {
                    address += instr.getLength();
                }
            } else {
                pline.setInstruction(null);
                ctx.hideInMacro(pline);
            }
            this.globalAddress = address;
        }
        if (skipMacroDepth <= 65536) {
            c = ctx.getTopConditional();
            while (c.getMacroDepth() >= skipMacroDepth) {
                c = ctx.popContext();
            }
            skipMacroDepth = 65537;
        }
    }

    void doPreprocessOut(SourceLine pline, PrintStream preprocess) {
        boolean commentOut = false;
        String commentOutComment = "";
        boolean noOut = false;
        if (pline.instr != null) {
            if (pline.instr.isBeginMacro()) {
                ++this.macroCount;
            }
            if (pline.instr.isInclude()) {
                commentOut = true;
                commentOutComment = "include line -> ";
            }
            if (pline.instr.isStructStart()) {
                // empty if block
            }
            if (pline.instr.isIf()) {
                noOut = true;
                this.conditionals.add(pline.instr.getCondition());
            }
            if (pline.instr.isElse()) {
                noOut = true;
                boolean if_conditial = this.conditionals.get(this.conditionals.size() - 1);
                this.conditionals.remove(this.conditionals.size() - 1);
                this.conditionals.add(!if_conditial);
            }
            if (pline.instr.isElseIf()) {
                noOut = true;
                this.conditionals.remove(this.conditionals.size() - 1);
                this.conditionals.add(pline.instr.getCondition());
            }
            if (pline.instr.isEndIf()) {
                noOut = true;
                this.conditionals.remove(this.conditionals.size() - 1);
            }
        }
        if (this.macroCount != 0) {
            noOut = true;
        }
        this.condition = this.conditionals.size() > 0 ? this.conditionals.get(this.conditionals.size() - 1) : true;
        if (!this.condition) {
            noOut = true;
        }
        if (pline.macro != null) {
            commentOut = true;
            commentOutComment = "macro call -> ";
        }
        if (!noOut) {
            if (commentOut) {
                preprocess.println("; " + commentOutComment + pline.inputLine);
            } else {
                preprocess.println(pline.inputLine);
            }
        }
        if (pline.instr != null && pline.instr.isEndMacro()) {
            --this.macroCount;
        }
    }

    private void pass2(LineContext ctx, SymbolTable symtab, Memory mem, PrintStream preprocess) {
        int address;
        this.globalAddress = address = 0;
        boolean oomDone = false;
        this.macroCount = 0;
        int maxMem = 32768;
        if (is48k) {
            maxMem = 49152;
        }
        for (SourceLine pline = ctx.first; pline != null; pline = pline.getNext()) {
            Instruction instr;
            if (preprocess != null) {
                this.doPreprocessOut(pline, preprocess);
            }
            if ((instr = pline.getInstruction()) == null) continue;
            if (ctx.currentStruct == null) {
                address += instr.getLength();
            }
            this.globalAddress = address;
            symtab.define("*", address, -2, null, 0, null);
            if (mem.current != null && !multibank && mem.current.length > maxMem) {
                oomDone = true;
            }
            instr.pass2(mem, symtab);
        }
        if (oomDone) {
            Asmj.error(ctx.first, "Resulting binary is larger than " + maxMem + " bytes, it can not run on a vectrex (" + mem.current.length + " -> " + (maxMem - mem.current.length) + ")!");
        }
    }

    private void writeBinary(Memory image, OutputStream binaryOut) {
        image.write(binaryOut);
    }

    private void writeSRecords(Memory image, SymbolTable st, OutputStream srecordsOut) {
        int xferAddress = st.getValue("*xfer");
        try {
            image.writeSRecords(srecordsOut, xferAddress);
        }
        catch (IOException x) {
            this.ps_error.println("Error writing s-record file:\n" + x.toString());
            this.ps_error.println("Error writing s-record file:\n" + x.toString());
        }
    }

    boolean generateCNT(String filename, SymbolTable symtab, LineContext ctx, Memory mem) {
        SourceLine pline;
        StringBuilder buf = new StringBuilder();
        Vector symbols = symtab.getSymbols();
        buf.append("BANK " + bank + "\n");
        for (int i = 0; i < symbols.size(); ++i) {
            Symbol sy = (Symbol)symbols.elementAt(i);
            if (!this.config.supportUnusedSymbols && !sy.isUsed()) continue;
            boolean equDone = false;
            int typ = sy.usageType;
            if (sy.getName().toLowerCase().equals("include_i") || sy.getName().toLowerCase().equals("assembler") || sy.getName().toLowerCase().equals("__6809__") || sy.getName().toLowerCase().equals("line") || sy.getName().toLowerCase().equals("true") || sy.getName().toLowerCase().equals("false")) continue;
            if (!sy.labelUsage && Math.abs(sy.value) < 128) {
                boolean isNegative = sy.value < 0;
                int v = Math.abs(sy.value);
                buf.append("EQU ").append(isNegative ? "-" : "").append(String.format("$%02X", v & 0xFFFF)).append(" ").append(sy.getName()).append("\n");
                if (sy.line_Comment.length() <= 0) continue;
                buf.append("COMMENT_LABEL ").append(isNegative ? "-" : "").append(String.format("$%02X", v & 0xFFFF)).append(" ").append(sy.line_Comment).append("\n");
                equDone = true;
                continue;
            }
            if ((typ & 0x20) == 32) {
                if (sy.dp_estimate != -1) {
                    buf.append("DIRECT_LABEL ").append(String.format("$%02X", sy.dp_estimate & 0xFF)).append(String.format(" $%02X", sy.value & 0xFF)).append(" ").append(sy.getName()).append("\n");
                    if (sy.line_Comment.length() <= 0) continue;
                    buf.append("COMMENT_LABEL ").append(String.format("$%02X", sy.value & 0xFF)).append(" ").append(sy.line_Comment).append("\n");
                    continue;
                }
                buf.append("LABEL ").append(String.format("$%04X", sy.value & 0xFFFF)).append(" ").append(sy.getName()).append("\n");
                if (sy.line_Comment.length() <= 0) continue;
                buf.append("COMMENT_LABEL ").append(String.format("$%04X", sy.value & 0xFFFF)).append(" ").append(sy.line_Comment).append("\n");
                continue;
            }
            if ((typ & 0x40) == 64) {
                buf.append("DIRECT_LABEL ").append(String.format("$%02X", sy.value >> 8 & 0xFF)).append(String.format(" $%02X", sy.value & 0xFF)).append(" ").append(sy.getName()).append("\n");
                if (sy.line_Comment.length() > 0) {
                    buf.append("COMMENT_LABEL ").append(String.format("$%02X", sy.value & 0xFF)).append(" ").append(sy.line_Comment).append("\n");
                }
            }
            buf.append("LABEL ").append(String.format("$%04X", sy.value & 0xFFFF)).append(" ").append(sy.getName()).append("\n");
            if (sy.line_Comment.length() <= 0) continue;
            buf.append("COMMENT_LABEL ").append(String.format("$%04X", sy.value & 0xFFFF)).append(" ").append(sy.line_Comment).append("\n");
        }
        int address = 0;
        for (pline = ctx.first; pline != null; pline = pline.getNext()) {
            Instruction instr = pline.getInstruction();
            if (instr != null) {
                address = instr.getAddress();
            }
            if (pline.fullLineComment != null && pline.fullLineComment.length() != 0) {
                buf.append("COMMENT_LINE " + String.format("$%04X", address) + " " + pline.fullLineComment + "\n");
            }
            if (pline.endOfLineComment != null && pline.endOfLineComment.length() != 0 && !pline.endOfLineCommentDone) {
                buf.append("COMMENT " + String.format("$%04X", address) + " " + pline.endOfLineComment + "\n");
            }
            if (pline.instr != null) {
                String symbol;
                ExpressionSymbol oe;
                int valAll;
                ArgumentMemoryLocation m;
                if (pline.instr instanceof SingleArg) {
                    SingleArg sa = (SingleArg)pline.instr;
                    if (sa.m != null) {
                        m = sa.m;
                        valAll = m.getOffset();
                        if (m.offsetExpression != null) {
                            if (m.offsetExpression instanceof ExpressionSymbol) {
                                oe = (ExpressionSymbol)m.offsetExpression;
                                if (oe.getSymbol() != null && oe.getSymbol().value == valAll) {
                                    symbol = oe.getSymbol().getName();
                                    buf.append("FORCE_SYMBOL " + String.format("$%04X", address) + " " + symbol + "\n");
                                }
                            } else if (m.offsetExpression instanceof ExpressionNumber) {
                                buf.append("FORCE_NO_SYMBOL " + String.format("$%04X", address) + "\n");
                            }
                        }
                    }
                }
                if (pline.instr instanceof RegArg) {
                    RegArg ra = (RegArg)pline.instr;
                    if (ra.m != null) {
                        m = ra.m;
                        valAll = m.getOffset();
                        if (m.offsetExpression != null) {
                            if (m.offsetExpression instanceof ExpressionSymbol) {
                                oe = (ExpressionSymbol)m.offsetExpression;
                                if (oe.getSymbol() != null && oe.getSymbol().value == valAll) {
                                    symbol = oe.getSymbol().getName();
                                    buf.append("FORCE_SYMBOL " + String.format("$%04X", address) + " " + symbol + "\n");
                                }
                            } else if (m.offsetExpression instanceof ExpressionNumber) {
                                buf.append("FORCE_NO_SYMBOL " + String.format("$%04X", address) + "\n");
                            }
                        }
                    }
                }
            }
            if (instr == null) continue;
            address += instr.getLength();
        }
        address = 0;
        int lastAddress = 0;
        int oldDP = -1;
        int currentDP = 0;
        int dpStart = 0;
        for (pline = ctx.first; pline != null; pline = pline.getNext()) {
            Instruction instr = pline.getInstruction();
            currentDP = pline.dp_value;
            if (currentDP != oldDP) {
                if (oldDP != -1) {
                    buf.append("RANGE " + String.format("$%04X", dpStart & 0xFFFF) + "-" + String.format("$%04X", lastAddress & 0xFFFF) + " DP " + String.format("$%02X", oldDP & 0xFF) + "\n");
                }
                dpStart = address;
            }
            oldDP = currentDP;
            lastAddress = address;
            if (instr == null) continue;
            address += instr.getLength();
        }
        if (currentDP != -1) {
            buf.append("RANGE " + String.format("$%04X", dpStart & 0xFFFF) + "-" + String.format("$%04X", lastAddress & 0xFFFF) + " DP " + String.format("$%02X", oldDP & 0xFF) + "\n");
        }
        if (mem.current == null) {
            return false;
        }
        int i = mem.current.base;
        while (i < mem.current.base + mem.current.length) {
            int type = mem.current.getType(i);
            int len = this.getConsecutiveType(mem.current, i, type, symtab);
            if (len == 0) {
                ++i;
                continue;
            }
            if (correctDataOption) {
                if (type == 8) {
                    buf.append("RANGE " + String.format("$%04X", i & 0xFFFF) + "-" + String.format("$%04X", i + len & 0xFFFF) + " DB_DATA " + len + "\n");
                } else if (type == 4) {
                    buf.append("RANGE " + String.format("$%04X", i & 0xFFFF) + "-" + String.format("$%04X", i + len & 0xFFFF) + " CHAR_DATA " + len + "\n");
                } else if (type == 16) {
                    buf.append("RANGE " + String.format("$%04X", i & 0xFFFF) + "-" + String.format("$%04X", i + len & 0xFFFF) + " DW_DATA " + len / 2 + "\n");
                } else if (type == 1) {
                    buf.append("RANGE " + String.format("$%04X", i & 0xFFFF) + "-" + String.format("$%04X", i + len & 0xFFFF) + " CODE\n");
                }
            } else if (type == 8) {
                buf.append("RANGE " + String.format("$%04X", i & 0xFFFF) + "-" + String.format("$%04X", i + len & 0xFFFF) + " DB_DATA\n");
            } else if (type == 4) {
                buf.append("RANGE " + String.format("$%04X", i & 0xFFFF) + "-" + String.format("$%04X", i + len & 0xFFFF) + " CHAR_DATA\n");
            } else if (type == 16) {
                buf.append("RANGE " + String.format("$%04X", i & 0xFFFF) + "-" + String.format("$%04X", i + len & 0xFFFF) + " DW_DATA\n");
            } else if (type == 1) {
                buf.append("RANGE " + String.format("$%04X", i & 0xFFFF) + "-" + String.format("$%04X", i + len & 0xFFFF) + " CODE\n");
            }
            i += len;
        }
        try {
            PrintWriter out = new PrintWriter(filename);
            out.println(buf.toString());
            out.close();
        }
        catch (Throwable e) {
            System.out.println("Error saving CNT file...");
            return false;
        }
        return true;
    }

    private void emitListing(LineContext ctx, Memory image, PrintStream listingOut) {
        int errs = 0;
        for (SourceLine p = ctx.first.getNext(); p != null; p = p.getNext()) {
            String m;
            int mx;
            int len;
            int adr;
            Instruction instr = p.getInstruction();
            Vector msgs = p.errorMessages;
            Vector msgs2 = p.warningMessages;
            Vector msgs3 = p.optimizeMessages;
            if (p.getHidden() && (msgs == null || msgs.size() == 0)) continue;
            if (instr != null && instr.generatedCode()) {
                adr = instr.getAddress();
                len = instr.getLength();
                listingOut.print(this.formatCode(image, adr, len));
                adr += 6;
                len -= 6;
            } else {
                len = 0;
                adr = 0;
                if (instr != null) {
                    adr = instr.getAddress();
                    len = instr.getLength();
                }
                listingOut.print(this.formatCode(null, adr, len));
            }
            String fname = p.getFilename();
            if (fname != null && !fname.equals("")) {
                listingOut.print("|");
            } else {
                listingOut.print(">");
            }
            listingOut.println(p.inputLine);
            if (instr != null && instr.generatedCode()) {
                while (len > 0) {
                    listingOut.print(this.formatCode(image, adr, len));
                    listingOut.println(">");
                    adr += 6;
                    len -= 6;
                }
            }
            if (msgs != null) {
                for (mx = 0; mx < msgs.size(); ++mx) {
                    m = (String)msgs.elementAt(mx);
                    listingOut.println("****** " + m);
                    ++errs;
                }
            }
            if (msgs2 != null) {
                for (mx = 0; mx < msgs2.size(); ++mx) {
                    m = (String)msgs2.elementAt(mx);
                    listingOut.println("++++++ " + m);
                }
            }
            if (msgs3 == null) continue;
            for (mx = 0; mx < msgs3.size(); ++mx) {
                m = (String)msgs3.elementAt(mx);
                listingOut.println("###### " + m);
            }
        }
        listingOut.println("\n" + errs + " errors detected.");
        listingOut.flush();
    }

    private String formatCode(Memory mem, int adr, int len) {
        StringBuffer output = new StringBuffer(26);
        if (mem != null) {
            output.append("  ").append(this.formatHex(adr, 4)).append("  ");
            if (len > 6) {
                len = 6;
            }
            for (int j = 0; j < len; ++j) {
                int b = mem.read(adr++);
                output.append(this.formatHex(b, 2)).append(" ");
            }
        }
        if (mem == null && adr != 0) {
            output.append("  ").append(this.formatHex(adr, 4)).append("  ");
        }
        int paddingNeeded = 26 - output.length();
        output.append(CODE_PADDING.substring(0, paddingNeeded));
        return output.toString();
    }

    private String formatHex(int num, int len) {
        String f = "00000000" + Integer.toHexString(num);
        return f.substring(f.length() - len);
    }

    public int getNumErrors() {
        return this.errorNum;
    }

    private void setErrorCount(LineContext ctx) {
        int errs = 0;
        for (SourceLine p = ctx.first; p != null; p = p.getNext()) {
            Vector msgs = p.errorMessages;
            if (msgs == null || msgs.size() <= 0) continue;
            for (int j = 0; j < msgs.size(); ++j) {
                ++errs;
            }
        }
        this.errorNum = errs;
    }

    private void emitErrors(LineContext ctx, PrintStream errorsOut) {
        int errs = 0;
        for (SourceLine p = ctx.first; p != null; p = p.getNext()) {
            String m;
            int j;
            Vector msgs = p.errorMessages;
            if (msgs != null && msgs.size() > 0) {
                for (j = 0; j < msgs.size(); ++j) {
                    m = (String)msgs.elementAt(j);
                    errorsOut.println("******" + m.substring((p.fileName + "(" + p.lineNumber + "): ").length()));
                    ++errs;
                }
                errorsOut.println("       " + p.fileName + "(" + p.lineNumber + "): " + p.inputLine + (p.instr != null ? " (" + String.format("$%04X", p.instr.getAddress() & 0xFFFF) + ")" : ""));
            }
            if ((msgs = p.warningMessages) != null && msgs.size() > 0) {
                for (j = 0; j < msgs.size(); ++j) {
                    m = (String)msgs.elementAt(j);
                    errorsOut.println("++++++" + m.substring((p.fileName + "(" + p.lineNumber + "): ").length()));
                }
                errorsOut.println("       " + p.fileName + "(" + p.lineNumber + "): " + p.inputLine);
            }
            if ((msgs = p.optimizeMessages) == null || msgs.size() <= 0) continue;
            for (j = 0; j < msgs.size(); ++j) {
                m = (String)msgs.elementAt(j);
                errorsOut.println("######" + m.substring((p.fileName + "(" + p.lineNumber + "): ").length()));
            }
            errorsOut.println("       " + p.fileName + "(" + p.lineNumber + "): " + p.inputLine);
        }
        if (errs != 0) {
            errorsOut.println("" + errs + " errors detected.");
        }
    }

    public static void error(SourceLine line, String errmsg) {
        line.addErrorMessage(line.fileName + "(" + line.lineNumber + "):  " + errmsg);
    }

    public static void warning(SourceLine line, String errmsg) {
        if (line != null) {
            line.addWarningMessage(line.fileName + "(" + line.lineNumber + "):  " + errmsg);
        } else {
            line.addWarningMessage("Unkown source:  " + errmsg);
        }
    }

    public static void optimize(SourceLine line, String errmsg) {
        line.addOptimizeMessage(line.fileName + "(" + line.lineNumber + "):  " + errmsg);
    }

    private static String pad(String s, int len) {
        while (s.length() < len) {
            s = s + "          ";
        }
        return s.substring(0, len);
    }

    private void die(Exception x) {
        this.die(x.toString());
    }

    private void die(String s) {
        throw new AsmjDeath(s);
    }

    private void usage() {
        this.usage("");
    }

    private void usage(Exception x) {
        this.usage(x.toString());
    }

    private void usage(String s) {
        if (s != null && s.length() > 0) {
            System.out.println(s);
        }
        System.out.println("Usage: java Asmj <options> [+f=]<filename>\nI/O options:\n  Must be preceded with '+' or '-', which turn them on or off, respectively.\n  If enabled, can be directed to a file;\n  otherwise default to standard I/O.\n    +b[=<filename>]   (binary, default=on)\n    +e[=<filename>]   (error, default=off)\n    +f=<filename>     (input, filename required)\n    +l[=<filename>]   (listing, default=on)\n    +s[=<filename>]   (s-records, default=off)\n    +t[=<filename>]   (symbol table, default=on)\nOther options:\n  Preceding '+' or '-' mean the same thing.\n    +D=symbol[=value]  (symbol definition)\n");
    }

    public void setCMap(HashMap<Character, Character> cm) {
        this.cmapping = cm;
    }

    public HashMap<Character, Character> getCMap() {
        return this.cmapping;
    }

    public static void clearLineInfo() {
        lineInfos = new HashMap();
    }

    public static void addLineInfo(int address, int lengthInByte, int type) {
        LineInfo li = new LineInfo(address, lengthInByte, type);
        lineInfos.put(address, li);
    }

    int getConsecutiveType(MemorySegment mem, int address, int type, SymbolTable symtab) {
        int newType;
        int addressOrg = address;
        int len = 0;
        if (type == 2) {
            type = 1;
        }
        do {
            ++len;
            newType = mem.getType(++address);
            if (type != 1 || newType != 2) continue;
            newType = 1;
        } while (type == newType);
        if (!correctDataOption || type == 1) {
            return len;
        }
        LineInfo li = lineInfos.get(addressOrg);
        if (li == null) {
            for (int i = 1; i < len; ++i) {
                li = lineInfos.get(addressOrg + i);
                if (li != null) {
                    return i;
                }
                if (!Asmj.hasLabelDefinition(addressOrg + i, symtab)) continue;
                return i;
            }
            if (len > maxData) {
                return maxData;
            }
            return len;
        }
        return li.lenInBytes;
    }

    static boolean hasLabelDefinition(int address, SymbolTable symtab) {
        return symtab.find(address) != null;
    }

    static {
        version = "";
        bank = 0;
        multibank = false;
        inBSS = false;
        currentBaseDir = "";
        is48k = false;
        ALLOW_DIF_TRANSFER = true;
        allReplacements = new ArrayList();
        replacementPrefix = Global.mainPathPrefix;
        doReplacements = false;
        localOpt = true;
        StringBuffer buf = new StringBuffer(26);
        for (int i = 0; i < 26; ++i) {
            buf.append(" ");
        }
        CODE_PADDING = buf.toString();
        LI_UNKOWN = 0;
        LI_BYTE = 1;
        LI_WORD = 3;
        LI_STRING = 4;
        correctDataOption = true;
        maxData = 8;
    }

    static class LineInfo {
        int startAddress = 0;
        int lenInBytes = 0;
        int type = LI_UNKOWN;

        LineInfo(int a, int l, int t) {
            this.startAddress = a;
            this.lenInBytes = l;
            this.type = t;
        }
    }

    static class ReplacementFileList {
        String binFileName = "";
        String replacementFileName = "";
        ArrayList<Replacements> replacementList = new ArrayList();

        ReplacementFileList() {
        }
    }

    static class Replacements {
        int address = 0;
        int len = 0;
        String replacementVarName = "";
        String replacementVarListName = "";

        Replacements() {
        }
    }
}

