/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.vide.assy.LineRecognizer;
import de.malban.vide.assy.ParseString;

public class Comment
implements LineRecognizer {
    @Override
    public boolean recognizes(ParseString s) {
        int p0 = s.getPosition();
        s.skipSpaces();
        if (s.length() > 0 && s.charAt(0) != '*' && s.charAt(0) != ';') {
            s.setPosition(p0);
            return false;
        }
        return true;
    }

    public static String removeEndOfLineComment(ParseString s) {
        int posSemicolon = s.buffer.substring(0).indexOf(";");
        if (posSemicolon < 0) {
            posSemicolon = Integer.MAX_VALUE;
        }
        if (posSemicolon == Integer.MAX_VALUE) {
            return "";
        }
        int posDouble = s.buffer.substring(0).indexOf("\"");
        int posSingle = s.buffer.substring(0).indexOf("'");
        if (posSingle < 0) {
            posSingle = Integer.MAX_VALUE;
        }
        if (posDouble < 0) {
            posDouble = Integer.MAX_VALUE;
        }
        if (posSemicolon < posDouble && posSemicolon < posSingle) {
            String ret = s.removeFrom(posSemicolon);
            ret = ret.trim();
            ret = ret.substring(1);
            ret = ret.trim();
            return ret;
        }
        String wc = s.buffer.substring(0);
        boolean enough = false;
        do {
            if ((wc = Comment.removeOneQuote(wc)) == null) {
                return "";
            }
            posDouble = wc.indexOf("\"");
            posSingle = wc.indexOf("'");
            posSemicolon = wc.indexOf(";");
            if (posSemicolon < 0) {
                posSemicolon = Integer.MAX_VALUE;
            }
            if (posSemicolon == Integer.MAX_VALUE) {
                return "";
            }
            if (posSingle < 0) {
                posSingle = Integer.MAX_VALUE;
            }
            if (posDouble >= 0) continue;
            posDouble = Integer.MAX_VALUE;
        } while (!(enough = posSemicolon < posDouble && posSemicolon < posSingle));
        String semiString = wc.substring(wc.indexOf(";"));
        String ret = s.removeFrom(s.buffer.indexOf(semiString));
        ret = ret.trim();
        ret = ret.substring(1);
        ret = ret.trim();
        return ret;
    }

    public String removeFrom(String s, int pos) {
        if (pos >= s.length()) {
            return "";
        }
        if (pos < 0) {
            return "";
        }
        String ret = s.substring(pos);
        s = s.substring(0, pos);
        return ret;
    }

    public static String removeEndOfLineComment(String s) {
        int posSemicolon = s.substring(0).indexOf(";");
        if (posSemicolon < 0) {
            posSemicolon = Integer.MAX_VALUE;
        }
        if (posSemicolon == Integer.MAX_VALUE) {
            return s;
        }
        int posDouble = s.substring(0).indexOf("\"");
        int posSingle = s.substring(0).indexOf("'");
        if (posSingle < 0) {
            posSingle = Integer.MAX_VALUE;
        }
        if (posDouble < 0) {
            posDouble = Integer.MAX_VALUE;
        }
        if (posSemicolon < posDouble && posSemicolon < posSingle) {
            if (posSemicolon == Integer.MAX_VALUE) {
                return s;
            }
            return s.substring(0, s.indexOf(";"));
        }
        String wc = s.substring(0);
        boolean enough = false;
        do {
            if ((wc = Comment.removeOneQuote(wc)) == null) {
                return "";
            }
            posDouble = wc.indexOf("\"");
            posSingle = wc.indexOf("'");
            posSemicolon = wc.indexOf(";");
            if (posSemicolon < 0) {
                posSemicolon = Integer.MAX_VALUE;
            }
            if (posSemicolon == Integer.MAX_VALUE) {
                return s;
            }
            if (posSingle < 0) {
                posSingle = Integer.MAX_VALUE;
            }
            if (posDouble >= 0) continue;
            posDouble = Integer.MAX_VALUE;
        } while (!(enough = posSemicolon < posDouble && posSemicolon < posSingle));
        String semiString = wc.substring(wc.indexOf(";"));
        return s.substring(0, s.indexOf(semiString));
    }

    public static String removeCEndOfLineComment(String s) {
        int posSemicolon = s.substring(0).indexOf("//");
        if (posSemicolon < 0) {
            posSemicolon = Integer.MAX_VALUE;
        }
        if (posSemicolon == Integer.MAX_VALUE) {
            return s;
        }
        int posDouble = s.substring(0).indexOf("\"");
        int posSingle = s.substring(0).indexOf("'");
        if (posSingle < 0) {
            posSingle = Integer.MAX_VALUE;
        }
        if (posDouble < 0) {
            posDouble = Integer.MAX_VALUE;
        }
        if (posSemicolon < posDouble && posSemicolon < posSingle) {
            if (posSemicolon == Integer.MAX_VALUE) {
                return s;
            }
            return s.substring(0, s.indexOf("//"));
        }
        String wc = s.substring(0);
        boolean enough = false;
        do {
            if ((wc = Comment.removeOneQuote(wc)) == null) {
                return "";
            }
            posDouble = wc.indexOf("\"");
            posSingle = wc.indexOf("'");
            posSemicolon = wc.indexOf("//");
            if (posSemicolon < 0) {
                posSemicolon = Integer.MAX_VALUE;
            }
            if (posSemicolon == Integer.MAX_VALUE) {
                return s;
            }
            if (posSingle < 0) {
                posSingle = Integer.MAX_VALUE;
            }
            if (posDouble >= 0) continue;
            posDouble = Integer.MAX_VALUE;
        } while (!(enough = posSemicolon < posDouble && posSemicolon < posSingle));
        String semiString = wc.substring(wc.indexOf("//"));
        return s.substring(0, s.indexOf(semiString));
    }

    public static String removeC1EndOfLineComment(String s) {
        int posSemicolon = s.substring(0).indexOf("/*");
        if (posSemicolon < 0) {
            posSemicolon = Integer.MAX_VALUE;
        }
        if (posSemicolon == Integer.MAX_VALUE) {
            return s;
        }
        int posDouble = s.substring(0).indexOf("\"");
        int posSingle = s.substring(0).indexOf("'");
        if (posSingle < 0) {
            posSingle = Integer.MAX_VALUE;
        }
        if (posDouble < 0) {
            posDouble = Integer.MAX_VALUE;
        }
        if (posSemicolon < posDouble && posSemicolon < posSingle) {
            if (posSemicolon == Integer.MAX_VALUE) {
                return s;
            }
            return s.substring(0, s.indexOf("/*"));
        }
        String wc = s.substring(0);
        boolean enough = false;
        do {
            if ((wc = Comment.removeOneQuote(wc)) == null) {
                return "";
            }
            posDouble = wc.indexOf("\"");
            posSingle = wc.indexOf("'");
            posSemicolon = wc.indexOf("/*");
            if (posSemicolon < 0) {
                posSemicolon = Integer.MAX_VALUE;
            }
            if (posSemicolon == Integer.MAX_VALUE) {
                return s;
            }
            if (posSingle < 0) {
                posSingle = Integer.MAX_VALUE;
            }
            if (posDouble >= 0) continue;
            posDouble = Integer.MAX_VALUE;
        } while (!(enough = posSemicolon < posDouble && posSemicolon < posSingle));
        String semiString = wc.substring(wc.indexOf("/*"));
        return s.substring(0, s.indexOf(semiString));
    }

    static String removeOneQuote(String wc) {
        int posDouble = wc.indexOf("\"");
        int posSingle = wc.indexOf("'");
        if (posSingle < 0) {
            posSingle = Integer.MAX_VALUE;
        }
        if (posDouble < 0) {
            posDouble = Integer.MAX_VALUE;
        }
        char quoteChar = '\u0000';
        quoteChar = posDouble < posSingle ? (char)'\"' : '\'';
        wc = wc.substring(wc.indexOf("" + quoteChar) + 1, wc.length());
        int i = 0;
        boolean found = false;
        boolean escapeFound = false;
        while (i < wc.length()) {
            char c = wc.charAt(i);
            if (c == '\\') {
                escapeFound = !escapeFound;
                ++i;
                continue;
            }
            if (c == quoteChar && !escapeFound) {
                found = true;
                break;
            }
            ++i;
            escapeFound = false;
        }
        if (!found) {
            return null;
        }
        return wc.substring(i + 1);
    }
}

