/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.AsmjDeath;
import de.malban.vide.assy.Conditional;
import de.malban.vide.assy.Macro;
import de.malban.vide.assy.SourceLine;
import de.malban.vide.assy.Struct;
import java.util.Vector;

public class LineContext {
    SourceLine first;
    SourceLine last;
    SourceLine current;
    Macro macroDef;
    public static int directRegister = -1;
    Struct currentStruct;
    Vector conditionalStack;
    Conditional top;
    boolean condition;

    public void setStruct(Struct s) {
        this.currentStruct = s;
    }

    public LineContext(SourceLine pline) {
        this.last = this.current = pline;
        this.first = this.current;
        this.macroDef = null;
        Object currentStruct = null;
        this.conditionalStack = new Vector();
        this.top = new Conditional();
        this.conditionalStack.addElement(this.top);
        this.condition = this.top.getState();
    }

    public void addLine(SourceLine pline) {
        pline.setNext(this.current.getNext());
        this.current.setNext(pline);
        if (this.last == this.current) {
            this.last = pline;
        }
        this.current = pline;
    }

    public void refreshState() {
        this.condition = this.top.getState();
    }

    public Conditional getTopConditional() {
        return this.top;
    }

    public Conditional popContext() {
        int nc = this.conditionalStack.size();
        if (nc <= 1) {
            throw new AsmjDeath("Asmj bug: empty stack");
        }
        this.conditionalStack.removeElementAt(nc - 1);
        this.top = (Conditional)this.conditionalStack.elementAt(nc - 2);
        this.condition = this.top.getState();
        return this.top;
    }

    private Conditional pushContext(Conditional c) {
        this.top = c;
        this.condition = this.top.getState();
        this.conditionalStack.addElement(this.top);
        return this.top;
    }

    public boolean processInstructions() {
        return this.condition;
    }

    public Conditional beginMacro() {
        return this.pushContext(new Conditional(this.current.getMacroDepth(), this.condition));
    }

    public boolean assertMacro() {
        if (!this.top.isMacro()) {
            Asmj.error(this.current, "No preceding 'macro'");
            return false;
        }
        return true;
    }

    public Conditional beginIf(boolean test) {
        return this.pushContext(new Conditional(this.current.getMacroDepth(), this.condition, test));
    }

    public boolean assertIf() {
        if (!this.top.isIf()) {
            Asmj.error(this.current, "No preceding 'if'");
            return false;
        }
        return true;
    }

    public boolean assertPastElse(boolean past) {
        if (this.top.pastElse() != past) {
            String verb = past ? "precede" : "follow";
            Asmj.error(this.current, "Cannot " + verb + " 'else'");
            return false;
        }
        return true;
    }

    public void hideInMacro(SourceLine s) {
        if (s.getMacroDepth() > 0) {
            s.setHidden(true);
        }
    }

    public boolean assertEndOfContext() {
        if (this.conditionalStack.size() == 1) {
            return true;
        }
        if (this.top.isIf()) {
            Asmj.error(this.last, "unterminated conditional");
            return false;
        }
        if (this.top.isMacro()) {
            Asmj.error(this.last, "unterminated macro");
            return false;
        }
        throw new AsmjDeath("Asmj bug: unrecognized Conditional");
    }

    public int getDepth() {
        return this.conditionalStack.size();
    }
}

