/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.vide.assy.MemorySegment;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class Memory {
    Vector segments = new Vector();
    MemorySegment current = null;
    public static final int MEM_UNKOWN = 0;
    public static final int MEM_CODE = 1;
    public static final int MEM_CODE_POSTBYTE = 2;
    public static final int MEM_CHAR_DATA = 4;
    public static final int MEM_BYTE_DATA = 8;
    public static final int MEM_WORD_DATA = 16;

    public void write(int address, int value, int type) {
        if (this.current == null) {
            this.current = new MemorySegment("default", address);
            this.segments.addElement(this.current);
        }
        this.current.write(address, value, type);
    }

    public void write(int addr, int value, int len, boolean bigendian, int type) {
        for (int i = 0; i < len; ++i) {
            int shift;
            int n = shift = bigendian ? len - 1 - i : i;
            if (type == 1) {
                if (i == 0) {
                    this.write(addr + i, value >>> shift * 8 & 0xFF, type);
                    continue;
                }
                this.write(addr + i, value >>> shift * 8 & 0xFF, 2);
                continue;
            }
            this.write(addr + i, value >>> shift * 8 & 0xFF, type);
        }
    }

    public int read(int address) {
        if (this.current == null) {
            return 0;
        }
        return this.current.read(address);
    }

    public int getType(int address) {
        if (this.current == null) {
            return 0;
        }
        return this.current.getType(address);
    }

    public void write(OutputStream out) {
        if (this.current == null) {
            return;
        }
        this.current.write(out);
    }

    public void writeSRecords(OutputStream out, int xferAddr) throws IOException {
        this.writeSRecords(out);
        if (this.segments.size() == 0) {
            return;
        }
        MemorySegment s = (MemorySegment)this.segments.elementAt(0);
        if (s != null && xferAddr >= 0) {
            s.writeS9Record(out, xferAddr);
        }
    }

    public void writeSRecords(OutputStream out) throws IOException {
        MemorySegment s = null;
        int count = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            s = (MemorySegment)this.segments.elementAt(i);
            count += s.writeSRecords(out);
        }
        if (s != null) {
            s.writeS5Record(out, count);
        }
    }
}

