/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import java.io.IOException;
import java.io.OutputStream;

public class MemorySegment {
    int base;
    int length;
    int allocated;
    int cksum;
    byte[] contents;
    int[] contentType;
    String name;

    public MemorySegment(String name, int base) {
        this.name = name;
        this.base = base;
        this.length = 0;
        this.allocated = 128;
        this.contents = new byte[this.allocated];
        this.fillNop(this.contents);
        this.contentType = new int[this.allocated];
    }

    public int size() {
        return this.length;
    }

    void fillNop(byte[] c) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = 18;
        }
    }

    public void write(int address, int value, int type) {
        int a;
        int[] new_contentType;
        byte[] new_contents;
        int new_allocated;
        int offset = address - this.base;
        if (offset < 0) {
            int new_base = address;
            int new_length = this.length - offset;
            new_allocated = this.allocated - offset;
            new_contents = new byte[new_allocated];
            this.fillNop(new_contents);
            new_contentType = new int[new_allocated];
            for (a = 0; a < this.length; ++a) {
                new_contents[a - offset] = this.contents[a];
                new_contentType[a - offset] = this.contentType[a];
            }
            this.base = new_base;
            this.length = new_length;
            this.allocated = new_allocated;
            this.contents = new_contents;
            this.contentType = new_contentType;
            offset = 0;
        }
        if (offset >= this.allocated) {
            new_allocated = this.allocated + offset + 128;
            new_contents = new byte[new_allocated];
            this.fillNop(new_contents);
            new_contentType = new int[new_allocated];
            for (a = 0; a < this.length; ++a) {
                new_contents[a] = this.contents[a];
                new_contentType[a] = this.contentType[a];
            }
            this.allocated = new_allocated;
            this.contents = new_contents;
            this.contentType = new_contentType;
        }
        if (offset >= this.length) {
            this.length = offset + 1;
        }
        this.contents[offset] = (byte)(value & 0xFF);
        this.contentType[offset] = type;
    }

    public int getType(int address) {
        int offset = address - this.base;
        if (offset < 0 || offset >= this.length) {
            return 0;
        }
        return this.contentType[offset];
    }

    public int read(int address) {
        int offset = address - this.base;
        if (offset < 0 || offset >= this.length) {
            return -1;
        }
        return this.contents[offset];
    }

    public void write(OutputStream out) {
        try {
            out.write(this.contents, 0, this.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized int writeSRecords(OutputStream out) throws IOException {
        int firstAddr = this.base;
        int lastAddr = this.base + this.length - 1;
        int reccount = 0;
        for (int addr = firstAddr; addr <= lastAddr; addr += 32) {
            int reclen = lastAddr + 1 - addr;
            if (reclen > 32) {
                reclen = 32;
            }
            this.cksum = 0;
            this.write(out, "S1");
            this.write(out, this.sRecordByte(reclen + 3));
            this.write(out, this.sRecordByte(addr >>> 8));
            this.write(out, this.sRecordByte(addr));
            for (int i = 0; i < reclen; ++i) {
                byte b = this.contents[addr - this.base + i];
                this.write(out, this.sRecordByte(b));
            }
            this.write(out, this.sRecordByte(255 - this.cksum));
            this.write(out, "\n");
            ++reccount;
        }
        return reccount;
    }

    public synchronized void writeS5Record(OutputStream out, int count) throws IOException {
        this.writeS59Record(out, 5, count);
    }

    public synchronized void writeS9Record(OutputStream out, int addr) throws IOException {
        this.writeS59Record(out, 9, addr);
    }

    private synchronized void writeS59Record(OutputStream out, int type, int num) throws IOException {
        this.cksum = 0;
        this.write(out, "S" + type);
        this.write(out, this.sRecordByte(3));
        this.write(out, this.sRecordByte(num >>> 8));
        this.write(out, this.sRecordByte(num));
        this.write(out, this.sRecordByte(255 - this.cksum));
        this.write(out, "\n");
    }

    private void write(OutputStream out, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            out.write(s.charAt(i));
        }
    }

    private String sRecordByte(int b) {
        this.cksum = this.cksum + (b &= 0xFF) & 0xFF;
        return MemorySegment.hexByte(b);
    }

    private static String hexByte(int n) {
        String s = "00" + Integer.toHexString(n).toUpperCase();
        return s.substring(s.length() - 2);
    }
}

