/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.util.UtilityString;
import java.util.Vector;

public class ParseString {
    String buffer;
    int cursor;
    int length;
    private static final String digits = "0123456789";
    private static final String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String symChar1s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_*";
    private static final String symChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789";

    public void changeHexTypeH() {
        String s1 = this.buffer.substring(0, this.cursor);
        String s2 = this.buffer.substring(this.cursor, this.buffer.indexOf("H"));
        String s3 = this.buffer.substring(this.buffer.indexOf("H") + 1, this.buffer.length());
        this.buffer = s1 + "$" + s2 + s3;
        this.length = this.buffer.length();
    }

    public void insert(int startInsert, String what) {
        String s1 = this.buffer.substring(0, this.cursor + startInsert);
        String s2 = this.buffer.substring(this.cursor + startInsert);
        this.buffer = s1 + what + s2;
        this.length = this.buffer.length();
    }

    public ParseString(char c) {
        char[] buf = new char[]{c};
        this.buffer = new String(buf);
        this.length = 1;
        this.cursor = 0;
    }

    public ParseString(String s) {
        this.buffer = s;
        this.length = s.length();
        this.cursor = 0;
    }

    public String removeFrom(int pos) {
        if (pos >= this.length) {
            return "";
        }
        if (pos < 0) {
            return "";
        }
        String ret = this.buffer.substring(pos);
        this.buffer = this.buffer.substring(0, pos);
        this.length = this.buffer.length();
        if (this.cursor >= this.length) {
            this.cursor = this.length;
        }
        return ret;
    }

    public int getPosition() {
        return this.cursor;
    }

    public void setPosition(int p) {
        this.cursor = p;
    }

    public boolean more() {
        return this.cursor < this.length;
    }

    public ParseString reset() {
        this.cursor = 0;
        return this;
    }

    public boolean skip(int n) {
        if (this.length() < n) {
            return false;
        }
        this.cursor += n;
        return true;
    }

    public boolean skip(String s) {
        if (!this.startsWith(s)) {
            return false;
        }
        this.cursor += s.length();
        return true;
    }

    public boolean skipCase(String s) {
        if (!this.startsWithCase(s)) {
            return false;
        }
        this.cursor += s.length();
        return true;
    }

    public boolean startsWith(String s) {
        return this.buffer.substring(this.cursor).startsWith(s);
    }

    public boolean startsWithCase(String s) {
        return this.buffer.substring(this.cursor).toLowerCase().startsWith(s.toLowerCase());
    }

    public boolean endsWith(String s) {
        return this.buffer.substring(this.cursor).endsWith(s);
    }

    public boolean trimEndsWith(String s) {
        return this.buffer.trim().substring(this.cursor).endsWith(s);
    }

    public boolean trimLocalEndsWith(String s) {
        String l = this.buffer.substring(this.cursor).trim();
        int li = l.indexOf(",");
        if (li >= 0) {
            l = l.substring(0, li);
        }
        if ((li = l.indexOf(")")) >= 0) {
            l = l.substring(0, li);
        }
        if ((li = l.indexOf("]")) >= 0) {
            l = l.substring(0, li);
        }
        if ((li = l.indexOf("+")) >= 0) {
            l = l.substring(0, li);
        }
        if ((li = l.indexOf("-")) >= 0) {
            l = l.substring(0, li);
        }
        if ((li = l.indexOf("*")) >= 0) {
            l = l.substring(0, li);
        }
        if ((li = l.indexOf("/")) >= 0) {
            l = l.substring(0, li);
        }
        return l.trim().endsWith(s);
    }

    public boolean startsWithNumber() {
        String l = this.buffer.substring(this.cursor).trim();
        int len = l.length();
        if (len <= 0) {
            return false;
        }
        int p = 0;
        String sub = l.substring(p, p + 1);
        if (!UtilityString.isHexNumber(sub)) {
            return false;
        }
        if (++p == len) {
            return true;
        }
        sub = l.substring(p, p + 1);
        if (!UtilityString.isHexNumber(sub)) {
            return false;
        }
        if (++p == len) {
            return true;
        }
        sub = l.substring(p, p + 1);
        if (!UtilityString.isHexNumber(sub)) {
            return false;
        }
        if (++p == len) {
            return true;
        }
        sub = l.substring(p, p + 1);
        if (!UtilityString.isHexNumber(sub)) {
            return false;
        }
        return false;
    }

    public String getCurrentString() {
        return this.buffer.substring(this.cursor);
    }

    public char charAt(int n) {
        if (this.cursor + n >= this.buffer.length()) {
            return '\u0000';
        }
        return this.buffer.charAt(this.cursor + n);
    }

    public int length() {
        return this.length - this.cursor;
    }

    public String substring(int n) {
        return this.buffer.substring(this.cursor + n);
    }

    public String substring(int n, int m) {
        return this.buffer.substring(this.cursor + n, this.cursor + m);
    }

    public String toLowerCase() {
        return this.buffer.substring(this.cursor).toLowerCase();
    }

    public String trim() {
        return this.buffer.substring(this.cursor).trim();
    }

    public String toString() {
        return this.substring(0);
    }

    public boolean endOfExpression() {
        return this.length() <= 0 || Character.isWhitespace(this.charAt(0));
    }

    public void skipSpaces() {
        while (this.length() > 0 && Character.isWhitespace(this.charAt(0))) {
            this.skip(1);
        }
    }

    public String nextWord() {
        int p0 = this.cursor;
        while (this.length() > 0 && !Character.isWhitespace(this.charAt(0))) {
            this.skip(1);
        }
        return this.buffer.substring(p0, this.cursor);
    }

    public String nextSymbol() {
        int len = 0;
        if (this.length() == 0 || symChar1s.indexOf(this.charAt(len)) < 0) {
            return null;
        }
        ++len;
        while (this.length() > len && symChars.indexOf(this.charAt(len)) >= 0) {
            ++len;
        }
        if (this.charAt(0) == '*' && len > 1) {
            return null;
        }
        return this.substring(0, len);
    }

    public Vector parseArgs() {
        return ParseString.parseArgs(this.substring(0));
    }

    public static Vector parseArgs(String s) {
        String[] ar;
        Vector<String> args = new Vector<String>();
        for (String a : ar = s.split(",")) {
            if ((a = a.trim()).length() == 0) continue;
            args.addElement(a);
        }
        return args;
    }
}

