/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.Register;

public class RegisterSet {
    private static int numberOfEncodings = 4;
    public static final int INDEX_ENCODING = 0;
    public static final int OFFSET_ENCODING = 1;
    public static final int STACK_ENCODING = 2;
    public static final int XFER_ENCODING = 3;
    public static Register a = new Register("a", 1, "A");
    public static Register b = new Register("b", 1, "B");
    public static Register d = new Register("d", 2, "D");
    public static Register x = new Register("x", 2, "X");
    public static Register y = new Register("y", 2, "Y");
    public static Register u = new Register("u", 2, "U");
    public static Register s = new Register("s", 2, "S");
    public static Register pc = new Register("pc", 2, "P");
    public static Register cc = new Register("cc", 1, "C");
    public static Register dp = new Register("dp", 1, "G");
    private static Register[] allRegisters = new Register[]{a, b, d, x, y, u, s, pc, cc, dp};

    public static Register parseReg(ParseString s, String bad, int encoding) {
        Register ri;
        s.skipSpaces();
        String sym = s.nextSymbol();
        if (sym == null) {
            return null;
        }
        if (sym.toLowerCase().equals("sp") && bad.indexOf((ri = allRegisters[6]).getRestrictionCode()) < 0 && ri.getAllowed(encoding)) {
            s.skip(sym);
            s.skipSpaces();
            return ri;
        }
        for (int i = 0; i < allRegisters.length; ++i) {
            Register ri2 = allRegisters[i];
            if (!ri2.getName().equals(sym.toLowerCase()) || bad.indexOf(ri2.getRestrictionCode()) >= 0 || !ri2.getAllowed(encoding)) continue;
            s.skip(sym);
            s.skipSpaces();
            return ri2;
        }
        return null;
    }

    private static void setNumberOfEncodings(int num) {
        numberOfEncodings = num;
        for (int i = 0; i < allRegisters.length; ++i) {
            allRegisters[i].setNumberOfEncodings(num);
        }
    }

    static {
        RegisterSet.setNumberOfEncodings(4);
        x.setCode(0, 0);
        y.setCode(0, 32);
        u.setCode(0, 64);
        s.setCode(0, 96);
        pc.setCode(0, 12);
        a.setCode(1, 6);
        b.setCode(1, 5);
        d.setCode(1, 11);
        d.setCode(3, 0);
        x.setCode(3, 1);
        y.setCode(3, 2);
        u.setCode(3, 3);
        s.setCode(3, 4);
        pc.setCode(3, 5);
        a.setCode(3, 8);
        b.setCode(3, 9);
        cc.setCode(3, 10);
        dp.setCode(3, 11);
        cc.setCode(2, 1);
        a.setCode(2, 2);
        b.setCode(2, 4);
        d.setCode(2, 6);
        dp.setCode(2, 8);
        x.setCode(2, 16);
        y.setCode(2, 32);
        u.setCode(2, 64);
        s.setCode(2, 64);
        pc.setCode(2, 128);
    }
}

