/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Comment;
import de.malban.vide.assy.Macro;
import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.instructions.Instruction;
import de.malban.vide.vedi.DebugComment;
import de.malban.vide.vedi.DebugCommentList;
import java.io.File;
import java.util.Vector;

public class SourceLine {
    public String label;
    public String op;
    public String rest;
    public String inputLine;
    String fileName;
    int lineNumber;
    Vector errorMessages;
    Vector warningMessages;
    Vector optimizeMessages;
    Instruction instr;
    Macro macro;
    boolean parsedOK;
    SourceLine next;
    int macroDepth;
    boolean hidden;
    boolean endOfLineCommentDone = false;
    String endOfLineComment = "";
    String fullLineComment = "";
    int dp_value = -1;
    private boolean optimize = false;
    static Comment commentRecognizer = Asmj.processor.commentRecognizer;

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean b) {
        this.optimize = b;
    }

    public int getDP() {
        return this.dp_value;
    }

    public void setDP(int d) {
        this.dp_value = d;
    }

    public String getEndOfLineComment() {
        return this.endOfLineComment;
    }

    public void setEndOfLineCommentProcessed(boolean b) {
        this.endOfLineCommentDone = b;
    }

    public static String convertSeperator(String filename) {
        String ret = UtilityString.replace(filename, "/", File.separator);
        ret = UtilityString.replace(ret, "\\", File.separator);
        return ret;
    }

    public SourceLine(String line, String fname, int lineNum) {
        DebugComment c;
        DebugCommentList list2;
        this.inputLine = line;
        this.fileName = fname;
        this.lineNumber = lineNum;
        if (line.toLowerCase().contains("#genvarlist#")) {
            String replaceListname;
            Asmj.doReplacements = true;
            String t = line;
            String[] splits = t.split("#");
            Asmj.rList.replacementFileName = replaceListname = splits[2].trim();
        }
        this.rest = null;
        this.op = null;
        this.label = null;
        this.errorMessages = null;
        this.instr = null;
        this.macro = null;
        this.macroDepth = 0;
        this.hidden = false;
        this.parsedOK = false;
        if (line.toLowerCase().contains("include")) {
            line = SourceLine.convertSeperator(line);
            line = UtilityString.replace(line, "clude\"", "clude \"");
            line = UtilityString.replace(line, "CLUDE\"", "CLUDE \"");
        }
        ParseString s = new ParseString(line);
        s.setPosition(0);
        if (line == null || line.trim().length() == 0) {
            return;
        }
        String tlabel = s.nextWord();
        if (tlabel.length() == 0) {
            s.setPosition(0);
        } else {
            if (line.contains(" set ")) {
                String newLine;
                this.inputLine = newLine = UtilityString.replace(line, " set ", " = ");
                line = newLine;
                s = new ParseString(line);
            }
            if (tlabel.contains("=")) {
                String newLine;
                String newStart = UtilityString.replace(tlabel, "=", " = ");
                this.inputLine = newLine = UtilityString.replace(line, tlabel, newStart);
                line = newLine;
                s = new ParseString(line);
            }
            s.setPosition(0);
        }
        String key = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(fname)).toLowerCase();
        if (commentRecognizer != null && commentRecognizer.recognizes(s)) {
            DebugComment c2;
            this.fullLineComment = line.trim().substring(1).trim();
            if (Asmj.allDebugComments != null && (list2 = Asmj.allDebugComments.get(key)) != null && (c2 = list2.getBreakpoint(lineNum - 1)) != null) {
                this.fullLineComment = this.fullLineComment + c2.getGeneratedComment();
            }
            return;
        }
        if (commentRecognizer != null) {
            this.endOfLineComment = Comment.removeEndOfLineComment(s);
        }
        if (Asmj.allDebugComments != null && (list2 = Asmj.allDebugComments.get(key)) != null && (c = list2.getBreakpoint(lineNum - 1)) != null) {
            this.endOfLineComment = this.endOfLineComment + c.getGeneratedComment();
        }
        s.setPosition(0);
        this.label = s.nextWord();
        if (this.label.length() == 0) {
            this.label = null;
        }
        if (this.label != null && this.label.endsWith(":")) {
            this.label = this.label.substring(0, this.label.length() - 1);
        }
        s.skipSpaces();
        if (s.length() == 0 && this.label != null) {
            this.op = "equ";
            this.rest = "*";
        } else {
            this.op = s.nextWord();
            this.rest = s.trim();
        }
        this.parsedOK = true;
        this.next = null;
    }

    public void eraseComments() {
        this.endOfLineComment = "";
        this.fullLineComment = "";
    }

    public SourceLine(SourceLine p0) {
        this.fileName = p0.fileName;
        this.lineNumber = p0.lineNumber;
        this.label = p0.label;
        this.op = p0.op;
        this.rest = p0.rest;
        this.inputLine = p0.inputLine;
        this.endOfLineComment = p0.endOfLineComment;
        this.fullLineComment = p0.fullLineComment;
        this.errorMessages = new Vector();
        this.macro = p0.macro;
        this.parsedOK = p0.parsedOK;
        this.instr = null;
        if (this.parsedOK && p0.instr != null) {
            this.instr = Instruction.create(p0.instr.getControl(), p0.instr.getSource());
        }
        this.next = null;
        this.macroDepth = 0;
        this.hidden = false;
    }

    public void setInstruction(Instruction i) {
        this.instr = i;
    }

    public Instruction getInstruction() {
        return this.instr;
    }

    public boolean parsed() {
        return this.parsedOK;
    }

    public void setMacro(Macro m) {
        this.macro = m;
    }

    public Macro getMacro() {
        return this.macro;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public String getLabel() {
        return this.label;
    }

    public void setOp(String s) {
        this.op = s;
    }

    public String getOp() {
        return this.op;
    }

    public void setRest(String s) {
        this.rest = s;
    }

    public String getRest() {
        return this.rest;
    }

    public void setInputLine(String s) {
        this.inputLine = s;
    }

    public String getInputLine() {
        return this.inputLine;
    }

    public void setFilename(String s) {
        this.fileName = s;
    }

    public String getFilename() {
        return this.fileName;
    }

    public void setLineNumber(int i) {
        this.lineNumber = i;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setNext(SourceLine p) {
        this.next = p;
    }

    public SourceLine getNext() {
        return this.next;
    }

    public void setMacroDepth(int i) {
        this.macroDepth = i;
    }

    public int getMacroDepth() {
        return this.macroDepth;
    }

    public void setHidden(boolean h) {
        this.hidden = h;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public String toString() {
        return (this.label != null ? this.label : "") + " " + this.op + " " + this.rest;
    }

    public void addErrorMessage(String m) {
        if (this.errorMessages == null) {
            this.errorMessages = new Vector();
        }
        this.errorMessages.addElement(m);
    }

    public void addWarningMessage(String m) {
        if (this.warningMessages == null) {
            this.warningMessages = new Vector();
        }
        this.warningMessages.addElement(m);
    }

    public void addOptimizeMessage(String m) {
        if (this.optimizeMessages == null) {
            this.optimizeMessages = new Vector();
        }
        this.optimizeMessages.addElement(m);
    }

    public void eraseErrorMessages() {
        if (this.errorMessages != null) {
            this.errorMessages.removeAllElements();
        }
    }

    public void eraseWarningMessages() {
        if (this.warningMessages != null) {
            this.warningMessages.removeAllElements();
        }
    }

    public void eraseOptimizeMessages() {
        if (this.optimizeMessages != null) {
            this.optimizeMessages.removeAllElements();
        }
    }
}

