/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.vide.assy.SourceLine;
import de.malban.vide.assy.Symbol;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;

public class SymbolTable {
    public static final int NO_LINE_NUMBER = -2;
    HashMap<Integer, Symbol> symbolsByAddress = new HashMap();
    Vector symbols = new Vector();

    public Vector getSymbols() {
        return this.symbols;
    }

    public boolean define(String name, int value, int where_defined, String comment, int definedHow, SourceLine source) {
        Symbol s = this.find(name);
        if (s != null) {
            s.define(value, where_defined, source);
        } else {
            s = new Symbol(name, value, where_defined, source);
            this.symbols.addElement(s);
        }
        s.definedHow = definedHow;
        if (definedHow == 2) {
            this.symbolsByAddress.put(value, s);
            s.used = true;
            s.labelUsage = true;
        }
        if (comment != null) {
            s.line_Comment = comment;
        }
        return true;
    }

    public boolean undefine(Symbol s) {
        return this.symbols.removeElement(s);
    }

    public Symbol reference(String name) {
        Symbol s = this.find(name);
        if (s == null) {
            s = new Symbol(name);
            this.symbols.addElement(s);
        }
        return s;
    }

    public int getValue(String name) {
        Symbol s = this.find(name);
        return s != null ? s.getValue() : -1;
    }

    public void setValue(String name, int value) {
        Symbol s = this.find(name);
        if (s != null) {
            s.setValue(value);
        }
    }

    public Symbol find(String name) {
        for (int i = 0; i < this.symbols.size(); ++i) {
            Symbol s;
            try {
                s = (Symbol)this.symbols.elementAt(i);
            }
            catch (ClassCastException x) {
                continue;
            }
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public Symbol find(int value) {
        return this.symbolsByAddress.get(value);
    }

    public void dump(PrintStream out) {
        out.println("Symbol Table");
        for (int i = 0; i < this.symbols.size(); ++i) {
            String formatted_value;
            Symbol s = (Symbol)this.symbols.elementAt(i);
            String name = s.getName();
            if (name.startsWith("*")) continue;
            if (s.defined()) {
                int value = s.getValue();
                formatted_value = "0000" + Integer.toHexString(value);
                formatted_value = formatted_value.substring(formatted_value.length() - 4);
            } else {
                formatted_value = "----";
            }
            out.println("  " + formatted_value + "  " + name);
        }
    }
}

