/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.expressions;

import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.SymbolTable;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.expressions.ExpressionNumber;
import de.malban.vide.assy.expressions.ExpressionOp;
import de.malban.vide.assy.expressions.ExpressionString;
import de.malban.vide.assy.expressions.ExpressionSymbol;

public abstract class Expression {
    protected static final String decimalDigits = "0123456789";
    protected static final String octalDigits = "01234567";
    protected static final String binaryDigits = "01";
    protected static final String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static final String symbolChar1s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ*_";
    protected static final String symbolChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
    protected static final String hexDigits = "0123456789abcdefABCDEF";
    protected int value;
    protected int sourceStart;
    protected int sourceEnd;
    protected ParseString buf;

    public abstract boolean isNumber();

    protected void parseStart(ParseString s) {
        this.buf = s;
        this.sourceStart = this.buf.getPosition();
    }

    protected void parseEnd() {
        this.sourceEnd = this.buf.getPosition();
    }

    public int parseLength() {
        return this.sourceEnd - this.sourceStart;
    }

    protected void parseError(String err) throws ParseException {
        this.parseError(err, true);
    }

    protected void parseError(String err, boolean sev) throws ParseException {
        this.buf.setPosition(this.sourceStart);
        this.sourceEnd = this.sourceStart;
        throw new ParseException(err, sev);
    }

    public abstract int eval(SymbolTable var1) throws SymbolDoesNotExistException;

    public int eval(SymbolTable st, boolean treatAsZero) throws SymbolDoesNotExistException {
        return this.eval(st);
    }

    public int numItems() {
        return 1;
    }

    public int getItem(int n) {
        return this.value;
    }

    public int getValue() {
        return this.value;
    }

    public int getValue(int len) {
        int mask = (1 << 8 * len) - 1;
        return this.value & mask;
    }

    public static Expression parse(String s, SymbolTable st) throws ParseException {
        return Expression.parse(new ParseString(s + " "), st);
    }

    public static Expression parse(ParseString s, SymbolTable st) throws ParseException {
        return ExpressionOp.parse(s, st);
    }

    public static Expression parseTerm(ParseString buf, SymbolTable st) throws ParseException {
        buf.skipSpaces();
        if (buf.length() == 0 || Character.isWhitespace(buf.charAt(0))) {
            throw new ParseException("missing term");
        }
        try {
            return ExpressionSymbol.parse(buf, st);
        }
        catch (ParseException x) {
            if (!x.isSevere()) {
                throw x;
            }
            try {
                return ExpressionNumber.parse(buf, st);
            }
            catch (ParseException x2) {
                if (!x2.isSevere()) {
                    throw x2;
                }
                try {
                    return ExpressionString.parse(buf, st);
                }
                catch (ParseException x3) {
                    if (!x3.isSevere()) {
                        throw x3;
                    }
                    int sourceStart = buf.getPosition();
                    char ch0 = buf.charAt(0);
                    if (ch0 != '(') {
                        throw new ParseException("unrecognized expression: " + buf.toString());
                    }
                    buf.skip(1);
                    Expression t1 = Expression.parse(buf, st);
                    buf.skipSpaces();
                    if (!buf.startsWith(")")) {
                        buf.setPosition(sourceStart);
                        throw new ParseException("missing closing parenthesis");
                    }
                    buf.skip(1);
                    return t1;
                }
            }
        }
    }
}

