/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.expressions;

import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.SymbolTable;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.expressions.Expression;
import java.util.Vector;

public class ExpressionList
extends Expression {
    private Vector list;
    private int listItemNum = -1;
    private int itemNum0 = -1;
    private int itemNum1 = -1;

    public Expression elementAt(int i) {
        return (Expression)this.list.elementAt(i);
    }

    public int size() {
        return this.list.size();
    }

    public static Expression parse(String s, SymbolTable st) throws ParseException {
        return new ExpressionList(new ParseString(s), st);
    }

    public static Expression parse(ParseString s, SymbolTable st) throws ParseException {
        return new ExpressionList(s, st);
    }

    private ExpressionList(ParseString s, SymbolTable st) throws ParseException {
        this.parseStart(s);
        this.list = new Vector();
        while (true) {
            Expression t = Expression.parse(s, st);
            this.list.addElement(t);
            if (s.length() <= 0 || s.charAt(0) != ',') break;
            s.skip(1);
        }
        if (!s.endOfExpression()) {
            throw new ParseException("illegal trailing characters");
        }
        this.parseEnd();
    }

    public Expression listItem(int n) {
        return (Expression)this.list.elementAt(n);
    }

    @Override
    public boolean isNumber() {
        boolean ret = true;
        for (int i = 0; i < this.list.size(); ++i) {
            ret &= this.listItem(i).isNumber();
        }
        return ret;
    }

    @Override
    public int getItem(int n) {
        if (n < this.itemNum0) {
            this.itemNum1 = -1;
            this.itemNum0 = -1;
            this.listItemNum = -1;
        }
        while (this.itemNum1 < n) {
            ++this.listItemNum;
            this.itemNum0 = this.itemNum1 + 1;
            this.itemNum1 = this.itemNum0 + this.listItem(this.listItemNum).numItems() - 1;
        }
        return this.listItem(this.listItemNum).getItem(n - this.itemNum0);
    }

    @Override
    public int getValue() {
        return this.listItem(0).getItem(0);
    }

    @Override
    public int numItems() {
        int n = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            n += this.listItem(i).numItems();
        }
        return n;
    }

    @Override
    public int eval(SymbolTable st) throws SymbolDoesNotExistException {
        for (int i = 0; i < this.list.size(); ++i) {
            Expression t = (Expression)this.list.elementAt(i);
            t.eval(st);
        }
        return 0;
    }
}

