/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.expressions;

import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.AsmjDeath;
import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.SymbolTable;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.expressions.Expression;

public class ExpressionNumber
extends Expression {
    public static Expression parse(String s, SymbolTable st) throws ParseException {
        return new ExpressionNumber(new ParseString(s));
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    public static Expression parse(ParseString s, SymbolTable t) throws ParseException {
        return new ExpressionNumber(s);
    }

    public static ExpressionNumber create(int value) {
        return new ExpressionNumber(value);
    }

    protected ExpressionNumber(int n) {
        this.value = n;
    }

    protected ExpressionNumber(ParseString s) throws ParseException {
        this.parseStart(s);
        this.parseNumber(s);
        this.parseEnd();
    }

    protected int parseNumber(ParseString s) throws ParseException {
        String s2 = null;
        if (s.trimEndsWith("H") && s.startsWithNumber()) {
            s.changeHexTypeH();
        } else if (s.trimLocalEndsWith("H") && s.startsWithNumber()) {
            s.changeHexTypeH();
        }
        if (s.length() == 0) {
            this.parseError("missing numeric literal");
        }
        char ch0 = s.charAt(0);
        int p0 = s.getPosition();
        ExpressionNumber ext = Asmj.processor.numberParser;
        if (ext != null) {
            try {
                this.value = ext.parseNumber(s);
                return this.value;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (s.skipCase("0x")) {
            int p1 = s.getPosition();
            while (s.length() > 0 && ExpressionNumber.isHexDigit(s.charAt(0))) {
                s.skip(1);
            }
            int n = s.getPosition() - p1;
            if (n == 0) {
                this.parseError("missing hex digits", false);
            }
            s2 = s.substring(-n, 0);
            try {
                this.value = Integer.parseInt(s2, 16);
            }
            catch (NumberFormatException x) {
                throw new AsmjDeath("Asmj bug: format of $" + s2);
            }
            return this.value;
        }
        s.setPosition(p0);
        if (ExpressionNumber.isDecimalDigit(ch0)) {
            s.skip(1);
            while (s.length() > 0 && ExpressionNumber.isDecimalDigit(s.charAt(0))) {
                s.skip(1);
            }
            int n = s.getPosition() - p0;
            if (n == 0) {
                this.parseError("missing decimal digits");
            }
            s2 = s.substring(-n, 0);
            try {
                this.value = Integer.parseInt(s2);
            }
            catch (NumberFormatException x) {
                throw new AsmjDeath("Asmj bug: format of " + s2);
            }
            return this.value;
        }
        this.parseError("missing numeric literal");
        return 0;
    }

    @Override
    public int eval(SymbolTable t) {
        return this.value;
    }

    public static int eval(String expr) throws ParseException {
        Expression e = ExpressionNumber.parse(expr, null);
        return e.value;
    }

    protected static boolean isHexDigit(char ch) {
        return "0123456789abcdefABCDEF".indexOf(ch) >= 0;
    }

    protected static boolean isDecimalDigit(char ch) {
        return "0123456789".indexOf(ch) >= 0;
    }

    protected static boolean isOctalDigit(char ch) {
        return "01234567".indexOf(ch) >= 0;
    }

    protected static boolean isBinaryDigit(char ch) {
        return "01".indexOf(ch) >= 0;
    }
}

