/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.expressions;

import de.malban.vide.assy.AsmjDeath;
import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.expressions.ExpressionNumber;

public class ExpressionNumberMotorola
extends ExpressionNumber {
    public ExpressionNumberMotorola() {
        super(0);
    }

    @Override
    public int parseNumber(ParseString s) throws ParseException {
        String s2 = null;
        this.parseStart(s);
        if (s.skip("$")) {
            int p1 = s.getPosition();
            while (s.length() > 0 && ExpressionNumberMotorola.isHexDigit(s.charAt(0))) {
                s.skip(1);
            }
            int n = s.getPosition() - p1;
            if (n == 0) {
                this.parseError("missing hex digits", false);
            }
            s2 = s.substring(-n, 0);
            try {
                this.value = Integer.parseInt(s2, 16);
            }
            catch (NumberFormatException x) {
                throw new AsmjDeath("Asmj bug: format of $" + s2);
            }
            return this.value;
        }
        if (s.skip("@")) {
            int p1 = s.getPosition();
            while (s.length() > 0 && ExpressionNumberMotorola.isOctalDigit(s.charAt(0))) {
                s.skip(1);
            }
            int n = s.getPosition() - p1;
            if (n == 0) {
                this.parseError("missing octal digits", false);
            }
            s2 = s.substring(-n, 0);
            try {
                this.value = Integer.parseInt(s2, 8);
            }
            catch (NumberFormatException x) {
                throw new AsmjDeath("Asmj bug: format of $" + s2);
            }
            return this.value;
        }
        if (s.skip("%")) {
            int p1 = s.getPosition();
            while (s.length() > 0 && ExpressionNumberMotorola.isBinaryDigit(s.charAt(0))) {
                s.skip(1);
            }
            int n = s.getPosition() - p1;
            if (n == 0) {
                this.parseError("missing binary digits", false);
            }
            s2 = s.substring(-n, 0);
            try {
                this.value = Integer.parseInt(s2, 2);
            }
            catch (NumberFormatException x) {
                throw new AsmjDeath("Asmj bug: format of $" + s2);
            }
            return this.value;
        }
        this.parseError("missing numeric literal");
        return 0;
    }
}

