/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.expressions;

import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.SymbolTable;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.expressions.Expression;
import java.util.Vector;

public class ExpressionString
extends Expression {
    byte[] value;
    int length;

    public static Expression parse(String s, SymbolTable st, boolean isFilename) throws ParseException {
        return new ExpressionString(new ParseString(s), isFilename);
    }

    public static Expression parse(String s, SymbolTable st) throws ParseException {
        return ExpressionString.parse(s, st, false);
    }

    public static Expression parse(ParseString s, SymbolTable st) throws ParseException {
        return new ExpressionString(s);
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    private ExpressionString(ParseString s) throws ParseException {
        this(s, false);
    }

    private ExpressionString(ParseString s, boolean isFilename) throws ParseException {
        int ch0;
        this.parseStart(s);
        if (s.length() == 0) {
            this.parseError("missing string expression");
        }
        if ((ch0 = s.charAt(0)) != 39 && ch0 != 34) {
            this.parseError("missing leading quote");
        }
        int quote = ch0;
        s.skip(1);
        Vector<Integer> v = new Vector<Integer>();
        while (true) {
            if (s.length() <= 0) {
                this.parseError("missing trailing quote", false);
            }
            if ((ch0 = s.charAt(0)) == quote) break;
            if (!isFilename && ch0 == 92) {
                s.skip(1);
                ch0 = s.charAt(0);
                switch (ch0) {
                    case 48: {
                        ch0 = 0;
                        break;
                    }
                    case 97: {
                        ch0 = 7;
                        break;
                    }
                    case 98: {
                        ch0 = 8;
                        break;
                    }
                    case 116: {
                        ch0 = 9;
                        break;
                    }
                    case 110: {
                        ch0 = 10;
                        break;
                    }
                    case 118: {
                        ch0 = 11;
                        break;
                    }
                    case 102: {
                        ch0 = 12;
                        break;
                    }
                    case 114: {
                        ch0 = 13;
                    }
                }
            }
            v.addElement(new Integer(ch0));
            s.skip(1);
        }
        s.skip(1);
        this.length = v.size();
        this.value = new byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.value[i] = (byte)((Integer)v.elementAt(i)).intValue();
        }
        this.parseEnd();
    }

    @Override
    public int eval(SymbolTable t) {
        return this.getValue();
    }

    @Override
    public int numItems() {
        return this.length;
    }

    @Override
    public int getItem(int n) {
        return this.value[n];
    }

    @Override
    public int getValue() {
        return this.getValue(2);
    }

    @Override
    public int getValue(int len) {
        int val = 0;
        for (int i = 0; i < 4 && i < len && i < this.length; ++i) {
            val = val << 8 | this.value[i] & 0xFF;
        }
        return val;
    }

    public String getString() {
        return new String(this.value);
    }
}

