/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.expressions;

import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.Symbol;
import de.malban.vide.assy.SymbolTable;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.expressions.Expression;

public class ExpressionSymbol
extends Expression {
    Symbol symbol;

    public Symbol getSymbol() {
        return this.symbol;
    }

    public static Expression parse(String s, SymbolTable st) throws ParseException {
        return new ExpressionSymbol(new ParseString(s), st);
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    public static Expression parse(ParseString s, SymbolTable st) throws ParseException {
        return new ExpressionSymbol(s, st);
    }

    private ExpressionSymbol(ParseString s, SymbolTable st) throws ParseException {
        String symbolName = ExpressionSymbol.parseName(s);
        this.symbol = st.reference(symbolName);
        if (this.symbol.defined()) {
            this.value = this.symbol.getValue();
        }
    }

    @Override
    public int eval(SymbolTable st) throws SymbolDoesNotExistException {
        this.symbolIsDefined();
        this.value = this.symbol.getValue();
        return this.value;
    }

    @Override
    public int eval(SymbolTable st, boolean treatAsZero) throws SymbolDoesNotExistException {
        try {
            this.symbolIsDefined();
        }
        catch (SymbolDoesNotExistException ex) {
            if (treatAsZero) {
                this.value = 0;
                return this.value;
            }
            throw ex;
        }
        this.value = this.symbol.getValue();
        return this.value;
    }

    public static String parseName(String s) {
        try {
            return ExpressionSymbol.parseName(new ParseString(s));
        }
        catch (ParseException x) {
            return "";
        }
    }

    public static String parseName(ParseString s) throws ParseException {
        int sourceStart = s.getPosition();
        char ch0 = s.charAt(0);
        if (!ExpressionSymbol.isSymbolChar1(ch0)) {
            s.setPosition(sourceStart);
            throw new ParseException("missing symbol name", true);
        }
        s.skip(1);
        while (s.length() > 0 && ExpressionSymbol.isSymbolChar(s.charAt(0))) {
            s.skip(1);
        }
        int n = s.getPosition() - sourceStart;
        String symbolName = s.substring(-n, 0);
        if (symbolName.startsWith("*") && symbolName.length() > 1) {
            s.setPosition(sourceStart);
            throw new ParseException("illegal symbol name", false);
        }
        return symbolName;
    }

    private static boolean isSymbolChar(char ch) {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_".indexOf(ch) >= 0;
    }

    private static boolean isSymbolChar1(char ch) {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ*_".indexOf(ch) >= 0;
    }

    private void symbolIsDefined() throws SymbolDoesNotExistException {
        if (!this.symbol.defined()) {
            throw new SymbolDoesNotExistException("Symbol not defined: " + this.symbol.getName(), this.symbol.getName());
        }
    }
}

