/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.instructions;

import de.malban.vide.assy.instructions.Branch;
import de.malban.vide.assy.instructions.Inherent;
import de.malban.vide.assy.instructions.Instruction;
import de.malban.vide.assy.instructions.InstructionGroup;
import de.malban.vide.assy.instructions.RegArg;
import de.malban.vide.assy.instructions.RegReg;
import de.malban.vide.assy.instructions.SingleArg;
import de.malban.vide.assy.instructions.Stack;
import de.malban.vide.assy.instructions.align;
import de.malban.vide.assy.instructions.asmj_else;
import de.malban.vide.assy.instructions.asmj_if;
import de.malban.vide.assy.instructions.bank;
import de.malban.vide.assy.instructions.bss;
import de.malban.vide.assy.instructions.cmap;
import de.malban.vide.assy.instructions.code;
import de.malban.vide.assy.instructions.data;
import de.malban.vide.assy.instructions.direct;
import de.malban.vide.assy.instructions.elseif;
import de.malban.vide.assy.instructions.end;
import de.malban.vide.assy.instructions.endif;
import de.malban.vide.assy.instructions.endm;
import de.malban.vide.assy.instructions.equ;
import de.malban.vide.assy.instructions.error;
import de.malban.vide.assy.instructions.exitm;
import de.malban.vide.assy.instructions.fcb;
import de.malban.vide.assy.instructions.fcc;
import de.malban.vide.assy.instructions.fdb;
import de.malban.vide.assy.instructions.ifdef;
import de.malban.vide.assy.instructions.ifeq;
import de.malban.vide.assy.instructions.ifndef;
import de.malban.vide.assy.instructions.ifneq;
import de.malban.vide.assy.instructions.include;
import de.malban.vide.assy.instructions.list;
import de.malban.vide.assy.instructions.nolist;
import de.malban.vide.assy.instructions.noopt;
import de.malban.vide.assy.instructions.opt;
import de.malban.vide.assy.instructions.org;
import de.malban.vide.assy.instructions.page;
import de.malban.vide.assy.instructions.psmacro;
import de.malban.vide.assy.instructions.rmb;
import de.malban.vide.assy.instructions.setdp;
import de.malban.vide.assy.instructions.struct;
import de.malban.vide.assy.instructions.title;
import de.malban.vide.assy.instructions.version;
import java.util.Hashtable;

public class InstructionSet
extends Hashtable {
    static final String INHERENT = "Inherent";
    static final String BRANCH = "Branch";
    static final String SINGLEARG = "SingleArg";
    static final String REGARG = "RegArg";
    static final String STACK = "Stack";
    static final String REGREG = "RegReg";
    static final String asmj_else = "asmj_else";
    static final String asmj_if = "asmj_if";
    static final String elseif = "elseif";
    static final String end = "end";
    static final String endif = "endif";
    static final String endm = "endm";
    static final String equ = "equ";
    static final String error = "error";
    static final String exitm = "exitm";
    static final String fcb = "fcb";
    static final String fcc = "fcc";
    static final String fdb = "fdb";
    static final String ifdef = "ifdef";
    static final String ifndef = "ifndef";
    static final String ifeq = "ifeq";
    static final String ifneq = "ifneq";
    static final String include = "include";
    static final String org = "org";
    static final String psmacro = "psmacro";
    static final String direct = "direct";
    static final String setdp = "setdp";
    static final String rmb = "rmb";
    static final String noopt = "noopt";
    static final String opt = "opt";
    static final String data = "data";
    static final String list = "list";
    static final String nolist = "nolist";
    static final String title = "title";
    static final String page = "page";
    static final String align = "align";
    static final String code = "code";
    static final String bss = "bss";
    static final String bank = "bank";
    static final String multibank = "64kBanked";
    static final String struct = "struct";
    static final String cmap = "cmap";
    static final String asm_version = "version";
    static final Hashtable groupmap = new Hashtable();
    static final Object[] instructionSet;

    public InstructionSet() {
        int opcode = 0;
        int datalen = 0;
        int opcodelen = 0;
        Class<?> instrClass = null;
        for (int i = 0; i < instructionSet.length; i += 5) {
            String mnemonic_s = (String)instructionSet[i];
            String class_s = (String)instructionSet[i + 1];
            String opcode_s = (String)instructionSet[i + 2];
            String datalen_s = (String)instructionSet[i + 3];
            String restriction_s = (String)instructionSet[i + 4];
            try {
                instrClass = (Class<?>)groupmap.get(class_s);
                if (instrClass == null) {
                    instrClass = Class.forName(class_s);
                }
                if (instrClass == null) {
                    throw new Exception();
                }
                opcodelen = opcode_s.length() / 2;
                if (opcodelen > 0) {
                    opcode = Integer.parseInt(opcode_s, 16);
                }
                if (datalen_s.length() > 0) {
                    datalen = Integer.parseInt(datalen_s);
                }
            }
            catch (Exception x) {
                System.err.println("Error in " + mnemonic_s + " class:" + class_s);
                x.printStackTrace();
                System.exit(1);
            }
            InstructionDetails details = new InstructionDetails(mnemonic_s, instrClass, opcode, opcodelen, datalen, restriction_s.toLowerCase());
            this.put(mnemonic_s, details);
        }
    }

    @Override
    public Object get(Object mnemonic_x) {
        String mnemonic = ((String)mnemonic_x).toLowerCase();
        InstructionDetails d = (InstructionDetails)super.get(mnemonic);
        if (d == null) {
            return null;
        }
        Instruction i = null;
        try {
            i = (Instruction)d.instructionClass.newInstance();
        }
        catch (Exception x) {
            System.out.println("Error in " + d.toString());
            x.printStackTrace();
            System.exit(1);
        }
        if (i instanceof InstructionGroup) {
            d.parameterize((InstructionGroup)i);
        }
        return i;
    }

    static {
        groupmap.put(INHERENT, Inherent.class);
        groupmap.put(BRANCH, Branch.class);
        groupmap.put(SINGLEARG, SingleArg.class);
        groupmap.put(REGARG, RegArg.class);
        groupmap.put(STACK, Stack.class);
        groupmap.put(REGREG, RegReg.class);
        groupmap.put(asmj_else, asmj_else.class);
        groupmap.put(asmj_if, asmj_if.class);
        groupmap.put(elseif, elseif.class);
        groupmap.put(end, end.class);
        groupmap.put(endif, endif.class);
        groupmap.put(endm, endm.class);
        groupmap.put(equ, equ.class);
        groupmap.put(error, error.class);
        groupmap.put(exitm, exitm.class);
        groupmap.put(fcb, fcb.class);
        groupmap.put(fcc, fcc.class);
        groupmap.put(fdb, fdb.class);
        groupmap.put(ifdef, ifdef.class);
        groupmap.put(ifndef, ifndef.class);
        groupmap.put(ifeq, ifeq.class);
        groupmap.put(ifneq, ifneq.class);
        groupmap.put(include, include.class);
        groupmap.put(org, org.class);
        groupmap.put(psmacro, psmacro.class);
        groupmap.put(direct, direct.class);
        groupmap.put(setdp, setdp.class);
        groupmap.put(noopt, noopt.class);
        groupmap.put(opt, opt.class);
        groupmap.put(data, data.class);
        groupmap.put(code, code.class);
        groupmap.put(bss, bss.class);
        groupmap.put(rmb, rmb.class);
        groupmap.put(list, list.class);
        groupmap.put(nolist, nolist.class);
        groupmap.put(title, title.class);
        groupmap.put(page, page.class);
        groupmap.put(align, align.class);
        groupmap.put(struct, struct.class);
        groupmap.put(bank, bank.class);
        groupmap.put(cmap, cmap.class);
        groupmap.put(asm_version, version.class);
        instructionSet = new Object[]{"abx", INHERENT, "3a", "0", "", "cwai", REGARG, "3c", "1", "dxe", "daa", INHERENT, "19", "0", "", "mul", INHERENT, "3d", "0", "", "nop", INHERENT, "12", "0", "", "rti", INHERENT, "3b", "0", "", "rts", INHERENT, "39", "0", "", "sex", INHERENT, "1d", "0", "", "swi", INHERENT, "3f", "0", "", "swi2", INHERENT, "103f", "0", "", "swi3", INHERENT, "113f", "0", "", "sync", INHERENT, "13", "0", "", "asla", INHERENT, "48", "0", "", "asra", INHERENT, "47", "0", "", "clra", INHERENT, "4f", "0", "", "coma", INHERENT, "43", "0", "", "deca", INHERENT, "4a", "0", "", "inca", INHERENT, "4c", "0", "", "lsla", INHERENT, "48", "0", "", "lsra", INHERENT, "44", "0", "", "nega", INHERENT, "40", "0", "", "rola", INHERENT, "49", "0", "", "rora", INHERENT, "46", "0", "", "tsta", INHERENT, "4d", "0", "", "aslb", INHERENT, "58", "0", "", "asrb", INHERENT, "57", "0", "", "clrb", INHERENT, "5f", "0", "", "comb", INHERENT, "53", "0", "", "decb", INHERENT, "5a", "0", "", "incb", INHERENT, "5c", "0", "", "lslb", INHERENT, "58", "0", "", "lsrb", INHERENT, "54", "0", "", "negb", INHERENT, "50", "0", "", "rolb", INHERENT, "59", "0", "", "rorb", INHERENT, "56", "0", "", "tstb", INHERENT, "5d", "0", "", "asl", SINGLEARG, "08", "1", "", "asr", SINGLEARG, "07", "1", "", "clr", SINGLEARG, "0f", "1", "", "com", SINGLEARG, "03", "1", "", "dec", SINGLEARG, "0a", "1", "", "inc", SINGLEARG, "0c", "1", "", "jmp", SINGLEARG, "0e", "1", "", "lsl", SINGLEARG, "08", "1", "", "lsr", SINGLEARG, "04", "1", "", "neg", SINGLEARG, "00", "1", "", "rol", SINGLEARG, "09", "1", "", "ror", SINGLEARG, "06", "1", "", "tst", SINGLEARG, "0d", "1", "", "adca", REGARG, "89", "1", "", "adda", REGARG, "8b", "1", "", "anda", REGARG, "84", "1", "", "bita", REGARG, "85", "1", "", "cmpa", REGARG, "81", "1", "", "eora", REGARG, "88", "1", "", "lda", REGARG, "86", "1", "", "jsr", REGARG, "8d", "1", "", "ora", REGARG, "8a", "1", "", "sbca", REGARG, "82", "1", "", "sta", REGARG, "87", "1", "i", "suba", REGARG, "80", "1", "", "adcb", REGARG, "c9", "1", "", "addb", REGARG, "cb", "1", "", "andb", REGARG, "c4", "1", "", "bitb", REGARG, "c5", "1", "", "cmpb", REGARG, "c1", "1", "", "eorb", REGARG, "c8", "1", "", "ldb", REGARG, "c6", "1", "", "orb", REGARG, "ca", "1", "", "sbcb", REGARG, "c2", "1", "", "stb", REGARG, "c7", "1", "I", "subb", REGARG, "c0", "1", "", "cmpx", REGARG, "8c", "2", "", "ldx", REGARG, "8e", "2", "", "stx", REGARG, "8f", "2", "i", "leax", REGARG, "10", "2", "ide", "cmpy", REGARG, "108c", "2", "", "ldy", REGARG, "108e", "2", "", "sty", REGARG, "108f", "2", "i", "leay", REGARG, "11", "2", "ide", "cmps", REGARG, "118c", "2", "", "lds", REGARG, "10ce", "2", "", "sts", REGARG, "10cf", "2", "i", "leas", REGARG, "12", "2", "ide", "cmpu", REGARG, "1183", "2", "", "ldu", REGARG, "ce", "2", "", "stu", REGARG, "cf", "2", "i", "leau", REGARG, "13", "2", "ide", "cmpd", REGARG, "1083", "2", "", "ldd", REGARG, "cc", "2", "", "std", REGARG, "cd", "2", "I", "addd", REGARG, "c3", "2", "", "subd", REGARG, "83", "2", "", "andcc", REGARG, "1c", "1", "dxe", "orcc", REGARG, "1a", "1", "dxe", "exg", REGREG, "1e", "1", "", "tfr", REGREG, "1f", "1", "", "pshs", STACK, "34", "1", "S", "puls", STACK, "35", "1", "S", "pshu", STACK, "36", "1", "U", "pulu", STACK, "37", "1", "U", "bcc", BRANCH, "24", "1", "", "bcs", BRANCH, "25", "1", "", "beq", BRANCH, "27", "1", "", "bge", BRANCH, "2c", "1", "", "bgt", BRANCH, "2e", "1", "", "bhi", BRANCH, "22", "1", "", "bhs", BRANCH, "24", "1", "", "ble", BRANCH, "2f", "1", "", "blo", BRANCH, "25", "1", "", "bls", BRANCH, "23", "1", "", "blt", BRANCH, "2d", "1", "", "bmi", BRANCH, "2b", "1", "", "bne", BRANCH, "26", "1", "", "bpl", BRANCH, "2a", "1", "", "bra", BRANCH, "20", "1", "", "brn", BRANCH, "21", "1", "", "bsr", BRANCH, "8d", "1", "", "bvc", BRANCH, "28", "1", "", "bvs", BRANCH, "29", "1", "", "lbcc", BRANCH, "1024", "2", "", "lbcs", BRANCH, "1025", "2", "", "lbeq", BRANCH, "1027", "2", "", "lbge", BRANCH, "102c", "2", "", "lbgt", BRANCH, "102e", "2", "", "lbhi", BRANCH, "1022", "2", "", "lbhs", BRANCH, "1024", "2", "", "lble", BRANCH, "102f", "2", "", "lblo", BRANCH, "1025", "2", "", "lbls", BRANCH, "1023", "2", "", "lblt", BRANCH, "102d", "2", "", "lbmi", BRANCH, "102b", "2", "", "lbne", BRANCH, "1026", "2", "", "lbpl", BRANCH, "102a", "2", "", "lbra", BRANCH, "16", "2", "", "lbrn", BRANCH, "1021", "2", "", "lbsr", BRANCH, "17", "2", "", "lbvc", BRANCH, "1028", "2", "", "lbvs", BRANCH, "1029", "2", "", "if", asmj_if, "", "0", "", "else", asmj_else, "", "0", "", elseif, elseif, "", "0", "", end, end, "", "0", "", endif, endif, "", "0", "", endm, endm, "", "0", "", equ, equ, "", "0", "", "=", equ, "", "0", "", error, error, "", "0", "", exitm, exitm, "", "0", "", fcb, fcb, "", "0", "", "db", fcb, "", "0", "", fcc, fcc, "", "0", "", fdb, fdb, "", "0", "", "dw", fdb, "", "0", "", ifdef, ifdef, "", "0", "", ifeq, ifeq, "", "0", "", ifndef, ifndef, "", "0", "", ifneq, ifneq, "", "0", "", include, include, "", "0", "", "macro", psmacro, "", "0", "", org, org, "", "0", "", direct, direct, "", "0", "", setdp, setdp, "", "0", "", noopt, noopt, "", "0", "", opt, opt, "", "0", "", data, data, "", "0", "", code, code, "", "0", "", bss, bss, "", "0", "", rmb, rmb, "", "0", "", struct, struct, "", "0", "", list, list, "", "0", "", nolist, nolist, "", "0", "", title, title, "", "0", "", page, page, "", "0", "", align, align, "", "0", "", bank, bank, "", "0", "", cmap, cmap, "", "0", "", "ds", rmb, "", "0", "", "fcw", fdb, "", "0", "", asm_version, asm_version, "", "0", ""};
    }

    private class InstructionDetails {
        public String mnemonic;
        public String restrictions;
        public Class instructionClass;
        public int opcode;
        public int opcodelength;
        public int datalength;

        public InstructionDetails(String m, Class c, int o, int p, int d, String r) {
            this.mnemonic = m;
            this.instructionClass = c;
            this.opcode = o;
            this.opcodelength = p;
            this.datalength = d;
            this.restrictions = r;
        }

        public void parameterize(InstructionGroup g) {
            g.setDetails(this.mnemonic, this.opcode, this.opcodelength, this.datalength, this.restrictions);
        }

        public String toString() {
            return "{" + this.mnemonic + "," + this.instructionClass + "," + this.opcode + "," + this.opcodelength + "," + this.datalength + ",'" + this.restrictions + "'}";
        }
    }
}

