/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.instructions;

import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.Register;
import de.malban.vide.assy.arguments.ArgumentRegisterList;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.instructions.InstructionGroup;

public class RegReg
extends InstructionGroup {
    Register src;
    Register dst;

    @Override
    public boolean parse(String arg) throws ParseException {
        ArgumentRegisterList rl = new ArgumentRegisterList(arg, this.getRestrictions(), 3);
        if (rl.getNumRegisters() != 2) {
            throw new ParseException("expected two registers");
        }
        this.src = rl.getReg(0);
        this.dst = rl.getReg(1);
        if (!Asmj.ALLOW_DIF_TRANSFER && this.src.getSize() != this.dst.getSize()) {
            this.dst = null;
            this.src = null;
            throw new ParseException("size mismatch");
        }
        this.setLength(2);
        return true;
    }

    @Override
    public boolean evalArgs() {
        return true;
    }

    @Override
    public boolean codegen(Memory mm) {
        this.writeOpcode(mm);
        int postbyte = this.src.getCode(3) << 4 | this.dst.getCode(3);
        mm.write(this.address + 1, postbyte, 2);
        return true;
    }
}

