/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.instructions;

import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.arguments.ArgumentMemoryLocation;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.instructions.Instruction;
import de.malban.vide.assy.instructions.InstructionGroup;

public class SingleArg
extends InstructionGroup {
    public ArgumentMemoryLocation m;

    @Override
    public boolean parse(String arg) throws ParseException {
        this.m = new ArgumentMemoryLocation(arg, this.symtab, (Instruction)this);
        switch (this.m.getMode()) {
            case 2: {
                this.setLength(2);
                this.opcode += 0;
                break;
            }
            case 4: {
                this.setLength(1 + this.m.getNumPostbytes());
                this.opcode += 96;
                break;
            }
            case 3: {
                this.setLength(3);
                this.opcode += 112;
                break;
            }
            default: {
                throw new ParseException("bad mode");
            }
        }
        return true;
    }

    @Override
    public boolean evalArgs() throws SymbolDoesNotExistException {
        this.m.eval(this.symtab);
        if (this.m.getMode() == 3) {
            int pc = this.address + 2;
            int dest = this.m.getOffset();
            int offset = dest - pc;
            if (this.source.isOptimize()) {
                boolean isNegative;
                boolean isShort = false;
                boolean bl = isNegative = offset < 0;
                if (isNegative && offset >= -128) {
                    isShort = true;
                }
                if (!isNegative && offset < 127) {
                    isShort = true;
                }
                if (isShort && this.source.op.toLowerCase().equals("jmp")) {
                    if (this.source.rest.startsWith(">")) {
                        this.source.rest = this.source.rest.substring(1);
                    }
                    String old = this.source.op;
                    this.source.op = "BRA";
                    Instruction i = (Instruction)Asmj.processor.instructionSet.get(this.source.op);
                    this.source.setInstruction(i);
                    this.source.rest = "" + offset;
                    i.source = this.source;
                    i.pass1(this.address, this.symtab);
                    Asmj.optimize(this.source, "Optimization changing \"" + old + "\" to \"" + this.source.op + "\" (NOP inserted)");
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean codegen(Memory mm) {
        this.writeOpcode(mm);
        this.m.codegen(mm, this.symtab, this.address + this.getOpcodeLength(), this.getDataLength());
        return true;
    }
}

