/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.instructions;

import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.Symbol;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.expressions.Expression;
import de.malban.vide.assy.expressions.ExpressionList;
import de.malban.vide.assy.expressions.ExpressionString;
import de.malban.vide.assy.expressions.ExpressionSymbol;
import de.malban.vide.assy.instructions.PseudoOp;
import java.util.HashMap;

public class fcb
extends PseudoOp {
    Expression data;
    boolean isBSS = false;

    public void setBSS(boolean b) {
        this.isBSS = b;
    }

    @Override
    public boolean parse(String paramString) throws ParseException {
        this.data = ExpressionList.parse(paramString, this.symtab);
        this.setLength(this.data.numItems());
        this.isBSS = Asmj.inBSS;
        return true;
    }

    public Symbol getSymbol() {
        ExpressionList ldata;
        if (this.data instanceof ExpressionSymbol) {
            ExpressionSymbol sdata = (ExpressionSymbol)this.data;
            return sdata.getSymbol();
        }
        if (this.data instanceof ExpressionList && (ldata = (ExpressionList)this.data).size() > 0 && ldata.elementAt(0) instanceof ExpressionSymbol) {
            ExpressionSymbol sdata = (ExpressionSymbol)ldata.elementAt(0);
            return sdata.getSymbol();
        }
        return null;
    }

    @Override
    public boolean evalArgs() throws SymbolDoesNotExistException {
        this.data.eval(this.symtab);
        return true;
    }

    boolean isSymbolString(ExpressionSymbol exprS) {
        return false;
    }

    boolean isStringItem(int i) {
        if (this.data instanceof ExpressionString) {
            return true;
        }
        if (this.data instanceof ExpressionList) {
            ExpressionList dList = (ExpressionList)this.data;
            int c = 0;
            for (int li = 0; li < dList.numItems(); ++li) {
                Expression expr = dList.listItem(li);
                if ((c += expr.numItems()) <= i) continue;
                if (expr instanceof ExpressionString) {
                    return true;
                }
                if (!(expr instanceof ExpressionSymbol)) break;
                return this.isSymbolString((ExpressionSymbol)expr);
            }
        }
        if (this.data instanceof ExpressionSymbol) {
            return this.isSymbolString((ExpressionSymbol)this.data);
        }
        return false;
    }

    public int getCMapedItem(int i) {
        Character mapped;
        int value = this.data.getItem(i) & 0xFF;
        if (!this.isStringItem(i)) {
            return value;
        }
        HashMap<Character, Character> cmaping = this.control.getCMap();
        if (cmaping != null && (mapped = cmaping.get(Character.valueOf((char)value))) != null) {
            return mapped.charValue();
        }
        return value;
    }

    @Override
    public boolean codegen(Memory paramMemory) {
        if (this.isBSS) {
            return true;
        }
        boolean isInRealityString = false;
        if (this.source.rest.startsWith("\"")) {
            isInRealityString = true;
        }
        for (int i = 0; i < this.length; ++i) {
            byte mappedItem = (byte)this.getCMapedItem(i);
            if (isInRealityString) {
                paramMemory.write(this.address + i, mappedItem, 4);
                continue;
            }
            paramMemory.write(this.address + i, mappedItem, 8);
        }
        if (isInRealityString) {
            Asmj.addLineInfo(this.address, this.length, Asmj.LI_STRING);
        } else {
            Asmj.addLineInfo(this.address, this.length, Asmj.LI_BYTE);
        }
        return true;
    }

    @Override
    public boolean generatedCode() {
        return true;
    }
}

