/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.dissy;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DASMStatics;
import de.malban.vide.dissy.Memory;
import de.malban.vide.dissy.MemoryInformation;
import de.malban.vide.dissy.MemoryInformationTableModel;
import de.malban.vide.dissy.MemoryInformationTableModelSmall;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DASM6809
extends DASMStatics {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static OutPutDefinition DEF = new OutPutDefinition();
    Memory myMemory = new Memory();
    public static boolean ALLOW_DIF_TRANSFER = true;
    int currentMemPointer = 0;
    int currentInstructionStartAddress = 0;
    int currentPC = 0;
    boolean endOfFile = false;
    boolean createLabels = false;
    boolean sizeWarning = false;
    boolean PC = false;
    String out2 = "";
    VideConfig config = VideConfig.getConfig();
    static HashMap<Integer, String> BIOSLABELS;
    static HashMap<Integer, String> BIOSLABELS2;
    static HashMap<Integer, String> BIOSFUNCTIONS;
    static HashMap<Integer, String> BIOS_WT1_FUNCTIONS;
    static HashMap<Integer, String> BIOS_WT1_LABELS;
    static HashMap<Integer, String> BIOS_WT1_LABELS2;
    static HashMap<Integer, String> BIOS_TOMLIN_LABELS;
    static HashMap<Integer, String> BIOS_TOMLIN_LABELS2;
    static HashMap<Integer, String> BIOS_TOMLIN_FUNCTIONS;
    int currentCNTScanBank = 0;

    public DASM6809() {
        this.reset();
    }

    int getbyte() {
        MemoryInformation m = this.myMemory.memMap.get(this.currentMemPointer);
        if (m == null) {
            this.endOfFile = true;
            return 0;
        }
        byte c = m.content;
        this.currentInstructionStartAddress = this.currentMemPointer++;
        return c & 0xFF;
    }

    int pregetbyte() {
        MemoryInformation m = this.myMemory.memMap.get(this.currentMemPointer);
        if (m == null) {
            return 0;
        }
        byte c = m.content;
        return c & 0xFF;
    }

    static boolean bittest(int c, int bitnumber) {
        while (--bitnumber > 0) {
            c >>= 1;
        }
        return (c & 1) == 1;
    }

    boolean fitbinarypattern(int c, String pattern) {
        if (pattern.length() == 0) {
            return true;
        }
        if (pattern.charAt(0) == '?') {
            return this.fitbinarypattern(c, pattern + 1);
        }
        if (pattern.charAt(0) == '0') {
            if (!DASM6809.bittest(c, pattern.length())) {
                return this.fitbinarypattern(c, pattern + 1);
            }
            return false;
        }
        if (pattern.charAt(0) == '1') {
            if (DASM6809.bittest(c, pattern.length())) {
                return this.fitbinarypattern(c, pattern + 1);
            }
            return false;
        }
        return false;
    }

    public static String printbinary(int c) {
        String ret = "";
        for (int i = 8; i > 0; --i) {
            ret = DASM6809.bittest(c, i) ? ret + "1" : ret + "0";
        }
        return ret;
    }

    public static String printbinary16(int c) {
        String ret = "";
        for (int i = 16; i > 0; --i) {
            ret = DASM6809.bittest(c, i) ? ret + "1" : ret + "0";
        }
        return ret;
    }

    boolean checkindpostbyte(int c, int numoperands, int[] operandarray) {
        if (this.fitbinarypattern(c, "0???????")) {
            if (this.fitbinarypattern(c, "0??00000")) {
                return true;
            }
            return true;
        }
        if (this.fitbinarypattern(c, "1??00000")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1???0001")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1??00010")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1???0011")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1???0100")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1???0101")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1???0110")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1???1001")) {
            if (this.pregetbyte() == 0 && this.fitbinarypattern(c, "???1????")) {
                return true;
            }
            return true;
        }
        if (this.fitbinarypattern(c, "1???1000")) {
            if ((this.pregetbyte() < 15 || this.pregetbyte() > 240) && this.fitbinarypattern(c, "???0????")) {
                return true;
            }
            return true;
        }
        if (this.fitbinarypattern(c, "1???1011")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1???1100")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1???1101")) {
            return true;
        }
        if (this.fitbinarypattern(c, "1???1111")) {
            return this.fitbinarypattern(c, "10011111");
        }
        return false;
    }

    public static void setStyle() {
        VideConfig config = VideConfig.getConfig();
        if (config.useTomlinConstants) {
            BIOSLABELS = BIOS_TOMLIN_LABELS;
            BIOSLABELS2 = BIOS_TOMLIN_LABELS2;
            BIOSFUNCTIONS = BIOS_TOMLIN_FUNCTIONS;
        } else {
            BIOSLABELS = BIOS_WT1_LABELS;
            BIOSLABELS2 = BIOS_WT1_LABELS2;
            BIOSFUNCTIONS = BIOS_WT1_FUNCTIONS;
        }
    }

    public static boolean isBIOSLabelPublic(String label, int address) {
        String l = BIOSLABELS.get(address);
        String l2 = BIOSLABELS2.get(address);
        boolean isLabel = false;
        if (l != null) {
            boolean bl = isLabel = isLabel || label.toLowerCase().equals(l.toLowerCase());
        }
        if (l2 != null) {
            isLabel = isLabel || label.toLowerCase().equals(l2.toLowerCase());
        }
        return isLabel;
    }

    public static String getBIOSLabel(int address) {
        String l = BIOSLABELS.get(address);
        String l2 = BIOSLABELS2.get(address);
        if (l != null) {
            return l;
        }
        return l2;
    }

    public static String getBIOSFunction(int address) {
        return BIOSFUNCTIONS.get(address);
    }

    boolean isBIOSLabel(String label, int address) {
        return false;
    }

    String getNonBIOSLableFirst(ArrayList<String> labels, int address) {
        for (int i = 0; i < labels.size(); ++i) {
            String label = labels.get(i);
            if (this.isBIOSLabel(label, address)) continue;
            return label;
        }
        return labels.get(0);
    }

    public void setCreateLabels(boolean c) {
        this.createLabels = c;
    }

    String checklabs(int address, MemoryInformation memInfo) {
        return this.checklabs(address, -1, memInfo);
    }

    String checklabs(int address, int mode, MemoryInformation memInfo) {
        return this.checklabs(address, mode, -1, memInfo);
    }

    String checklabs(int address, int mode, int dp, MemoryInformation memInfo) {
        return this.checklabs(address, mode, -1, -1, memInfo);
    }

    String checklabs(int address, int mode, int dp, int numOperands, MemoryInformation memInfo) {
        String labtemp = "";
        boolean shortaddr = true;
        boolean hasLabel = false;
        MemoryInformation info = this.myMemory.memMap.get(address);
        if (info != null) {
            ArrayList<Object> labels = new ArrayList();
            if (mode == 5) {
                labels = info.immediateLabels;
                if (labels.size() == 0 && address > 256) {
                    labels = info.labels;
                }
            } else if (mode == 1) {
                if (dp != -1) {
                    boolean doVarTest = false;
                    HashMap<Integer, String> map = this.myMemory.directLabels.get(dp);
                    if (map != null) {
                        String lab = map.get(address & 0xFF);
                        if (lab != null) {
                            labtemp = labtemp + lab;
                        } else {
                            doVarTest = true;
                        }
                    } else {
                        doVarTest = true;
                    }
                    if (doVarTest) {
                        int testAddress = address + dp * 256;
                        MemoryInformation info2 = this.myMemory.memMap.get(testAddress);
                        if (info2.labels.size() > 0) {
                            if (memInfo.forcedSymbol != null) {
                                if (memInfo.forcedSymbol.length() != 0) {
                                    for (int iii = 0; iii < info2.labels.size(); ++iii) {
                                        if (!memInfo.forcedSymbol.equals(info2.labels.get(iii))) continue;
                                        labtemp = labtemp + info2.labels.get(iii);
                                    }
                                } else {
                                    labtemp = labtemp + info2.labels.get(0);
                                }
                            } else {
                                labtemp = labtemp + info2.labels.get(0);
                            }
                            HashMap<Integer, String> dmap = this.myMemory.directLabels.get(dp);
                            if (dmap == null) {
                                dmap = new HashMap();
                                this.myMemory.directLabels.put(dp, dmap);
                            }
                            dmap.put(address, info2.labels.get(0));
                        }
                    }
                }
            } else {
                labels = info.labels;
            }
            if (labels.size() > 0) {
                if (memInfo.forcedSymbol != null) {
                    if (memInfo.forcedSymbol.length() != 0) {
                        for (int iii = 0; iii < labels.size(); ++iii) {
                            if (!memInfo.forcedSymbol.equals(labels.get(iii))) continue;
                            labtemp = labtemp + (String)labels.get(iii);
                        }
                    } else {
                        labtemp = labtemp + this.getNonBIOSLableFirst(labels, address);
                    }
                } else {
                    labtemp = labtemp + this.getNonBIOSLableFirst(labels, address);
                }
                hasLabel = true;
            }
        }
        if (memInfo.forcedSymbol != null && memInfo.forcedSymbol.length() == 0) {
            labtemp = "";
            hasLabel = true;
        }
        shortaddr = numOperands != -1 ? numOperands == 0 || numOperands == 1 : address < 128 && address > -129 || mode == 1;
        if (labtemp.length() == 0) {
            labtemp = "";
            if (info != null && this.createLabels && (mode == 3 || mode == 6 || mode == 4)) {
                labtemp = "_" + String.format("%04X", address & 0xFFFF);
                info.labels.add(labtemp);
                hasLabel = true;
            } else {
                labtemp = address >= 0 || mode == 1 ? (shortaddr ? labtemp + DASM6809.DEF.hexPrefix + String.format("%02X", address & 0xFF) : labtemp + DASM6809.DEF.hexPrefix + String.format("%04X", address & 0xFFFF)) : (address < 128 && address > -129 ? (shortaddr ? labtemp + "-" + DASM6809.DEF.hexPrefix + String.format("%02X", -address & 0xFF) : labtemp + "-" + DASM6809.DEF.hexPrefix + String.format("%04X", -address & 0xFFFF)) : labtemp + "-" + DASM6809.DEF.hexPrefix + String.format("%04X", -address & 0xFFFF));
            }
        }
        if (mode == 3) {
            address -= this.currentMemPointer;
            if ((address &= 0xFF) >= 128) {
                address -= 256;
            }
            if (!hasLabel) {
                int a = address & 0xFF;
                labtemp = a < 128 ? DASM6809.DEF.hexPrefix + String.format("%02X", a) : "-" + DASM6809.DEF.hexPrefix + String.format("%02X", 256 - a);
            }
        }
        if (mode == 6) {
            address -= this.currentMemPointer;
            if ((address &= 0xFFFF) >= 32768) {
                address -= 65536;
            }
            if (!hasLabel) {
                int a = address & 0xFFFF;
                labtemp = a < 32768 ? DASM6809.DEF.hexPrefix + String.format("%04X", a) : "-" + DASM6809.DEF.hexPrefix + String.format("%04X", 65536 - a);
            }
        }
        if (mode != 5) {
            this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).referingToAddress = address;
        }
        this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).referingToShort = shortaddr;
        return labtemp;
    }

    String printoperands(int opcode, int numoperands, int[] operandarray, int mode, String opname, int page2, MemoryInformation memInfo) {
        int offset = 0;
        String str = "";
        String out2 = "";
        int dp = memInfo.directPageAddress;
        this.PC = false;
        this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).referingAddressMode = mode;
        if (opcode != 31 && opcode != 30) {
            switch (mode) {
                case 5: {
                    str = str + DASM6809.DEF.immediatePrefix;
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        switch (mode) {
            case 3: {
                int rel = operandarray[0];
                str = str + this.checklabs(this.currentMemPointer + (rel < 128 ? rel : rel - 256), mode, -1, 1, memInfo);
                break;
            }
            case 6: {
                int rel = (operandarray[0] << 8) + operandarray[1];
                str = str + this.checklabs(this.currentMemPointer + (rel < 32768 ? rel : rel - 65536), mode, 2, memInfo);
                break;
            }
            case 2: {
                int pb2;
                int pb = operandarray[0];
                int reg = pb >> 5 & 3;
                if ((pb & 0x8F) == 135 || (pb & 0x8F) == 138 || (pb & 0x8F) == 142) {
                    return this.incorrectDisassembleFoundAt(this.currentPC, "Illegal postbyte value for indexed addressing, bit combination of 4 lower bits.");
                }
                if ((pb & 0x9F) == 146 || (pb & 0x9F) == 144) {
                    return this.incorrectDisassembleFoundAt(this.currentPC, "Illegal postbyte value ,-R or ,R+  not allowed for indirect indexed addressing.");
                }
                if ((pb & 0x9F) == 143) {
                    return this.incorrectDisassembleFoundAt(this.currentPC, "Illegal postbyte value 16 bit extended not allowed in indexed (non indirect) addressing.");
                }
                if ((pb & 0xFF) == 191 || (pb & 0xFF) == 223 || (pb & 0xFF) == 255) {
                    return this.incorrectDisassembleFoundAt(this.currentPC, "Illegal postbyte value 16 bit indirect indexed addressing expects bits 5 and 6 to be 0");
                }
                if ((pb & 0x8F) == 141 || (pb & 0x8F) == 140) {
                    reg = 4;
                    if ((pb >> 4 & 6) != 0) {
                        return this.incorrectDisassembleFoundAt(this.currentPC, "Ambiguous pc index addressing, postbytes bit 5 and 6 are non zero (assi generates 0).");
                    }
                }
                if ((pb2 = pb & 0x8F) == 136 || pb2 == 140) {
                    offset = this.getbyte();
                    ++memInfo.cycles;
                    if (this.endOfFile) {
                        return this.incorrectDisassembleFoundAt(this.currentPC, "End of file while reading operands (8bit).");
                    }
                    ++this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).length;
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.add(this.myMemory.memMap.get(this.currentMemPointer - 1));
                    ++this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).disType;
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).belongsToInstruction = this.myMemory.memMap.get(this.currentPC);
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).isInstructionByte = this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1 + 1;
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).hexDump = String.format("%02X", opcode);
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).disType = 11 + this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1;
                    if (offset > 127) {
                        offset -= 256;
                    }
                    memInfo.disassembledMnemonic = opname;
                    if ((pb & 0x90) == 144) {
                        memInfo.cycles += 3;
                        str = str + DASM6809.DEF.indexedPrefix;
                    }
                    if (pb == 140) {
                        out2 = this.checklabs(offset, memInfo) + "," + regs[reg];
                    } else if (offset >= 0) {
                        MemoryInformation info;
                        out2 = DASM6809.DEF.hexPrefix + String.format("%02X", offset) + "," + regs[reg];
                        if (memInfo.forcedSymbol != null && memInfo.forcedSymbol.length() != 0 && (info = this.myMemory.memMap.get(offset)) != null) {
                            for (int iii = 0; iii < info.labels.size(); ++iii) {
                                if (!memInfo.forcedSymbol.equals(info.labels.get(iii))) continue;
                                out2 = info.labels.get(iii) + "," + regs[reg];
                            }
                        }
                    } else {
                        MemoryInformation info;
                        out2 = "-" + DASM6809.DEF.hexPrefix + String.format("%02X", -offset) + "," + regs[reg];
                        if (memInfo.forcedSymbol != null && memInfo.forcedSymbol.length() != 0 && (info = this.myMemory.memMap.get(offset)) != null) {
                            for (int iii = 0; iii < info.labels.size(); ++iii) {
                                if (!memInfo.forcedSymbol.equals(info.labels.get(iii))) continue;
                                out2 = info.labels.get(iii) + "," + regs[reg];
                            }
                        }
                    }
                    str = str + DASM6809.DEF._8bitPrefix + out2;
                } else if (pb2 == 137 || pb2 == 141 || pb2 == 143) {
                    int helper = this.getbyte();
                    memInfo.cycles += 4;
                    if (this.endOfFile) {
                        return this.incorrectDisassembleFoundAt(this.currentPC, "End of file while reading operands (16 byte-1).");
                    }
                    ++this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).length;
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.add(this.myMemory.memMap.get(this.currentMemPointer - 1));
                    ++this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).disType;
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).belongsToInstruction = this.myMemory.memMap.get(this.currentPC);
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).isInstructionByte = this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1 + 1;
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).hexDump = String.format("%02X", opcode);
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).disType = 11 + this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1;
                    offset = helper << 8;
                    helper = this.getbyte();
                    if (this.endOfFile) {
                        return this.incorrectDisassembleFoundAt(this.currentPC, "End of file while reading operands (16 byte-2).");
                    }
                    ++this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).length;
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.add(this.myMemory.memMap.get(this.currentMemPointer - 1));
                    ++this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).disType;
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).belongsToInstruction = this.myMemory.memMap.get(this.currentPC);
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).isInstructionByte = this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1 + 1;
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).hexDump = String.format("%02X", opcode);
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.get((int)(this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1)).disType = 11 + this.myMemory.memMap.get((Object)Integer.valueOf((int)this.currentPC)).familyBytes.size() - 1;
                    if (pb != 143 && (offset += helper) > Short.MAX_VALUE) {
                        offset -= 65536;
                    }
                    offset &= 0xFFFF;
                    memInfo.disassembledMnemonic = opname;
                    if ((pb & 0x90) == 144) {
                        str = str + DASM6809.DEF.indexedPrefix;
                        memInfo.cycles += 3;
                    }
                    if (reg == 4) {
                        ++memInfo.cycles;
                    }
                    if (pb == 159) {
                        out2 = this.checklabs(offset, memInfo);
                        memInfo.cycles -= 2;
                    } else if (pb == 141) {
                        out2 = this.checklabs(offset, memInfo) + "," + regs[reg];
                    } else if (offset >= 0) {
                        MemoryInformation info;
                        out2 = DASM6809.DEF.hexPrefix + String.format("%04X", offset) + "," + regs[reg];
                        if (memInfo.forcedSymbol != null && memInfo.forcedSymbol.length() != 0 && (info = this.myMemory.memMap.get(offset)) != null) {
                            for (int iii = 0; iii < info.labels.size(); ++iii) {
                                if (!memInfo.forcedSymbol.equals(info.labels.get(iii))) continue;
                                out2 = info.labels.get(iii) + "," + regs[reg];
                            }
                        }
                    } else {
                        MemoryInformation info;
                        out2 = "-" + DASM6809.DEF.hexPrefix + String.format("%04X", offset) + "," + regs[reg];
                        if (memInfo.forcedSymbol != null && memInfo.forcedSymbol.length() != 0 && (info = this.myMemory.memMap.get(offset)) != null) {
                            for (int iii = 0; iii < info.labels.size(); ++iii) {
                                if (!memInfo.forcedSymbol.equals(info.labels.get(iii))) continue;
                                out2 = info.labels.get(iii) + "," + regs[reg];
                            }
                        }
                    }
                    str = str + DASM6809.DEF._16bitPrefix + out2;
                } else if ((pb & 0x80) != 0) {
                    memInfo.disassembledMnemonic = opname;
                    if ((pb & 0x90) == 144) {
                        str = str + DASM6809.DEF.indexedPrefix;
                        memInfo.cycles += 3;
                    }
                    if ((pb & 0x8F) == 128) {
                        out2 = "," + regs[reg] + "+";
                        str = str + out2;
                        memInfo.cycles += 2;
                    } else if ((pb & 0x8F) == 129) {
                        out2 = "," + regs[reg] + "++";
                        str = str + out2;
                        memInfo.cycles += 3;
                    } else if ((pb & 0x8F) == 130) {
                        out2 = ",-" + regs[reg] + "";
                        str = str + out2;
                        memInfo.cycles += 2;
                    } else if ((pb & 0x8F) == 131) {
                        out2 = ",--" + regs[reg] + "";
                        str = str + out2;
                        memInfo.cycles += 3;
                    } else if ((pb & 0x8F) == 132) {
                        out2 = "," + regs[reg] + "";
                        str = str + out2;
                    } else if ((pb & 0x8F) == 133) {
                        out2 = "b," + regs[reg] + "";
                        str = str + out2;
                        ++memInfo.cycles;
                    } else if ((pb & 0x8F) == 134) {
                        out2 = "a," + regs[reg] + "";
                        str = str + out2;
                        ++memInfo.cycles;
                    } else if ((pb & 0x8F) == 139) {
                        out2 = "d," + regs[reg] + "";
                        str = str + out2;
                        memInfo.cycles += 4;
                    }
                } else {
                    MemoryInformation info;
                    offset = pb & 0x1F;
                    if (offset > 15) {
                        offset -= 32;
                    }
                    memInfo.disassembledMnemonic = opname;
                    out2 = offset < 0 ? "-" + DASM6809.DEF.hexPrefix + String.format("%02X", -offset) + "," + regs[reg] : DASM6809.DEF.hexPrefix + String.format("%02X", offset) + "," + regs[reg];
                    if (memInfo.forcedSymbol != null && memInfo.forcedSymbol.length() != 0 && (info = this.myMemory.memMap.get(offset)) != null) {
                        for (int iii = 0; iii < info.labels.size(); ++iii) {
                            if (!memInfo.forcedSymbol.equals(info.labels.get(iii))) continue;
                            out2 = info.labels.get(iii) + "," + regs[reg];
                        }
                    }
                    str = str + DASM6809.DEF._5bitPrefix + out2;
                    ++memInfo.cycles;
                }
                if ((pb & 0x90) != 144) break;
                str = str + DASM6809.DEF.indexedPostfix;
                break;
            }
            default: {
                if (opcode == 31 || opcode == 30) {
                    out2 = "" + teregs[operandarray[0] >> 4 & 0xF] + "," + teregs[operandarray[0] & 0xF];
                    str = str + out2;
                    break;
                }
                if (opcode == 52 || opcode == 54) {
                    boolean comma = false;
                    if ((operandarray[0] & 0x80) > 0) {
                        str = str + "pc";
                        comma = true;
                        this.PC = true;
                        memInfo.cycles += 2;
                    }
                    if ((operandarray[0] & 0x40) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = opcode == 52 || opcode == 53 ? str + "u" : str + "s";
                        memInfo.cycles += 2;
                        comma = true;
                    }
                    if ((operandarray[0] & 0x20) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "y";
                        comma = true;
                        memInfo.cycles += 2;
                    }
                    if ((operandarray[0] & 0x10) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "x";
                        comma = true;
                        memInfo.cycles += 2;
                    }
                    if ((operandarray[0] & 8) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "dp";
                        comma = true;
                        ++memInfo.cycles;
                    }
                    if ((operandarray[0] & 4) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "b";
                        comma = true;
                        ++memInfo.cycles;
                    }
                    if ((operandarray[0] & 2) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "a";
                        comma = true;
                        ++memInfo.cycles;
                    }
                    if ((operandarray[0] & 1) <= 0) break;
                    if (comma) {
                        str = str + ",";
                    }
                    str = str + "cc";
                    ++memInfo.cycles;
                    break;
                }
                if (opcode == 53 || opcode == 55) {
                    boolean comma = false;
                    if ((operandarray[0] & 1) > 0) {
                        str = str + "cc";
                        comma = true;
                        ++memInfo.cycles;
                    }
                    if ((operandarray[0] & 2) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "a";
                        comma = true;
                        ++memInfo.cycles;
                    }
                    if ((operandarray[0] & 4) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "b";
                        comma = true;
                        ++memInfo.cycles;
                    }
                    if ((operandarray[0] & 8) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "dp";
                        comma = true;
                        ++memInfo.cycles;
                    }
                    if ((operandarray[0] & 0x10) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "x";
                        comma = true;
                        memInfo.cycles += 2;
                    }
                    if ((operandarray[0] & 0x20) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = str + "y";
                        comma = true;
                        memInfo.cycles += 2;
                    }
                    if ((operandarray[0] & 0x40) > 0) {
                        if (comma) {
                            str = str + ",";
                        }
                        str = opcode == 52 || opcode == 53 ? str + "u" : str + "s";
                        comma = true;
                        memInfo.cycles += 2;
                    }
                    if ((operandarray[0] & 0x80) <= 0) break;
                    if (comma) {
                        str = str + ",";
                    }
                    str = str + "pc";
                    this.PC = true;
                    memInfo.cycles += 2;
                    break;
                }
                if (numoperands == 0) break;
                if (numoperands == 2) {
                    if (mode != 5) {
                        str = str + DASM6809.DEF._16bitPrefix;
                    }
                    str = str + this.checklabs((operandarray[0] << 8) + operandarray[1], mode, -1, numoperands, memInfo);
                    break;
                }
                if (numoperands == 1) {
                    if (mode != 5) {
                        str = str + DASM6809.DEF._8bitPrefix;
                    }
                    str = str + this.checklabs(operandarray[0], mode, dp, numoperands, memInfo);
                    break;
                }
                if (mode != 5) {
                    str = str + DASM6809.DEF._5bitPrefix;
                }
                str = str + DASM6809.DEF.hexPrefix;
                for (int i = 0; i < numoperands; ++i) {
                    str = str + String.format("%02X", operandarray[i]) + "";
                }
            }
        }
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String disassemble(int startAddress) {
        int i;
        this.currentPC = startAddress;
        this.currentInstructionStartAddress = startAddress;
        this.currentMemPointer = startAddress;
        int[] operand = new int[4];
        int familyCounter = -1;
        int opcode = this.getbyte();
        if (this.endOfFile) {
            return this.incorrectDisassembleFoundAt(startAddress, "End of file while reading byte.");
        }
        MemoryInformation memInfo = this.myMemory.memMap.get(startAddress);
        memInfo.reset();
        if (memInfo.disType != 0 && memInfo.disType != 15 && memInfo.disType != -1 && memInfo.disType != -2) {
            return "Memory location known, not disassembled again.";
        }
        memInfo.hexDump = DASM6809.DEF.hexPrefix + String.format("%02X", opcode);
        DASMStatics.Opcodeinfo op = null;
        for (i = 0; i < numops[0] && DASM6809.pg1opcodes[i].opcode != opcode; ++i) {
        }
        int iLen = DASMStatics.getNumOpcodes(memInfo.content, this.myMemory.memMap.get((Object)Integer.valueOf((int)((startAddress + 1) % 65536))).content);
        boolean ok = true;
        for (int il = 0; il < iLen; ++il) {
            MemoryInformation memInfo2 = this.myMemory.memMap.get((startAddress + 1 + il) % 65536);
            if (memInfo2.disType != 1 && memInfo2.disType != -3 && memInfo2.disType != 2 && memInfo2.disType != 3 && memInfo2.disType != 4 && memInfo2.disType != 5) continue;
            memInfo.reset();
        }
        if (!ok) {
            memInfo.length = 0;
            memInfo.disassembledMnemonic = "DB";
            memInfo.disassembledOperand = memInfo.disassembledOperand + DASM6809.DEF.hexPrefix + String.format("%02X", memInfo.content & 0xFF);
            ++memInfo.length;
            return "";
        }
        memInfo.indexInOpcodeTablePage0 = i;
        memInfo.disType = 6;
        if (i < numops[0]) {
            if (DASM6809.pg1opcodes[i].mode >= 7) {
                int j;
                int k;
                int page2;
                memInfo.page = page2 = DASM6809.pg1opcodes[i].mode - 7 + 1;
                memInfo.cycles = DASM6809.pg1opcodes[i].numcycles;
                int helper = this.getbyte();
                if (this.endOfFile) {
                    return this.incorrectDisassembleFoundAt(startAddress, "End of file while at page seek.");
                }
                opcode = helper;
                memInfo.familyBytes.add(this.myMemory.memMap.get(this.currentMemPointer - 1));
                ++memInfo.disType;
                memInfo.familyBytes.get((int)(++familyCounter)).belongsToInstruction = memInfo;
                memInfo.familyBytes.get((int)familyCounter).isInstructionByte = familyCounter + 1;
                memInfo.familyBytes.get((int)familyCounter).hexDump = String.format("%02X", opcode);
                memInfo.familyBytes.get((int)familyCounter).disType = 11 + familyCounter;
                for (k = 0; k < numops[page2] && opcode != DASM6809.pgpointers[page2][k].opcode; ++k) {
                }
                if (page2 == 1) {
                    memInfo.familyBytes.get((int)familyCounter).indexInOpcodeTablePage1 = k;
                }
                if (page2 == 2) {
                    memInfo.familyBytes.get((int)familyCounter).indexInOpcodeTablePage2 = k;
                }
                if (k == numops[page2]) return this.incorrectDisassembleFoundAt(startAddress, "Opcode not found in any page.");
                op = pgpointers[page2][k];
                int numoperands = DASM6809.pgpointers[page2][k].numoperands;
                memInfo.cycles += DASM6809.pgpointers[page2][k].numcycles;
                for (j = 0; j < numoperands - 1; ++j) {
                    int helper2 = this.getbyte();
                    memInfo.familyBytes.add(this.myMemory.memMap.get(this.currentMemPointer - 1));
                    ++memInfo.disType;
                    memInfo.familyBytes.get((int)(++familyCounter)).belongsToInstruction = memInfo;
                    memInfo.familyBytes.get((int)familyCounter).isInstructionByte = familyCounter + 1;
                    memInfo.familyBytes.get((int)familyCounter).hexDump = String.format("%02X", helper2);
                    memInfo.familyBytes.get((int)familyCounter).disType = 11 + familyCounter;
                    operand[j] = helper2;
                    if (!this.endOfFile) continue;
                    return this.incorrectDisassembleFoundAt(startAddress, "End of file while at page " + (page2 + 1) + " opcode search.");
                }
                if (j != numoperands - 1) {
                    return this.incorrectDisassembleFoundAt(startAddress, "End of file while at page " + (page2 + 1) + ": incorrect number of operands.");
                }
                if (DASM6809.pgpointers[page2][k].mode != 2) {
                    memInfo.disassembledMnemonic = memInfo.disassembledMnemonic + DASM6809.pgpointers[page2][k].name;
                }
                String opAdd = this.printoperands(opcode, numoperands - 1, operand, DASM6809.pgpointers[page2][k].mode, DASM6809.pgpointers[page2][k].name, page2, memInfo);
                if (memInfo.disType != 1 && memInfo.disType != -3) {
                    memInfo.disassembledOperand = memInfo.disassembledOperand + opAdd;
                    memInfo.length = 1 + memInfo.familyBytes.size();
                }
            } else {
                int j;
                memInfo.page = 0;
                memInfo.cycles = DASM6809.pg1opcodes[i].numcycles;
                op = pg1opcodes[i];
                int numoperands = DASM6809.pg1opcodes[i].numoperands;
                for (j = 0; j < numoperands; ++j) {
                    int helper2 = this.getbyte();
                    memInfo.familyBytes.add(this.myMemory.memMap.get(this.currentMemPointer - 1));
                    ++memInfo.disType;
                    memInfo.familyBytes.get((int)(++familyCounter)).belongsToInstruction = memInfo;
                    memInfo.familyBytes.get((int)familyCounter).isInstructionByte = familyCounter + 1;
                    memInfo.familyBytes.get((int)familyCounter).hexDump = String.format("%02X", helper2);
                    memInfo.familyBytes.get((int)familyCounter).disType = 11 + familyCounter;
                    operand[j] = helper2;
                    if (!this.endOfFile) continue;
                    return this.incorrectDisassembleFoundAt(startAddress, "End of file while in opcode search Page 1.");
                }
                if (j != numoperands) {
                    return this.incorrectDisassembleFoundAt(startAddress, "Opcode search Page 1: incorrect number of operands.");
                }
                boolean c1 = teregs[operand[0] >> 4 & 0xF].toUpperCase().equals("INV");
                boolean c2 = teregs[operand[0] & 0xF].toUpperCase().equals("INV");
                this.sizeWarning = false;
                if ((opcode == 31 || opcode == 30) && teregssize[operand[0] >> 4 & 0xF] - teregssize[operand[0] & 0xF] != 0) {
                    if (!ALLOW_DIF_TRANSFER) return this.incorrectDisassembleFoundAt(startAddress, "Illegal Register code (EXG/TFR).");
                    this.sizeWarning = true;
                }
                if ((opcode == 31 || opcode == 30) && (c1 || c2)) {
                    this.sizeWarning = false;
                    return this.incorrectDisassembleFoundAt(startAddress, "Illegal Register code (EXG/TFR).");
                }
                if ((opcode == 52 || opcode == 53 || opcode == 54 || opcode == 55) && operand[0] == 0) {
                    return this.incorrectDisassembleFoundAt(startAddress, "Illegal Register code (PUSH/PULL).");
                }
                if (this.sizeWarning) {
                    memInfo.comments.add("WARNING mismatching operand size found");
                    this.sizeWarning = false;
                }
                if (DASM6809.pg1opcodes[i].mode != 2) {
                    memInfo.disassembledMnemonic = memInfo.disassembledMnemonic + DASM6809.pg1opcodes[i].name;
                }
                String opAdd = this.printoperands(opcode, numoperands, operand, DASM6809.pg1opcodes[i].mode, DASM6809.pg1opcodes[i].name, 0, memInfo);
                if (memInfo.disType != 1 && memInfo.disType != -3) {
                    memInfo.disassembledOperand = memInfo.disassembledOperand + opAdd;
                    memInfo.length = 1 + memInfo.familyBytes.size();
                }
            }
        } else if (i == numops[0]) {
            return this.incorrectDisassembleFoundAt(startAddress, "Opcode not found (page 1).");
        }
        this.PC = false;
        return "";
    }

    public MemoryInformationTableModel getTableModel() {
        return MemoryInformationTableModel.createModel(this.myMemory);
    }

    public MemoryInformationTableModelSmall getTableModelSmall() {
        return MemoryInformationTableModelSmall.createModel(this.myMemory);
    }

    String incorrectDisassembleFoundAt(int startAddress, String errorMsg) {
        MemoryInformation memInfo = this.myMemory.memMap.get(startAddress);
        if (memInfo == null) {
            return "";
        }
        memInfo.reset();
        memInfo.disType = 1;
        memInfo.disassembledMnemonic = "DB";
        memInfo.disassembledOperand = String.format("$%02X", memInfo.content & 0xFF);
        memInfo.comments.add("DISSI " + errorMsg);
        memInfo.disassemblerInfoText = errorMsg;
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readCNTFile(String name) {
        try (BufferedReader br = new BufferedReader(new FileReader(name));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                this.doOneCNTLine(line);
                line = br.readLine();
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static int toNumber(String s) {
        return DASM6809.toNumber(s, false);
    }

    public static int toNumber(String s, boolean largeAllowed) {
        s = UtilityString.replace(s, "$$", "$");
        s = s.toUpperCase();
        boolean minus = false;
        int radix = 10;
        int result = 0;
        if (s.startsWith("-")) {
            minus = true;
            s = s.substring(1);
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (s.startsWith("$")) {
            radix = 16;
            s = s.substring(1);
        }
        if (s.startsWith("%")) {
            radix = 2;
            s = s.substring(1);
        }
        if (s.startsWith("b")) {
            radix = 2;
            s = s.substring(1);
        }
        if (s.startsWith("0X")) {
            s = s.substring(2);
            radix = 16;
        }
        try {
            result = Integer.parseInt(s, radix);
            if (minus) {
                result *= -1;
            }
            if (!largeAllowed) {
                result &= 0xFFFF;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public int processVectrexHeader() {
        MemoryInformation info;
        int a;
        int stringOrg = a = 0;
        this.myMemory.memMap.get((Object)Integer.valueOf((int)a)).length = 0;
        this.myMemory.memMap.get((Object)Integer.valueOf((int)a)).comments.add("GCS Copyright");
        this.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disTypeCollectionMax = 30;
        do {
            if ((info = this.myMemory.memMap.get(a++)) == null) {
                return -1;
            }
            if (a > 32768) {
                return -1;
            }
            info.disType = 4;
            info.typeWasSet = true;
            ++this.myMemory.memMap.get((Object)Integer.valueOf((int)stringOrg)).length;
        } while ((info.content & 0xFF) != 128);
        info.disType = 1;
        info.typeWasSet = true;
        info = this.myMemory.memMap.get(a++);
        info.comments.add("Start music pointer");
        info.length = 2;
        info.disType = 3;
        info.typeWasSet = true;
        info = this.myMemory.memMap.get(a++);
        info.disType = 3;
        info.typeWasSet = true;
        while (this.myMemory.memMap.get((Object)Integer.valueOf((int)a)).content != 0) {
            info = this.myMemory.memMap.get(a++);
            info.comments.add("hight, width, rel y, rel x (from 0,0)");
            info.disTypeCollectionMax = 4;
            info.disType = 1;
            info.typeWasSet = true;
            info = this.myMemory.memMap.get(a++);
            info.disType = 1;
            info.typeWasSet = true;
            info = this.myMemory.memMap.get(a++);
            info.disType = 1;
            info.typeWasSet = true;
            info = this.myMemory.memMap.get(a++);
            info.disType = 1;
            info.typeWasSet = true;
            this.myMemory.memMap.get((Object)Integer.valueOf((int)a)).comments.add("individual title String(s)");
            stringOrg = a;
            this.myMemory.memMap.get((Object)Integer.valueOf((int)stringOrg)).length = 0;
            do {
                info = this.myMemory.memMap.get(a++);
                info.disTypeCollectionMax = 30;
                info.disType = 4;
                info.typeWasSet = true;
                ++this.myMemory.memMap.get((Object)Integer.valueOf((int)stringOrg)).length;
            } while ((info.content & 0xFF) != 128);
            info.disType = 1;
            info.typeWasSet = true;
        }
        this.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disType = 1;
        this.myMemory.memMap.get((Object)Integer.valueOf((int)a)).typeWasSet = true;
        this.myMemory.memMap.get((Object)Integer.valueOf((int)a)).comments.add("end of header");
        this.myMemory.memMap.get((Object)Integer.valueOf((int)(++a))).comments.add("start of cartridge code!");
        this.myMemory.memMap.get((Object)Integer.valueOf((int)a)).labels.add("start");
        return a;
    }

    public void resetInfo() {
        this.myMemory.reset();
        this.myMemory.init();
        this.currentCNTScanBank = 0;
    }

    public void reset() {
        this.myMemory.reset();
        this.myMemory.init();
        this.currentCNTScanBank = 0;
    }

    public String disassemble(byte[] data2, int romStartAddress, int disassemblyStartAddress, boolean assumeVectrexModule) {
        return this.disassemble(data2, romStartAddress, disassemblyStartAddress, assumeVectrexModule, 0);
    }

    public String disassemble(byte[] data2, int romStartAddress, int disassemblyStartAddress, boolean assumeVectrexModule, int bank2) {
        return this.disassemble(data2, romStartAddress, disassemblyStartAddress, assumeVectrexModule, bank2, false);
    }

    public String disassemble(byte[] data2, int romStartAddress, int disassemblyStartAddress, boolean assumeVectrexModule, int bank2, boolean fullMode) {
        int i;
        int len;
        this.myMemory.setBank(bank2, true);
        this.currentCNTScanBank = bank2;
        if (!fullMode) {
            String biosName = null;
            String tmpFile = UtilityFiles.convertSeperator(Global.mainPathPrefix + this.config.usedSystemRom);
            if (new File(tmpFile).exists()) {
                biosName = new File(tmpFile).getName();
            }
            if (biosName == null) {
                biosName = "system.img";
            }
            String biosNameOnly = biosName.substring(0, biosName.indexOf("."));
            if (assumeVectrexModule) {
                int m;
                boolean tmp = this.createLabels;
                this.createLabels = false;
                try {
                    boolean done;
                    if (!this.config.usefilebasedBIOSConstants) {
                        this.supplyBIOSLabels();
                    } else if (this.config.lstFirst) {
                        done = this.readLSTFile(Global.mainPathPrefix + "system" + File.separator + biosNameOnly + ".lst", true);
                        if (!done) {
                            this.readCNTFile(Global.mainPathPrefix + "system" + File.separator + biosNameOnly + ".cnt");
                        }
                    } else {
                        done = this.readCNTFile(Global.mainPathPrefix + "system" + File.separator + biosNameOnly + ".cnt");
                        if (!done) {
                            this.readLSTFile(Global.mainPathPrefix + "system" + File.separator + biosNameOnly + ".lst", true);
                        }
                    }
                    Path path = Paths.get(tmpFile, new String[0]);
                    byte[] biosData = Files.readAllBytes(path);
                    this.disassemble(biosData, 57344, 57344, false, bank2);
                }
                catch (Throwable e) {
                    this.log.addLog("An error occured while loading vectrex bios files. [" + tmpFile + "]", LogPanel.WARN);
                    this.log.addLog("Disassembly will continue without additional BIOS information!", LogPanel.WARN);
                    this.log.addLog(Utility.getStackTrace(e), LogPanel.WARN);
                }
                this.createLabels = tmp;
                for (m = 51200; m <= 52223; ++m) {
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)m)).memType = 0;
                }
                for (m = 53248; m <= 55295; ++m) {
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)m)).memType = 2;
                }
                for (m = 55296; m <= 57343; ++m) {
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)m)).memType = 3;
                }
            }
            if (data2 == null) {
                return "";
            }
        }
        if ((len = data2.length) > 49152) {
            len = 49152;
        }
        this.endOfFile = false;
        for (i = romStartAddress; i < romStartAddress + len; ++i) {
            this.myMemory.buildMemInfo(i, data2[i - romStartAddress]);
        }
        if (romStartAddress == 0 && assumeVectrexModule && (disassemblyStartAddress = this.processVectrexHeader()) == -1) {
            return "";
        }
        if (!fullMode) {
            this.doAllKnownMemoryLocations(romStartAddress, romStartAddress + len);
        }
        i = disassemblyStartAddress;
        while (i < romStartAddress + len) {
            MemoryInformation info = this.myMemory.memMap.get(i);
            if (info.done) {
                i += info.length;
                continue;
            }
            this.disassemble(i);
            i += this.myMemory.memMap.get((Object)Integer.valueOf((int)i)).length;
        }
        return "";
    }

    void reDisassemble(boolean all) {
        int end2 = 49152;
        if (all) {
            end2 = 65536;
        }
        this.doAllKnownMemoryLocations(0, end2);
    }

    public int getInstructionLengthAt(int address) {
        return this.myMemory.memMap.get((Object)Integer.valueOf((int)address)).length;
    }

    public void doAllKnownMemoryLocations(int startDisAddress, int endDisAddress) {
        int i = startDisAddress;
        while (i < endDisAddress) {
            int word;
            MemoryInformation orgInfo;
            boolean inLoop;
            boolean wasDissed = false;
            MemoryInformation info = this.myMemory.memMap.get(i);
            if (info.disType == 0) {
                ++i;
                continue;
            }
            if (info.disType == -2) {
                ++i;
                continue;
            }
            if (info.done && info.disassembledOperand.length() != 0) {
                i += info.length;
                continue;
            }
            if (info.disType == -3) {
                info.length = 0;
                info.disassembledMnemonic = "DB";
                inLoop = false;
                orgInfo = info;
                orgInfo.disassembledOperand = "";
                while (info.disType == -3 && orgInfo.length < orgInfo.disTypeCollectionMax && i + orgInfo.length < 65536) {
                    info.done = true;
                    String c = "";
                    if (inLoop) {
                        c = c + ", ";
                    }
                    c = (info.content & 0xFF) >= 0 && (info.content & 0xFF) < 128 ? c + (info.content & 0xFF) : c + -(256 - (info.content & 0xFF));
                    inLoop = true;
                    orgInfo.disassembledOperand = orgInfo.disassembledOperand + c;
                    ++orgInfo.length;
                    info = this.myMemory.memMap.get(i + orgInfo.length);
                    if (info != null) continue;
                    break;
                }
            } else if (info.disType == 1) {
                info.length = 0;
                info.disassembledMnemonic = "DB";
                inLoop = false;
                orgInfo = info;
                orgInfo.disassembledOperand = "";
                while (info.disType == 1 && orgInfo.length < orgInfo.disTypeCollectionMax && i + orgInfo.length < 65536) {
                    info.done = true;
                    String c = "";
                    if (inLoop) {
                        c = c + ", ";
                    }
                    c = c + DASM6809.DEF.hexPrefix + String.format("%02X", info.content & 0xFF);
                    inLoop = true;
                    orgInfo.disassembledOperand = orgInfo.disassembledOperand + c;
                    ++orgInfo.length;
                    info = this.myMemory.memMap.get(i + orgInfo.length);
                    if (info != null) continue;
                    break;
                }
            } else if (info.disType == 5) {
                info.length = 0;
                info.disassembledMnemonic = "DB";
                inLoop = false;
                orgInfo = info;
                orgInfo.disassembledOperand = "";
                while (info.disType == 5 && orgInfo.length < orgInfo.disTypeCollectionMax && i + orgInfo.length < 65536) {
                    info.done = true;
                    String c = "";
                    if (inLoop) {
                        c = c + ", ";
                    }
                    c = c + "%" + DASM6809.printbinary(info.content & 0xFF);
                    inLoop = true;
                    orgInfo.disassembledOperand = orgInfo.disassembledOperand + c;
                    ++orgInfo.length;
                    info = this.myMemory.memMap.get(i + orgInfo.length);
                    if (info != null) continue;
                    break;
                }
            } else if (info.disType == 2) {
                info.length = 0;
                info.disassembledMnemonic = "DW";
                inLoop = false;
                orgInfo = info;
                orgInfo.disassembledOperand = "";
                while (info.disType == 2 && orgInfo.length < orgInfo.disTypeCollectionMax && i + orgInfo.length < 65536) {
                    info.done = true;
                    word = (info.content & 0xFF) * 256;
                    word += this.myMemory.memMap.get((Object)Integer.valueOf((int)(info.address + 1))).content & 0xFF;
                    String c = "";
                    if (inLoop) {
                        c = c + ", ";
                    }
                    c = c + DASM6809.DEF.hexPrefix + String.format("%04X", word);
                    inLoop = true;
                    orgInfo.disassembledOperand = orgInfo.disassembledOperand + c;
                    orgInfo.length += 2;
                    info = this.myMemory.memMap.get(i + orgInfo.length);
                    if (info != null) continue;
                    break;
                }
            } else if (info.disType == 3) {
                info.length = 0;
                info.disassembledMnemonic = "DW";
                inLoop = false;
                orgInfo = info;
                orgInfo.disassembledOperand = "";
                while (info.disType == 3 && orgInfo.length < orgInfo.disTypeCollectionMax && i + orgInfo.length < 65536) {
                    info.done = true;
                    word = (info.content & 0xFF) * 256;
                    word += this.myMemory.memMap.get((Object)Integer.valueOf((int)(info.address + 1))).content & 0xFF;
                    String c = "";
                    if (inLoop) {
                        c = c + ", ";
                    }
                    inLoop = true;
                    if (this.myMemory.memMap.get((Object)Integer.valueOf((int)word)).labels.size() > 0) {
                        c = c + this.myMemory.memMap.get((Object)Integer.valueOf((int)word)).labels.get(0);
                    } else {
                        this.myMemory.memMap.get((Object)Integer.valueOf((int)word)).labels.add("_" + String.format("%04X", word));
                        c = c + this.myMemory.memMap.get((Object)Integer.valueOf((int)word)).labels.get(0);
                    }
                    orgInfo.disassembledOperand = orgInfo.disassembledOperand + c;
                    orgInfo.length += 2;
                    info = this.myMemory.memMap.get(i + orgInfo.length);
                    if (info != null) continue;
                    break;
                }
            } else if (info.disType == 4) {
                if ((info.content & 0xFF) < 32 || (info.content & 0xFF) > 126) {
                    info.disType = 1;
                    info.length = 1;
                    continue;
                }
                info.length = 0;
                info.disassembledMnemonic = "DB";
                info.disassembledOperand = "\"";
                boolean mustClose = true;
                boolean inLoop2 = false;
                orgInfo = info;
                while (info.disType == 4 && orgInfo.length < orgInfo.disTypeCollectionMax && i + orgInfo.length < 65536) {
                    info.done = true;
                    char c = (char)(info.content & 0xFF);
                    inLoop2 = true;
                    ++orgInfo.length;
                    if ((info.content & 0xFF) == 0) {
                        orgInfo.disassembledOperand = orgInfo.disassembledOperand + "\"";
                        mustClose = false;
                        if (inLoop2) {
                            orgInfo.disassembledOperand = orgInfo.disassembledOperand + ", ";
                        }
                        orgInfo.disassembledOperand = orgInfo.disassembledOperand + DASM6809.DEF.hexPrefix + "00";
                        break;
                    }
                    if ((info.content & 0xFF) == 128) {
                        orgInfo.disassembledOperand = orgInfo.disassembledOperand + "\"";
                        mustClose = false;
                        if (inLoop2) {
                            orgInfo.disassembledOperand = orgInfo.disassembledOperand + ", ";
                        }
                        orgInfo.disassembledOperand = orgInfo.disassembledOperand + DASM6809.DEF.hexPrefix + String.format("%02X", info.content & 0xFF);
                        break;
                    }
                    orgInfo.disassembledOperand = orgInfo.disassembledOperand + c;
                    info = this.myMemory.memMap.get(i + orgInfo.length);
                }
                if (mustClose) {
                    orgInfo.disassembledOperand = orgInfo.disassembledOperand + "\"";
                }
                if (orgInfo.length < orgInfo.disTypeCollectionMax && (this.myMemory.memMap.get((Object)Integer.valueOf((int)(i + orgInfo.length))).content & 0xFF) == 128) {
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)(i + orgInfo.length))).done = true;
                    orgInfo.disassembledOperand = orgInfo.disassembledOperand + ", " + DASM6809.DEF.hexPrefix + String.format("%02X", this.myMemory.memMap.get((Object)Integer.valueOf((int)(i + orgInfo.length))).content & 0xFF);
                    ++orgInfo.length;
                }
            } else {
                this.disassemble(i);
                wasDissed = true;
            }
            if (!wasDissed) {
                for (int off = 0; off < this.myMemory.memMap.get((Object)Integer.valueOf((int)i)).length; ++off) {
                    this.myMemory.memMap.get((Object)Integer.valueOf((int)(i + off))).done = true;
                }
            }
            i += this.myMemory.memMap.get((Object)Integer.valueOf((int)i)).length;
        }
    }

    private void addNewBranches(MemoryInformation info) {
        DASMStatics.Opcodeinfo op = null;
        int page2 = info.page;
        if (page2 == 0) {
            op = pg1opcodes[info.indexInOpcodeTablePage0];
        }
        if (page2 == 1) {
            op = pg2opcodes[this.myMemory.memMap.get((Object)Integer.valueOf((int)(info.address + 1))).indexInOpcodeTablePage1];
        }
        if (page2 == 2) {
            op = pg3opcodes[this.myMemory.memMap.get((Object)Integer.valueOf((int)(info.address + 1))).indexInOpcodeTablePage2];
        }
        if (op.opcode != 14 || op.opcode != 101 || op.opcode != 126 || op.opcode != 147 || op.opcode != 173 || op.opcode != 189 || op.opcode != 22 || op.opcode != 23 || op.opcode != 141 || op.opcode != 63 || op.opcode < 32 || op.opcode <= 47) {
            // empty if block
        }
    }

    String spaceTo(String l, int to) {
        while (l.length() < to) {
            l = l + " ";
        }
        return l;
    }

    String getOutPutString(int startAdress, int length) {
        String ret = "";
        for (int i = startAdress; i < startAdress + length; i += this.myMemory.memMap.get((Object)Integer.valueOf((int)i)).length) {
            MemoryInformation info = this.myMemory.memMap.get(i);
            for (String l : info.labels) {
                ret = ret + "" + l + ":\n";
            }
            String line = "";
            line = this.spaceTo(line, 22);
            line = line + info.disassembledMnemonic;
            line = this.spaceTo(line, 31);
            line = line + info.disassembledOperand;
            for (String l : info.comments) {
                line = this.spaceTo(line, 55);
                line = line + ";" + l;
                ret = ret + line + "\n";
                line = "";
            }
            if (line.length() == 0) continue;
            ret = ret + line + "\n";
        }
        return ret;
    }

    public boolean tryLoadList(String name) {
        if (name == null) {
            return false;
        }
        int li = name.lastIndexOf(".");
        if (li < 0) {
            return false;
        }
        File f = new File(name = name.substring(0, li) + ".lst");
        if (!f.exists()) {
            return false;
        }
        this.readLSTFile(name, false);
        return true;
    }

    public boolean tryLoadCNT(String name) {
        if (name == null) {
            return false;
        }
        int li = name.lastIndexOf(".");
        if (li < 0) {
            return false;
        }
        File f = new File(name = name.substring(0, li) + ".cnt");
        if (f.exists()) {
            this.readCNTFile(name);
            return true;
        }
        String nameOnly = name;
        if (nameOnly.contains(File.separator)) {
            nameOnly = nameOnly.substring(nameOnly.lastIndexOf(File.separator) + 1);
        }
        if ((f = new File(name = "cnt" + File.separator + nameOnly)).exists()) {
            this.readCNTFile(name);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readLSTFile(String name, boolean allowBios) {
        try (BufferedReader br = new BufferedReader(new FileReader(name));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            int lastAddress = 0;
            int count = 0;
            boolean islwasm = this.checkLWAsm(line);
            while (true) {
                lastAddress = !islwasm ? this.doOneLSTLine(line, lastAddress, allowBios) : this.doOneLWASMLSTLine(line, lastAddress, allowBios);
                line = br.readLine();
                if (line == null) {
                    boolean bl = true;
                    return bl;
                }
                ++count;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    static String[] removeEmpty(String[] s) {
        ArrayList<String> as = new ArrayList<String>();
        for (String ss : s) {
            if (ss.length() <= 0) continue;
            as.add(ss);
        }
        return as.toArray(new String[0]);
    }

    private int doOneLSTLine(String line, int lastAddress, boolean allowBios) {
        String[] s = DASM6809.removeEmpty(line.split(" "));
        int adr = lastAddress;
        String[] lr = DASM6809.removeEmpty(line.split("\\|"));
        String[] r = null;
        String[] l = null;
        if (lr.length > 0) {
            l = DASM6809.removeEmpty(lr[0].split(" "));
        }
        if (lr.length > 1) {
            r = DASM6809.removeEmpty(lr[1].split(" "));
        }
        if (r != null && r.length > 0 && !r[0].startsWith(";") && !r[0].startsWith("*")) {
            if (lr[1].startsWith(r[0])) {
                String label = r[0].endsWith(":") ? r[0].substring(0, r[0].length() - 1) : r[0];
                String address = "$" + s[0];
                int adress = DASM6809.toNumber(address);
                if (!allowBios && adress >= 53248) {
                    return adress;
                }
                MemoryInformation info = this.myMemory.memMap.get(adress);
                if (info == null) {
                    info = this.myMemory.buildMemInfo(adress);
                }
                if (!info.hasLabel(label)) {
                    info.labels.add(label);
                }
                return adress;
            }
            if (r[0].endsWith(":")) {
                String address = "$" + s[0];
                String label = r[0].substring(0, r[0].length() - 1);
                int adress = DASM6809.toNumber(address);
                if (!allowBios && adress >= 53248) {
                    return adress;
                }
                MemoryInformation info = this.myMemory.memMap.get(adress);
                if (info == null) {
                    info = this.myMemory.buildMemInfo(adress);
                }
                if (!info.hasLabel(label)) {
                    info.labels.add(label);
                }
                return adress;
            }
        }
        if (s.length == 0) {
            return adr;
        }
        if (s.length == 4 && s[1].equals(":")) {
            String address = s[2];
            String label = s[0];
            int adress = DASM6809.toNumber("$" + address);
            if (adress < 0) {
                return lastAddress;
            }
            if (!allowBios && adress >= 53248) {
                return adress;
            }
            MemoryInformation info = this.myMemory.memMap.get(adress);
            if (info == null) {
                info = this.myMemory.buildMemInfo(adress);
            }
            if (!info.hasLabel(label)) {
                info.labels.add(label);
            }
            return adress;
        }
        if (s[s.length - 1].endsWith(":")) {
            String address = s[0];
            String label = s[s.length - 1].substring(0, s[s.length - 1].length() - 1);
            int adress = DASM6809.toNumber("$" + address);
            if (adress < 0) {
                return lastAddress;
            }
            if (!allowBios && adress >= 53248) {
                return adress;
            }
            MemoryInformation info = this.myMemory.memMap.get(adress);
            if (info == null) {
                info = this.myMemory.buildMemInfo(adress);
            }
            if (!info.hasLabel(label)) {
                info.labels.add(label);
            }
            return adress;
        }
        if (s.length == 4) {
            // empty if block
        }
        if (line.length() < 8) {
            return lastAddress;
        }
        if (line.trim().startsWith("*")) {
            if (lastAddress == -1) {
                return lastAddress;
            }
            MemoryInformation info = this.myMemory.memMap.get(lastAddress);
            info.comments.add(line.trim());
            return lastAddress;
        }
        if (line.substring(4, 7).equals(" : ")) {
            int address = DASM6809.toNumber("$" + line.substring(0, 4));
            MemoryInformation info = this.myMemory.memMap.get(address);
            adr = address;
            if (info == null) {
                info = this.myMemory.buildMemInfo(address);
            }
            if (address >= 0) {
                int c = line.indexOf(";");
                if (c > 0) {
                    String comment = line.substring(c);
                    info.comments.add(comment);
                } else {
                    c = line.length();
                }
                line = line.substring(0, c);
                int reduce = 5;
                c = line.toUpperCase().indexOf(" FCC ");
                if (c < 0) {
                    c = line.toUpperCase().indexOf(" DB ");
                    if (c >= 0 && line.substring(c).split("\"").length != 2) {
                        c = -1;
                    }
                    reduce = 4;
                }
                if (c >= 0) {
                    String[] spl = DASM6809.removeEmpty((line = line.substring(c + reduce)).trim().split("\""));
                    if (spl.length == 0) {
                        return address;
                    }
                    int cc = 0;
                    for (int i = address; i < address + spl[0].length(); ++i) {
                        info = this.myMemory.memMap.get(i);
                        if (info == null) {
                            info = this.myMemory.buildMemInfo(address);
                        }
                        info.disType = 4;
                        info.typeWasSet = true;
                        info.length = spl[0].length() - cc;
                        info.disTypeCollectionMax = spl[0].length() - cc++;
                    }
                    return address;
                }
                reduce = 5;
                c = line.toUpperCase().indexOf(" FCB ");
                if (c < 0) {
                    reduce = 4;
                    c = line.toUpperCase().indexOf(" DB ");
                }
                if (c >= 0) {
                    line = line.substring(c + reduce);
                    String[] spl = DASM6809.removeEmpty(line.split(","));
                    int cc = 0;
                    for (int i = address; i < address + spl.length; ++i) {
                        info = this.myMemory.memMap.get(i);
                        if (info == null) {
                            info = this.myMemory.buildMemInfo(address);
                        }
                        info.disType = 1;
                        info.typeWasSet = true;
                        info.length = spl.length - cc++;
                        info.disassembledMnemonic = "DB";
                    }
                    return address;
                }
                reduce = 5;
                c = line.toUpperCase().indexOf(" FDB ");
                if (c < 0) {
                    reduce = 4;
                    c = line.toUpperCase().indexOf(" DW ");
                }
                if (c >= 0) {
                    line = line.substring(c + reduce);
                    String[] spl = DASM6809.removeEmpty(line.split(","));
                    for (int i = address; i < address + spl.length * 2; ++i) {
                        info = this.myMemory.memMap.get(i);
                        if (info == null) {
                            info = this.myMemory.buildMemInfo(address);
                        }
                        info.disType = 2;
                        info.typeWasSet = true;
                        info.length = 2;
                        info.disassembledMnemonic = "DW";
                    }
                    return address;
                }
                String[] spl = DASM6809.removeEmpty(line.split(" "));
                if (spl.length > 5) {
                    if (spl[3].equals("[") && spl[3].indexOf("]") >= 0) {
                        info = this.myMemory.memMap.get(address);
                        if (info == null) {
                            info = this.myMemory.buildMemInfo(address);
                        }
                        info.disType = 6;
                        info.typeWasSet = true;
                    }
                    return address;
                }
            }
        }
        return adr;
    }

    private void doRangeLine(int rangeStart, int rangeEnd, String type, int maxSame) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            MemoryInformation info;
            if (type.trim().toUpperCase().equals("DEC_DATA")) {
                if (maxSame == 0) {
                    maxSame = 8;
                }
                info = this.myMemory.buildMemInfo(i);
                info.disType = -3;
                info.typeWasSet = true;
                info.disTypeCollectionMax = maxSame;
            }
            if (type.trim().toUpperCase().equals("DB_DATA")) {
                if (maxSame == 0) {
                    maxSame = 8;
                }
                info = this.myMemory.buildMemInfo(i);
                info.disType = 1;
                info.typeWasSet = true;
                info.disTypeCollectionMax = maxSame;
            }
            if (type.trim().toUpperCase().equals("BIN_DATA")) {
                if (maxSame == 0) {
                    maxSame = 8;
                }
                info = this.myMemory.buildMemInfo(i);
                info.disType = 5;
                info.typeWasSet = true;
                info.disTypeCollectionMax = maxSame;
            }
            if (type.trim().toUpperCase().equals("DW_DATA")) {
                if (maxSame == 0) {
                    maxSame = 4;
                }
                info = this.myMemory.buildMemInfo(i);
                info.disType = 2;
                info.typeWasSet = true;
                info.disTypeCollectionMax = maxSame;
            }
            if (type.trim().toUpperCase().equals("DWP_DATA")) {
                if (maxSame == 0) {
                    maxSame = 1;
                }
                info = this.myMemory.buildMemInfo(i);
                info.disType = 3;
                info.typeWasSet = true;
                info.disTypeCollectionMax = maxSame;
            }
            if (type.trim().toUpperCase().equals("DW_POINTER")) {
                if (maxSame == 0) {
                    maxSame = 1;
                }
                info = this.myMemory.buildMemInfo(i);
                info.disType = 3;
                info.typeWasSet = true;
                info.disTypeCollectionMax = maxSame;
            }
            if (type.trim().toUpperCase().equals("CHAR_DATA")) {
                if (maxSame == 0) {
                    maxSame = 20;
                }
                info = this.myMemory.buildMemInfo(i);
                info.disType = 4;
                info.typeWasSet = true;
                info.disTypeCollectionMax = maxSame;
            }
            if (type.trim().toUpperCase().equals("CODE")) {
                info = this.myMemory.buildMemInfo(i);
                info.disType = 0;
                info.disType = -1;
                info.typeWasSet = true;
            }
            if (!type.trim().toUpperCase().equals("DP")) continue;
            info = this.myMemory.buildMemInfo(i);
            info.directPageAddress = maxSame;
        }
    }

    private void doOneCNTLine(String line) {
        block87: {
            String[] s;
            block95: {
                String address;
                String[] s2;
                block94: {
                    block93: {
                        block92: {
                            block91: {
                                block90: {
                                    block89: {
                                        block88: {
                                            block86: {
                                                if ((line = line.trim()).toUpperCase().startsWith("HIGHEST_USED_RAM")) {
                                                    s2 = line.split(" ");
                                                    if ((s2 = DASM6809.removeEmpty(s2)).length > 1) {
                                                        address = s2[1];
                                                        this.myMemory.highestUserRAM = DASM6809.toNumber(address);
                                                    }
                                                }
                                                if (line.toUpperCase().startsWith("C_INFO_BLOCK")) {
                                                    MemoryInformation.MemCInfoBlock infBlock = new MemoryInformation.MemCInfoBlock();
                                                    s = (line = line.substring("C_INFO_BLOCK".length()).trim()).split(" ");
                                                    String address2 = s[0];
                                                    int adress = DASM6809.toNumber(address2);
                                                    if (adress < 0) {
                                                        return;
                                                    }
                                                    if (adress > 65536) {
                                                        return;
                                                    }
                                                    infBlock.address = adress;
                                                    String filename = line.substring(line.indexOf("\"") + 1, line.indexOf("\"FN_END"));
                                                    String subLine = line.substring(line.indexOf("\"FN_END") + "\"FN_END".length()).trim();
                                                    s = subLine.split(" ");
                                                    s = DASM6809.removeEmpty(s);
                                                    String linenoS = s[0];
                                                    int lineNo = DASM6809.toNumber(linenoS);
                                                    subLine = subLine.substring(linenoS.length() + 1).trim();
                                                    String cline = subLine.substring(subLine.indexOf("\"") + 1, subLine.lastIndexOf("\""));
                                                    boolean hasBreakPoint = line.contains("BKPOINT=1");
                                                    infBlock.address = adress;
                                                    infBlock.lineNo = lineNo;
                                                    infBlock.file = filename;
                                                    infBlock.lineString = cline;
                                                    MemoryInformation info = this.myMemory.memMap.get(adress);
                                                    if (info == null) {
                                                        info = this.myMemory.buildMemInfo(adress);
                                                    }
                                                    info.cInfo = infBlock;
                                                    if (hasBreakPoint) {
                                                        info.comments.add("; hey dissi \"break\"");
                                                    }
                                                    return;
                                                }
                                                if (line.toUpperCase().startsWith("BANK")) {
                                                    int newbank;
                                                    this.currentCNTScanBank = 0;
                                                    line = line.substring(5).trim();
                                                    this.currentCNTScanBank = newbank = DASM6809.toNumber(line);
                                                    this.myMemory.setBank(this.currentCNTScanBank, true);
                                                    return;
                                                }
                                                if (line.toUpperCase().startsWith("START_BANK")) {
                                                    int newbank;
                                                    this.currentCNTScanBank = 0;
                                                    line = line.substring(10).trim();
                                                    this.currentCNTScanBank = newbank = DASM6809.toNumber(line);
                                                    this.myMemory.setBank(this.currentCNTScanBank, true);
                                                    return;
                                                }
                                                if (line.toUpperCase().startsWith("END_BANK")) {
                                                    this.currentCNTScanBank = 0;
                                                    this.myMemory.setBank(this.currentCNTScanBank, true);
                                                    return;
                                                }
                                                if (!line.toUpperCase().startsWith("RANGE")) break block86;
                                                line = line.substring(5).trim().replaceAll("-", " ");
                                                s2 = (line = UtilityString.replace(line, "  ", " ")).split(" ");
                                                if (s2.length < 3) {
                                                    return;
                                                }
                                                int rangeStart = DASM6809.toNumber(s2[0]);
                                                int rangeEnd = DASM6809.toNumber(s2[1]);
                                                if (rangeEnd == 0) {
                                                    return;
                                                }
                                                if (rangeEnd < rangeStart) {
                                                    return;
                                                }
                                                String type = s2[2];
                                                int maxSame = 0;
                                                if (s2.length > 3) {
                                                    maxSame = DASM6809.toNumber(s2[3]);
                                                }
                                                this.doRangeLine(rangeStart, rangeEnd, type, maxSame);
                                                break block87;
                                            }
                                            if (!line.toUpperCase().startsWith("EQU")) break block88;
                                            line = line.substring(3).trim();
                                            line = UtilityString.replace(line, "  ", " ");
                                            s2 = line.split(" ");
                                            address = s2[0];
                                            String label = line.substring(address.length()).trim();
                                            int adress = DASM6809.toNumber(address);
                                            if (adress < 0) {
                                                return;
                                            }
                                            if (adress > 65536) {
                                                return;
                                            }
                                            MemoryInformation info = this.myMemory.memMap.get(adress);
                                            if (info == null) {
                                                info = this.myMemory.buildMemInfo(adress);
                                            }
                                            if (!info.hasImmediateLabel(label)) {
                                                info.immediateLabels.add(label);
                                            }
                                            if (info.hasLabel(label)) break block87;
                                            info.labels.add(label);
                                            break block87;
                                        }
                                        if (!line.toUpperCase().startsWith("DIRECT_LABEL")) break block89;
                                        line = line.substring(12).trim();
                                        s2 = (line = UtilityString.replace(line, "  ", " ")).split(" ");
                                        if (s2.length < 3) {
                                            return;
                                        }
                                        String label = s2[2];
                                        int dp = DASM6809.toNumber(s2[0]);
                                        int adress = DASM6809.toNumber(s2[1]);
                                        if (adress < 0) {
                                            return;
                                        }
                                        if (adress > 65536) {
                                            return;
                                        }
                                        if (dp < 0) {
                                            return;
                                        }
                                        if (dp > 65536) {
                                            return;
                                        }
                                        HashMap<Integer, String> map = this.myMemory.directLabels.get(dp);
                                        if (map == null) {
                                            map = new HashMap();
                                            this.myMemory.directLabels.put(dp, map);
                                        }
                                        map.put(adress, label);
                                        break block87;
                                    }
                                    if (!line.toUpperCase().startsWith("LABEL")) break block90;
                                    line = line.substring(5).trim();
                                    line = UtilityString.replace(line, "  ", " ");
                                    s2 = line.split(" ");
                                    address = s2[0];
                                    String label = line.substring(address.length()).trim();
                                    int adress = DASM6809.toNumber(address);
                                    if (adress < 0) {
                                        return;
                                    }
                                    if (adress > 65536) {
                                        return;
                                    }
                                    MemoryInformation info = this.myMemory.memMap.get(adress);
                                    if (info == null) {
                                        info = this.myMemory.buildMemInfo(adress);
                                    }
                                    if (info.hasLabel(label)) break block87;
                                    info.labels.add(label);
                                    break block87;
                                }
                                if (!line.toUpperCase().startsWith("FORCE_SYMBOL")) break block91;
                                line = line.substring("FORCE_SYMBOL".length()).trim();
                                line = UtilityString.replace(line, "  ", " ");
                                s2 = line.split(" ");
                                address = s2[0];
                                String symbol = line.substring(address.length()).trim();
                                int adress = DASM6809.toNumber(address);
                                if (adress < 0) {
                                    return;
                                }
                                if (adress > 65536) {
                                    return;
                                }
                                MemoryInformation info = this.myMemory.memMap.get(adress);
                                if (info == null) {
                                    info = this.myMemory.buildMemInfo(adress);
                                }
                                info.forcedSymbol = symbol;
                                break block87;
                            }
                            if (!line.toUpperCase().startsWith("FORCE_NO_SYMBOL")) break block92;
                            line = line.substring("FORCE_NO_SYMBOL".length()).trim();
                            s2 = (line = UtilityString.replace(line, "  ", " ")).split(" ");
                            address = s2[0];
                            int adress = DASM6809.toNumber(address);
                            if (adress < 0) {
                                return;
                            }
                            if (adress > 65536) {
                                return;
                            }
                            MemoryInformation info = this.myMemory.memMap.get(adress);
                            if (info == null) {
                                info = this.myMemory.buildMemInfo(adress);
                            }
                            info.forcedSymbol = "";
                            break block87;
                        }
                        if (!line.toUpperCase().startsWith("COMMENT_LABEL")) break block93;
                        line = line.substring(13).trim();
                        s2 = line.split(" ");
                        address = s2[0];
                        String comment = line.substring(address.length()).trim();
                        int adress = DASM6809.toNumber(address);
                        if (adress < 0) {
                            return;
                        }
                        if (adress >= 65536) {
                            return;
                        }
                        MemoryInformation info = this.myMemory.memMap.get(adress);
                        if (info == null) {
                            info = this.myMemory.buildMemInfo(adress);
                        }
                        if (info.hasComment(comment)) break block87;
                        info.comments.add(comment);
                        break block87;
                    }
                    if (!line.toUpperCase().startsWith("COMMENT_LINE")) break block94;
                    line = line.substring(12).trim();
                    s2 = line.split(" ");
                    address = s2[0];
                    String comment = line.substring(address.length()).trim();
                    int adress = DASM6809.toNumber(address);
                    if (adress < 0) {
                        return;
                    }
                    if (adress >= 65536) {
                        return;
                    }
                    MemoryInformation info = this.myMemory.memMap.get(adress);
                    if (info == null) {
                        info = this.myMemory.buildMemInfo(adress);
                    }
                    if (info.hasComment(comment)) break block87;
                    info.comments.add(comment);
                    break block87;
                }
                if (!line.toUpperCase().startsWith("COMMENT")) break block95;
                line = line.substring(7).trim();
                s2 = line.split(" ");
                address = s2[0];
                String comment = line.substring(address.length()).trim();
                int adress = DASM6809.toNumber(address);
                if (adress < 0) {
                    return;
                }
                if (adress >= 65536) {
                    return;
                }
                MemoryInformation info = this.myMemory.memMap.get(adress);
                if (info == null) {
                    info = this.myMemory.buildMemInfo(adress);
                }
                if (info.hasComment(comment)) break block87;
                info.comments.add(comment);
                break block87;
            }
            if (line.toUpperCase().startsWith("VTEXT")) {
                int max = 30;
                line = line.substring(5).trim();
                s = line.split(" ");
                String address1 = s[0];
                String address2 = s.length == 1 ? address1 : s[1];
                if (s.length == 3) {
                    max = DASM6809.toNumber(s[2]);
                }
                int adress1 = DASM6809.toNumber(address1);
                int adress2 = DASM6809.toNumber(address2);
                if (adress1 < 0) {
                    return;
                }
                if (adress1 < 65536) {
                    return;
                }
                if (adress2 < 0) {
                    return;
                }
                if (adress2 < 65536) {
                    return;
                }
                for (int a = adress1; a <= adress2; ++a) {
                    MemoryInformation info = this.myMemory.memMap.get(a);
                    if (info == null) {
                        info = this.myMemory.buildMemInfo(a);
                    }
                    info.disType = 4;
                    info.typeWasSet = true;
                    info.length = 1;
                    info.disTypeCollectionMax = max;
                }
            } else if (line.toUpperCase().startsWith("DATA_DECIMAL")) {
                int max = 4;
                line = line.substring(5).trim();
                line = UtilityString.replace(line, "  ", " ");
                s = line.split(" ");
                String address1 = s[0];
                String address2 = s.length == 1 ? address1 : s[1];
                if (s.length == 3) {
                    max = DASM6809.toNumber(s[2]);
                }
                int adress1 = DASM6809.toNumber(address1);
                int adress2 = DASM6809.toNumber(address2);
                if (adress1 < 0) {
                    return;
                }
                if (adress1 < 65536) {
                    return;
                }
                if (adress2 < 0) {
                    return;
                }
                if (adress2 < 65536) {
                    return;
                }
                for (int a = adress1; a <= adress2; ++a) {
                    MemoryInformation info = this.myMemory.memMap.get(a);
                    if (info == null) {
                        info = this.myMemory.buildMemInfo(a);
                    }
                    info.disType = -3;
                    info.typeWasSet = true;
                    info.disTypeCollectionMax = max;
                    info.length = 1;
                }
            } else if (line.toUpperCase().startsWith("DATA_BYTE")) {
                int max = 4;
                line = line.substring(5).trim();
                line = UtilityString.replace(line, "  ", " ");
                s = line.split(" ");
                String address1 = s[0];
                String address2 = s.length == 1 ? address1 : s[1];
                if (s.length == 3) {
                    max = DASM6809.toNumber(s[2]);
                }
                int adress1 = DASM6809.toNumber(address1);
                int adress2 = DASM6809.toNumber(address2);
                if (adress1 < 0) {
                    return;
                }
                if (adress1 < 65536) {
                    return;
                }
                if (adress2 < 0) {
                    return;
                }
                if (adress2 < 65536) {
                    return;
                }
                for (int a = adress1; a <= adress2; ++a) {
                    MemoryInformation info = this.myMemory.memMap.get(a);
                    if (info == null) {
                        info = this.myMemory.buildMemInfo(a);
                    }
                    info.disType = 1;
                    info.typeWasSet = true;
                    info.disTypeCollectionMax = max;
                    info.length = 1;
                }
            } else if (line.toUpperCase().startsWith("DATA_BINARY")) {
                int max = 4;
                line = line.substring(5).trim();
                line = UtilityString.replace(line, "  ", " ");
                s = line.split(" ");
                String address1 = s[0];
                String address2 = s.length == 1 ? address1 : s[1];
                if (s.length == 3) {
                    max = DASM6809.toNumber(s[2]);
                }
                int adress1 = DASM6809.toNumber(address1);
                int adress2 = DASM6809.toNumber(address2);
                if (adress1 < 0) {
                    return;
                }
                if (adress1 < 65536) {
                    return;
                }
                if (adress2 < 0) {
                    return;
                }
                if (adress2 < 65536) {
                    return;
                }
                for (int a = adress1; a <= adress2; ++a) {
                    MemoryInformation info = this.myMemory.memMap.get(a);
                    if (info == null) {
                        info = this.myMemory.buildMemInfo(a);
                    }
                    info.disType = 5;
                    info.typeWasSet = true;
                    info.disTypeCollectionMax = max;
                    info.length = 1;
                }
            } else if (line.toUpperCase().startsWith("DATA_WORD")) {
                int max = 1;
                line = line.substring(5).trim();
                line = UtilityString.replace(line, "  ", " ");
                s = line.split(" ");
                String address1 = s[0];
                String address2 = s.length == 1 ? address1 : s[1];
                if (s.length == 3) {
                    max = DASM6809.toNumber(s[2]);
                }
                int adress1 = DASM6809.toNumber(address1);
                int adress2 = DASM6809.toNumber(address2);
                if (adress1 < 0) {
                    return;
                }
                if (adress1 < 65536) {
                    return;
                }
                if (adress2 < 0) {
                    return;
                }
                if (adress2 < 65536) {
                    return;
                }
                for (int a = adress1; a <= adress2; ++a) {
                    MemoryInformation info = this.myMemory.memMap.get(a);
                    if (info == null) {
                        info = this.myMemory.buildMemInfo(a);
                    }
                    info.disType = 2;
                    info.typeWasSet = true;
                    info.disTypeCollectionMax = max;
                    info.length = 1;
                }
            }
        }
    }

    public void supplyBIOSLabels() {
        MemoryInformation info;
        String label;
        Integer adress;
        for (Map.Entry<Integer, String> entry : BIOSLABELS.entrySet()) {
            adress = entry.getKey();
            label = entry.getValue();
            info = this.myMemory.memMap.get(adress);
            if (info == null) {
                info = this.myMemory.buildMemInfo(adress);
            }
            if (info.hasLabel(label)) continue;
            info.labels.add(label);
        }
        for (Map.Entry<Integer, String> entry : BIOSLABELS2.entrySet()) {
            adress = entry.getKey();
            label = entry.getValue();
            info = this.myMemory.memMap.get(adress);
            if (info == null) {
                info = this.myMemory.buildMemInfo(adress);
            }
            if (info.hasLabel(label)) continue;
            info.labels.add(label);
        }
        for (Map.Entry<Integer, String> entry : BIOSFUNCTIONS.entrySet()) {
            adress = entry.getKey();
            label = entry.getValue();
            info = this.myMemory.memMap.get(adress);
            if (info == null) {
                info = this.myMemory.buildMemInfo(adress);
            }
            if (info.hasLabel(label)) continue;
            info.labels.add(label);
        }
    }

    boolean checkLWAsm(String firstLine) {
        if (firstLine.length() < 23) {
            return false;
        }
        return firstLine.substring(22, 23).equals("(");
    }

    private int doOneLWASMLSTLine(String _line, int lastAddress, boolean allowBios) {
        int adress = lastAddress;
        if (_line.length() > 5) {
            String adr = _line.substring(0, 4);
            adress = DASM6809.toNumber("$" + adr);
            if (adress == 0) {
                return lastAddress;
            }
        }
        if (!allowBios && adress >= 53248) {
            return adress;
        }
        MemoryInformation info = this.myMemory.memMap.get(adress);
        if (info == null) {
            info = this.myMemory.buildMemInfo(adress);
        }
        String line = "";
        if (_line.length() > 65) {
            line = _line.substring(64);
        }
        String[] s = DASM6809.removeEmpty(line.split(" "));
        int adr = lastAddress;
        String[] r = DASM6809.removeEmpty(line.split(" "));
        if (r != null && r.length > 0 && !r[0].startsWith(";") && !r[0].startsWith("*")) {
            if (line.startsWith(r[0])) {
                String label = r[0].endsWith(":") ? r[0].substring(0, r[0].length() - 1) : r[0];
                if (!info.hasLabel(label)) {
                    info.labels.add(label);
                }
                return adress;
            }
            if (r[0].endsWith(":")) {
                String address = "$" + s[0];
                String label = r[0].substring(0, r[0].length() - 1);
                if (!info.hasLabel(label)) {
                    info.labels.add(label);
                }
                return adress;
            }
        }
        if (s.length == 0) {
            return adr;
        }
        if (s.length == 4 && s[1].equals(":")) {
            String label = s[0];
            if (!info.hasLabel(label)) {
                info.labels.add(label);
            }
            return adress;
        }
        if (s[s.length - 1].endsWith(":")) {
            String label = s[s.length - 1].substring(0, s[s.length - 1].length() - 1);
            if (!info.hasLabel(label)) {
                info.labels.add(label);
            }
            return adress;
        }
        if (s.length == 4) {
            // empty if block
        }
        if (line.length() < 8) {
            return lastAddress;
        }
        if (line.trim().startsWith("*")) {
            if (lastAddress == -1) {
                return lastAddress;
            }
            info.comments.add(line.trim());
            return lastAddress;
        }
        if (line.substring(4, 7).equals(" : ")) {
            adr = adress;
            if (adress >= 0) {
                int c = line.indexOf(";");
                if (c > 0) {
                    String comment = line.substring(c);
                    info.comments.add(comment);
                } else {
                    c = line.length();
                }
                line = line.substring(0, c);
                int reduce = 5;
                c = line.toUpperCase().indexOf(" FCC ");
                if (c < 0) {
                    c = line.toUpperCase().indexOf(" DB ");
                    if (c >= 0 && line.substring(c).split("\"").length != 2) {
                        c = -1;
                    }
                    reduce = 4;
                }
                if (c >= 0) {
                    String[] spl = DASM6809.removeEmpty((line = line.substring(c + reduce)).trim().split("\""));
                    if (spl.length == 0) {
                        return adress;
                    }
                    int cc = 0;
                    for (int i = adress; i < adress + spl[0].length(); ++i) {
                        info = this.myMemory.memMap.get(i);
                        if (info == null) {
                            info = this.myMemory.buildMemInfo(adress);
                        }
                        info.disType = 4;
                        info.typeWasSet = true;
                        info.length = spl[0].length() - cc;
                        info.disTypeCollectionMax = spl[0].length() - cc++;
                    }
                    return adress;
                }
                reduce = 5;
                c = line.toUpperCase().indexOf(" FCB ");
                if (c < 0) {
                    reduce = 4;
                    c = line.toUpperCase().indexOf(" DB ");
                }
                if (c >= 0) {
                    line = line.substring(c + reduce);
                    String[] spl = DASM6809.removeEmpty(line.split(","));
                    int cc = 0;
                    for (int i = adress; i < adress + spl.length; ++i) {
                        info = this.myMemory.memMap.get(i);
                        if (info == null) {
                            info = this.myMemory.buildMemInfo(adress);
                        }
                        info.disType = 1;
                        info.typeWasSet = true;
                        info.length = spl.length - cc++;
                        info.disassembledMnemonic = "DB";
                    }
                    return adress;
                }
                reduce = 5;
                c = line.toUpperCase().indexOf(" FDB ");
                if (c < 0) {
                    reduce = 4;
                    c = line.toUpperCase().indexOf(" DW ");
                }
                if (c >= 0) {
                    line = line.substring(c + reduce);
                    String[] spl = DASM6809.removeEmpty(line.split(","));
                    for (int i = adress; i < adress + spl.length * 2; ++i) {
                        info = this.myMemory.memMap.get(i);
                        if (info == null) {
                            info = this.myMemory.buildMemInfo(adress);
                        }
                        info.disType = 2;
                        info.typeWasSet = true;
                        info.length = 2;
                        info.disassembledMnemonic = "DW";
                    }
                    return adress;
                }
                String[] spl = DASM6809.removeEmpty(line.split(" "));
                if (spl.length > 5) {
                    if (spl[3].equals("[") && spl[3].indexOf("]") >= 0) {
                        info = this.myMemory.memMap.get(adress);
                        if (info == null) {
                            info = this.myMemory.buildMemInfo(adress);
                        }
                        info.disType = 6;
                        info.typeWasSet = true;
                    }
                    return adress;
                }
            }
        }
        return adr;
    }

    static {
        BIOS_WT1_FUNCTIONS = new HashMap();
        BIOS_WT1_LABELS = new HashMap();
        BIOS_WT1_LABELS2 = new HashMap();
        BIOS_WT1_LABELS.put(51200, "REG0");
        BIOS_WT1_LABELS.put(51201, "REG1");
        BIOS_WT1_LABELS.put(51202, "REG2");
        BIOS_WT1_LABELS.put(51203, "REG3");
        BIOS_WT1_LABELS.put(51204, "REG4");
        BIOS_WT1_LABELS.put(51205, "REG5");
        BIOS_WT1_LABELS.put(51206, "REG6");
        BIOS_WT1_LABELS.put(51207, "REG7");
        BIOS_WT1_LABELS.put(51208, "REG8");
        BIOS_WT1_LABELS.put(51209, "REG9");
        BIOS_WT1_LABELS.put(51210, "REGA");
        BIOS_WT1_LABELS.put(51211, "REGB");
        BIOS_WT1_LABELS.put(51212, "REGC");
        BIOS_WT1_LABELS.put(51213, "REGD");
        BIOS_WT1_LABELS.put(51214, "REGE");
        BIOS_WT1_LABELS.put(51215, "TRIGGR");
        BIOS_WT1_LABELS.put(51217, "EDGE");
        BIOS_WT1_LABELS.put(51218, "KEY0");
        BIOS_WT1_LABELS.put(51219, "KEY1");
        BIOS_WT1_LABELS.put(51220, "KEY2");
        BIOS_WT1_LABELS.put(51221, "KEY3");
        BIOS_WT1_LABELS.put(51222, "KEY4");
        BIOS_WT1_LABELS.put(51223, "KEY5");
        BIOS_WT1_LABELS.put(51224, "KEY6");
        BIOS_WT1_LABELS.put(51225, "KEY7");
        BIOS_WT1_LABELS.put(51226, "POTRES");
        BIOS_WT1_LABELS.put(51227, "POT0");
        BIOS_WT1_LABELS.put(51228, "POT1");
        BIOS_WT1_LABELS.put(51229, "POT1");
        BIOS_WT1_LABELS.put(51230, "POT3");
        BIOS_WT1_LABELS.put(51231, "EPOT0");
        BIOS_WT1_LABELS.put(51232, "EPOT1");
        BIOS_WT1_LABELS.put(51233, "EPOT2");
        BIOS_WT1_LABELS.put(51234, "EPOT3");
        BIOS_WT1_LABELS.put(51235, "LIST");
        BIOS_WT1_LABELS.put(51236, "ZSKIP");
        BIOS_WT1_LABELS.put(51237, "FRAME");
        BIOS_WT1_LABELS.put(51239, "TENSTY");
        BIOS_WT1_LABELS.put(51240, "DWELL");
        BIOS_WT1_LABELS.put(51241, "DASH");
        BIOS_WT1_LABELS.put(51242, "SIZRAS");
        BIOS_WT1_LABELS.put(51244, "MESAGE");
        BIOS_WT1_LABELS.put(51246, "XTMR0");
        BIOS_WT1_LABELS.put(51247, "XTMR1");
        BIOS_WT1_LABELS.put(51248, "XTMR2");
        BIOS_WT1_LABELS.put(51249, "XTMR3");
        BIOS_WT1_LABELS.put(51250, "XTMR4");
        BIOS_WT1_LABELS.put(51251, "XTMR5");
        BIOS_WT1_LABELS.put(51252, "ABSY");
        BIOS_WT1_LABELS.put(51253, "ABSX");
        BIOS_WT1_LABELS.put(51254, "ANGLE");
        BIOS_WT1_LABELS.put(51255, "WSINE");
        BIOS_WT1_LABELS.put(51257, "WCSINE");
        BIOS_WT1_LABELS.put(51259, "LEG");
        BIOS_WT1_LABELS.put(51260, "LAG");
        BIOS_WT1_LABELS.put(51261, "FRMTIM");
        BIOS_WT1_LABELS.put(51263, "REQ0");
        BIOS_WT1_LABELS.put(51264, "REQ1");
        BIOS_WT1_LABELS.put(51265, "REQ2");
        BIOS_WT1_LABELS.put(51266, "REQ3");
        BIOS_WT1_LABELS.put(51267, "REQ4");
        BIOS_WT1_LABELS.put(51268, "REQ5");
        BIOS_WT1_LABELS.put(51269, "REQ6");
        BIOS_WT1_LABELS.put(51270, "REQ7");
        BIOS_WT1_LABELS.put(51271, "REQ8");
        BIOS_WT1_LABELS.put(51272, "REQ9");
        BIOS_WT1_LABELS.put(51273, "REQA");
        BIOS_WT1_LABELS.put(51274, "REQB");
        BIOS_WT1_LABELS.put(51275, "REQC");
        BIOS_WT1_LABELS.put(51276, "REQD");
        BIOS_WT1_LABELS.put(51277, "DOREMI");
        BIOS_WT1_LABELS.put(51279, "FADE");
        BIOS_WT1_LABELS.put(51281, "VIBE");
        BIOS_WT1_LABELS.put(51283, "TUNE");
        BIOS_WT1_LABELS.put(51285, "NEWGEN");
        BIOS_WT1_LABELS.put(51286, "TSTAT");
        BIOS_WT1_LABELS.put(51287, "RESTC");
        BIOS_WT1_LABELS.put(51288, "RATEA");
        BIOS_WT1_LABELS.put(51289, "VIBA");
        BIOS_WT1_LABELS.put(51290, "RATEB");
        BIOS_WT1_LABELS.put(51291, "VIBB");
        BIOS_WT1_LABELS.put(51292, "RATEC");
        BIOS_WT1_LABELS.put(51293, "VIBC");
        BIOS_WT1_LABELS.put(51294, "FADEA");
        BIOS_WT1_LABELS.put(51295, "FADEB");
        BIOS_WT1_LABELS.put(51296, "FADEC");
        BIOS_WT1_LABELS.put(51297, "TONEA");
        BIOS_WT1_LABELS.put(51299, "TONEB");
        BIOS_WT1_LABELS.put(51301, "TONEC");
        BIOS_WT1_LABELS.put(51303, "SATUS");
        BIOS_WT1_LABELS.put(51304, "LATUS");
        BIOS_WT1_LABELS.put(51305, "XATUS");
        BIOS_WT1_LABELS.put(51306, "GAP");
        BIOS_WT1_LABELS.put(51307, "B1FREQ");
        BIOS_WT1_LABELS.put(51309, "B2FREQ");
        BIOS_WT1_LABELS.put(51311, "F1FREQ");
        BIOS_WT1_LABELS.put(51313, "FEAST");
        BIOS_WT1_LABELS.put(51314, "PEDGE");
        BIOS_WT1_LABELS.put(51315, "NEDGE");
        BIOS_WT1_LABELS.put(51316, "K1FREQ");
        BIOS_WT1_LABELS.put(51318, "BACON");
        BIOS_WT1_LABELS.put(51319, "XACON");
        BIOS_WT1_LABELS.put(51320, "SPEKT");
        BIOS_WT1_LABELS.put(51321, "PLAYRS");
        BIOS_WT1_LABELS.put(51322, "OPTION");
        BIOS_WT1_LABELS.put(51323, "SEED");
        BIOS_WT1_LABELS.put(51325, "RANCID");
        BIOS_WT1_LABELS.put(51328, "LASRAM");
        BIOS_WT1_LABELS2.put(51328, "SBTN");
        BIOS_WT1_LABELS.put(51329, "SJOY");
        BIOS_WT1_LABELS.put(51331, "ETMP1");
        BIOS_WT1_LABELS.put(51332, "ETMP2");
        BIOS_WT1_LABELS.put(51333, "ETMP3");
        BIOS_WT1_LABELS.put(51334, "ETMP4");
        BIOS_WT1_LABELS.put(51335, "ETMP5");
        BIOS_WT1_LABELS.put(51336, "ETMP6");
        BIOS_WT1_LABELS.put(51337, "ETMP7");
        BIOS_WT1_LABELS.put(51338, "ETMP8");
        BIOS_WT1_LABELS.put(51339, "ETMP9");
        BIOS_WT1_LABELS.put(51340, "ETMP10");
        BIOS_WT1_LABELS.put(51343, "TEMP1");
        BIOS_WT1_LABELS.put(51344, "TEMP2");
        BIOS_WT1_LABELS.put(51345, "TEMP3");
        BIOS_WT1_LABELS.put(51346, "TEMP4");
        BIOS_WT1_LABELS.put(51347, "TEMP5");
        BIOS_WT1_LABELS.put(51348, "TEMP6");
        BIOS_WT1_LABELS.put(51349, "TEMP7");
        BIOS_WT1_LABELS.put(51350, "TEMP8");
        BIOS_WT1_LABELS.put(51351, "TEMP9");
        BIOS_WT1_LABELS.put(51352, "TEMP10");
        BIOS_WT1_LABELS.put(51355, "ACTPLY");
        BIOS_WT1_LABELS.put(51356, "TMR1");
        BIOS_WT1_LABELS.put(51359, "TMR2");
        BIOS_WT1_LABELS.put(51362, "TMR3");
        BIOS_WT1_LABELS.put(51365, "TMR4");
        BIOS_WT1_LABELS.put(51368, "SCOR1");
        BIOS_WT1_LABELS.put(51375, "SCOR2");
        BIOS_WT1_LABELS.put(51435, "HISCOR");
        BIOS_WT1_LABELS.put(51712, "RAMMES");
        BIOS_WT1_LABELS.put(53248, "CNTRL");
        BIOS_WT1_LABELS.put(53249, "DAC");
        BIOS_WT1_LABELS.put(53250, "DCNTRL");
        BIOS_WT1_LABELS.put(53251, "DDAC");
        BIOS_WT1_LABELS.put(53252, "T1LOLC");
        BIOS_WT1_LABELS.put(53253, "T1HOC");
        BIOS_WT1_LABELS.put(53254, "T1LOL");
        BIOS_WT1_LABELS.put(53255, "T1HOL");
        BIOS_WT1_LABELS.put(53256, "T2LOLC");
        BIOS_WT1_LABELS.put(53257, "T2HOC");
        BIOS_WT1_LABELS.put(53258, "SHIFT");
        BIOS_WT1_LABELS.put(53259, "ACNTRL");
        BIOS_WT1_LABELS.put(53260, "PCNTRL");
        BIOS_WT1_LABELS.put(53261, "IFLAG");
        BIOS_WT1_LABELS.put(53262, "IENABL");
        BIOS_WT1_LABELS.put(53263, "ORA");
        BIOS_WT1_LABELS.put(52202, "Vec_Default_Stk");
        BIOS_WT1_LABELS.put(52203, "Vec_High_Score");
        BIOS_WT1_LABELS.put(52210, "Vec_SWI3_Vector");
        BIOS_WT1_LABELS2.put(52210, "Vec_SWI2_Vector");
        BIOS_WT1_LABELS.put(52213, "Vec_FIRQ_Vector");
        BIOS_WT1_LABELS.put(52216, "Vec_IRQ_Vector");
        BIOS_WT1_LABELS.put(52219, "Vec_SWI_Vector");
        BIOS_WT1_LABELS2.put(52219, "Vec_NMI_Vector");
        BIOS_WT1_LABELS.put(52222, "Vec_Cold_Flag");
        BIOS_WT1_FUNCTIONS.put(59317, "MLTY8");
        BIOS_WT1_FUNCTIONS.put(59346, "MLTY16");
        BIOS_WT1_FUNCTIONS.put(59786, "RANPOS");
        BIOS_WT1_FUNCTIONS.put(59966, "CONE");
        BIOS_WT1_FUNCTIONS.put(59997, "ADOT");
        BIOS_WT1_FUNCTIONS.put(60013, "DDOT");
        BIOS_WT1_FUNCTIONS.put(60031, "APACK");
        BIOS_WT1_FUNCTIONS.put(60045, "DPACK");
        BIOS_WT1_FUNCTIONS.put(60072, "ASMESS");
        BIOS_WT1_FUNCTIONS.put(60084, "SCRMES");
        BIOS_WT1_FUNCTIONS.put(60111, "SCRBTH");
        BIOS_WT1_FUNCTIONS.put(60144, "WAIT");
        BIOS_WT1_FUNCTIONS.put(61440, "Cold_Start");
        BIOS_WT1_FUNCTIONS.put(61548, "Warm_Start");
        BIOS_WT1_FUNCTIONS.put(61772, "INTPIA");
        BIOS_WT1_FUNCTIONS.put(61796, "INTMSC");
        BIOS_WT1_FUNCTIONS.put(61835, "INTALL");
        BIOS_WT1_FUNCTIONS.put(61842, "FRWAIT");
        BIOS_WT1_FUNCTIONS.put(61858, "Set_Refresh");
        BIOS_WT1_FUNCTIONS.put(61866, "DPIO");
        BIOS_WT1_FUNCTIONS.put(61871, "DPRAM");
        BIOS_WT1_FUNCTIONS.put(61882, "INPUT");
        BIOS_WT1_FUNCTIONS.put(61876, "DBNCE");
        BIOS_WT1_FUNCTIONS.put(61941, "JOYSTK");
        BIOS_WT1_FUNCTIONS.put(61944, "JOYBIT");
        BIOS_WT1_FUNCTIONS.put(62038, "WRREG");
        BIOS_WT1_FUNCTIONS.put(62041, "WRPSC");
        BIOS_WT1_FUNCTIONS.put(62043, "Sound_Byte_raw");
        BIOS_WT1_FUNCTIONS.put(62066, "INTPSG");
        BIOS_WT1_FUNCTIONS.put(62077, "PSGLST");
        BIOS_WT1_FUNCTIONS.put(62084, "PSGMIR");
        BIOS_WT1_FUNCTIONS.put(62089, "REQOUT");
        BIOS_WT1_FUNCTIONS.put(62092, "Do_Sound_x");
        BIOS_WT1_FUNCTIONS.put(62109, "INT1Q");
        BIOS_WT1_FUNCTIONS.put(62113, "INT2Q");
        BIOS_WT1_FUNCTIONS.put(62117, "INT3Q");
        BIOS_WT1_FUNCTIONS.put(62121, "INTMAX");
        BIOS_WT1_FUNCTIONS.put(62123, "INTENS");
        BIOS_WT1_FUNCTIONS.put(62142, "DOTTIM");
        BIOS_WT1_FUNCTIONS.put(62145, "DOTX");
        BIOS_WT1_FUNCTIONS.put(62147, "DOTAB");
        BIOS_WT1_FUNCTIONS.put(62149, "DOT");
        BIOS_WT1_FUNCTIONS.put(62165, "DIFDOT");
        BIOS_WT1_FUNCTIONS.put(62174, "DOTPCK");
        BIOS_WT1_FUNCTIONS.put(62182, "DEFLOK");
        BIOS_WT1_FUNCTIONS.put(62194, "POSWID");
        BIOS_WT1_FUNCTIONS.put(62204, "POSITD");
        BIOS_WT1_FUNCTIONS.put(62216, "POSIT2");
        BIOS_WT1_FUNCTIONS.put(62220, "POSIT1");
        BIOS_WT1_FUNCTIONS.put(62222, "POSITB");
        BIOS_WT1_FUNCTIONS.put(62224, "POSITX");
        BIOS_WT1_FUNCTIONS.put(62226, "POSITN");
        BIOS_WT1_FUNCTIONS.put(62282, "DZERO");
        BIOS_WT1_FUNCTIONS.put(62287, "CZERO");
        BIOS_WT1_FUNCTIONS.put(62292, "ZERGND");
        BIOS_WT1_FUNCTIONS.put(62299, "ACTGND");
        BIOS_WT1_FUNCTIONS.put(62315, "ZERO");
        BIOS_WT1_FUNCTIONS.put(62323, "RSTSIZ");
        BIOS_WT1_FUNCTIONS.put(62328, "RSTPOS");
        BIOS_WT1_FUNCTIONS.put(62330, "MSSPOS");
        BIOS_WT1_FUNCTIONS.put(62341, "TXTSIZ");
        BIOS_WT1_FUNCTIONS.put(62346, "Print_List");
        BIOS_WT1_FUNCTIONS.put(62348, "TXTPOS");
        BIOS_WT1_FUNCTIONS.put(62353, "SHIPX");
        BIOS_WT1_FUNCTIONS.put(62355, "DSHIP");
        BIOS_WT1_FUNCTIONS.put(62381, "DUFFAX");
        BIOS_WT1_FUNCTIONS.put(62385, "DUFTIM");
        BIOS_WT1_FUNCTIONS.put(62389, "DUFLST");
        BIOS_WT1_FUNCTIONS.put(62391, "TDUFFY");
        BIOS_WT1_FUNCTIONS.put(62393, "LDUFFY");
        BIOS_WT1_FUNCTIONS.put(62396, "DUFFY");
        BIOS_WT1_FUNCTIONS.put(62398, "DUFFAB");
        BIOS_WT1_FUNCTIONS.put(62414, "DIFFAX");
        BIOS_WT1_FUNCTIONS.put(62418, "DIFTIM");
        BIOS_WT1_FUNCTIONS.put(62422, "DIFLST");
        BIOS_WT1_FUNCTIONS.put(62424, "TDIFFY");
        BIOS_WT1_FUNCTIONS.put(62426, "LDIFFY");
        BIOS_WT1_FUNCTIONS.put(62429, "DIFFY");
        BIOS_WT1_FUNCTIONS.put(62431, "DIFFAB");
        BIOS_WT1_FUNCTIONS.put(62468, "PACK2X");
        BIOS_WT1_FUNCTIONS.put(62472, "PACK1X");
        BIOS_WT1_FUNCTIONS.put(62476, "LPACK");
        BIOS_WT1_FUNCTIONS.put(62478, "TPACK");
        BIOS_WT1_FUNCTIONS.put(62480, "PACKET");
        BIOS_WT1_FUNCTIONS.put(62515, "DSHDF1");
        BIOS_WT1_FUNCTIONS.put(62516, "DSHDF");
        BIOS_WT1_FUNCTIONS.put(62519, "DASHDF");
        BIOS_WT1_FUNCTIONS.put(62521, "Draw_Pat_VL_d");
        BIOS_WT1_FUNCTIONS.put(62574, "DASHPK");
        BIOS_WT1_FUNCTIONS.put(62613, "RASTER");
        BIOS_WT1_FUNCTIONS.put(62616, "MRASTR");
        BIOS_WT1_FUNCTIONS.put(62737, "RAND3");
        BIOS_WT1_FUNCTIONS.put(62743, "RANDOM");
        BIOS_WT1_FUNCTIONS.put(62771, "INTREQ");
        BIOS_WT1_FUNCTIONS.put(62783, "BCLR");
        BIOS_WT1_FUNCTIONS.put(62786, "CLREX");
        BIOS_WT1_FUNCTIONS.put(62789, "CLR256");
        BIOS_WT1_FUNCTIONS.put(62792, "CLRBLK");
        BIOS_WT1_FUNCTIONS.put(62800, "CLR80");
        BIOS_WT1_FUNCTIONS.put(62802, "BLKFIL");
        BIOS_WT1_FUNCTIONS.put(62810, "D2TMR");
        BIOS_WT1_FUNCTIONS.put(62814, "DECTMR");
        BIOS_WT1_FUNCTIONS.put(62819, "Dec_Counters");
        BIOS_WT1_FUNCTIONS.put(62829, "DEL38");
        BIOS_WT1_FUNCTIONS.put(62833, "DEL33");
        BIOS_WT1_FUNCTIONS.put(62837, "DEL28");
        BIOS_WT1_FUNCTIONS.put(62841, "DEL20");
        BIOS_WT1_FUNCTIONS.put(62842, "DEL");
        BIOS_WT1_FUNCTIONS.put(62845, "DEL13");
        BIOS_WT1_FUNCTIONS.put(62846, "DECBIT");
        BIOS_WT1_FUNCTIONS.put(62852, "ABSAB");
        BIOS_WT1_FUNCTIONS.put(62859, "ABSB");
        BIOS_WT1_FUNCTIONS.put(62867, "CMPASS");
        BIOS_WT1_FUNCTIONS.put(62937, "COSINE");
        BIOS_WT1_FUNCTIONS.put(62936, "SINE");
        BIOS_WT1_FUNCTIONS.put(62939, "Get_Run_Idx");
        BIOS_WT1_FUNCTIONS.put(62959, "SINCOS");
        BIOS_WT1_FUNCTIONS.put(62975, "LROT90");
        BIOS_WT1_FUNCTIONS.put(62977, "LNROT");
        BIOS_WT1_FUNCTIONS.put(62979, "ALNROT");
        BIOS_WT1_FUNCTIONS.put(62992, "DROT");
        BIOS_WT1_FUNCTIONS.put(62995, "BDROT");
        BIOS_WT1_FUNCTIONS.put(62998, "ADROT");
        BIOS_WT1_FUNCTIONS.put(63007, "PROT");
        BIOS_WT1_FUNCTIONS.put(63010, "APROT");
        BIOS_WT1_FUNCTIONS.put(63031, "Rot_VL_dft");
        BIOS_WT1_FUNCTIONS.put(63067, "MSINE");
        BIOS_WT1_FUNCTIONS.put(63069, "LSINE");
        BIOS_WT1_FUNCTIONS.put(63073, "MCSINE");
        BIOS_WT1_FUNCTIONS.put(63075, "LCSINE");
        BIOS_WT1_FUNCTIONS.put(63103, "BLKMV1");
        BIOS_WT1_FUNCTIONS.put(63107, "BLKMOV");
        BIOS_WT1_FUNCTIONS.put(63111, "REPLAY");
        BIOS_WT1_FUNCTIONS.put(63117, "SPLAY");
        BIOS_WT1_FUNCTIONS.put(63120, "ASPLAY");
        BIOS_WT1_FUNCTIONS.put(63122, "TPLAY");
        BIOS_WT1_FUNCTIONS.put(63298, "XPLAY");
        BIOS_WT1_FUNCTIONS.put(63401, "SELOPT");
        BIOS_WT1_FUNCTIONS.put(63567, "SCLR");
        BIOS_WT1_FUNCTIONS.put(63582, "BYTADD");
        BIOS_WT1_FUNCTIONS.put(63612, "SCRADD");
        BIOS_WT1_FUNCTIONS.put(63616, "STKADD");
        BIOS_WT1_FUNCTIONS.put(63671, "Strip_Zeros");
        BIOS_WT1_FUNCTIONS.put(63687, "WINNER");
        BIOS_WT1_FUNCTIONS.put(63704, "HISCR");
        BIOS_WT1_FUNCTIONS.put(63717, "OFF1BX");
        BIOS_WT1_FUNCTIONS.put(63731, "OFF2BX");
        BIOS_WT1_FUNCTIONS.put(63743, "BXTEST");
        BIOS_WT1_FUNCTIONS.put(63790, "EXPLOD");
        BIOS_WT1_FUNCTIONS.put(63946, "SETAMP");
        BIOS_WT1_FUNCTIONS.put(65439, "Draw_Grid_VL");
        BIOS_TOMLIN_FUNCTIONS = new HashMap();
        BIOS_TOMLIN_LABELS = new HashMap();
        BIOS_TOMLIN_LABELS2 = new HashMap();
        BIOS_TOMLIN_LABELS.put(51200, "Vec_Snd_Shadow");
        BIOS_TOMLIN_LABELS.put(51215, "Vec_Btn_State");
        BIOS_TOMLIN_LABELS.put(51216, "Vec_Prev_Btns");
        BIOS_TOMLIN_LABELS.put(51217, "Vec_Buttons");
        BIOS_TOMLIN_LABELS.put(51218, "Vec_Button_1_1");
        BIOS_TOMLIN_LABELS.put(51219, "Vec_Button_1_2");
        BIOS_TOMLIN_LABELS.put(51220, "Vec_Button_1_3");
        BIOS_TOMLIN_LABELS.put(51221, "Vec_Button_1_4");
        BIOS_TOMLIN_LABELS.put(51222, "Vec_Button_2_1");
        BIOS_TOMLIN_LABELS.put(51223, "Vec_Button_2_2");
        BIOS_TOMLIN_LABELS.put(51224, "Vec_Button_2_3");
        BIOS_TOMLIN_LABELS.put(51225, "Vec_Button_2_4");
        BIOS_TOMLIN_LABELS.put(51226, "Vec_Joy_Resltn");
        BIOS_TOMLIN_LABELS.put(51227, "Vec_Joy_1_X");
        BIOS_TOMLIN_LABELS.put(51228, "Vec_Joy_1_Y");
        BIOS_TOMLIN_LABELS.put(51229, "Vec_Joy_2_X");
        BIOS_TOMLIN_LABELS.put(51230, "Vec_Joy_2_Y");
        BIOS_TOMLIN_LABELS2.put(51230, "Vec_Joy_Mux");
        BIOS_TOMLIN_LABELS2.put(51231, "Vec_Joy_Mux");
        BIOS_TOMLIN_LABELS.put(51231, "Vec_Joy_Mux_1_X");
        BIOS_TOMLIN_LABELS.put(51232, "Vec_Joy_Mux_1_Y");
        BIOS_TOMLIN_LABELS.put(51233, "Vec_Joy_Mux_2_X");
        BIOS_TOMLIN_LABELS.put(51234, "Vec_Joy_Mux_2_Y");
        BIOS_TOMLIN_LABELS.put(51235, "Vec_Misc_Count");
        BIOS_TOMLIN_LABELS.put(51236, "Vec_0Ref_Enable");
        BIOS_TOMLIN_LABELS.put(51237, "Vec_Loop_Count");
        BIOS_TOMLIN_LABELS.put(51239, "Vec_Brightness");
        BIOS_TOMLIN_LABELS.put(51240, "Vec_Dot_Dwell");
        BIOS_TOMLIN_LABELS.put(51241, "Vec_Pattern");
        BIOS_TOMLIN_LABELS.put(51242, "Vec_Text_HW");
        BIOS_TOMLIN_LABELS2.put(51242, "Vec_Text_Height");
        BIOS_TOMLIN_LABELS.put(51243, "Vec_Text_Width");
        BIOS_TOMLIN_LABELS.put(51244, "Vec_Str_Ptr");
        BIOS_TOMLIN_LABELS.put(51246, "Vec_Counters");
        BIOS_TOMLIN_LABELS2.put(51246, "Vec_Counter_1");
        BIOS_TOMLIN_LABELS.put(51247, "Vec_Counter_2");
        BIOS_TOMLIN_LABELS.put(51248, "Vec_Counter_3");
        BIOS_TOMLIN_LABELS.put(51249, "Vec_Counter_4");
        BIOS_TOMLIN_LABELS.put(51250, "Vec_Counter_5");
        BIOS_TOMLIN_LABELS.put(51251, "Vec_Counter_6");
        BIOS_TOMLIN_LABELS.put(51252, "Vec_RiseRun_Tmp");
        BIOS_TOMLIN_LABELS.put(51254, "Vec_Angle");
        BIOS_TOMLIN_LABELS.put(51255, "Vec_Run_Index");
        BIOS_TOMLIN_LABELS.put(51257, "Vec_Rise_Index");
        BIOS_TOMLIN_LABELS.put(51259, "Vec_RiseRun_Len");
        BIOS_TOMLIN_LABELS.put(51261, "Vec_Rfrsh");
        BIOS_TOMLIN_LABELS2.put(51261, "Vec_Rfrsh_lo");
        BIOS_TOMLIN_LABELS.put(51262, "Vec_Rfrsh_hi");
        BIOS_TOMLIN_LABELS2.put(51263, "Vec_Music_Work");
        BIOS_TOMLIN_LABELS.put(51263, "Vec_Music_Wk_D");
        BIOS_TOMLIN_LABELS.put(51264, "Vec_Music_Wk_C");
        BIOS_TOMLIN_LABELS.put(51265, "Vec_Music_Wk_B");
        BIOS_TOMLIN_LABELS.put(51266, "Vec_Music_Wk_A");
        BIOS_TOMLIN_LABELS.put(51267, "Vec_Music_Wk_9");
        BIOS_TOMLIN_LABELS.put(51268, "Vec_Music_Wk_8");
        BIOS_TOMLIN_LABELS.put(51269, "Vec_Music_Wk_7");
        BIOS_TOMLIN_LABELS.put(51270, "Vec_Music_Wk_6");
        BIOS_TOMLIN_LABELS.put(51271, "Vec_Music_Wk_5");
        BIOS_TOMLIN_LABELS.put(51272, "Vec_Music_Wk_4");
        BIOS_TOMLIN_LABELS.put(51273, "Vec_Music_Wk_3");
        BIOS_TOMLIN_LABELS.put(51274, "Vec_Music_Wk_2");
        BIOS_TOMLIN_LABELS.put(51275, "Vec_Music_Wk_1");
        BIOS_TOMLIN_LABELS.put(51276, "Vec_Music_Wk_0");
        BIOS_TOMLIN_LABELS.put(51277, "Vec_Freq_Table");
        BIOS_TOMLIN_LABELS.put(51279, "Vec_Max_Players");
        BIOS_TOMLIN_LABELS.put(51280, "Vec_Max_Games");
        BIOS_TOMLIN_LABELS2.put(51279, "Vec_ADSR_Table");
        BIOS_TOMLIN_LABELS.put(51281, "Vec_Twang_Table");
        BIOS_TOMLIN_LABELS.put(51283, "Vec_Music_Ptr");
        BIOS_TOMLIN_LABELS2.put(51283, "Vec_Expl_ChanA");
        BIOS_TOMLIN_LABELS.put(51284, "Vec_Expl_Chans");
        BIOS_TOMLIN_LABELS.put(51285, "Vec_Music_Chan");
        BIOS_TOMLIN_LABELS.put(51286, "Vec_Music_Flag");
        BIOS_TOMLIN_LABELS.put(51287, "Vec_Duration");
        BIOS_TOMLIN_LABELS2.put(51288, "Vec_Music_Twang");
        BIOS_TOMLIN_LABELS.put(51288, "Vec_Expl_1");
        BIOS_TOMLIN_LABELS.put(51289, "Vec_Expl_2");
        BIOS_TOMLIN_LABELS.put(51290, "Vec_Expl_3");
        BIOS_TOMLIN_LABELS.put(51291, "Vec_Expl_4");
        BIOS_TOMLIN_LABELS.put(51292, "Vec_Expl_Chan");
        BIOS_TOMLIN_LABELS.put(51293, "Vec_Expl_ChanB");
        BIOS_TOMLIN_LABELS.put(51294, "Vec_ADSR_Timers");
        BIOS_TOMLIN_LABELS.put(51297, "Vec_Music_Freq");
        BIOS_TOMLIN_LABELS.put(51303, "Vec_Expl_Flag");
        BIOS_TOMLIN_LABELS.put(51319, "Vec_Expl_Timer");
        BIOS_TOMLIN_LABELS.put(51321, "Vec_Num_Players");
        BIOS_TOMLIN_LABELS.put(51322, "Vec_Num_Game");
        BIOS_TOMLIN_LABELS.put(51323, "Vec_Seed_Ptr");
        BIOS_TOMLIN_LABELS.put(51325, "Vec_Random_Seed");
        BIOS_TOMLIN_LABELS.put(53248, "VIA_port_b");
        BIOS_TOMLIN_LABELS.put(53249, "VIA_port_a");
        BIOS_TOMLIN_LABELS.put(53250, "VIA_DDR_b");
        BIOS_TOMLIN_LABELS.put(53251, "VIA_DDR_a");
        BIOS_TOMLIN_LABELS.put(53252, "VIA_t1_cnt_lo");
        BIOS_TOMLIN_LABELS.put(53253, "VIA_t1_cnt_hi");
        BIOS_TOMLIN_LABELS.put(53254, "VIA_t1_lch_lo");
        BIOS_TOMLIN_LABELS.put(53255, "VIA_t1_lch_hi");
        BIOS_TOMLIN_LABELS.put(53256, "VIA_t2_lo");
        BIOS_TOMLIN_LABELS.put(53257, "VIA_t2_hi");
        BIOS_TOMLIN_LABELS.put(53258, "VIA_shift_reg");
        BIOS_TOMLIN_LABELS.put(53259, "VIA_aux_cntl");
        BIOS_TOMLIN_LABELS.put(53260, "VIA_cntl");
        BIOS_TOMLIN_LABELS.put(53261, "VIA_int_flags");
        BIOS_TOMLIN_LABELS.put(53262, "VIA_int_enable");
        BIOS_TOMLIN_LABELS.put(53263, "VIA_port_a_nohs");
        BIOS_TOMLIN_LABELS.put(52202, "Vec_Default_Stk");
        BIOS_TOMLIN_LABELS.put(52203, "Vec_High_Score");
        BIOS_TOMLIN_LABELS.put(52210, "Vec_SWI3_Vector");
        BIOS_TOMLIN_LABELS2.put(52210, "Vec_SWI2_Vector");
        BIOS_TOMLIN_LABELS.put(52213, "Vec_FIRQ_Vector");
        BIOS_TOMLIN_LABELS.put(52216, "Vec_IRQ_Vector");
        BIOS_TOMLIN_LABELS.put(52219, "Vec_SWI_Vector");
        BIOS_TOMLIN_LABELS2.put(52219, "Vec_NMI_Vector");
        BIOS_TOMLIN_LABELS.put(52222, "Vec_Cold_Flag");
        BIOS_TOMLIN_FUNCTIONS.put(61842, "Wait_Recal");
        BIOS_TOMLIN_FUNCTIONS.put(62123, "Intensity_a");
        BIOS_TOMLIN_FUNCTIONS.put(62829, "Delay_3");
        BIOS_TOMLIN_FUNCTIONS.put(61440, "Cold_Start");
        BIOS_TOMLIN_FUNCTIONS.put(61548, "Warm_Start");
        BIOS_TOMLIN_FUNCTIONS.put(61772, "Init_VIA");
        BIOS_TOMLIN_FUNCTIONS.put(61796, "Init_OS_RAM");
        BIOS_TOMLIN_FUNCTIONS.put(61835, "Init_OS");
        BIOS_TOMLIN_FUNCTIONS.put(61858, "Set_Refresh");
        BIOS_TOMLIN_FUNCTIONS.put(61866, "DP_to_D0");
        BIOS_TOMLIN_FUNCTIONS.put(61871, "DP_to_C8");
        BIOS_TOMLIN_FUNCTIONS.put(61882, "Read_Btns");
        BIOS_TOMLIN_FUNCTIONS.put(61876, "Read_Btns_Mask");
        BIOS_TOMLIN_FUNCTIONS.put(61941, "Joy_Analog");
        BIOS_TOMLIN_FUNCTIONS.put(61944, "Joy_Digital");
        BIOS_TOMLIN_FUNCTIONS.put(62038, "Sound_Byte");
        BIOS_TOMLIN_FUNCTIONS.put(62041, "Sound_Byte_x");
        BIOS_TOMLIN_FUNCTIONS.put(62043, "Sound_Byte_raw");
        BIOS_TOMLIN_FUNCTIONS.put(62066, "Clear_Sound");
        BIOS_TOMLIN_FUNCTIONS.put(62077, "Sound_Bytes");
        BIOS_TOMLIN_FUNCTIONS.put(62084, "DelaSound_Bytes_xy_3");
        BIOS_TOMLIN_FUNCTIONS.put(62089, "Do_Sound");
        BIOS_TOMLIN_FUNCTIONS.put(62092, "Do_Sound_x");
        BIOS_TOMLIN_FUNCTIONS.put(62109, "Intensity_1F");
        BIOS_TOMLIN_FUNCTIONS.put(62113, "Intensity_3F");
        BIOS_TOMLIN_FUNCTIONS.put(62117, "Intensity_5F");
        BIOS_TOMLIN_FUNCTIONS.put(62121, "Intensity_7F");
        BIOS_TOMLIN_FUNCTIONS.put(62123, "Intensity_a");
        BIOS_TOMLIN_FUNCTIONS.put(62142, "Dot_ix_b");
        BIOS_TOMLIN_FUNCTIONS.put(62145, "Dot_ix");
        BIOS_TOMLIN_FUNCTIONS.put(62147, "Dot_d");
        BIOS_TOMLIN_FUNCTIONS.put(62149, "Dot_here");
        BIOS_TOMLIN_FUNCTIONS.put(62165, "Dot_List");
        BIOS_TOMLIN_FUNCTIONS.put(62174, "Dot_List_Reset");
        BIOS_TOMLIN_FUNCTIONS.put(62182, "Recalibrate");
        BIOS_TOMLIN_FUNCTIONS.put(62194, "Moveto_x_7F");
        BIOS_TOMLIN_FUNCTIONS.put(62204, "Moveto_d_7F");
        BIOS_TOMLIN_FUNCTIONS.put(62216, "Moveto_ix_FF");
        BIOS_TOMLIN_FUNCTIONS.put(62220, "Moveto_ix_7F");
        BIOS_TOMLIN_FUNCTIONS.put(62222, "Moveto_ix_b");
        BIOS_TOMLIN_FUNCTIONS.put(62224, "Moveto_ix");
        BIOS_TOMLIN_FUNCTIONS.put(62226, "Moveto_d");
        BIOS_TOMLIN_FUNCTIONS.put(62282, "Reset0Ref_D0");
        BIOS_TOMLIN_FUNCTIONS.put(62287, "Check0Ref");
        BIOS_TOMLIN_FUNCTIONS.put(62292, "Reset0Ref");
        BIOS_TOMLIN_FUNCTIONS.put(62299, "Reset_Pen");
        BIOS_TOMLIN_FUNCTIONS.put(62315, "Reset0Int");
        BIOS_TOMLIN_FUNCTIONS.put(62323, "Print_Str_hwyx");
        BIOS_TOMLIN_FUNCTIONS.put(62328, "Print_Str_yx");
        BIOS_TOMLIN_FUNCTIONS.put(62330, "Print_Str_d");
        BIOS_TOMLIN_FUNCTIONS.put(62341, "Print_List_hw");
        BIOS_TOMLIN_FUNCTIONS.put(62346, "Print_List");
        BIOS_TOMLIN_FUNCTIONS.put(62348, "Print_List_chk");
        BIOS_TOMLIN_FUNCTIONS.put(62353, "Print_Ships_x");
        BIOS_TOMLIN_FUNCTIONS.put(62355, "Print_Ships");
        BIOS_TOMLIN_FUNCTIONS.put(62381, "Mov_Draw_VLc_a");
        BIOS_TOMLIN_FUNCTIONS.put(62385, "Mov_Draw_VL_b");
        BIOS_TOMLIN_FUNCTIONS.put(62389, "Mov_Draw_VLcs");
        BIOS_TOMLIN_FUNCTIONS.put(62391, "Mov_Draw_VL_ab");
        BIOS_TOMLIN_FUNCTIONS.put(62393, "Mov_Draw_VL_a");
        BIOS_TOMLIN_FUNCTIONS.put(62396, "Mov_Draw_VL");
        BIOS_TOMLIN_FUNCTIONS.put(62398, "Mov_Draw_VL_d");
        BIOS_TOMLIN_FUNCTIONS.put(62414, "Draw_VLc");
        BIOS_TOMLIN_FUNCTIONS.put(62418, "Draw_VL_b");
        BIOS_TOMLIN_FUNCTIONS.put(62422, "Draw_VLcs");
        BIOS_TOMLIN_FUNCTIONS.put(62424, "Draw_VL_ab");
        BIOS_TOMLIN_FUNCTIONS.put(62426, "Draw_VL_a");
        BIOS_TOMLIN_FUNCTIONS.put(62429, "Draw_VL");
        BIOS_TOMLIN_FUNCTIONS.put(62431, "Draw_Line_d");
        BIOS_TOMLIN_FUNCTIONS.put(62468, "Draw_VLp_FF");
        BIOS_TOMLIN_FUNCTIONS.put(62472, "Draw_VLp_7F");
        BIOS_TOMLIN_FUNCTIONS.put(62476, "Draw_VLp_scale");
        BIOS_TOMLIN_FUNCTIONS.put(62478, "Draw_VLp_b");
        BIOS_TOMLIN_FUNCTIONS.put(62480, "Draw_VLp");
        BIOS_TOMLIN_FUNCTIONS.put(62516, "Draw_Pat_VL_a");
        BIOS_TOMLIN_FUNCTIONS.put(62519, "Draw_Pat_VL");
        BIOS_TOMLIN_FUNCTIONS.put(62521, "Draw_Pat_VL_d");
        BIOS_TOMLIN_FUNCTIONS.put(62574, "Draw_VL_mode");
        BIOS_TOMLIN_FUNCTIONS.put(62613, "Print_Str");
        BIOS_TOMLIN_FUNCTIONS.put(62737, "Random_3");
        BIOS_TOMLIN_FUNCTIONS.put(62743, "Random");
        BIOS_TOMLIN_FUNCTIONS.put(62771, "Init_Music_Buf");
        BIOS_TOMLIN_FUNCTIONS.put(62783, "Clear_x_b");
        BIOS_TOMLIN_FUNCTIONS.put(62786, "Clear_C8_RAM");
        BIOS_TOMLIN_FUNCTIONS.put(62789, "Clear_x_256");
        BIOS_TOMLIN_FUNCTIONS.put(62792, "Clear_x_d");
        BIOS_TOMLIN_FUNCTIONS.put(62800, "Clear_x_b_80");
        BIOS_TOMLIN_FUNCTIONS.put(62802, "Clear_x_b_a");
        BIOS_TOMLIN_FUNCTIONS.put(62810, "Dec_3_Counters");
        BIOS_TOMLIN_FUNCTIONS.put(62814, "Dec_6_Counters");
        BIOS_TOMLIN_FUNCTIONS.put(62819, "Dec_Counters");
        BIOS_TOMLIN_FUNCTIONS.put(62833, "Delay_2");
        BIOS_TOMLIN_FUNCTIONS.put(62837, "Delay_1");
        BIOS_TOMLIN_FUNCTIONS.put(62841, "Delay_0");
        BIOS_TOMLIN_FUNCTIONS.put(62842, "Delay_b");
        BIOS_TOMLIN_FUNCTIONS.put(62845, "Delay_RTS");
        BIOS_TOMLIN_FUNCTIONS.put(62846, "Bitmask_a");
        BIOS_TOMLIN_FUNCTIONS.put(62852, "Abs_a_b");
        BIOS_TOMLIN_FUNCTIONS.put(62859, "Abs_b");
        BIOS_TOMLIN_FUNCTIONS.put(62867, "Rise_Run_Angle");
        BIOS_TOMLIN_FUNCTIONS.put(62937, "Get_Rise_Idx");
        BIOS_TOMLIN_FUNCTIONS.put(62939, "Get_Run_Idx");
        BIOS_TOMLIN_FUNCTIONS.put(62959, "Get_Rise_Run");
        BIOS_TOMLIN_FUNCTIONS.put(62975, "Rise_Run_X");
        BIOS_TOMLIN_FUNCTIONS.put(62977, "Rise_Run_Y");
        BIOS_TOMLIN_FUNCTIONS.put(62979, "Rise_Run_Len");
        BIOS_TOMLIN_FUNCTIONS.put(62992, "Rot_VL_ab");
        BIOS_TOMLIN_FUNCTIONS.put(62998, "Rot_VL");
        BIOS_TOMLIN_FUNCTIONS.put(63007, "Rot_VL_Mode");
        BIOS_TOMLIN_FUNCTIONS.put(63031, "Rot_VL_dft");
        BIOS_TOMLIN_FUNCTIONS.put(63067, "Xform_Run_a");
        BIOS_TOMLIN_FUNCTIONS.put(63069, "Xform_Run");
        BIOS_TOMLIN_FUNCTIONS.put(63073, "Xform_Rise_a");
        BIOS_TOMLIN_FUNCTIONS.put(63075, "Xform_Rise");
        BIOS_TOMLIN_FUNCTIONS.put(63103, "Move_Mem_a_1");
        BIOS_TOMLIN_FUNCTIONS.put(63107, "Move_Mem_a");
        BIOS_TOMLIN_FUNCTIONS.put(63111, "Init_Music_chk");
        BIOS_TOMLIN_FUNCTIONS.put(63117, "Init_Music");
        BIOS_TOMLIN_FUNCTIONS.put(63122, "Init_Music_x");
        BIOS_TOMLIN_FUNCTIONS.put(63401, "Select_Game");
        BIOS_TOMLIN_FUNCTIONS.put(63567, "Clear_Score");
        BIOS_TOMLIN_FUNCTIONS.put(63582, "Add_Score_a");
        BIOS_TOMLIN_FUNCTIONS.put(63612, "Add_Score_d");
        BIOS_TOMLIN_FUNCTIONS.put(63671, "Strip_Zeros");
        BIOS_TOMLIN_FUNCTIONS.put(63687, "Compare_Score");
        BIOS_TOMLIN_FUNCTIONS.put(63704, "New_High_Score");
        BIOS_TOMLIN_FUNCTIONS.put(63717, "Obj_Will_Hit_u");
        BIOS_TOMLIN_FUNCTIONS.put(63731, "Obj_Will_Hit");
        BIOS_TOMLIN_FUNCTIONS.put(63743, "Obj_Hit");
        BIOS_TOMLIN_FUNCTIONS.put(63790, "Explosion_Snd");
        BIOS_TOMLIN_FUNCTIONS.put(65439, "Draw_Grid_VL");
        BIOSLABELS = BIOS_WT1_LABELS;
        BIOSLABELS2 = BIOS_WT1_LABELS2;
        BIOSFUNCTIONS = BIOS_WT1_FUNCTIONS;
    }

    class ToScan {
        private ArrayList<CodeMemoryScan> toScan = new ArrayList();
        private HashMap<CodeMemoryScan, Boolean> checker = new HashMap();

        ToScan() {
        }

        public void add(CodeMemoryScan scan) {
            if (this.checker.get(scan) != null) {
                return;
            }
            this.checker.put(scan, true);
            this.toScan.add(scan);
        }

        public CodeMemoryScan next() {
            for (CodeMemoryScan scan : this.toScan) {
                if (scan.done) continue;
                return scan;
            }
            return null;
        }
    }

    class CodeMemoryScan {
        int startadress;
        boolean done = false;

        CodeMemoryScan() {
        }
    }

    public static class OutPutDefinition {
        public String hexPrefix = "$";
        public String immediatePrefix = "#";
        public String indexedPrefix = "[";
        public String indexedPostfix = "]";
        public String _8bitPrefix = "<";
        public String _5bitPrefix = "<<";
        public String _16bitPrefix = ">";
    }
}

