/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.dissy;

import de.malban.util.UtilityString;
import de.malban.util.syntax.Syntax.TokenStyles;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DASMStatics;
import de.malban.vide.dissy.Memory;
import de.malban.vide.dissy.MemoryInformation;
import de.malban.vide.vecx.Profiler;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class MemoryInformationTableModelSmall
extends AbstractTableModel {
    VideConfig config = VideConfig.getConfig();
    public Profiler profiler = null;
    public static Boolean[] columnVisibleALL = new Boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    public Boolean[] columnVisible = new Boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    public static int[] columnWidthSmall1 = new int[]{50, 50, 150, 30, 100, 10, 20, 20, 20, 20, 20};
    public static int[] columnWidthSmall2 = new int[]{50, 50, 150, 30, 100, 10, 20, 20, 20, 20, 20};
    public static boolean wasInit = false;
    private boolean smallMode = false;
    String[] columnNamesSmall = new String[]{"Address", "Label", "Content", "Mnemonic", "Operand", "Page", "Cycles", "Mode", "->Address", "Type", "Length", "Comments", "DP", "PR access", "PR cycles", "Pr csum"};
    String[] columnNames = new String[]{"Address", "Label", "Content", "Mnemonic", "Operand", "Page", "Cycles", "Mode", "->Address", "Type", "Length", "Comments", "DP", "PR access", "PR cycles", "Pr csum"};
    private ArrayList<MemoryInformation> visible = new ArrayList();
    Memory orgData = null;
    String highLightLabel = "";
    String highLightClick = "";
    boolean fullDisplay = true;

    public void initVisibity() {
        int i;
        for (i = 0; i < columnVisibleALL.length; ++i) {
            this.columnVisible[i] = columnVisibleALL[i];
        }
        if (this.smallMode) {
            for (i = 5; i < columnVisibleALL.length; ++i) {
                this.columnVisible[i] = false;
            }
            this.columnVisible[6] = columnVisibleALL[6];
            this.columnVisible[7] = columnVisibleALL[7];
            this.columnVisible[10] = columnVisibleALL[10];
        }
    }

    public Memory getOrgData() {
        return this.orgData;
    }

    public void setFullDisplay(boolean b) {
        this.fullDisplay = b;
    }

    public static MemoryInformationTableModelSmall createModel(Memory mem) {
        MemoryInformationTableModelSmall model = new MemoryInformationTableModelSmall();
        model.orgData = mem;
        model.showAll();
        return model;
    }

    public void showAll() {
        this.visible.clear();
        int addedIndex = 0;
        for (int i = 0; i < 65536; ++i) {
            MemoryInformation memInfo = this.orgData.memMap.get(i);
            if (memInfo == null) continue;
            if (memInfo.cInfo != null) {
                this.visible.add(memInfo);
                memInfo.cInfoRow = addedIndex++;
            }
            this.visible.add(memInfo);
            memInfo.myRow = addedIndex++;
        }
    }

    public void reduceBIOS() {
        ArrayList<MemoryInformation> visibleNew = new ArrayList<MemoryInformation>();
        int addCount = 0;
        for (int i = 0; i < this.visible.size(); ++i) {
            if (this.visible.get((int)i).address >= 57344) continue;
            MemoryInformation info = this.visible.get(i);
            if (info.isCInfo()) {
                visibleNew.add(info);
                info.cInfoRow = addCount;
                info.myRow = addCount++;
                MemoryInformation info2 = this.visible.get(i + 1);
                if (info != info2) continue;
                visibleNew.add(info);
                ++i;
                info.myRow = addCount++;
                continue;
            }
            visibleNew.add(info);
            info.myRow = addCount++;
        }
        this.visible = visibleNew;
    }

    public void reduceUnkown() {
        ArrayList<MemoryInformation> visibleNew = new ArrayList<MemoryInformation>();
        int addCount = 0;
        for (int i = 0; i < this.visible.size(); ++i) {
            if (this.visible.get((int)i).disType == 0) continue;
            MemoryInformation info = this.visible.get(i);
            if (info.isCInfo()) {
                visibleNew.add(info);
                info.cInfoRow = addCount;
                info.myRow = addCount++;
                MemoryInformation info2 = this.visible.get(i + 1);
                if (info != info2) continue;
                visibleNew.add(info);
                ++i;
                info.myRow = addCount++;
                continue;
            }
            visibleNew.add(info);
            info.myRow = addCount++;
        }
        this.visible = visibleNew;
    }

    public void reduceInvisible() {
        ArrayList<MemoryInformation> visibleNew = new ArrayList<MemoryInformation>();
        int addCount = 0;
        for (int i = 0; i < this.visible.size(); ++i) {
            if (!this.visible.get((int)i).visible) continue;
            MemoryInformation info = this.visible.get(i);
            if (info.isCInfo()) {
                visibleNew.add(info);
                info.cInfoRow = addCount;
                info.myRow = addCount++;
                MemoryInformation info2 = this.visible.get(i + 1);
                if (info != info2) continue;
                visibleNew.add(info);
                ++i;
                info.myRow = addCount++;
                continue;
            }
            visibleNew.add(info);
            info.myRow = addCount++;
        }
        this.visible = visibleNew;
    }

    public void reduceCompleteInstructions() {
        ArrayList<MemoryInformation> visibleNew = new ArrayList<MemoryInformation>();
        int nextPossibleAddress = 0;
        int addCount = 0;
        for (int i = 0; i < this.visible.size(); ++i) {
            if (this.visible.get((int)i).address < nextPossibleAddress || this.visible.get((int)i).disType >= 11) continue;
            MemoryInformation info = this.visible.get(i);
            if (info.isCInfo()) {
                visibleNew.add(info);
                info.cInfoRow = addCount;
                info.myRow = addCount++;
                MemoryInformation info2 = this.visible.get(i + 1);
                if (info != info2) continue;
                visibleNew.add(info);
                ++i;
                info.myRow = addCount++;
                continue;
            }
            visibleNew.add(info);
            info.myRow = addCount++;
            nextPossibleAddress = this.visible.get((int)i).address + this.visible.get((int)i).length;
        }
        this.visible = visibleNew;
    }

    public int getNearestVisibleRow(int address) {
        int i = 0;
        for (i = 0; i < this.visible.size() && (address >= this.visible.get((int)i).address || this.visible.get(i).isCInfo(i)); ++i) {
        }
        return i - 1;
    }

    public int getRowForAddress(int address) {
        int i = 0;
        for (i = 0; i < this.visible.size(); ++i) {
            if (this.visible.get(i).isCInfo(i) || address != this.visible.get((int)i).address) continue;
            return i;
        }
        return -1;
    }

    public void setSmallMode(boolean b) {
        this.smallMode = b;
        this.initVisibity();
    }

    public int convertViewToModel(int col) {
        int ret = -1;
        int counter = 0;
        for (int i = 0; i < this.columnVisible.length; ++i) {
            if (this.columnVisible[i] == null) {
                this.columnVisible[i] = true;
            }
            if (!this.columnVisible[i].booleanValue()) continue;
            if (counter == col) {
                return i;
            }
            ++counter;
        }
        return ret;
    }

    public int convertModelToView(int col) {
        int ret = 0;
        for (int i = 0; i < this.columnVisible.length; ++i) {
            if (i == col) {
                return ret;
            }
            if (!this.columnVisible[i].booleanValue()) continue;
            ++ret;
        }
        return -1;
    }

    public int getViewColumnCount() {
        int ret = 0;
        for (int i = 0; i < this.columnVisible.length; ++i) {
            if (this.columnVisible[i] == null) {
                this.columnVisible[i] = true;
            }
            if (!this.columnVisible[i].booleanValue()) continue;
            ++ret;
        }
        return ret;
    }

    private MemoryInformationTableModelSmall() {
    }

    @Override
    public int getRowCount() {
        return this.visible.size();
    }

    public boolean isRowCInfo(int row) {
        return this.visible.get((int)row).cInfoRow == row;
    }

    @Override
    public int getColumnCount() {
        return this.getViewColumnCount();
    }

    public int getColumnOrgCount() {
        return this.columnNames.length;
    }

    public boolean isVisible(int col) {
        return this.columnVisible[col];
    }

    public int getColWidth1(int col) {
        if (col >= columnWidthSmall1.length) {
            return 10;
        }
        return columnWidthSmall1[col];
    }

    public int getColWidth2(int col) {
        if (col >= columnWidthSmall2.length) {
            return 10;
        }
        return columnWidthSmall2[col];
    }

    public MemoryInformation getValueAt(int row) {
        return this.visible.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        MemoryInformation minfo;
        try {
            minfo = this.getValueAt(row);
        }
        catch (Throwable e) {
            return "";
        }
        if (minfo.isCInfo(row)) {
            if (col == 0) {
                return "$" + String.format("%04X", minfo.address);
            }
            if (col == 1) {
                return minfo.cInfo.lineString;
            }
            return "";
        }
        if (col == 0) {
            return "$" + String.format("%04X", minfo.address);
        }
        if (col == 1) {
            StringBuilder l = new StringBuilder();
            if (!this.fullDisplay) {
                int countDisplay = 0;
                int start = -1;
                for (int i = 0; i < minfo.length; ++i) {
                    boolean displayed = false;
                    MemoryInformation next = this.orgData.memMap.get(minfo.address + i);
                    if (next == null) continue;
                    for (int ii = 0; ii < next.labels.size(); ++ii) {
                        if (!displayed) {
                            start = l.length();
                            l.append("[" + i + "]");
                            ++countDisplay;
                        }
                        displayed = true;
                        l.append(next.labels.get(ii) + ":");
                    }
                }
                if (countDisplay == 1) {
                    l.replace(start, 3, "");
                }
            } else {
                MemoryInformation next = this.orgData.memMap.get(minfo.address);
                if (next != null) {
                    for (int ii = 0; ii < next.labels.size(); ++ii) {
                        l.append(next.labels.get(ii) + ":");
                    }
                }
            }
            return l.toString();
        }
        if (col == 2) {
            if (minfo.contentUnkown) {
                return "???";
            }
            StringBuilder l = new StringBuilder();
            for (int i = 0; i < minfo.length; ++i) {
                MemoryInformation next = this.orgData.memMap.get(minfo.address + i);
                if (next == null) continue;
                l.append(String.format("%02X ", next.content & 0xFF));
            }
            return l.toString();
        }
        if (col == 3) {
            String l = minfo.disassembledMnemonic;
            return l;
        }
        if (col == 4) {
            String l = minfo.disassembledOperand;
            l = this.toHTML(l, minfo, row);
            return l;
        }
        if (col == 5) {
            String l = "" + minfo.page;
            return l;
        }
        if (col == 6) {
            MemoryInformation next;
            int page2 = minfo.page;
            if (page2 == -1) {
                return "???";
            }
            int index = 1;
            if (page2 == 0) {
                index = minfo.indexInOpcodeTablePage0;
            }
            if (page2 == 1) {
                index = -1;
                next = this.orgData.memMap.get(minfo.address + 1);
                if (next != null) {
                    index = next.indexInOpcodeTablePage1;
                }
            }
            if (page2 == 2) {
                index = -1;
                next = this.orgData.memMap.get(minfo.address + 1);
                if (next != null) {
                    index = next.indexInOpcodeTablePage2;
                }
            }
            if (index == -1) {
                return "???";
            }
            String l = "" + DASMStatics.pgpointers[page2][index].numcycles;
            return "" + minfo.cycles;
        }
        if (col == 7) {
            if (minfo.referingAddressMode == -1) {
                return "";
            }
            return DASMStatics.modenames[minfo.referingAddressMode];
        }
        if (col == 8) {
            if (minfo.referingToAddress == -1) {
                return "";
            }
            if (minfo.referingAddressMode == 3) {
                int a = minfo.referingToAddress & 0xFF;
                if (a < 128) {
                    return String.format("$%02X", a);
                }
                return String.format("-$%02X", 256 - a);
            }
            if (minfo.referingAddressMode == 6) {
                int a = minfo.referingToAddress & 0xFFFF;
                if (a < 32768) {
                    return String.format("$%04X", a);
                }
                return String.format("-$%04X", 65536 - a);
            }
            if (minfo.referingToShort) {
                return String.format("$%02X", minfo.referingToAddress);
            }
            return String.format("$%04X", minfo.referingToAddress);
        }
        if (col == 9) {
            if (minfo.disType == -2) {
                return "LOADED";
            }
            if (minfo.disType == -1) {
                return "CODE";
            }
            if (minfo.disType >= 0) {
                return MemoryInformation.disTypeString[minfo.disType];
            }
            if (minfo.disType == -3) {
                return "DB DEC";
            }
            return "UNKOWN";
        }
        if (col == 10) {
            return minfo.length;
        }
        if (col == 11) {
            StringBuilder l = new StringBuilder();
            if (!this.fullDisplay) {
                int countDisplay = 0;
                int start = -1;
                for (int i = 0; i < minfo.length; ++i) {
                    MemoryInformation next = this.orgData.memMap.get(minfo.address + i);
                    boolean displayed = false;
                    if (next == null) continue;
                    for (int ii = 0; ii < next.comments.size(); ++ii) {
                        if (!displayed) {
                            start = l.length();
                            l.append("[" + i + "]");
                            ++countDisplay;
                        }
                        displayed = true;
                        l.append(next.comments.get(ii) + ":");
                    }
                }
                if (countDisplay == 1) {
                    l.replace(start, 3, "");
                }
            } else {
                MemoryInformation next = this.orgData.memMap.get(minfo.address);
                if (next != null) {
                    for (int ii = 0; ii < next.comments.size(); ++ii) {
                        l.append(next.comments.get(ii) + ":");
                    }
                }
            }
            return l.toString();
        }
        if (col == 12) {
            String ret = "";
            ret = Math.abs(minfo.directPageAddress) < 256 ? String.format("$%02X", minfo.directPageAddress & 0xFF) : String.format("$%04X", minfo.directPageAddress & 0xFFFF);
            return ret;
        }
        int address = minfo.address;
        if (col == 13) {
            String ret = "";
            if (!this.isProfiling()) {
                return ret;
            }
            ret = this.profiler.trackingOnly ? (this.profiler.finalOnly ? "" + this.profiler.memory[address].lastTrack_accessCount_final : "" + this.profiler.memory[address].lastTrack_accessCount) : "" + this.profiler.memory[address].accessCount;
            return ret;
        }
        if (col == 14) {
            String ret = "";
            if (!this.isProfiling()) {
                return ret;
            }
            Profiler.ProfilerMemoryLocation memoryLocation = this.profiler.memory[address];
            ret = this.profiler.trackingOnly ? (this.profiler.finalOnly ? "" + this.profiler.memory[address].lastTrack_accessCycles_final : "" + this.profiler.memory[address].lastTrack_accessCycles) : "" + this.profiler.memory[address].accessCycles;
            return ret;
        }
        if (col == 15) {
            String ret = "";
            if (!this.isProfiling()) {
                return ret;
            }
            Profiler.ProfilerMemoryLocation memoryLocation = this.profiler.memory[address];
            ret = this.profiler.trackingOnly ? (this.profiler.finalOnly ? "" + (this.profiler.memory[address].caller_lastTrack_accessCyclesSum_final + this.profiler.memory[address].lastTrack_accessCycles_final) : "" + (this.profiler.memory[address].caller_lastTrack_accessCyclesSum + this.profiler.memory[address].lastTrack_accessCycles)) : "" + (this.profiler.memory[address].accessCyclesSum + this.profiler.memory[address].accessCycles);
            return ret;
        }
        return "-";
    }

    @Override
    public String getColumnName(int column) {
        if (this.smallMode) {
            return this.columnNamesSmall[column];
        }
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.smallMode) {
            return false;
        }
        if (this.isRowCInfo(rowIndex)) {
            return false;
        }
        if (columnIndex == 11) {
            return true;
        }
        return columnIndex == 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        MemoryInformation memInfo;
        if (this.smallMode) {
            return;
        }
        if (columnIndex == 1) {
            String[] labels;
            memInfo = this.getValueAt(rowIndex);
            ArrayList oldLabels = (ArrayList)memInfo.labels.clone();
            memInfo.labels.clear();
            String label = aValue.toString();
            String[] stringArray = labels = label.split(":");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String l = stringArray[i];
                if (l.trim().length() <= 0) continue;
                memInfo.labels.add(l);
            }
            boolean changeRelevant = true;
            if (this.orgData != null) {
                changeRelevant = this.orgData.labelsChanged(memInfo, oldLabels);
            }
            if (changeRelevant) {
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
        if (columnIndex == 11) {
            String[] comments;
            memInfo = this.getValueAt(rowIndex);
            memInfo.comments.clear();
            String comment = aValue.toString();
            for (String c : comments = comment.split(":")) {
                memInfo.comments.add(c);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public Color getBackground(int row, int c) {
        String op;
        MemoryInformation minfo = this.getValueAt(row);
        int col = this.convertViewToModel(c);
        if (col == 0) {
            return this.config.tableAddress;
        }
        if (minfo.isCInfo(row)) {
            return this.config.cLinesBack;
        }
        if (this.highLightClick.length() > 0 && col == 4 && (op = this.getValueAt(row, col).toString()).contains(this.highLightClick)) {
            return Color.GREEN;
        }
        if (this.highLightLabel.length() > 0 && col == 4 && (op = this.getValueAt(row, col).toString()).toLowerCase().contains(this.highLightLabel)) {
            return Color.YELLOW;
        }
        MemoryInformation memInfo = this.getValueAt(row);
        if (memInfo.address >= 57344) {
            return this.config.tableBIOS;
        }
        if (this.orgData.currentBank != 0) {
            return this.config.tableOtherBank;
        }
        return null;
    }

    public Color getForeground(int row, int col) {
        MemoryInformation minfo = this.getValueAt(row);
        if (minfo.isCInfo(row) && col != 0) {
            return this.config.cLinesFore;
        }
        return null;
    }

    public void setHighliteLabel(String h) {
        this.highLightLabel = h.trim().toLowerCase();
    }

    public void setHighliteClick(String h) {
        this.highLightClick = h.trim();
    }

    public boolean isProfiling() {
        if (this.profiler == null) {
            return false;
        }
        return this.config.doProfile;
    }

    String toHTML(String l, MemoryInformation minfo, int row) {
        boolean isAddress;
        l = UtilityString.replace(l, "0", "~0!");
        l = UtilityString.replace(l, "1", "~1!");
        l = UtilityString.replace(l, "2", "~2!");
        l = UtilityString.replace(l, "3", "~3!");
        l = UtilityString.replace(l, "4", "~4!");
        l = UtilityString.replace(l, "5", "~5!");
        l = UtilityString.replace(l, "6", "~6!");
        l = UtilityString.replace(l, "7", "~7!");
        l = UtilityString.replace(l, "8", "~8!");
        l = UtilityString.replace(l, "9", "~9!");
        l = UtilityString.replace(l, "a", "~a!");
        l = UtilityString.replace(l, "b", "~b!");
        l = UtilityString.replace(l, "c", "~c!");
        l = UtilityString.replace(l, "d", "~d!");
        l = UtilityString.replace(l, "e", "~e!");
        l = UtilityString.replace(l, "f", "~f!");
        l = UtilityString.replace(l, "A", "~A!");
        l = UtilityString.replace(l, "B", "~B!");
        l = UtilityString.replace(l, "C", "~C!");
        l = UtilityString.replace(l, "D", "~D!");
        l = UtilityString.replace(l, "E", "~E!");
        l = UtilityString.replace(l, "F", "~F!");
        Object o = this.getValueAt(row, 3);
        String mnemonic = "";
        boolean bl = isAddress = minfo.referingToAddress != -1;
        if (o != null) {
            mnemonic = o.toString().toLowerCase();
        }
        AttributeSet _operator = TokenStyles.getStyle("operator");
        Color c = StyleConstants.getForeground(_operator);
        String operatorColor = "???HASH???" + String.format("%02X", c.getRed() & 0xFF) + String.format("%02X", c.getGreen() & 0xFF) + String.format("%02X", c.getBlue() & 0xFF);
        AttributeSet _variable = TokenStyles.getStyle("literalVariable");
        c = StyleConstants.getForeground(_variable);
        String variableColor = "???HASH???" + String.format("%02X", c.getRed() & 0xFF) + String.format("%02X", c.getGreen() & 0xFF) + String.format("%02X", c.getBlue() & 0xFF);
        AttributeSet _register = TokenStyles.getStyle("register");
        c = StyleConstants.getForeground(_register);
        String registerColor = "???HASH???" + String.format("%02X", c.getRed() & 0xFF) + String.format("%02X", c.getGreen() & 0xFF) + String.format("%02X", c.getBlue() & 0xFF);
        AttributeSet _literal = TokenStyles.getStyle("literal");
        c = StyleConstants.getForeground(_literal);
        String literalColor = "???HASH???" + String.format("%02X", c.getRed() & 0xFF) + String.format("%02X", c.getGreen() & 0xFF) + String.format("%02X", c.getBlue() & 0xFF);
        AttributeSet _preprop = TokenStyles.getStyle("preprocessor");
        c = StyleConstants.getForeground(_preprop);
        String prepropColor = "???HASH???" + String.format("%02X", c.getRed() & 0xFF) + String.format("%02X", c.getGreen() & 0xFF) + String.format("%02X", c.getBlue() & 0xFF);
        AttributeSet _literalString = TokenStyles.getStyle("literalstring");
        c = StyleConstants.getForeground(_literalString);
        String literalStringColor = "???HASH???" + String.format("%02X", c.getRed() & 0xFF) + String.format("%02X", c.getGreen() & 0xFF) + String.format("%02X", c.getBlue() & 0xFF);
        boolean isStringValue = false;
        String innerStringValue = "";
        if (mnemonic.equals("db") && l.trim().startsWith("\"")) {
            innerStringValue = l.substring(1, l.lastIndexOf("\""));
            l = UtilityString.replace(l, innerStringValue, "---INNER_STRING_VALUE---");
            innerStringValue = UtilityString.toXML(UtilityString.onlyXMLVisibleASCII(innerStringValue));
            isStringValue = true;
        }
        String r = l;
        r = UtilityString.replace(r, "#", "!!!HASH!!!");
        r = "<html>" + UtilityString.toXML(UtilityString.onlyXMLVisibleASCII(r)) + "</html>";
        String sl = UtilityString.replace(l, "<", "");
        sl = UtilityString.replace(sl, ">", "");
        sl = UtilityString.replace(sl, "#", "");
        r = UtilityString.replace(r, sl, "<font color='" + variableColor + "'>" + sl + "</font>");
        if (mnemonic.equals("db") || mnemonic.equals("dw")) {
            sl = UtilityString.replace(l, "\"", "&quot;");
            if (mnemonic.equals("db")) {
                r = UtilityString.replace(r, sl, "<font color='" + literalColor + "'>" + sl + "</font>");
            } else if (l.contains("$")) {
                r = UtilityString.replace(r, sl, "<font color='" + literalColor + "'>" + sl + "</font>");
            }
        } else if (isAddress) {
            o = this.getValueAt(row, 8);
            if (o != null) {
                String os = o.toString();
                r = UtilityString.replace(r, os, "<font color='" + literalColor + "'>" + os + "</font>");
            }
        } else {
            sl = UtilityString.replace(l, "<<", "");
            sl = UtilityString.replace(sl, "<", "");
            sl = UtilityString.replace(sl, ">", "");
            if ((sl = UtilityString.replace(sl, "-", "")).contains(",") && (sl = sl.substring(0, sl.indexOf(","))).length() != 0) {
                r = UtilityString.replace(r, sl, "<font color='" + literalColor + "'>" + sl + "</font>");
            }
            if (!l.startsWith("#")) {
                r = UtilityString.replace(r, "~a!", "<font color='" + registerColor + "'>~a!</font>");
                r = UtilityString.replace(r, "~b!", "<font color='" + registerColor + "'>~b!</font>");
                r = UtilityString.replace(r, "~d!", "<font color='" + registerColor + "'>~d!</font>");
                r = UtilityString.replace(r, "dp", "<font color='" + registerColor + "'>dp</font>");
                r = UtilityString.replace(r, "x", "<font color='" + registerColor + "'>x</font>");
                r = UtilityString.replace(r, "y", "<font color='" + registerColor + "'>y</font>");
                r = UtilityString.replace(r, "u", "<font color='" + registerColor + "'>u</font>");
                r = UtilityString.replace(r, "s", "<font color='" + registerColor + "'>s</font>");
                r = UtilityString.replace(r, "pc", "<font color='" + registerColor + "'>pc</font>");
                r = UtilityString.replace(r, "cc", "<font color='" + registerColor + "'>cc</font>");
            } else if (l.substring(1).startsWith("$") || l.substring(1).startsWith("%")) {
                r = UtilityString.replace(r, l.substring(1), "<font color='" + literalColor + "'>" + l.substring(1) + "</font>");
            }
        }
        if (isStringValue) {
            innerStringValue = UtilityString.replace(innerStringValue, "&#x20;", " ");
            r = UtilityString.replace(r, "---INNER_STRING_VALUE---", "<font color='" + literalStringColor + "'>" + innerStringValue + "</font>");
        }
        r = UtilityString.replace(r, "!!!HASH!!!", "<font color='" + operatorColor + "'>#</font>");
        r = UtilityString.replace(r, "[", "<font color='" + operatorColor + "'>[</font>");
        r = UtilityString.replace(r, "]", "<font color='" + operatorColor + "'>]</font>");
        r = UtilityString.replace(r, "+", "<font color='" + operatorColor + "'>+</font>");
        r = UtilityString.replace(r, "-", "<font color='" + operatorColor + "'>-</font>");
        r = UtilityString.replace(r, "&quot;", "<font color='" + operatorColor + "'>&quot;</font>");
        r = UtilityString.replace(r, ",", "<font color='" + operatorColor + "'>,</font>");
        r = UtilityString.replace(r, "&lt;", "<font color='" + operatorColor + "'>&lt;</font>");
        r = UtilityString.replace(r, "&gt;", "<font color='" + operatorColor + "'>&gt;</font>");
        r = UtilityString.replace(r, "???HASH???", "#");
        r = UtilityString.replace(r, "font color", "font face='Monospaced' color");
        r = UtilityString.replace(r, "_", "<u>&nbsp;</u>");
        r = UtilityString.replace(r, "<html>", "<html><nobr>");
        r = UtilityString.replace(r, "</html>", "</nobr></html>");
        r = UtilityString.replace(r, "&apos;", "'");
        r = UtilityString.replace(r, "&quot;", "\"");
        r = UtilityString.replace(r, "&amp;", "&");
        r = UtilityString.replace(r, "~0!", "0");
        r = UtilityString.replace(r, "~1!", "1");
        r = UtilityString.replace(r, "~2!", "2");
        r = UtilityString.replace(r, "~3!", "3");
        r = UtilityString.replace(r, "~4!", "4");
        r = UtilityString.replace(r, "~5!", "5");
        r = UtilityString.replace(r, "~6!", "6");
        r = UtilityString.replace(r, "~7!", "7");
        r = UtilityString.replace(r, "~8!", "8");
        r = UtilityString.replace(r, "~9!", "9");
        r = UtilityString.replace(r, "~a!", "a");
        r = UtilityString.replace(r, "~b!", "b");
        r = UtilityString.replace(r, "~c!", "c");
        r = UtilityString.replace(r, "~d!", "d");
        r = UtilityString.replace(r, "~e!", "e");
        r = UtilityString.replace(r, "~f!", "f");
        r = UtilityString.replace(r, "~A!", "A");
        r = UtilityString.replace(r, "~B!", "B");
        r = UtilityString.replace(r, "~C!", "C");
        r = UtilityString.replace(r, "~D!", "D");
        r = UtilityString.replace(r, "~E!", "E");
        r = UtilityString.replace(r, "~F!", "F");
        return r;
    }
}

