/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.dissy;

import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.vecx.panels.RegisterJPanel;

public class Watch {
    public static int WATCHTYPE_BINARY = 0;
    public static int WATCHTYPE_BYTE_8 = 1;
    public static int WATCHTYPE_BYTE_16 = 2;
    public static int WATCHTYPE_STRING = 3;
    public static int WATCHTYPE_BYTE_PAIR = 4;
    public static int WATCHTYPE_BYTE_SEQUENCE = 5;
    DissiPanel dissi = null;
    int startaddress = 0;
    int type = 0;
    int length = 1;

    private Watch() {
    }

    public String toString() {
        if (this.dissi == null) {
            return "";
        }
        int val = this.peek(this.startaddress) & 0xFF;
        if (this.type == WATCHTYPE_BINARY) {
            return "%" + RegisterJPanel.printbinary(val);
        }
        if (this.type == WATCHTYPE_BYTE_8) {
            String ret = "$" + String.format("%02X", val);
            ret = ret + " #" + val + "(#" + (val > 127 ? val - 256 : val) + "), binary: %" + RegisterJPanel.printbinary(val);
            return ret;
        }
        if (this.type == WATCHTYPE_BYTE_16) {
            int val16 = (val & 0xFF) * 256 + this.peek((this.startaddress + 1) % 65536);
            String ret = "$" + String.format("%04X", val16);
            ret = ret + " #" + val16 + "(#" + (val16 > Short.MAX_VALUE ? val16 - 32768 : val16) + ")";
            return ret;
        }
        if (this.type == WATCHTYPE_BYTE_PAIR) {
            String ret = "$" + String.format("%02X", this.peek(this.startaddress));
            ret = ret + " $" + String.format("%02X", this.peek((this.startaddress + 1) % 65536));
            return ret;
        }
        if (this.type == WATCHTYPE_BYTE_SEQUENCE) {
            String ret = "";
            for (int i = 0; i < this.length; ++i) {
                if (ret.length() > 0) {
                    ret = ret + " ";
                }
                ret = ret + "$" + String.format("%02X", this.peek((this.startaddress + i) % 65536));
            }
            return ret;
        }
        if (this.type == WATCHTYPE_STRING) {
            String ret = "";
            int v = 0;
            int count = 0;
            while ((v = this.peek((this.startaddress + count) % 65536)) != 0 && v <= 127 && v >= 0) {
                ret = ret + (char)v;
                ++count;
            }
            return ret;
        }
        return "";
    }

    private int peek(int address) {
        if (this.dissi == null) {
            return 0;
        }
        if (this.dissi.currentDissi == null) {
            return 0;
        }
        if (this.dissi.currentDissi.vecxPanel == null) {
            return 0;
        }
        return this.dissi.currentDissi.vecxPanel.getVecXMem8(address) & 0xFF;
    }

    public static void addWatch(int address, int t, int l, DissiPanel d) {
        Watch.removeWatch(address, d);
        Watch w = new Watch();
        w.startaddress = address;
        w.type = t;
        w.length = l;
        w.dissi = d;
        d.currentDissi.watchlist.add(w);
    }

    public static void removeWatch(int address, DissiPanel d) {
        Watch w = new Watch();
        w.startaddress = address;
        d.currentDissi.removeWatchByAddress(address);
    }
}

