/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.script;

import de.malban.graphics.GFXVector;
import de.malban.graphics.Vertex;
import de.malban.util.UtilityString;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Vector;

public class DBParser {
    public static final int UNKOWN = -1;
    public static final int Draw_VLc = 0;
    public static final int Draw_VL_b = 1;
    public static final int Draw_VLcs = 2;
    public static final int Draw_VLp = 3;
    public static final int Draw_VLp_scale = 4;
    int listType = -1;
    int pos = 0;
    boolean loaded = false;
    String data = "";
    public static final int DB = 0;
    public static final int DW = 1;

    public boolean readFile(String filename) {
        Path path = Paths.get(filename, new String[0]);
        try {
            this.data = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            this.data = UtilityString.replace(this.data, "\r\n", "\n");
            this.data = UtilityString.replace(this.data, "\t", "  ");
            this.loaded = true;
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }

    String tillEndOfLine() {
        StringBuffer b = new StringBuffer();
        String sign = "";
        while (!sign.equals("\n") && this.pos < this.data.length()) {
            sign = this.data.substring(this.pos, this.pos + 1);
            if (!sign.equals("\n")) {
                b.append(sign);
            }
            ++this.pos;
        }
        return b.toString();
    }

    void oneLineBack() {
        char c;
        do {
            --this.pos;
            if (this.pos != 0) continue;
            return;
        } while ((c = this.data.charAt(this.pos)) != '\n');
        do {
            --this.pos;
            if (this.pos != 0) continue;
            return;
        } while ((c = this.data.charAt(this.pos)) != '\n');
        ++this.pos;
    }

    void lineStart() {
        char c;
        do {
            --this.pos;
            if (this.pos != 0) continue;
            return;
        } while ((c = this.data.charAt(this.pos)) != '\n');
        ++this.pos;
    }

    boolean isEOF() {
        return this.pos >= this.data.length();
    }

    void skipWord() {
        while (!UtilityString.isWordBoundry(this.data.charAt(this.pos))) {
            ++this.pos;
        }
    }

    String getWord() {
        char c;
        StringBuffer b = new StringBuffer();
        if (this.pos >= this.data.length()) {
            return "";
        }
        while (!UtilityString.isWordBoundry(c = this.data.charAt(this.pos))) {
            b.append(c);
            ++this.pos;
            if (this.pos < this.data.length()) continue;
            break;
        }
        return b.toString();
    }

    String getWord(String line) {
        char c;
        int p = 0;
        StringBuffer b = new StringBuffer();
        if (p >= line.length()) {
            return "";
        }
        while (!UtilityString.isWordBoundry(c = line.charAt(p))) {
            b.append(c);
            if (++p < line.length()) continue;
            break;
        }
        return b.toString();
    }

    public void setPositionAfterLabel() {
        String line;
        while ((line = this.tillEndOfLine()).startsWith(" ") || line.startsWith(";") || line.startsWith("*")) {
        }
        this.skipWord();
        if (this.data.charAt(this.pos) == ':') {
            ++this.pos;
        }
    }

    public void setPositionAfterLabel(String label) {
        String word;
        String line;
        do {
            line = this.tillEndOfLine();
            if (!this.isEOF()) continue;
            return;
        } while (line.startsWith(" ") || line.startsWith(";") || line.startsWith("*") || !(word = this.getWord(line)).equals(label));
        this.pos -= line.length() - word.length();
        if (this.data.charAt(this.pos) == ':') {
            ++this.pos;
        }
    }

    public void setPositionAfterFind(String text) {
        this.pos = this.data.indexOf(text);
        this.pos = this.pos == -1 ? 0 : (this.pos += text.length());
    }

    public void setPosition(int p) {
        this.pos = p;
    }

    public void setPositionToLine(int line) {
        int p;
        String[] lines = this.data.split("\n");
        if (line >= lines.length) {
            return;
        }
        int lc = 0;
        for (p = 0; p < line; p += lines[lc++].length() + 1) {
        }
        this.pos = p;
    }

    public int getNextDataType() {
        String line;
        int lineStartSave = 0;
        int t = -1;
        do {
            lineStartSave = this.pos;
            line = this.tillEndOfLine();
            if (this.isEOF()) {
                return -1;
            }
            if (t == -1 && line.toLowerCase().contains(" db ")) {
                t = 0;
            }
            if (t != -1 || !line.toLowerCase().contains(" dw ")) continue;
            t = 1;
        } while (t == -1);
        this.pos = lineStartSave;
        if (t == 0) {
            this.pos += line.toLowerCase().indexOf(" db ") + 4;
        }
        if (t == 1) {
            this.pos += line.toLowerCase().indexOf(" dw ") + 4;
        }
        return t;
    }

    boolean skipWhiteSpaces() {
        char c = this.data.charAt(this.pos);
        while (c == ' ' || c == '\t' || c == '\n') {
            if (c == '\n') {
                ++this.pos;
                return true;
            }
            ++this.pos;
            c = this.data.charAt(this.pos);
        }
        return false;
    }

    public String getNextDataText() {
        StringBuffer b = new StringBuffer();
        if (this.skipWhiteSpaces()) {
            return "";
        }
        do {
            char c = this.data.charAt(this.pos);
            ++this.pos;
            if (c == '\n' || c == ',') break;
            b.append(c);
        } while (this.pos < this.data.length());
        return b.toString();
    }

    public int getNextDataIntValue() {
        String t = this.getNextDataText();
        t = this.stripOperators(t);
        return DBParser.toNumber(t);
    }

    String stripOperators(String s) {
        StringBuffer r = new StringBuffer();
        int p = 0;
        char c = s.charAt(p++);
        while (!this.isDigit(c, true)) {
            if (p >= s.length()) {
                return "";
            }
            c = s.charAt(p++);
        }
        boolean first = true;
        while (this.isDigit(c, first)) {
            r.append(c);
            first = false;
            if (p >= s.length()) break;
            c = s.charAt(p++);
        }
        return r.toString();
    }

    boolean isDigit(char c, boolean acceptOp) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (!acceptOp) {
            return false;
        }
        if (c == '$') {
            return true;
        }
        if (c == '-') {
            return true;
        }
        return c == '+';
    }

    public static int toNumber(String s) {
        s = s.toUpperCase();
        boolean minus = false;
        int radix = 10;
        int result = 0;
        if (s.startsWith("-")) {
            minus = true;
            s = s.substring(1);
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (s.startsWith("$")) {
            radix = 16;
            s = s.substring(1);
        }
        if (s.toLowerCase().startsWith("0x")) {
            s = s.substring(2);
            radix = 16;
        }
        try {
            result = Integer.parseInt(s, radix);
            if (minus) {
                result *= -1;
            }
        }
        catch (Throwable ex) {
            return Integer.MAX_VALUE;
        }
        return result;
    }

    public Vertex getNextVertex() {
        return null;
    }

    public GFXVector getNextVector() {
        return null;
    }

    public Vector getNextVectorList() {
        Vector<GFXVector> ret = new Vector<GFXVector>();
        if (this.listType == 0) {
            if (this.getNextDataType() != 0) {
                return null;
            }
            int length = this.getNextDataIntValue();
            if (length == Integer.MAX_VALUE) {
                return null;
            }
            GFXVector oldVector = null;
            for (int i = 0; i < length; ++i) {
                GFXVector vector;
                if (this.getNextDataType() != 0) {
                    return null;
                }
                int x = this.getNextDataIntValue();
                if (x == Integer.MAX_VALUE) {
                    return null;
                }
                int y = this.getNextDataIntValue();
                if (y == Integer.MAX_VALUE) {
                    return null;
                }
                oldVector = vector = new GFXVector(oldVector, x, y, 0);
                ret.addElement(vector);
            }
        }
        return ret;
    }

    public void setExpectedListType(int type) {
        this.listType = type;
    }
}

