/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.script;

import de.malban.Global;
import de.malban.vide.script.ExportData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ExportDataPool {
    public static final String DEFAULT_XML_NAME = new String("ExportData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, ExportData> mExportData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public ExportDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public ExportDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error ExportData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mExportData = ExportData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        ExportData.saveCollectionAsXML(this.mFileName, this.mExportData.values());
        this.buildKlassenMap();
    }

    public void remove(ExportData st) {
        this.mExportData.remove(st.mName);
    }

    public void put(ExportData st) {
        this.mExportData.remove(st.mName);
        this.mExportData.put(st.mName, st);
    }

    public void putAsNew(ExportData st) {
        this.mExportData.put(st.mName, st);
    }

    public ExportData get(String key) {
        return this.mExportData.get(key);
    }

    public HashMap<String, ExportData> getHashMap() {
        return this.mExportData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, ExportData>> entries = this.mExportData.entrySet();
        for (Map.Entry<String, ExportData> entry : entries) {
            ExportData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, ExportData> getMapForKlasse(String klasse) {
        HashMap<String, ExportData> ret = new HashMap<String, ExportData>();
        Set<Map.Entry<String, ExportData>> entries = this.mExportData.entrySet();
        for (Map.Entry<String, ExportData> entry : entries) {
            ExportData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

