/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.vide.veccy.ActionData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ActionDataPool {
    public static final String DEFAULT_XML_NAME = new String("ActionData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, ActionData> mActionData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public ActionDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public ActionDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error ActionData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mActionData = ActionData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        ActionData.saveCollectionAsXML(this.mFileName, this.mActionData.values());
        this.buildKlassenMap();
    }

    public void remove(ActionData st) {
        this.mActionData.remove(st.mName);
    }

    public void put(ActionData st) {
        this.mActionData.remove(st.mName);
        this.mActionData.put(st.mName, st);
    }

    public void putAsNew(ActionData st) {
        this.mActionData.put(st.mName, st);
    }

    public ActionData get(String key) {
        return this.mActionData.get(key);
    }

    public HashMap<String, ActionData> getHashMap() {
        return this.mActionData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, ActionData>> entries = this.mActionData.entrySet();
        for (Map.Entry<String, ActionData> entry : entries) {
            ActionData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, ActionData> getMapForKlasse(String klasse) {
        HashMap<String, ActionData> ret = new HashMap<String, ActionData>();
        Set<Map.Entry<String, ActionData>> entries = this.mActionData.entrySet();
        for (Map.Entry<String, ActionData> entry : entries) {
            ActionData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

