/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.vide.veccy.ActionNewData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ActionNewDataPool {
    public static final String DEFAULT_XML_NAME = new String("ActionNewData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, ActionNewData> mActionNewData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public ActionNewDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public ActionNewDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error ActionNewData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mActionNewData = ActionNewData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        ActionNewData.saveCollectionAsXML(this.mFileName, this.mActionNewData.values());
        this.buildKlassenMap();
    }

    public void remove(ActionNewData st) {
        this.mActionNewData.remove(st.mName);
    }

    public void put(ActionNewData st) {
        this.mActionNewData.remove(st.mName);
        this.mActionNewData.put(st.mName, st);
    }

    public void putAsNew(ActionNewData st) {
        this.mActionNewData.put(st.mName, st);
    }

    public ActionNewData get(String key) {
        return this.mActionNewData.get(key);
    }

    public HashMap<String, ActionNewData> getHashMap() {
        return this.mActionNewData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, ActionNewData>> entries = this.mActionNewData.entrySet();
        for (Map.Entry<String, ActionNewData> entry : entries) {
            ActionNewData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, ActionNewData> getMapForKlasse(String klasse) {
        HashMap<String, ActionNewData> ret = new HashMap<String, ActionNewData>();
        Set<Map.Entry<String, ActionNewData>> entries = this.mActionNewData.entrySet();
        for (Map.Entry<String, ActionNewData> entry : entries) {
            ActionNewData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

