/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.Single3dDisplayPanel;
import de.malban.graphics.Vertex;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.util.Utility;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.ActionData;
import de.malban.vide.veccy.ActionDataPool;
import de.malban.vide.veccy.ActionNewData;
import de.malban.vide.veccy.ActionResultData;
import de.malban.vide.veccy.ActionResultDataPool;
import de.malban.vide.veccy.ActionTriggerData;
import de.malban.vide.veccy.ActionTriggerDataPool;
import de.malban.vide.veccy.SpriteData;
import de.malban.vide.veccy.SpriteDataPool;
import de.malban.vide.veccy.VectorListFileChoserJPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class ActionPanel
extends JPanel {
    ActionTriggerDataPool mTriggerPool = new ActionTriggerDataPool();
    ActionResultDataPool mResultPool = new ActionResultDataPool();
    private ActionNewData data = new ActionNewData();
    private ActionTriggerData triggers = new ActionTriggerData();
    private ActionResultData results = new ActionResultData();
    private SpriteData sprite = new SpriteData();
    private GFXVectorAnimation currentAnimation = new GFXVectorAnimation();
    private int inGuiUpdate = 0;
    int currentEventRow = -1;
    String lastPath = Global.mainPathPrefix;
    private Single3dDisplayPanel actionAnimation;
    private Single3dDisplayPanel actionBoundingBox;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButtonAddEvent;
    private JButton jButtonAddResult;
    private JButton jButtonAddTrigger;
    private JButton jButtonDeleteLastPosRow;
    private JButton jButtonLoad2;
    private JButton jButtonLoad3;
    private JButton jButtonNewPosRow;
    private JButton jButtonRemoveEvent;
    private JButton jButtonRemoveResult;
    private JButton jButtonRemoveTrigger;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBoxSoundLoop;
    private JComboBox<String> jComboBoxBehaviour;
    private JComboBox<String> jComboBoxTextType;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JSlider jSliderSourceScale;
    private JTable jTableDeltaTable;
    private JTable jTableEventTable;
    private JTable jTablePositioningTable;
    private JTable jTableResultTable;
    private JTable jTableTriggerTable;
    private JTextArea jTextAreaText;
    private JTextField jTextFieldActionId;
    private JTextField jTextFieldAnimationName;
    private JTextField jTextFieldBoundingBoxOffsetX;
    private JTextField jTextFieldBoundingBoxOffsetY;
    private JTextField jTextFieldIntensity;
    private JTextField jTextFieldSoundName;
    private JTextField jTextFieldWhileActiveChangeX;
    private JTextField jTextFieldWhileActiveChangeY;
    private JTextField jTextFieldtextHeight;
    private JTextField jTextFieldtextWidth;
    GFXVectorAnimation boundingAnimation = new GFXVectorAnimation();
    static int BLOW = 10;

    public ActionPanel() {
        this.initComponents();
        this.actionAnimation.setSingleRepaint(true);
        this.actionAnimation.setScale(40.0);
        this.actionAnimation.setAngleX(0);
        this.actionAnimation.setAngleY(0);
        this.actionAnimation.setAngleZ(0);
        this.actionAnimation.setAxisAngleX(0);
        this.actionAnimation.setAxisAngleY(0);
        this.actionAnimation.setAxisAngleZ(0);
        this.actionBoundingBox.setSingleRepaint(true);
        this.actionBoundingBox.setScale(40.0);
        this.actionBoundingBox.setAngleX(0);
        this.actionBoundingBox.setAngleY(0);
        this.actionBoundingBox.setAngleZ(0);
        this.actionBoundingBox.setAxisAngleX(0);
        this.actionBoundingBox.setAxisAngleY(0);
        this.actionBoundingBox.setAxisAngleZ(0);
        this.jSliderSourceScaleStateChanged(null);
        this.tableSetup();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jCheckBox1 = new JCheckBox();
        this.actionAnimation = new Single3dDisplayPanel();
        this.jTextFieldAnimationName = new JTextField();
        this.jButtonLoad2 = new JButton();
        this.jLabel3 = new JLabel();
        this.jSliderSourceScale = new JSlider();
        this.jLabel13 = new JLabel();
        this.jTextFieldActionId = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextFieldWhileActiveChangeY = new JTextField();
        this.jTextFieldWhileActiveChangeX = new JTextField();
        this.jLabel16 = new JLabel();
        this.jCheckBoxSoundLoop = new JCheckBox();
        this.jTextFieldSoundName = new JTextField();
        this.jButtonLoad3 = new JButton();
        this.jButton1 = new JButton();
        this.jComboBoxBehaviour = new JComboBox();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTablePositioningTable = new JTable();
        this.jButtonDeleteLastPosRow = new JButton();
        this.jButtonNewPosRow = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableEventTable = new JTable();
        this.jButtonAddEvent = new JButton();
        this.jButtonRemoveEvent = new JButton();
        this.jLabel19 = new JLabel();
        this.actionBoundingBox = new Single3dDisplayPanel();
        this.jLabel15 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jTextFieldBoundingBoxOffsetY = new JTextField();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTableDeltaTable = new JTable();
        this.jLabel21 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jComboBoxTextType = new JComboBox();
        this.jTextFieldtextHeight = new JTextField();
        this.jTextFieldtextWidth = new JTextField();
        this.jTextFieldBoundingBoxOffsetX = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldIntensity = new JTextField();
        this.jScrollPane4 = new JScrollPane();
        this.jTextAreaText = new JTextArea();
        this.jLabel22 = new JLabel();
        this.jButtonAddTrigger = new JButton();
        this.jButtonRemoveTrigger = new JButton();
        this.jScrollPane5 = new JScrollPane();
        this.jTableTriggerTable = new JTable();
        this.jButtonAddResult = new JButton();
        this.jButtonRemoveResult = new JButton();
        this.jLabel23 = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.jTableResultTable = new JTable();
        this.jCheckBox1.setText("jCheckBox1");
        this.actionAnimation.setMaximumSize(new Dimension(150, 150));
        this.actionAnimation.setMinimumSize(new Dimension(150, 150));
        GroupLayout actionAnimationLayout = new GroupLayout(this.actionAnimation);
        this.actionAnimation.setLayout(actionAnimationLayout);
        actionAnimationLayout.setHorizontalGroup(actionAnimationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        actionAnimationLayout.setVerticalGroup(actionAnimationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jTextFieldAnimationName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jTextFieldAnimationNameActionPerformed(evt);
            }
        });
        this.jButtonLoad2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad2.setToolTipText("load animation");
        this.jButtonLoad2.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonLoad2ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("animation file");
        this.jSliderSourceScale.setMajorTickSpacing(1);
        this.jSliderSourceScale.setMaximum(50);
        this.jSliderSourceScale.setMinimum(1);
        this.jSliderSourceScale.setMinorTickSpacing(1);
        this.jSliderSourceScale.setOrientation(1);
        this.jSliderSourceScale.setValue(20);
        this.jSliderSourceScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ActionPanel.this.jSliderSourceScaleStateChanged(evt);
            }
        });
        this.jLabel13.setText("ID");
        this.jLabel14.setText("delta: y, x");
        this.jLabel14.setToolTipText("while the action is active change y and x position");
        this.jTextFieldWhileActiveChangeY.setHorizontalAlignment(11);
        this.jTextFieldWhileActiveChangeY.setText("0");
        this.jTextFieldWhileActiveChangeY.setToolTipText("update position y while active");
        this.jTextFieldWhileActiveChangeY.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ActionPanel.this.jTextFieldWhileActiveChangeYFocusLost(evt);
            }
        });
        this.jTextFieldWhileActiveChangeY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jTextFieldWhileActiveChangeYActionPerformed(evt);
            }
        });
        this.jTextFieldWhileActiveChangeX.setHorizontalAlignment(11);
        this.jTextFieldWhileActiveChangeX.setText("0");
        this.jTextFieldWhileActiveChangeX.setToolTipText("update position x while active");
        this.jTextFieldWhileActiveChangeX.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ActionPanel.this.jTextFieldWhileActiveChangeXFocusLost(evt);
            }
        });
        this.jTextFieldWhileActiveChangeX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jTextFieldWhileActiveChangeXActionPerformed(evt);
            }
        });
        this.jLabel16.setText("sound (afx)");
        this.jCheckBoxSoundLoop.setText("loop");
        this.jTextFieldSoundName.setToolTipText("ym\naks (from arkos tracker 1)\n??? (universal arkos tracker 2)\nafx \n\n");
        this.jTextFieldSoundName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jTextFieldSoundNameActionPerformed(evt);
            }
        });
        this.jButtonLoad3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad3.setToolTipText("load animation");
        this.jButtonLoad3.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonLoad3ActionPerformed(evt);
            }
        });
        this.jButton1.setText("play");
        this.jButton1.setEnabled(false);
        this.jComboBoxBehaviour.setModel(new DefaultComboBoxModel<String>(new String[]{"player 1 controlled", "player 2 controlled", "fixed position", "fixed movement (not done)", "parent direction", "target player 1", "track player 1 (not done)", "follow sprite", "sprite", "patrol", "text", "trigger only"}));
        this.jLabel17.setText("behaviour");
        this.jLabel18.setText("positioning");
        this.jTablePositioningTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTablePositioningTable);
        this.jButtonDeleteLastPosRow.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonDeleteLastPosRow.setToolTipText("Removes the last row of the positions table");
        this.jButtonDeleteLastPosRow.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDeleteLastPosRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonDeleteLastPosRowActionPerformed(evt);
            }
        });
        this.jButtonNewPosRow.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonNewPosRow.setToolTipText("add one row to positions table");
        this.jButtonNewPosRow.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonNewPosRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonNewPosRowActionPerformed(evt);
            }
        });
        this.jTableEventTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableEventTable.setToolTipText("<html>\nFor -> y, x<bR>\na value is possible<bR>\n++, -- is possible <bR>\n+=x, -=x is possible for x < 10<bR>\nx is possible - no change <bR>\n=xxx is possible - a global 8 bit variable<bR>\n</html>");
        this.jTableEventTable.getTableHeader().setResizingAllowed(false);
        this.jTableEventTable.getTableHeader().setReorderingAllowed(false);
        this.jTableEventTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ActionPanel.this.jTableEventTableMousePressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableEventTable);
        this.jButtonAddEvent.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonAddEvent.setToolTipText("add one trigger");
        this.jButtonAddEvent.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAddEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonAddEventActionPerformed(evt);
            }
        });
        this.jButtonRemoveEvent.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonRemoveEvent.setToolTipText("remove the selected  trigger");
        this.jButtonRemoveEvent.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonRemoveEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonRemoveEventActionPerformed(evt);
            }
        });
        this.jLabel19.setText("event");
        this.actionBoundingBox.setMaximumSize(new Dimension(150, 150));
        this.actionBoundingBox.setMinimumSize(new Dimension(150, 150));
        GroupLayout actionBoundingBoxLayout = new GroupLayout(this.actionBoundingBox);
        this.actionBoundingBox.setLayout(actionBoundingBoxLayout);
        actionBoundingBoxLayout.setHorizontalGroup(actionBoundingBoxLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        actionBoundingBoxLayout.setVerticalGroup(actionBoundingBoxLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabel15.setText("bounding box");
        this.jLabel20.setText("offset");
        this.jTextFieldBoundingBoxOffsetY.setText("0");
        this.jTextFieldBoundingBoxOffsetY.setToolTipText("bounding box manual delta Y");
        this.jTextFieldBoundingBoxOffsetY.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ActionPanel.this.jTextFieldBoundingBoxOffsetYFocusLost(evt);
            }
        });
        this.jTextFieldBoundingBoxOffsetY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jTextFieldBoundingBoxOffsetYActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.buttonGroup1.add(this.jRadioButton2);
        this.jTableDeltaTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane3.setViewportView(this.jTableDeltaTable);
        this.jLabel21.setText("(per step)");
        this.jLabel21.setToolTipText("while the action is active change y and x position");
        this.jLabel1.setText("text");
        this.jComboBoxTextType.setModel(new DefaultComboBoxModel<String>(new String[]{"5 font", "standard font", "vector (not done)"}));
        this.jTextFieldtextHeight.setHorizontalAlignment(11);
        this.jTextFieldtextHeight.setText("2");
        this.jTextFieldtextHeight.setToolTipText("text height");
        this.jTextFieldtextHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ActionPanel.this.jTextFieldtextHeightFocusLost(evt);
            }
        });
        this.jTextFieldtextHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jTextFieldtextHeightActionPerformed(evt);
            }
        });
        this.jTextFieldtextWidth.setHorizontalAlignment(11);
        this.jTextFieldtextWidth.setText("50");
        this.jTextFieldtextWidth.setToolTipText("text width");
        this.jTextFieldtextWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ActionPanel.this.jTextFieldtextWidthFocusLost(evt);
            }
        });
        this.jTextFieldtextWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jTextFieldtextWidthActionPerformed(evt);
            }
        });
        this.jTextFieldBoundingBoxOffsetX.setText("0");
        this.jTextFieldBoundingBoxOffsetX.setToolTipText("bounding box manual delta X");
        this.jTextFieldBoundingBoxOffsetX.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ActionPanel.this.jTextFieldBoundingBoxOffsetXFocusLost(evt);
            }
        });
        this.jTextFieldBoundingBoxOffsetX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jTextFieldBoundingBoxOffsetXActionPerformed(evt);
            }
        });
        this.jLabel2.setText("intensity ");
        this.jTextFieldIntensity.setHorizontalAlignment(11);
        this.jTextFieldIntensity.setToolTipText("if empty -> intensity will not be used especially for this action");
        this.jTextFieldIntensity.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ActionPanel.this.jTextFieldIntensityFocusLost(evt);
            }
        });
        this.jTextFieldIntensity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jTextFieldIntensityActionPerformed(evt);
            }
        });
        this.jTextAreaText.setColumns(20);
        this.jTextAreaText.setRows(5);
        this.jScrollPane4.setViewportView(this.jTextAreaText);
        this.jLabel22.setText("trigger");
        this.jButtonAddTrigger.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonAddTrigger.setToolTipText("add one trigger");
        this.jButtonAddTrigger.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAddTrigger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonAddTriggerActionPerformed(evt);
            }
        });
        this.jButtonRemoveTrigger.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonRemoveTrigger.setToolTipText("remove the selected  trigger");
        this.jButtonRemoveTrigger.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonRemoveTrigger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonRemoveTriggerActionPerformed(evt);
            }
        });
        this.jTableTriggerTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableTriggerTable.setToolTipText("<html>\nFor -> y, x<bR>\na value is possible<bR>\n++, -- is possible <bR>\n+=x, -=x is possible for x < 10<bR>\nx is possible - no change <bR>\n=xxx is possible - a global 8 bit variable<bR>\n</html>");
        this.jTableTriggerTable.getTableHeader().setResizingAllowed(false);
        this.jTableTriggerTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane5.setViewportView(this.jTableTriggerTable);
        this.jButtonAddResult.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonAddResult.setToolTipText("add one trigger");
        this.jButtonAddResult.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAddResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonAddResultActionPerformed(evt);
            }
        });
        this.jButtonRemoveResult.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonRemoveResult.setToolTipText("remove the selected  trigger");
        this.jButtonRemoveResult.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonRemoveResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.jButtonRemoveResultActionPerformed(evt);
            }
        });
        this.jLabel23.setText("results");
        this.jTableResultTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableResultTable.setToolTipText("<html>\nFor -> y, x<bR>\na value is possible<bR>\n++, -- is possible <bR>\n+=x, -=x is possible for x < 10<bR>\nx is possible - no change <bR>\n=xxx is possible - a global 8 bit variable<bR>\n</html>");
        this.jTableResultTable.getTableHeader().setResizingAllowed(false);
        this.jTableResultTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane6.setViewportView(this.jTableResultTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel15)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.actionBoundingBox, -2, 120, -2).addComponent(this.actionAnimation, GroupLayout.Alignment.LEADING, -2, 120, -2).addComponent(this.jTextFieldBoundingBoxOffsetX, -2, 43, -2).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldActionId)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel20, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jTextFieldBoundingBoxOffsetY, -2, 43, -2))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderSourceScale, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonRemoveEvent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddEvent)).addComponent(this.jLabel17, -2, 84, -2).addComponent(this.jLabel19).addComponent(this.jLabel3).addComponent(this.jLabel14, -2, 69, -2).addComponent(this.jLabel21, -2, 69, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButtonDeleteLastPosRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNewPosRow)).addComponent(this.jLabel18, -1, -1, Short.MAX_VALUE))).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 633, Short.MAX_VALUE)).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 328, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel22).addGap(18, 18, 18).addComponent(this.jButtonRemoveTrigger).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddTrigger))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonRemoveResult).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddResult).addContainerGap(232, Short.MAX_VALUE)).addComponent(this.jScrollPane6, -2, 0, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldWhileActiveChangeY, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldWhileActiveChangeX, -2, 40, -2).addGap(29, 29, 29).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldIntensity, -2, 40, -2)).addComponent(this.jComboBoxBehaviour, -2, 223, -2).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldAnimationName, -2, 279, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad2))).addGap(0, 340, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16, -2, 82, -2).addComponent(this.jLabel1, -2, 46, -2)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jTextFieldSoundName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad3)).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxSoundLoop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxTextType, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldtextHeight, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldtextWidth, -2, 40, -2)).addComponent(this.jScrollPane4, -2, 255, -2)))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAnimationName, -2, -1, -2).addComponent(this.jLabel3)).addComponent(this.jButtonLoad2, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldWhileActiveChangeY, -2, -1, -2).addComponent(this.jTextFieldWhileActiveChangeX, -2, -1, -2).addComponent(this.jLabel14).addComponent(this.jRadioButton1).addComponent(this.jLabel2).addComponent(this.jTextFieldIntensity, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel21).addComponent(this.jRadioButton2)).addComponent(this.jScrollPane3, -2, 40, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.jComboBoxBehaviour, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel19, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAddEvent).addComponent(this.jButtonRemoveEvent).addComponent(this.jScrollPane2, -1, 91, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAddTrigger).addComponent(this.jButtonRemoveTrigger)).addComponent(this.jLabel22, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -1, 136, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAddResult).addComponent(this.jButtonRemoveResult)).addComponent(this.jLabel23, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -2, 0, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDeleteLastPosRow).addComponent(this.jButtonNewPosRow))).addComponent(this.jScrollPane1, -2, 121, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jTextFieldSoundName, -2, -1, -2)).addComponent(this.jButtonLoad3, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.jCheckBoxSoundLoop)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxTextType, -2, -1, -2).addComponent(this.jTextFieldtextHeight, -2, -1, -2).addComponent(this.jTextFieldtextWidth, -2, -1, -2))))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.actionAnimation, -2, 120, -2).addComponent(this.jSliderSourceScale, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jTextFieldActionId, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionBoundingBox, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.jTextFieldBoundingBoxOffsetY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldBoundingBoxOffsetX, -2, -1, -2).addGap(133, 133, 133)))));
    }

    private void jTextFieldAnimationNameActionPerformed(ActionEvent evt) {
    }

    private void jButtonLoad2ActionPerformed(ActionEvent evt) {
        this.loadAnimation();
    }

    private void jSliderSourceScaleStateChanged(ChangeEvent evt) {
        int value = this.jSliderSourceScale.getValue();
        int max = this.jSliderSourceScale.getMaximum();
        double scale = value - (max - 1) / 2;
        if (value < max / 2 + 1) {
            int invScale;
            scale = (invScale = max / 2 - --value) == 0 ? 1.0 : 1.0 / (double)invScale;
        }
        if (scale > 1.0) {
            scale -= 0.75;
        }
        if (scale > 2.0) {
            scale -= 0.5;
        }
        if (scale > 2.5) {
            scale -= 0.25;
        }
        if (scale > 2.75) {
            scale -= 0.5;
        }
        this.actionAnimation.setScale(scale);
        this.actionBoundingBox.setScale(scale);
    }

    private void jTextFieldWhileActiveChangeYFocusLost(FocusEvent evt) {
    }

    private void jTextFieldWhileActiveChangeYActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldWhileActiveChangeXFocusLost(FocusEvent evt) {
    }

    private void jTextFieldWhileActiveChangeXActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldSoundNameActionPerformed(ActionEvent evt) {
    }

    private void jButtonLoad3ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (this.lastPath.length() == 0) {
            this.lastPath = Global.mainPathPrefix;
            fc.setCurrentDirectory(new File(this.lastPath));
        } else {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("afx", "afx");
        fc.setFileFilter(filter);
        int re = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (fc == null) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        this.lastPath = fc.getSelectedFile().getAbsolutePath();
        File file = new File(this.lastPath);
        if (!this.lastPath.toLowerCase().endsWith(".afx")) {
            return;
        }
        Object data2 = null;
        Path path = Paths.get(this.lastPath, new String[0]);
        String nameOnly = path.getFileName().toString();
        String barenameOnly = nameOnly.substring(0, nameOnly.length() - 4);
        this.jTextFieldSoundName.setText(path.toString());
    }

    private void jButtonDeleteLastPosRowActionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        if (this.data.mpositioning == null) {
            return;
        }
        if (this.data.mpositioning.size() != 0) {
            this.data.mpositioning.remove(this.data.mpositioning.size() - 1);
        }
        if (this.data.mpositioning.size() != 0) {
            this.data.mpositioning.remove(this.data.mpositioning.size() - 1);
        }
        if (this.data.mpositioning.size() != 0) {
            this.data.mpositioning.remove(this.data.mpositioning.size() - 1);
        }
        this.resetPosTable();
    }

    private void jButtonNewPosRowActionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        if (this.data.mpositioning == null) {
            this.data.mpositioning = new Vector();
        }
        this.data.mpositioning.addElement(0);
        this.data.mpositioning.addElement(0);
        this.data.mpositioning.addElement(0);
        this.resetPosTable();
    }

    private void jButtonAddEventActionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        if (this.data.meventName == null) {
            this.data.meventName = new Vector();
        }
        if (this.data.mtriggerName == null) {
            this.data.mtriggerName = new Vector();
        }
        if (this.data.mresultName == null) {
            this.data.mresultName = new Vector();
        }
        if (this.data.meventUID == null) {
            this.data.meventUID = new Vector();
        }
        this.data.meventName.addElement("");
        this.data.mtriggerName.addElement("");
        this.data.mresultName.addElement("");
        this.data.meventUID.addElement(UUID.randomUUID().toString());
        this.resetEventTable();
    }

    private void jButtonRemoveEventActionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        int row = this.jTableEventTable.getSelectedRow();
        if (this.data.meventName != null && this.data.meventName.size() > row) {
            String eventBaseName = this.getEventBaseName(row);
            this.data.meventName.remove(row);
            if (this.data.mtriggerName != null && this.data.mtriggerName.size() > row) {
                this.data.mtriggerName.remove(row);
            }
            if (this.data.mresultName != null && this.data.mresultName.size() > row) {
                this.data.mresultName.remove(row);
            }
            if (this.data.meventUID != null && this.data.meventUID.size() > row) {
                this.data.meventUID.remove(row);
            }
            if (eventBaseName != null) {
                this.removeTrigger(eventBaseName);
                this.removeResult(eventBaseName);
            }
        }
        this.resetEventTable();
    }

    private void jTextFieldBoundingBoxOffsetYActionPerformed(ActionEvent evt) {
        this.data.mboundingBoxOffsetY = this.jTextFieldBoundingBoxOffsetY.getText();
        this.computeBoundingBox();
    }

    private void jTextFieldBoundingBoxOffsetYFocusLost(FocusEvent evt) {
        this.data.mboundingBoxOffsetY = this.jTextFieldBoundingBoxOffsetY.getText();
        this.computeBoundingBox();
    }

    private void jTextFieldtextHeightFocusLost(FocusEvent evt) {
    }

    private void jTextFieldtextHeightActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldtextWidthFocusLost(FocusEvent evt) {
    }

    private void jTextFieldtextWidthActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldBoundingBoxOffsetXFocusLost(FocusEvent evt) {
        this.data.mboundingBoxOffsetX = this.jTextFieldBoundingBoxOffsetX.getText();
        this.computeBoundingBox();
    }

    private void jTextFieldBoundingBoxOffsetXActionPerformed(ActionEvent evt) {
        this.data.mboundingBoxOffsetX = this.jTextFieldBoundingBoxOffsetX.getText();
        this.computeBoundingBox();
    }

    private void jTextFieldIntensityFocusLost(FocusEvent evt) {
    }

    private void jTextFieldIntensityActionPerformed(ActionEvent evt) {
    }

    private void jButtonAddTriggerActionPerformed(ActionEvent evt) {
        String uid = this.getCurrentEventUID();
        if (uid == null) {
            return;
        }
        if (this.triggers == null) {
            return;
        }
        if (this.triggers.mtriggerByCause == null) {
            this.triggers.mtriggerByCause = new Vector();
        }
        if (this.triggers.mtriggerBySpriteID == null) {
            this.triggers.mtriggerBySpriteID = new Vector();
        }
        if (this.triggers.mtriggerByY == null) {
            this.triggers.mtriggerByY = new Vector();
        }
        if (this.triggers.mtriggerByX == null) {
            this.triggers.mtriggerByX = new Vector();
        }
        if (this.triggers.mtriggerByTicks == null) {
            this.triggers.mtriggerByTicks = new Vector();
        }
        this.triggers.mtriggerByCause.addElement("");
        this.triggers.mtriggerBySpriteID.addElement("");
        this.triggers.mtriggerByY.addElement(0);
        this.triggers.mtriggerByX.addElement(0);
        this.triggers.mtriggerByTicks.addElement("");
        this.triggers.mClass = uid;
        this.triggers.mName = uid;
        this.resetTriggerTable();
    }

    private void jButtonRemoveTriggerActionPerformed(ActionEvent evt) {
    }

    private void jButtonAddResultActionPerformed(ActionEvent evt) {
        String uid = this.getCurrentEventUID();
        if (uid == null) {
            return;
        }
        if (this.results == null) {
            return;
        }
        if (this.results.mresultType == null) {
            this.results.mresultType = new Vector();
        }
        if (this.results.mresultActionID == null) {
            this.results.mresultActionID = new Vector();
        }
        if (this.results.mresultSpriteID == null) {
            this.results.mresultSpriteID = new Vector();
        }
        if (this.results.mresultY == null) {
            this.results.mresultY = new Vector();
        }
        if (this.results.mresultX == null) {
            this.results.mresultX = new Vector();
        }
        this.results.mresultType.addElement("");
        this.results.mresultActionID.addElement("");
        this.results.mresultSpriteID.addElement("");
        this.results.mresultY.addElement("");
        this.results.mresultX.addElement("");
        this.results.mClass = uid;
        this.results.mName = uid;
        this.resetTriggerTable();
    }

    private void jButtonRemoveResultActionPerformed(ActionEvent evt) {
    }

    private void jTableEventTableMousePressed(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        int rowAtPoint = table.rowAtPoint(evt.getPoint());
        int columnAtPoint = table.columnAtPoint(evt.getPoint());
        if (rowAtPoint != -1) {
            this.changeEventSelection(rowAtPoint);
        }
    }

    boolean loadAnimation() {
        String filename = Global.mainPathPrefix + "xml" + File.separator + "vectoranimation";
        filename = VectorListFileChoserJPanel.showSavePanel(filename, "Load Vector-Animation", true);
        return this.loadAnimationFromElement(filename);
    }

    boolean loadAnimationFromElement(String loadName) {
        boolean ok = false;
        if (loadName != null) {
            if (!loadName.toUpperCase().endsWith(".XML")) {
                loadName = loadName + ".xml";
            }
            this.setCurrentAnimation(new GFXVectorAnimation());
            ok = this.getCurrentAnimation().loadFromXML(loadName);
            if (ok) {
                if (this.getCurrentAnimation().size() > 0) {
                    if (this.inGuiUpdate == 0) {
                        this.updateActionData();
                    }
                } else {
                    return false;
                }
            }
            loadName = Utility.makeVideRelative(loadName);
        }
        this.jTextFieldAnimationName.setText(loadName);
        return ok;
    }

    public GFXVectorAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public void setCurrentAnimation(GFXVectorAnimation currentAnimation) {
        this.currentAnimation = currentAnimation;
        this.actionAnimation.setAnimation(currentAnimation);
        this.actionAnimation.setDelay(50);
    }

    void updateActionData() {
        this.data.mName = this.jTextFieldActionId.getText();
        this.data.manimationFile = this.jTextFieldAnimationName.getText();
        this.data.mchangeWhileActiveY = this.jTextFieldWhileActiveChangeY.getText();
        this.data.mchangeWhileActiveX = this.jTextFieldWhileActiveChangeX.getText();
        this.data.msoundLoop = this.jCheckBoxSoundLoop.isSelected();
        this.data.msoundFile = this.jTextFieldSoundName.getText();
        this.data.mboundingBoxOffsetY = this.jTextFieldBoundingBoxOffsetY.getText();
        this.data.mboundingBoxOffsetX = this.jTextFieldBoundingBoxOffsetX.getText();
        this.data.mbehaviour = this.jComboBoxBehaviour.getSelectedItem().toString();
        this.data.mtext = this.jTextAreaText.getText();
        this.data.mtextType = this.jComboBoxTextType.getSelectedItem().toString();
        this.data.mtextHeight = UtilityString.Int0(this.jTextFieldtextHeight.getText());
        this.data.mtextWidth = UtilityString.Int0(this.jTextFieldtextWidth.getText());
        this.data.mintensity = this.jTextFieldIntensity.getText();
    }

    void readActionData() {
        ++this.inGuiUpdate;
        this.jTextFieldActionId.setText(this.data.mName);
        this.jTextFieldAnimationName.setText(this.data.manimationFile);
        this.jTextFieldWhileActiveChangeY.setText("" + this.data.mchangeWhileActiveY);
        if (this.jTextFieldWhileActiveChangeY.getText().length() == 0) {
            this.jTextFieldWhileActiveChangeY.setText("0");
        }
        this.jTextFieldWhileActiveChangeX.setText("" + this.data.mchangeWhileActiveX);
        if (this.jTextFieldWhileActiveChangeX.getText().length() == 0) {
            this.jTextFieldWhileActiveChangeX.setText("0");
        }
        this.jCheckBoxSoundLoop.setSelected(this.data.msoundLoop);
        this.jTextFieldSoundName.setText(this.data.msoundFile);
        this.jTextFieldBoundingBoxOffsetY.setText("" + this.data.mboundingBoxOffsetY);
        this.jTextFieldBoundingBoxOffsetX.setText("" + this.data.mboundingBoxOffsetX);
        this.jComboBoxBehaviour.setSelectedItem(this.data.mbehaviour);
        this.jTextFieldIntensity.setText(this.data.mintensity);
        this.jTextFieldtextHeight.setText("" + this.data.mtextHeight);
        this.jTextFieldtextWidth.setText("" + this.data.mtextWidth);
        this.jTextAreaText.setText(this.data.mtext);
        this.jComboBoxTextType.setSelectedItem(this.data.mtextType);
        this.loadAnimationFromElement(this.data.manimationFile);
        this.computeBoundingBox();
        --this.inGuiUpdate;
    }

    public void setActionData(ActionNewData d, SpriteData s) {
        this.data = d;
        this.sprite = s;
        this.readActionData();
        this.tableSetup();
        this.resetTrigger();
    }

    public ActionNewData getActionData() {
        this.updateActionData();
        return this.data;
    }

    void resetPosTable() {
        this.jTablePositioningTable.tableChanged(null);
        this.jTablePositioningTable.repaint();
    }

    void resetEventTable() {
        int widthAll = this.jTableEventTable.getWidth();
        this.jTableEventTable.tableChanged(null);
        this.jTableEventTable.repaint();
        this.resetTriggerTable();
        this.resetResultTable();
    }

    void tableSetup() {
        TriggerModel triggerModel;
        EventModel eventModel;
        PosModel posModel = new PosModel();
        if (posModel != null) {
            this.jTablePositioningTable.setModel(posModel);
        }
        if ((eventModel = new EventModel()) != null) {
            this.jTableEventTable.setModel(eventModel);
        }
        if ((triggerModel = new TriggerModel()) != null) {
            this.jTableTriggerTable.setModel(triggerModel);
        }
        ResultModel resultModel = new ResultModel();
        if (triggerModel != null) {
            this.jTableResultTable.setModel(resultModel);
        }
        ArrayList<Cause> listCause = new ArrayList<Cause>();
        listCause.add(new Cause("joystick center"));
        listCause.add(new Cause("joystick up left (not done)"));
        listCause.add(new Cause("joystick left down (not done)"));
        listCause.add(new Cause("joystick down right (not done)"));
        listCause.add(new Cause("joystick right up (not done)"));
        listCause.add(new Cause("joystick up"));
        listCause.add(new Cause("joystick left"));
        listCause.add(new Cause("joystick down"));
        listCause.add(new Cause("joystick right"));
        listCause.add(new Cause("analog horizontal"));
        listCause.add(new Cause("analog vertical"));
        listCause.add(new Cause("analog delta horizontal (not done)"));
        listCause.add(new Cause("analog delta vertical (not done)"));
        listCause.add(new Cause("button down 1"));
        listCause.add(new Cause("button down 2"));
        listCause.add(new Cause("button down 3"));
        listCause.add(new Cause("button down 4"));
        listCause.add(new Cause("button pressed 1"));
        listCause.add(new Cause("button pressed 2"));
        listCause.add(new Cause("button pressed 3"));
        listCause.add(new Cause("button pressed 4"));
        listCause.add(new Cause("on creation"));
        listCause.add(new Cause("sprite no collision"));
        listCause.add(new Cause("sprite collision"));
        listCause.add(new Cause("sprite receive collision"));
        listCause.add(new Cause("list collision (not done)"));
        listCause.add(new Cause("timer expired"));
        listCause.add(new Cause("long timer expired"));
        listCause.add(new Cause("position equals"));
        listCause.add(new Cause("position > Y"));
        listCause.add(new Cause("position < Y"));
        listCause.add(new Cause("position > X"));
        listCause.add(new Cause("position < X"));
        listCause.add(new Cause("variable = (not done)"));
        listCause.add(new Cause("variable < (not done)"));
        listCause.add(new Cause("variable > (not done)"));
        ArrayList<Target> listTarget = new ArrayList<Target>();
        listTarget.add(new Target("action change"));
        listTarget.add(new Target("spawn sprite"));
        listTarget.add(new Target("random spawn sprite"));
        listTarget.add(new Target("set position"));
        listTarget.add(new Target("block movement"));
        listTarget.add(new Target("speed change"));
        listTarget.add(new Target("play sfx"));
        listTarget.add(new Target("next level"));
        listTarget.add(new Target("variable change"));
        listTarget.add(new Target("intensity change"));
        listTarget.add(new Target("set level"));
        listTarget.add(new Target("remove"));
        listTarget.add(new Target("remove all"));
        ArrayList<ActionID> listActionID = new ArrayList<ActionID>();
        ActionDataPool mActionDataPool = new ActionDataPool();
        Collection<String> collectionKlasse = mActionDataPool.getKlassenHashMap().values();
        String klasse = this.sprite.mName + "_Actions";
        Collection<ActionData> colC = mActionDataPool.getMapForKlasse(klasse).values();
        Iterator<ActionData> iterC = colC.iterator();
        listActionID.add(new ActionID(""));
        while (iterC.hasNext()) {
            ActionData item = iterC.next();
            listActionID.add(new ActionID(item.mName));
        }
        ArrayList<SpriteID> listSpriteID = new ArrayList<SpriteID>();
        SpriteDataPool mSpriteDataPool = new SpriteDataPool();
        collectionKlasse = mSpriteDataPool.getKlassenHashMap().values();
        klasse = "AllSprites";
        Collection<SpriteData> colCs = mSpriteDataPool.getMapForKlasse(klasse).values();
        Iterator<SpriteData> iterCs = colCs.iterator();
        listSpriteID.add(new SpriteID(""));
        while (iterCs.hasNext()) {
            SpriteData item = iterCs.next();
            listSpriteID.add(new SpriteID(item.mName));
        }
        this.jTableEventTable.setDefaultEditor(Cause.class, new CauseCellEditor(listCause));
        this.jTableEventTable.setDefaultEditor(Target.class, new TargetCellEditor(listTarget));
        this.jTableEventTable.setDefaultEditor(ActionID.class, new ActionIDCellEditor(listActionID));
        this.jTableEventTable.setDefaultEditor(SpriteID.class, new SpriteIDCellEditor(listSpriteID));
        this.jTableEventTable.setDefaultRenderer(Cause.class, new CostumCellRenderer());
        this.jTableEventTable.setDefaultRenderer(Target.class, new CostumCellRenderer());
        this.jTableEventTable.setDefaultRenderer(ActionID.class, new CostumCellRenderer());
        this.jTableEventTable.setDefaultRenderer(SpriteID.class, new CostumCellRenderer());
        this.jTableTriggerTable.setDefaultEditor(Cause.class, new CauseCellEditor(listCause));
        this.jTableTriggerTable.setDefaultEditor(Target.class, new TargetCellEditor(listTarget));
        this.jTableTriggerTable.setDefaultEditor(ActionID.class, new ActionIDCellEditor(listActionID));
        this.jTableTriggerTable.setDefaultEditor(SpriteID.class, new SpriteIDCellEditor(listSpriteID));
        this.jTableTriggerTable.setDefaultRenderer(Cause.class, new CostumCellRenderer());
        this.jTableTriggerTable.setDefaultRenderer(Target.class, new CostumCellRenderer());
        this.jTableTriggerTable.setDefaultRenderer(ActionID.class, new CostumCellRenderer());
        this.jTableTriggerTable.setDefaultRenderer(SpriteID.class, new CostumCellRenderer());
        this.jTableResultTable.setDefaultEditor(Cause.class, new CauseCellEditor(listCause));
        this.jTableResultTable.setDefaultEditor(Target.class, new TargetCellEditor(listTarget));
        this.jTableResultTable.setDefaultEditor(ActionID.class, new ActionIDCellEditor(listActionID));
        this.jTableResultTable.setDefaultEditor(SpriteID.class, new SpriteIDCellEditor(listSpriteID));
        this.jTableResultTable.setDefaultRenderer(Cause.class, new CostumCellRenderer());
        this.jTableResultTable.setDefaultRenderer(Target.class, new CostumCellRenderer());
        this.jTableResultTable.setDefaultRenderer(ActionID.class, new CostumCellRenderer());
        this.jTableResultTable.setDefaultRenderer(SpriteID.class, new CostumCellRenderer());
        this.mTriggerPool = new ActionTriggerDataPool();
        this.mResultPool = new ActionResultDataPool();
        this.currentEventRow = -1;
        this.resetPosTable();
        this.resetEventTable();
        this.resetTriggerTable();
        this.resetResultTable();
    }

    void computeBoundingBox() {
        GFXVectorList boundingList = ActionPanel.computeBoundingBoxStatic(this.data);
        this.boundingAnimation = new GFXVectorAnimation();
        if (boundingList != null) {
            this.boundingAnimation.add(boundingList);
        }
        this.actionBoundingBox.setAnimation(this.boundingAnimation);
        this.actionBoundingBox.repaint();
    }

    static GFXVectorList computeBoundingBoxStatic(ActionNewData data2) {
        GFXVectorAnimation currentAnimation = new GFXVectorAnimation();
        String loadName = data2.manimationFile;
        if (loadName != null) {
            if (!loadName.toUpperCase().endsWith(".XML")) {
                loadName = loadName + ".xml";
            }
            if (!currentAnimation.loadFromXML(loadName)) {
                return null;
            }
        }
        int xMin = 100000;
        int yMin = 100000;
        int xMax = -100000;
        int yMax = -100000;
        if (currentAnimation == null) {
            return null;
        }
        if (currentAnimation.size() == 0) {
            return null;
        }
        GFXVectorList list2 = currentAnimation.get(0);
        xMax = list2.getXMax() / BLOW;
        yMax = list2.getYMax() / BLOW;
        xMin = list2.getXMin() / BLOW;
        yMin = list2.getYMin() / BLOW;
        if (xMax == 0 && list2.getXMax() != 0) {
            xMax = list2.getXMax() > 0 ? 1 : -1;
        }
        if (yMax == 0 && list2.getYMax() != 0) {
            yMax = list2.getYMax() > 0 ? 1 : -1;
        }
        if (xMin == 0 && list2.getXMin() != 0) {
            xMin = list2.getXMin() > 0 ? 1 : -1;
        }
        if (yMin == 0 && list2.getYMin() != 0) {
            yMin = list2.getYMin() > 0 ? 1 : -1;
        }
        boolean immediateY = data2.mboundingBoxOffsetY.startsWith("#");
        boolean immediateX = data2.mboundingBoxOffsetX.startsWith("#");
        int by = UtilityString.Int0(UtilityString.replace(data2.mboundingBoxOffsetY, "#", ""));
        int bx = UtilityString.Int0(UtilityString.replace(data2.mboundingBoxOffsetX, "#", ""));
        if (immediateY) {
            yMax = by;
            yMin = -by;
        } else {
            yMax += by;
            yMin -= by;
        }
        if (immediateX) {
            xMax = bx;
            xMin = -bx;
        } else {
            xMax += bx;
            xMin -= bx;
        }
        if (xMax == 0 && list2.getXMax() != 0) {
            xMax = list2.getXMax() > 0 ? 1 : -1;
        }
        if (yMax == 0 && list2.getYMax() != 0) {
            yMax = list2.getYMax() > 0 ? 1 : -1;
        }
        if (xMin == 0 && list2.getXMin() != 0) {
            xMin = list2.getXMin() > 0 ? 1 : -1;
        }
        if (yMin == 0 && list2.getYMin() != 0) {
            yMin = list2.getYMin() > 0 ? 1 : -1;
        }
        GFXVectorList boundingList = new GFXVectorList();
        boundingList.add(new GFXVector(new Vertex(xMax * BLOW, yMax * BLOW, 0.0), new Vertex(xMin * BLOW, yMax * BLOW, 0.0)));
        boundingList.add(new GFXVector(new Vertex(xMin * BLOW, yMax * BLOW, 0.0), new Vertex(xMin * BLOW, yMin * BLOW, 0.0)));
        boundingList.add(new GFXVector(new Vertex(xMin * BLOW, yMin * BLOW, 0.0), new Vertex(xMax * BLOW, yMin * BLOW, 0.0)));
        boundingList.add(new GFXVector(new Vertex(xMax * BLOW, yMin * BLOW, 0.0), new Vertex(xMax * BLOW, yMax * BLOW, 0.0)));
        return boundingList;
    }

    void stopEditing() {
        if (this.jTableEventTable.isEditing()) {
            this.jTableEventTable.getCellEditor().stopCellEditing();
        }
        if (this.jTablePositioningTable.isEditing()) {
            this.jTablePositioningTable.getCellEditor().stopCellEditing();
        }
        if (this.jTableTriggerTable.isEditing()) {
            this.jTableTriggerTable.getCellEditor().stopCellEditing();
        }
        if (this.jTableResultTable.isEditing()) {
            this.jTableResultTable.getCellEditor().stopCellEditing();
        }
    }

    void resetTriggerTable() {
        int widthAll = this.jTableTriggerTable.getWidth();
        this.jTableTriggerTable.tableChanged(null);
        this.jTableTriggerTable.getColumnModel().getColumn(0).setMinWidth(120);
        this.jTableTriggerTable.getColumnModel().getColumn(1).setMinWidth(50);
        this.jTableTriggerTable.getColumnModel().getColumn(2).setMinWidth(50);
        this.jTableTriggerTable.getColumnModel().getColumn(3).setMinWidth(50);
        this.jTableTriggerTable.getColumnModel().getColumn(4).setMinWidth(100);
        this.jTableTriggerTable.repaint();
    }

    void resetResultTable() {
        int widthAll = this.jTableResultTable.getWidth();
        this.jTableResultTable.tableChanged(null);
        this.jTableResultTable.getColumnModel().getColumn(0).setMinWidth(100);
        this.jTableResultTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.jTableResultTable.getColumnModel().getColumn(2).setMinWidth(100);
        this.jTableResultTable.getColumnModel().getColumn(3).setMinWidth(50);
        this.jTableResultTable.getColumnModel().getColumn(4).setMinWidth(50);
        this.jTableResultTable.repaint();
    }

    String getEventBaseName(int row) {
        return this.data.meventUID.elementAt(row);
    }

    void removeTrigger(String n) {
    }

    void removeResult(String n) {
    }

    void setTrigger(int row) {
        block0: {
            ActionTriggerData item;
            String base = this.getEventBaseName(row);
            Collection<String> collectionKlasse = this.mTriggerPool.getKlassenHashMap().values();
            String klasse = base;
            Collection<ActionTriggerData> colC = this.mTriggerPool.getMapForKlasse(klasse).values();
            Iterator<ActionTriggerData> iterC = colC.iterator();
            if (!iterC.hasNext()) break block0;
            this.triggers = item = iterC.next();
        }
    }

    void setResults(int row) {
        block0: {
            ActionResultData item;
            String base = this.getEventBaseName(row);
            Collection<String> collectionKlasse = this.mResultPool.getKlassenHashMap().values();
            String klasse = base;
            Collection<ActionResultData> colC = this.mResultPool.getMapForKlasse(klasse).values();
            Iterator<ActionResultData> iterC = colC.iterator();
            if (!iterC.hasNext()) break block0;
            this.results = item = iterC.next();
        }
    }

    void changeEventSelection(int row) {
        if (row == -1) {
            this.triggers = new ActionTriggerData();
            this.results = new ActionResultData();
            this.currentEventRow = -1;
        } else {
            this.setTrigger(row);
            this.setResults(row);
            this.currentEventRow = row;
        }
        this.jTableTriggerTable.tableChanged(null);
        this.jTableTriggerTable.repaint();
        this.jTableResultTable.tableChanged(null);
        this.jTableResultTable.repaint();
    }

    void saveTriggersAndResults() {
        this.mTriggerPool.save();
        this.mResultPool.save();
    }

    String getCurrentEventUID() {
        if (this.data == null) {
            return null;
        }
        if (this.currentEventRow == -1) {
            return null;
        }
        return this.data.meventUID.elementAt(this.currentEventRow);
    }

    void resetTrigger() {
        this.changeEventSelection(-1);
    }

    class SpriteIDCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private SpriteID value;
        private List<SpriteID> listString;

        public SpriteIDCellEditor(List<SpriteID> l) {
            this.listString = l;
            Collections.sort(this.listString, new Comparator<SpriteID>(){

                @Override
                public int compare(SpriteID o1, SpriteID o2) {
                    return o1.c.compareToIgnoreCase(o2.c);
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof SpriteID) {
                this.value = (SpriteID)value;
            }
            JComboBox<SpriteID> comboCountry = new JComboBox<SpriteID>();
            for (SpriteID aCountry : this.listString) {
                comboCountry.addItem(aCountry);
            }
            comboCountry.setSelectedItem(value);
            comboCountry.addActionListener(this);
            if (isSelected) {
                comboCountry.setBackground(table.getSelectionBackground());
            } else {
                comboCountry.setBackground(table.getBackground());
            }
            return comboCountry;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox comboCountry = (JComboBox)event.getSource();
            this.value = (SpriteID)comboCountry.getSelectedItem();
        }
    }

    class ActionIDCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private ActionID value;
        private List<ActionID> listString;

        public ActionIDCellEditor(List<ActionID> l) {
            this.listString = l;
            Collections.sort(this.listString, new Comparator<ActionID>(){

                @Override
                public int compare(ActionID o1, ActionID o2) {
                    return o1.c.compareToIgnoreCase(o2.c);
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof ActionID) {
                this.value = (ActionID)value;
            }
            JComboBox<ActionID> comboCountry = new JComboBox<ActionID>();
            for (ActionID aCountry : this.listString) {
                comboCountry.addItem(aCountry);
            }
            comboCountry.setSelectedItem(value);
            comboCountry.addActionListener(this);
            if (isSelected) {
                comboCountry.setBackground(table.getSelectionBackground());
            } else {
                comboCountry.setBackground(table.getBackground());
            }
            return comboCountry;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox comboCountry = (JComboBox)event.getSource();
            this.value = (ActionID)comboCountry.getSelectedItem();
        }
    }

    class TargetCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private Target value;
        private List<Target> listString;

        public TargetCellEditor(List<Target> l) {
            this.listString = l;
            Collections.sort(this.listString, new Comparator<Target>(){

                @Override
                public int compare(Target o1, Target o2) {
                    return o1.c.compareToIgnoreCase(o2.c);
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Target) {
                this.value = (Target)value;
            }
            JComboBox<Target> comboCountry = new JComboBox<Target>();
            for (Target aCountry : this.listString) {
                comboCountry.addItem(aCountry);
            }
            comboCountry.setSelectedItem(value);
            comboCountry.addActionListener(this);
            if (isSelected) {
                comboCountry.setBackground(table.getSelectionBackground());
            } else {
                comboCountry.setBackground(table.getBackground());
            }
            return comboCountry;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox comboCountry = (JComboBox)event.getSource();
            this.value = (Target)comboCountry.getSelectedItem();
        }
    }

    class CauseCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private Cause value;
        private List<Cause> listString;

        public CauseCellEditor(List<Cause> l) {
            this.listString = l;
            Collections.sort(this.listString, new Comparator<Cause>(){

                @Override
                public int compare(Cause o1, Cause o2) {
                    return o1.c.compareToIgnoreCase(o2.c);
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Cause) {
                this.value = (Cause)value;
            }
            JComboBox<Cause> comboCountry = new JComboBox<Cause>();
            for (Cause aCountry : this.listString) {
                comboCountry.addItem(aCountry);
            }
            comboCountry.setSelectedItem(value);
            comboCountry.addActionListener(this);
            if (isSelected) {
                comboCountry.setBackground(table.getSelectionBackground());
            } else {
                comboCountry.setBackground(table.getBackground());
            }
            return comboCountry;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox comboCountry = (JComboBox)event.getSource();
            this.value = (Cause)comboCountry.getSelectedItem();
        }
    }

    public class ResultModel
    extends AbstractTableModel {
        public final String[] NAMES = new String[]{"->target", "->action", "->sprite", "->Y", "->X"};

        @Override
        public int getColumnCount() {
            return this.NAMES.length;
        }

        @Override
        public int getRowCount() {
            if (ActionPanel.this.results == null) {
                return 0;
            }
            if (((ActionPanel)ActionPanel.this).results.mresultType == null) {
                return 0;
            }
            return ((ActionPanel)ActionPanel.this).results.mresultType.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                if (ActionPanel.this.results == null) {
                    return new Target("");
                }
                if (((ActionPanel)ActionPanel.this).results.mresultType == null) {
                    return new Target("");
                }
                if (((ActionPanel)ActionPanel.this).results.mresultType.size() <= row) {
                    return new Target("");
                }
                return new Target(((ActionPanel)ActionPanel.this).results.mresultType.elementAt(row));
            }
            if (col == 1) {
                if (ActionPanel.this.results == null) {
                    return new ActionID("");
                }
                if (((ActionPanel)ActionPanel.this).results.mresultActionID == null) {
                    return new ActionID("");
                }
                if (((ActionPanel)ActionPanel.this).results.mresultActionID.size() <= row) {
                    return new ActionID("");
                }
                return new Target(((ActionPanel)ActionPanel.this).results.mresultActionID.elementAt(row));
            }
            if (col == 2) {
                if (ActionPanel.this.results == null) {
                    return new SpriteID("");
                }
                if (((ActionPanel)ActionPanel.this).results.mresultSpriteID == null) {
                    return new SpriteID("");
                }
                if (((ActionPanel)ActionPanel.this).results.mresultSpriteID.size() <= row) {
                    return new SpriteID("");
                }
                return new SpriteID(((ActionPanel)ActionPanel.this).results.mresultSpriteID.elementAt(row));
            }
            if (col == 3) {
                if (ActionPanel.this.results == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).results.mresultY == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).results.mresultY.size() <= row) {
                    return 0;
                }
                return ((ActionPanel)ActionPanel.this).results.mresultY.elementAt(row);
            }
            if (col == 4) {
                if (ActionPanel.this.results == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).results.mresultX == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).results.mresultX.size() <= row) {
                    return 0;
                }
                return ((ActionPanel)ActionPanel.this).results.mresultX.elementAt(row);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Target.class;
            }
            if (col == 1) {
                return ActionID.class;
            }
            if (col == 2) {
                return SpriteID.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            Object V;
            if (ActionPanel.this.results == null) {
                return;
            }
            if (aValue == null) {
                return;
            }
            if (col == 0) {
                if (((ActionPanel)ActionPanel.this).results.mresultType == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).results.mresultType.size()) {
                    return;
                }
                V = (Target)aValue;
                ((ActionPanel)ActionPanel.this).results.mresultType.setElementAt(((Target)V).c, row);
            }
            if (col == 1) {
                if (((ActionPanel)ActionPanel.this).results.mresultActionID == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).results.mresultActionID.size()) {
                    return;
                }
                V = (ActionID)aValue;
                ((ActionPanel)ActionPanel.this).results.mresultActionID.setElementAt(((ActionID)V).c, row);
            }
            if (col == 2) {
                if (((ActionPanel)ActionPanel.this).results.mresultSpriteID == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).results.mresultSpriteID.size()) {
                    return;
                }
                V = (SpriteID)aValue;
                ((ActionPanel)ActionPanel.this).results.mresultSpriteID.setElementAt(((SpriteID)V).c, row);
            }
            if (col == 3) {
                if (((ActionPanel)ActionPanel.this).results.mresultY == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).results.mresultY.size()) {
                    return;
                }
                V = (String)aValue;
                ((ActionPanel)ActionPanel.this).results.mresultY.setElementAt((String)V, row);
            }
            if (col == 4) {
                if (((ActionPanel)ActionPanel.this).results.mresultX == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).results.mresultX.size()) {
                    return;
                }
                V = (String)aValue;
                ((ActionPanel)ActionPanel.this).results.mresultX.setElementAt((String)V, row);
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.NAMES[col];
        }
    }

    public class TriggerModel
    extends AbstractTableModel {
        public final String[] NAMES = new String[]{"cause", "Y", "X", "ticks", "sprite"};

        @Override
        public int getColumnCount() {
            return this.NAMES.length;
        }

        @Override
        public int getRowCount() {
            if (ActionPanel.this.triggers == null) {
                return 0;
            }
            if (((ActionPanel)ActionPanel.this).triggers.mtriggerByCause == null) {
                return 0;
            }
            return ((ActionPanel)ActionPanel.this).triggers.mtriggerByCause.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                if (ActionPanel.this.triggers == null) {
                    return new Cause("");
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByCause == null) {
                    return new Cause("");
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByCause.size() <= row) {
                    return new Cause("");
                }
                return new Cause(((ActionPanel)ActionPanel.this).triggers.mtriggerByCause.elementAt(row));
            }
            if (col == 1) {
                if (ActionPanel.this.triggers == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByY == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByY.size() <= row) {
                    return 0;
                }
                return ((ActionPanel)ActionPanel.this).triggers.mtriggerByY.elementAt(row);
            }
            if (col == 2) {
                if (ActionPanel.this.triggers == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByX == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByX.size() <= row) {
                    return 0;
                }
                return ((ActionPanel)ActionPanel.this).triggers.mtriggerByX.elementAt(row);
            }
            if (col == 3) {
                if (ActionPanel.this.triggers == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByTicks == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByTicks.size() <= row) {
                    return 0;
                }
                return ((ActionPanel)ActionPanel.this).triggers.mtriggerByTicks.elementAt(row);
            }
            if (col == 4) {
                if (ActionPanel.this.triggers == null) {
                    return new SpriteID("");
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerBySpriteID == null) {
                    return new SpriteID("");
                }
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerBySpriteID.size() <= row) {
                    return new SpriteID("");
                }
                return new SpriteID(((ActionPanel)ActionPanel.this).triggers.mtriggerBySpriteID.elementAt(row));
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Cause.class;
            }
            if (col == 3) {
                return String.class;
            }
            if (col == 4) {
                return SpriteID.class;
            }
            return Integer.class;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            Object V;
            if (ActionPanel.this.triggers == null) {
                return;
            }
            if (aValue == null) {
                return;
            }
            if (col == 0) {
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByCause == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).triggers.mtriggerByCause.size()) {
                    return;
                }
                V = (Cause)aValue;
                ((ActionPanel)ActionPanel.this).triggers.mtriggerByCause.setElementAt(((Cause)V).c, row);
            }
            if (col == 1) {
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByY == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).triggers.mtriggerByY.size()) {
                    return;
                }
                V = (Integer)aValue;
                ((ActionPanel)ActionPanel.this).triggers.mtriggerByY.setElementAt((Integer)V, row);
            }
            if (col == 2) {
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByX == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).triggers.mtriggerByX.size()) {
                    return;
                }
                V = (Integer)aValue;
                ((ActionPanel)ActionPanel.this).triggers.mtriggerByX.setElementAt((Integer)V, row);
            }
            if (col == 3) {
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerByTicks == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).triggers.mtriggerByTicks.size()) {
                    return;
                }
                V = (String)aValue;
                ((ActionPanel)ActionPanel.this).triggers.mtriggerByTicks.setElementAt((String)V, row);
            }
            if (col == 4) {
                if (((ActionPanel)ActionPanel.this).triggers.mtriggerBySpriteID == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).triggers.mtriggerBySpriteID.size()) {
                    return;
                }
                V = (SpriteID)aValue;
                ((ActionPanel)ActionPanel.this).triggers.mtriggerBySpriteID.setElementAt(((SpriteID)V).c, row);
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.NAMES[col];
        }
    }

    public class EventModel
    extends AbstractTableModel {
        public final String[] NAMES = new String[]{"Name", "Trigger", "Result"};

        @Override
        public int getColumnCount() {
            return this.NAMES.length;
        }

        @Override
        public int getRowCount() {
            if (ActionPanel.this.data == null) {
                return 0;
            }
            if (((ActionPanel)ActionPanel.this).data.meventUID == null) {
                return 0;
            }
            return ((ActionPanel)ActionPanel.this).data.meventUID.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                if (ActionPanel.this.data == null) {
                    return new Cause("");
                }
                if (((ActionPanel)ActionPanel.this).data.meventName == null) {
                    return new Cause("");
                }
                if (((ActionPanel)ActionPanel.this).data.meventName.size() <= row) {
                    return new Cause("");
                }
                return ((ActionPanel)ActionPanel.this).data.meventName.elementAt(row);
            }
            if (col == 1) {
                if (ActionPanel.this.data == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).data.mtriggerName == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).data.mtriggerName.size() <= row) {
                    return 0;
                }
                return ((ActionPanel)ActionPanel.this).data.mtriggerName.elementAt(row);
            }
            if (col == 2) {
                if (ActionPanel.this.data == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).data.mresultName == null) {
                    return 0;
                }
                if (((ActionPanel)ActionPanel.this).data.mresultName.size() <= row) {
                    return 0;
                }
                return ((ActionPanel)ActionPanel.this).data.mresultName.elementAt(row);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            String V;
            if (ActionPanel.this.data == null) {
                return;
            }
            if (aValue == null) {
                return;
            }
            if (col == 0) {
                if (((ActionPanel)ActionPanel.this).data.meventName == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).data.meventName.size()) {
                    return;
                }
                V = (String)aValue;
                ((ActionPanel)ActionPanel.this).data.meventName.setElementAt(V, row);
            }
            if (col == 1) {
                if (((ActionPanel)ActionPanel.this).data.mtriggerName == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).data.mtriggerName.size()) {
                    return;
                }
                V = (String)aValue;
                ((ActionPanel)ActionPanel.this).data.mtriggerName.setElementAt(V, row);
            }
            if (col == 2) {
                if (((ActionPanel)ActionPanel.this).data.mresultName == null) {
                    return;
                }
                if (row >= ((ActionPanel)ActionPanel.this).data.mresultName.size()) {
                    return;
                }
                V = (String)aValue;
                ((ActionPanel)ActionPanel.this).data.mresultName.setElementAt(V, row);
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.NAMES[col];
        }
    }

    class SpriteID {
        public String c;

        SpriteID(String cc) {
            this.c = cc;
        }

        public String toString() {
            return this.c;
        }
    }

    class ActionID {
        public String c;

        ActionID(String cc) {
            this.c = cc;
        }

        public String toString() {
            return this.c;
        }
    }

    class Target {
        public String c;

        Target(String cc) {
            this.c = cc;
        }

        public String toString() {
            return this.c;
        }
    }

    class Cause {
        public String c;

        Cause(String cc) {
            this.c = cc;
        }

        public String toString() {
            return this.c;
        }
    }

    class CostumCellRenderer
    extends DefaultTableCellRenderer {
        CostumCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    public class PosModel
    extends AbstractTableModel {
        public final String[] NAMES = new String[]{"count", "speedY", "speedX"};

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (ActionPanel.this.data == null) {
                return 0;
            }
            if (((ActionPanel)ActionPanel.this).data.mpositioning == null) {
                return 0;
            }
            return ((ActionPanel)ActionPanel.this).data.mpositioning.size() / 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (ActionPanel.this.data == null) {
                return 0;
            }
            if (((ActionPanel)ActionPanel.this).data.mpositioning == null) {
                return 0;
            }
            if (row * 3 + col >= ((ActionPanel)ActionPanel.this).data.mpositioning.size()) {
                return 0;
            }
            return ((ActionPanel)ActionPanel.this).data.mpositioning.elementAt(row * 3 + col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return Integer.class;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (ActionPanel.this.data == null) {
                return;
            }
            if (((ActionPanel)ActionPanel.this).data.mpositioning == null) {
                return;
            }
            if (row * 3 + col >= ((ActionPanel)ActionPanel.this).data.mpositioning.size()) {
                return;
            }
            Integer V = (Integer)aValue;
            ((ActionPanel)ActionPanel.this).data.mpositioning.setElementAt(V, row * 3 + col);
        }

        @Override
        public String getColumnName(int col) {
            return this.NAMES[col];
        }
    }
}

