/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.vide.veccy.ActionResultData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ActionResultDataPool {
    public static final String DEFAULT_XML_NAME = new String("ActionResultData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, ActionResultData> mActionResultData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public ActionResultDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public ActionResultDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error ActionResultData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mActionResultData = ActionResultData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        ActionResultData.saveCollectionAsXML(this.mFileName, this.mActionResultData.values());
        this.buildKlassenMap();
    }

    public void remove(ActionResultData st) {
        this.mActionResultData.remove(st.mName);
    }

    public void put(ActionResultData st) {
        this.mActionResultData.remove(st.mName);
        this.mActionResultData.put(st.mName, st);
    }

    public void putAsNew(ActionResultData st) {
        this.mActionResultData.put(st.mName, st);
    }

    public ActionResultData get(String key) {
        return this.mActionResultData.get(key);
    }

    public HashMap<String, ActionResultData> getHashMap() {
        return this.mActionResultData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, ActionResultData>> entries = this.mActionResultData.entrySet();
        for (Map.Entry<String, ActionResultData> entry : entries) {
            ActionResultData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, ActionResultData> getMapForKlasse(String klasse) {
        HashMap<String, ActionResultData> ret = new HashMap<String, ActionResultData>();
        Set<Map.Entry<String, ActionResultData>> entries = this.mActionResultData.entrySet();
        for (Map.Entry<String, ActionResultData> entry : entries) {
            ActionResultData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

