/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.ActionTriggerDataXMLHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ActionTriggerData {
    protected String mClass = "";
    public String mName = "";
    protected Vector<String> mtriggerByCause = new Vector();
    protected Vector<Integer> mtriggerByY = new Vector();
    protected Vector<Integer> mtriggerByX = new Vector();
    protected Vector<String> mtriggerByTicks = new Vector();
    protected Vector<String> mtriggerBySpriteID = new Vector();
    private static ActionTriggerDataXMLHandler XMLHANDLER = new ActionTriggerDataXMLHandler();

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public Vector<String> gettriggerByCause() {
        return this.mtriggerByCause;
    }

    public void settriggerByCause(Vector<String> triggerByCause) {
        this.mtriggerByCause = triggerByCause;
    }

    public Vector<Integer> gettriggerByY() {
        return this.mtriggerByY;
    }

    public void settriggerByY(Vector<Integer> triggerByY) {
        this.mtriggerByY = triggerByY;
    }

    public Vector<Integer> gettriggerByX() {
        return this.mtriggerByX;
    }

    public void settriggerByX(Vector<Integer> triggerByX) {
        this.mtriggerByX = triggerByX;
    }

    public Vector<String> gettriggerByTicks() {
        return this.mtriggerByTicks;
    }

    public void settriggerByTicks(Vector<String> triggerByTicks) {
        this.mtriggerByTicks = triggerByTicks;
    }

    public Vector<String> gettriggerBySpriteID() {
        return this.mtriggerBySpriteID;
    }

    public void settriggerBySpriteID(Vector<String> triggerBySpriteID) {
        this.mtriggerBySpriteID = triggerBySpriteID;
    }

    private String exportXML() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append("\t<ActionTriggerData>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<triggerByCauses>\n");
        for (i = 0; i < this.mtriggerByCause.size(); ++i) {
            s.append("\t\t\t<triggerByCause>" + UtilityString.toXML(this.mtriggerByCause.elementAt(i)) + "</triggerByCause>\n");
        }
        s.append("\t\t</triggerByCauses>\n");
        s.append("\t\t<triggerByYs>\n");
        for (i = 0; i < this.mtriggerByY.size(); ++i) {
            s.append("\t\t\t<triggerByY>" + this.mtriggerByY.elementAt(i) + "</triggerByY>\n");
        }
        s.append("\t\t</triggerByYs>\n");
        s.append("\t\t<triggerByXs>\n");
        for (i = 0; i < this.mtriggerByX.size(); ++i) {
            s.append("\t\t\t<triggerByX>" + this.mtriggerByX.elementAt(i) + "</triggerByX>\n");
        }
        s.append("\t\t</triggerByXs>\n");
        s.append("\t\t<triggerByTickss>\n");
        for (i = 0; i < this.mtriggerByTicks.size(); ++i) {
            s.append("\t\t\t<triggerByTicks>" + UtilityString.toXML(this.mtriggerByTicks.elementAt(i)) + "</triggerByTicks>\n");
        }
        s.append("\t\t</triggerByTickss>\n");
        s.append("\t\t<triggerBySpriteIDs>\n");
        for (i = 0; i < this.mtriggerBySpriteID.size(); ++i) {
            s.append("\t\t\t<triggerBySpriteID>" + UtilityString.toXML(this.mtriggerBySpriteID.elementAt(i)) + "</triggerBySpriteID>\n");
        }
        s.append("\t\t</triggerBySpriteIDs>\n");
        s.append("\t</ActionTriggerData>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static ActionTriggerDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<ActionTriggerData> col) {
        return ActionTriggerData.saveCollectionAsXML(Global.mBaseDir, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<ActionTriggerData> col) {
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllActionTriggerData>\n");
            for (ActionTriggerData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllActionTriggerData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, ActionTriggerData> getHashMapFromXML(String filename) {
        HashMap<String, ActionTriggerData> filters = new HashMap<String, ActionTriggerData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ActionTriggerDataXMLHandler h = ActionTriggerData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "ActionTriggerData Load Error...", 1);
        }
        return filters;
    }
}

