/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.vide.veccy.ActionTriggerData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ActionTriggerDataPool {
    public static final String DEFAULT_XML_NAME = new String("ActionTriggerData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, ActionTriggerData> mActionTriggerData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public ActionTriggerDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public ActionTriggerDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error ActionTriggerData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mActionTriggerData = ActionTriggerData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        ActionTriggerData.saveCollectionAsXML(this.mFileName, this.mActionTriggerData.values());
        this.buildKlassenMap();
    }

    public void remove(ActionTriggerData st) {
        this.mActionTriggerData.remove(st.mName);
    }

    public void put(ActionTriggerData st) {
        this.mActionTriggerData.remove(st.mName);
        this.mActionTriggerData.put(st.mName, st);
    }

    public void putAsNew(ActionTriggerData st) {
        this.mActionTriggerData.put(st.mName, st);
    }

    public ActionTriggerData get(String key) {
        return this.mActionTriggerData.get(key);
    }

    public HashMap<String, ActionTriggerData> getHashMap() {
        return this.mActionTriggerData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, ActionTriggerData>> entries = this.mActionTriggerData.entrySet();
        for (Map.Entry<String, ActionTriggerData> entry : entries) {
            ActionTriggerData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, ActionTriggerData> getMapForKlasse(String klasse) {
        HashMap<String, ActionTriggerData> ret = new HashMap<String, ActionTriggerData>();
        Set<Map.Entry<String, ActionTriggerData>> entries = this.mActionTriggerData.entrySet();
        for (Map.Entry<String, ActionTriggerData> entry : entries) {
            ActionTriggerData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

