/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.GameDataXMLHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class GameData {
    protected String mClass = "";
    public String mName = "";
    protected Vector<String> mLevel = new Vector();
    private static GameDataXMLHandler XMLHANDLER = new GameDataXMLHandler();

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public Vector<String> getLevel() {
        return this.mLevel;
    }

    public void setLevel(Vector<String> Level2) {
        this.mLevel = Level2;
    }

    private String exportXML() {
        StringBuffer s = new StringBuffer();
        s.append("\t<GameData>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<Levels>\n");
        for (int i = 0; i < this.mLevel.size(); ++i) {
            s.append("\t\t\t<Level>" + UtilityString.toXML(this.mLevel.elementAt(i)) + "</Level>\n");
        }
        s.append("\t\t</Levels>\n");
        s.append("\t</GameData>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static GameDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<GameData> col) {
        return GameData.saveCollectionAsXML(Global.mBaseDir, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<GameData> col) {
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllGameData>\n");
            for (GameData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllGameData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, GameData> getHashMapFromXML(String filename) {
        HashMap<String, GameData> filters = new HashMap<String, GameData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            GameDataXMLHandler h = GameData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "GameData Load Error...", 1);
        }
        return filters;
    }
}

